/*
 *
 *  @(#)ramstat.c	1.6 Copyright (C) B.M.Goodheart 1987, 1888, 1989, 1991 
 *
 *
 *
 *  		      DISCLAIMER OF WARRANTY. 
 *  This software is distributed "as is" and without warranties as to 
 *  performance of merchantability or any other warranties whether expressed 
 *  or implied. In no event shall the author (the copyright holder) be held 
 *  liable for any loss of profit or any other commercial damage resulting 
 *  from the use or misuse of this software, including but not limited to 
 *  special, incidental, consequential or other damages.  The user must 
 *  assume the entire risk of using this software.
 *
 *
 *			LISCENSE AGREEMENT
 *	This software is placed	into the public domain and 
 *	may be copied or distributed freely provided no profit or 
 *	gain is made and is used for personal use only and the code 
 *	as distributed retains all copyright notices in the code. 
 *	This includes any copyright statements in the target
 *	binary and executable code produced from the distributed source. 
 *
 *
 *	                DISTRIBUTION NOTE
 * 	This file contains the code for a RAM disk driver for UNIX System 5.2
 *	and System V.3.	It has been designed specifically for Microport's 
 *	System V/AT iAPX286 and Interactive Systems V/386 i386 systems
 * 	but should work with other PC based System V.? ports with only 
 *	minor modifications, specifically the BUFSEL selector on the 80286.
 *	This driver should work on any V.3 implementation on a PC. 
 *
 *
 *	               IMPORTANT NOTE !!!
 *	Any files or data stored within the ram disks will be 
 *	LOST FOR EVER if the system is brought down for ANY reason.
 *
 *	There are also two other programs distributed associated 
 *	with the driver, they are ramstat(1M) and raminit(1M). 
 *	These are used to control the ram disk driver in user mode 
 *	See also ram(7).
 *
 *	Berny Goodheart (berny@tndsyd.oz@munnari.oz.au)
 *
 * The user program /etc/ramstat is used to initialise the RAM disk
 *
 *		-i	Initialise the RAM disk.
 *		-r	Delete and remove the RAM disk and all its contents
 *		-d	toggle debug mode on or off
 *		-n#	display stats of ram disk '#'
 *		-m	get system memory info (i386) only
 *
 *
 *	5-10-91 - SV4.0 MOD - R. L. Bolin @ gatech!sbmsg1!bsts00!rlb
 *		  See defines for SV4
 */


#ifdef SV4
static char *bmgid = "@(#)ramstat.c	1.6 (SV4.0) Copyright (C) Berny Goodheart 5/20/91";
#else
static char *bmgid = "@(#)ramstat.c	1.6 Copyright (C) Berny Goodheart 5/20/91";
#endif
#include <sys/types.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ramd.h>

static int size;
static int fd;
char devnam[128];
extern int errno;
static int ramnum;

union r_ramst state;

#if i386
#define pdetophys(x)	(x * 4096)
#endif

#ifdef SV4
static void
_trap(sig)
int sig;
#else
static void
_trap()
#endif
{
	(void) signal(SIGINT,_trap);
	if(fd > 0)
		close(fd);
	printf("Aborted\n");
	exit(0);
}

main(argc,argv)
int argc;
char *argv[];
{

	(void) signal(SIGINT,_trap);
	ramnum = -1;

	/*
 	 * Allow users to get stats
	 */
	if(argc != 1)
		setuid(getuid());

	if((fd = open("/dev/ctrlram",O_WRONLY)) == -1){
		perror("/dev/ctrlram");
		exit(1);
	} 

	if(argc == 1) {
		ramstat(fd,TCGETRAM);
		exit(0);
	}


	if(argv[1][0] != '-')
		usage();

	switch (argv[1][1]) {
#if i386
		case 'm':
			if(argc != 2)
				usage();
			ramstat(fd,TCMEMINFO);
			break;
#endif
		case 'n':
			if(isdigit(argv[1][2])) {
				ramnum = atoi(&argv[1][2]);
				ramstat(fd,TCGETRAM);
			} else usage();
			break;
		case 'd':
			if(argc != 2)
				usage();
			ramstat(fd,TCRAMDBG);
			break;
		case 'r':
			if(argc != 4)
				usage();
			close(fd);
			if((fd = open(argv[2],O_WRONLY)) == -1){
				perror(argv[2]);
				exit(1);
			} 
			close(fd);
			if((fd = open(argv[3],O_WRONLY)) == -1){
				perror(argv[3]);
				exit(1);
			}
			strcpy(devnam,argv[3]); 
			if(umount(argv[2]) == -1) {
				if(errno != EINVAL) {
					perror(argv[2]);
					exit(1);
				}
			}
			ramstat(fd,TCDELRAM);
			break;
		case 'i':
			if(argc != 4)
				usage();
			close(fd);
			if((fd = open(argv[3],O_WRONLY)) == -1){
				perror(argv[3]);
				exit(1);
			}
			strcpy(devnam,argv[3]); 
			if((size = atoi(argv[2])) < 20) {
				fprintf(stderr,"ramstat: illegal block size\n");
				exit(1);
			}
			ramstat(fd,TCSETRAM);
			break;
		default :
			usage();
	}
	close(fd);
	exit(0);
}

ramstat(fd,mode)
int fd, mode;
{
	int x,m;
	
	switch(mode) {
#if i386
		case TCMEMINFO:
			if((x = ioctl(fd,TCMEMINFO,&state)) != -1)
				printf("maxmem %ld\nfreemem %ld\n",
					pdetophys(state.r_meminfo.r_maxmem),
					pdetophys(state.r_meminfo.r_freemem));
			break;
#endif
		case TCDELRAM:
			if((x = ioctl(fd,TCDELRAM,0)) != -1)
				printf("Ram disk %s closed\n",devnam);
			break;
		case TCSETRAM:
			state.r_arg = size;
			if((x = ioctl(fd,TCSETRAM,&state)) != -1) 
				printf(
				"\nRam disk (%s) initialized (%d Physical Blocks)\n\n"
					,devnam,size);
			break;
		case TCRAMDBG:
			if((x = ioctl(fd,TCRAMDBG,&state)) != -1) 
				printf("Ram disk debug mode %s\n",
					state.r_arg == 0 ? "OFF" : "ON");
			break;
		case TCGETRAM:
			if((x = ioctl(fd,TCGETRAM,&state)) != -1) {
			if(ramnum == -1)
				printf("\n   RAM	BLOCKS	STATE	OPENS	ADDR\n");
			for(x = 0; x < NRDEVS;x++) {
				if(ramnum != -1 && ramnum != x)
					continue;
				printf(
				"   %d	%d	%s	%d	0x%x%c"
				,state.r_rstat.r_dev[x]
				,state.r_rstat.r_blks[x]
				,state.r_rstat.r_stat[x]
					== RAM_OPEN ? "open" : "closed"
				,(state.r_rstat.r_opns[x] 
					== 0 ? 0 : state.r_rstat.r_opns[x] -1)
				,state.r_rstat.r_addr[x]
				,(ramnum == -1 ? '\n' : ' '));
			}
			if(state.r_rstat.r_dbg != 0) {
				if(ramnum == -1)
					printf("\n  ");
				printf(" Debug ON");
			}
			putchar('\n');
			}/* if */

	}
	if(x < 0) {
		perror("ramstat");
		exit(1);
	}
	close(fd);
}


	
usage()
{
	fprintf(stderr,"Usage: ramstat\n"); 
	fprintf(stderr,"       ramstat -d\n");
	fprintf(stderr,"       ramstat -n#\n");
#if i386
	fprintf(stderr,"       ramstat -m\n");
#endif
	fprintf(stderr,"       ramstat -r  block_special  char_special\n");
	fprintf(stderr,"       ramstat -i  blocks  char_special\n");
	exit(1);
}

