/*
 *
 *  @(#)ram.h	2.5 Copyright (C) B.M.Goodheart 1987, 1888, 1989, 1991 
 *
 *
 *
 *  		      DISCLAIMER OF WARRANTY. 
 *  This software is distributed "as is" and without warranties as to 
 *  performance of merchantability or any other warranties whether expressed 
 *  or implied. In no event shall the author (the copyright holder) be held 
 *  liable for any loss of profit or any other commercial damage resulting 
 *  from the use or misuse of this software, including but not limited to 
 *  special, incidental, consequential or other damages.  The user must 
 *  assume the entire risk of using this software.
 *
 *
 *			LISCENSE AGREEMENT
 *	This software is placed	into the public domain and 
 *	may be copied or distributed freely provided no profit or 
 *	gain is made and is used for personal use only and the code 
 *	as distributed retains all copyright notices in the code. 
 *	This includes any copyright statements in the target
 *	binary and executable code produced from the distributed source. 
 *
 *
 *	                DISTRIBUTION NOTE
 * 	This file contains the code for a RAM disk driver for UNIX System 5.2
 *	and System V.3.	It has been designed specifically for Microport's 
 *	System V/AT iAPX286 and Interactive Systems V/386 i386 systems
 * 	but should work with other PC based System V.? ports with only 
 *	minor modifications, specifically the BUFSEL selector on the 80286.
 *	This driver should work on any V.3 implementation on a PC. 
 *
 *
 *	               IMPORTANT NOTE !!!
 *	Any files or data stored within the ram disks will be 
 *	LOST FOR EVER if the system is brought down for ANY reason.
 *
 *	There are also two other programs distributed associated 
 *	with the driver, they are ramstat(1M) and raminit(1M). 
 *	These are used to control the ram disk driver in user mode 
 *	See also ram(7).
 *
 *	Berny Goodheart (berny@tndsyd.oz@munnari.oz.au)
 *
 */

#define RAM_CLOSED	0
#define RAM_OPEN	1

#define RAMIO		('R'<<8)
#define TCSETRAM	(RAMIO|1)
#define TCDELRAM	(RAMIO|2)
#define TCGETRAM	(RAMIO|3)
#define TCRAMDBG	(RAMIO|4)
#if i386
#define TCMEMINFO	(RAMIO|5)
#endif


#define NRDEVS		4		/* max number of devs	      */

/*
 * NOTE on the i386 machine
 * a block is 4096 bytes
 * on the iAPX286 it is 512 bytes
 *
 * min number of blks/ram disk for a 32k ram disk
 *
 */
#if i386
#define MINRAMSIZ	8
#else
#define MINRAMSIZ	64
#endif

/* union for use by all ramdisk drive ioctl calls */
union r_ramst {
	int 	r_arg;

	/*
	 * Ram device status structure
	 */
	struct {
		int		r_dev[NRDEVS];	/* index to device	*/
		int		r_blks[NRDEVS];	/* physical block count */
		dev_t		r_stat[NRDEVS];	/* open or closed	*/
		int		r_opns[NRDEVS];	/* # of opens	  	*/
		int		r_addr[NRDEVS];	/* mapin memory addr	*/
		dev_t		r_dbg;		/* debug on or off	*/
	}r_rstat;
	
#if i386
	/*
	 * r_meminfo is used to request system wide 
	 * memory information using TCMEMINFO as the ioctl arg
	 * NOTE: not available on 80286
	 *
	 */
	struct {
		ulong		r_maxmem;	/* total system mem     */
		ulong		r_freemem;	/* available mem        */
	} r_meminfo;	
#endif
};


