#include <stdio.h>
#include <sgtty.h>
#include "ttyio.h"

#define TRUE 1
#define FALSE 0

static struct sgttyb savetty;
static struct sgttyb tty;
static int havetty = FALSE;

tty_init()
{
}

tty_setmode(flags)
int flags;
{
if(!havetty)
	{
	if(ioctl(0, TIOCGETP, &savetty) < 0)
		return -1;

	tty = savetty;
	havetty = TRUE;
	}

if(flags & TTY_ECHO)
	tty.sg_flags |= ECHO;

if(flags & TTY_NOECHO)
	tty.sg_flags &= ~ECHO;

if(flags & TTY_CANON)
	{
	tty.sg_flags &= ~CBREAK;
	tty.sg_flags |= CRMOD;
	}

if(flags & TTY_NOCANON)
	{
	tty.sg_flags |= CBREAK;
	tty.sg_flags &= ~CRMOD;
	}

if(ioctl(0, TIOCSETN, &tty) < 0)
	return -1;

return 0;
}

tty_getchar()
{
return getchar();
}

tty_navail()
{
#ifdef FIONREAD

int nchars;

if(ioctl(0, FIONREAD, &nchars) < 0)
	return -1;

return nchars;

#else

return -1;

#endif
}

tty_reset()
{
if(havetty)
	ioctl(0, TIOCSETN, &savetty);
}
