#include <stdio.h>
#include <ctype.h>
#include "ttyio.h"

#define Streq(s1, s2) (strcmp(s1, s2) == 0)

main(argc, argv)
int argc;
char *argv[];
{
int flags = 0;
int i;
int c;
int r;

for(i = 1; i < argc; i++)
	{
	if(Streq(argv[i], "echo"))
		flags |= TTY_ECHO;
	else if(Streq(argv[i], "noecho"))
		flags |= TTY_NOECHO;
	else if(Streq(argv[i], "canon"))
		flags |= TTY_CANON;
	else if(Streq(argv[i], "nocanon"))
		flags |= TTY_NOCANON;
	else	fprintf(stderr, "ttytest: unknown mode \"%s\"\n", argv[i]);
	}

tty_init();

if(tty_setmode(flags) < 0)
	{
	fprintf(stderr, "ttytest: can't set requested mode(s)\n");
	exit(1);
	}

while(1)
	{
	while((r = tty_navail()) == 0)
		;

	printf("tty_navail returned %d\n", r);

	if(r <= 0)
		r = 1;

	for(i = 0; i < r; i++)
		{
		c = tty_getchar();

		if(isprint(c))
			printf("you typed %c\n", c);
		else	printf("you typed %d\n", c);

		if(c == EOF)
			break;
		}

	if(c == EOF)
		break;
	}

tty_reset();
}
