/**************************************************************************
*
* FunktrackerGOLD - By Jason Nunn
*
* =====================================================================
*
* Machine Dependant and other settings (and anything that's common)
*
**************************************************************************/
#include "options.h"

#define FUNK_VERSION  "1.0"
#define FUNK_DATED    __DATE__
#define WELCOME \
"FunktrackerGOLD " FUNK_VERSION ", Compiled: " FUNK_DATED "\n"\
"and original DOS32 Funktracker Project by Jason Nunn\n"\
"Contacts  Snail: 32 Rothdale Rd\n" \
"                 Moil Darwin NT 0810\n" \
"                 AUSTRALIA\n"

#define STOP 0
#define PLAY 1

#define MAX_BPM_RATE 188
#define MIN_BPM_RATE 62
 
/******************************************
* defs for 32bit Linux 1.2.13
*
* we use these to reference alignment critical
* structures in our funk file
*
******************************************/
typedef                char sDB;  /*1 byte*/
typedef unsigned       char uDB;
typedef          short int  sDW;  /*2 bytes*/
typedef unsigned short int  uDW;
typedef                int  sDD;  /*4 bytes*/
typedef unsigned       int  uDD;
typedef             double  sDQ;  /*ansi double - 8 bytes*/

/*This structure is used for talking to either a DAC mixxer or
DSP mixxer*/
typedef struct _tchmix
{
  unsigned long start;
  unsigned long length;
  unsigned char funkctrl;
  void          *sample_addr;
  double        sample_ptr;
  double        freq;
  int           left_volume;
  int           right_volume;
  long          *echo_buffer;
  unsigned int  echo_ptr;
  int           echo_delay;  /*16 point* @ 0.02 per sec each*/
  int           echo_decay;  /*also 16 point*/
  int           echo_feedback;
} tchmix;

/*statistical types for info block*/
#define FKCPU_UNKNOWN  0
#define FKCPU_IBMPC1   1
#define FKCPU_IBMPC2   2
#define FKCPU_I386     3
#define FKCPU_I486     4
#define FKCPU_PENTIUM  5
#define FKCPU_LINUX    6
#define FKCPU_FREEBSD  7
#define FKCPU_NOTUSED8 8
#define FKCPU_NOTUSED9 9
#define FKCPU_NOTUSEDA 10
#define FKCPU_NOTUSEDB 11
#define FKCPU_NOTUSEDC 12
#define FKCPU_NOTUSEDD 13
#define FKCPU_NOTUSEDE 14
#define FKCPU_OTHER    15

#define FKCARD_SB20      0
#define FKCARD_SBPRO     1
#define FKCARD_GUSV      2
#define FKCARD_SB10      3
#define FKCARD_SB16      4
#define FKCARD_GUSF      5
#define FKCARD_RIPPED    6
#define FKCARD_PAS       7
#define FKCARD_VOX08     8
#define FKCARD_VOX16     9
#define FKCARD_NOTUSEDA 10
#define FKCARD_NOTUSEDB 11
#define FKCARD_NOTUSEDC 12
#define FKCARD_NOTUSEDD 13
#define FKCARD_NOTUSEDE 14
#define FKCARD_OTHER    15
