Needs["Demo`"]

(* $Id: HDemo.awk,v 1.1 89/06/06 15:06:13 mbp Exp $
 *
 *  Note:  This demo is for the Sun version
 *)

Print[""]
Print["Loading various packages; please be patient ..."]

Needs["Heisenberg`"]

Print["Done."]
Print[""]
Print["This is a Mathematica demonstration package.  It will display"]
Print["explanatory text, such as this paragraph, and regular Mathematica"]
Print["input and output, such as the following trivial example:"]

Demo["2 + 2"]

Print[""]
Print["It will pause at various times to give you a chance to read what it"]
Print["has displayed."]

Pause[]

Print[""]
Print["This demonstration illustrates 'Heisenberg' an interactive environment"]
Print["in which you can define (symbolically or numerically), draw, and"]
Print["manipulate objects in Heisenberg space, the boundary of the complex"]
Print["hyperbolic plane.  Mathematica handles the symbolic aspects of the"]
Print["environment, while a separate graphics program displays the objects"]
Print["you have defined and allows you to view them from different angles"]
Print["interactively.  The graphics program may be running on a separate"]
Print["computer from Mathematica; the two programs communicate through a Unix"]
Print["socket."]

Pause[]

Print[""]
Print["This text is being printed by Mathematica.  Before we can establish"]
Print["the connection to the graphics program, you must start that program on"]
Print["your local machine (i.e. the one you are now sitting in front of,"]
Print["which may not be the same as the one Mathematica is running on).  To"]
Print["start the graphics program, go to another command window on your"]
Print["machine and give the command 'startheis'.  In response to this command"]
Print["you will see a short message telling you that the Heisenberg graphics"]
Print["program has been started on your machine.  No window will appear at"]
Print["this time; the graphics window will appear later when the connection"]
Print["to Mathematica is made."]
Print[""]
Print["If you have not started the graphics program yet, do so now with the"]
Print["'startheis' command."]

Pause["Hit <return> after you have executed 'startheis' ..."]

Print[""]
Print["Now that you have started the graphics program, we are ready to"]
Print["establish the connection between it and Mathematica.  Once this"]
Print["connection is made, the graphics program's window should appear on"]
Print["your screen. It will probably cover up most of the Mathematica window"]
Print["(this one); you may want to resize and/or reposition the Mathematica"]
Print["window so that you can see most of both windows.  You should not try"]
Print["to resize the graphics window, but you may reposition it if you like."]

Pause["Hit <return> to connect to the graphics program ..."]

HConnect[]

Print[""]
Print["The connection should now be established, and the Heisenberg graphics"]
Print["window should appear on the screen.  If did not, and does not appear"]
Print["within a few seconds, you should abort Mathematica (with control-C;"]
Print["get all the way out of Mathematica) and try everything from the"]
Print["beginning."]

Pause[]

Print[""]
Print["We begin by defining x to be the point in Heisenberg space with"]
Print["coordinates (1+I, 2) (points in Heisenberg space are defined by a pair"]
Print["of numbers, the first complex and the second real; I stands for the"]
Print["square root of -1 in Mathematica):"]

Demo["x = Hpoint[ 1 + I, 2 ]"]

Pause[]

Print[""]
Print["And we define c to be a chain with center at (0,1) and radius 1:"]

Demo["c = Chain[ Hpoint[0,1], 1 ]"]

Pause[]

Print[""]
Print["Now that x and c are defined, we can draw them:"]

Demo["HDraw[x, c]"]

Print[""]
Print["You should now see a point and an ellipse (the chain) in the graphics"]
Print["window.  You can use the control panel on the right-hand side of the"]
Print["graphics window to look at the picture from different viewpoints"]
Print["(Heisenberg space is three-dimensional).  To do this, point at the"]
Print["control buttons with the mouse and click the left mouse button.  Go"]
Print["ahead and try it now."]
Print[""]
Print["You can interact with the graphics window in this way at any time.  If"]
Print["you want more information about how to use these buttons, click the"]
Print["'?' button."]

Pause[]

Print[""]
Print["Now we obtain a second point by inverting the point x in the chain c:"]

Demo["x2 = HApply[ C21Inversion[c], x ]"]
Demo["HDraw[x2]"]

Pause[]

Print[""]
Print["This defines s to be the spinal sphere with vertices x and x2:"]

Demo["s = Spinal[ x, x2 ]"]
Demo["HDraw[s]"]

Pause[]

Print[""]
Print["We can also draw the special object 'Grid', which stands for a grid in"]
Print["the x-y plane and a vertical axis.  This grid sometimes helps you make"]
Print["visual sense out of what you see in the graphics window."]

Demo["HDraw[Grid]"]

Pause[]

Print[""]
Print["HClear erases everything in the graphics window, allowing you to start"]
Print["with a clean slate:"]

Demo["HClear[]"]

Pause[]

Print[""]
Print["We have the full power of Mathematica available to do things like"]
Print["loops, function definitions, etc.  For example, in the previous lines"]
Print["of this demo, we drew a point and a chain, inverted the point in the"]
Print["chain, and then drew the spinal sphere whose vertices are the original"]
Print["point and its inversion.  We can define a function for doing this:"]

Demo["func[x_Hpoint, c_Chain] :=\n
  Block[\n
    {x2,s},\n
    x2 = HApply[ C21Inversion[c], x ];\n
      s = Spinal[ x, x2 ];\n
      HDraw[x, c, x2, s]\n
    ]"]

Pause[]

Print[""]
Print["We can then accomplish the whole operation above by a single function call:"]

Demo["func[x,c]"]


Pause[]

Demo["HClear[]"]
Demo["HDraw[Grid]"]

Print[""]
Print["Now we will use a loop to draw a sequence of chains obtained by"]
Print["repetitive translation of one chain:"]

Pause[]

Demo["f = HTranslation[ Hpoint[1,0] ]"]
Demo["c[-5] = Chain[ Hpoint[-5,0], 1 ]"]
Demo["For [i=-4, i<=5, ++i,\n
  c[i] = HApply[ f, c[i-1] ];\n
    HDraw[c[i]] ]"]

Pause[]

Print[""]
Print["This is the end of this demonstration.  You may now interact directly"]
Print["with Mathematica to define, draw, and manipulate your own objects."]
Print[""]
Print["To get information about a symbol or function, type '?' followed by"]
Print["the name of the symbol or function.  To exit Mathematica, type 'Quit'."]
Print["This will terminate the Heisenberg graphics program as well."]

Null
