/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef GLGDEF

#include "gl.h"

typedef struct {

  /* gadget data */
  char *data;

  /* Procedure to draw gadget; the syntax for this procedure should be
   *
   * 	draw(data)
   * 	char *data;
   *
   * It should draw the gadget with the given data.
   */
  int (*draw)();

  /* Procedure to process gadget events; the syntax for this procedure
   * should be
   *
   * 	int processevent(data, event)
   * 	char *data;
   * 	GlgEvent event;
   *
   * It should check to see if the gadget g wants the event, and if so,
   * it should process it and return 1.  If not, return 0.
   */
  int (*processevent)();

} GlGadget;

typedef struct {

  /* event device */
  Device dev;

  /* event value */
  short val;

  /* event (world) coords */
  double x,y;

} GlgEvent;

GlGadget *GlgProcessEvent();

#define GLGDEF

#include "sliders.h"
#include "messages.h"
#include "texts.h"
#include "buttons.h"

#endif
