/*
 * glgdemo.c: demo program for glg package
 *
 * To compile: cc -o glgdemo -lglg -lgl_s
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <stdio.h>
#include <gl.h>
#include <device.h>
#include "glg.h"

static int s1_proc(), s2_proc(), b1_proc(), m_proc(), DrawWindow();

#define bgnd	((Colorindex)48)
#define barmark	((Colorindex) 9)
#define inbar	((Colorindex) 7)
#define outline	((Colorindex) 0)
#define txtcol	((Colorindex) 0)

GLGSLIDER(s1,			/* slider symbol  */
	  s1_g,			/* gadget symbol */
	  S_DOUBLE,		/* type double */
	  "s1: %7.3f",		/* label format string */
	  s1_proc,		/* callback procedure */
	  4.912, 4.859,		/* (x,y) coords of center */
	  2.0, 0.5,		/* width, height */
	  0, 10, 5,		/* min, max, initial value */
	  bgnd, barmark, inbar,	/* colors */
	    outline, txtcol
	  );

GLGSLIDER(s2,			/* slider symbol  */
	  s2_g,			/* gadget symbol */
	  S_INT,		/* type int */
	  "s2: %2d",		/* label format string */
	  s2_proc,		/* callback procedure */
	  4.951, 2.233,		/* (x,y) coords of center */
	  2.0, 0.5,		/* width, height */
	  0, 10, 5,		/* min, max, initial value */
	  bgnd, barmark,inbar,	/* colors */
	    outline, txtcol
	  );

GLGMESSAGE(m1,				/* message symbol */
	   m1_g,			/* gadget symbol */
	   "This is message number 1",	/* message string */
	   m_proc,			/* callback proc */
	   0.273, 9.418,		/* (x,y) coords of message */
	   bgnd, txtcol			/* colors */
	   );

GLGMESSAGE(m2,				/* message symbol */
	   m2_g,			/* gadget symbol */
	   "Hit the 's' key to enter a string",	/* message string */
	   m_proc,			/* callback proc */
	   0.253, 7.542,		/* (x,y) coords of message */
	   bgnd, txtcol			/* colors */
	   );

char t1_string[20];
GLGTEXT(t1,			/* text symbol */
	t1_g,			/* gadget symbol */
	t1_string,		/* place to store text value string */
	sizeof(t1_string),	/* declared length of text value string */
	NULL,			/* callback procedure */
	0.370, 8.462,		/* (x,y) coords of text */
	bgnd, txtcol, txtcol	/* colors */
	);

char *b1_strings[] = { "one", "two", "three" };
Colorindex b1_colors[] = { 1, 2, 3 };
GLGBUTTON(b1,			/* button symbol */
	  b1_g,			/* text symbol */
	  b1_proc,		/* callback procedure */
	  7.057, 8.311,		/* (x,y) location of button */
	  1.0, 0.7,		/* width, height of button */
	  3, 0,			/* # vals, current val of button */
	  b1_strings,		/* array of labels */
	  b1_colors,		/* array of colors */
	  txtcol, outline	/* text & outline colors */
	  );

GlGadget *gadgets[] = { &s1_g, &s2_g, &m1_g, &m2_g, &t1_g, &b1_g, NULL };

static int xorg, yorg, xsize, ysize;
#define	XMIN	 0.0
#define	XMAX	10.0
#define	YMIN	 0.0
#define	YMAX	10.0

main()
{
  GlgEvent event;
  
  foreground();
  winopen("gtest");
  wintitle("gtest");
  ortho2(XMIN, XMAX, YMIN, YMAX);
  doublebuffer();
  gconfig();
  frontbuffer(FALSE);
  GlgSetWindow(XMIN, XMAX, YMIN, YMAX);
  GlgInit(gadgets, DrawWindow);
  DrawWindow();
  
  qdevice(LEFTMOUSE);
  qdevice(MIDDLEMOUSE);
  qdevice(RIGHTMOUSE);
  qdevice(KEYBD);
  
  while (1) {
    GlgReadEvent(&event);
    switch (event.dev) {
    case REDRAW:
      DrawWindow();
      break;
      
    default:
      if (!GlgProcessEvent(event)) {
	if ( (event.dev==KEYBD) && (event.val=='s') ) {
	  char str[20], buf[50];
	  PutString(1,"Enter a string in the text item");
	  GetString(str);
	  sprintf(buf, "You entered '%s'", str);
	  PutString(1,buf);
	}
      }
      break;
    }
    
  }
  
}


PutString(n,s)
int n;
char *s;
{
  static char msg1[50], msg2[50];

  if (n==1) {
    strcpy(msg1, s);
    m1.string = msg1;
  }
  else {
    strcpy(msg2, s);
    m2.string = msg2;
  }
  DrawWindow();
}


GetString(s)
char *s;
{
  int done = 0;
  GlgEvent event;

  while (!done) {

    GlgReadEvent(&event);
    if ( (GlgProcessEvent(event) == &t1_g) &&
	(event.dev==KEYBD) &&
	( (event.val==GlgCTRL_J) || (event.val==GlgRET) ) )
      done = 1;

  }
  strcpy(s, t1.string);
}

static int
  DrawWindow()
{
  reshapeviewport();
  getorigin(&xorg,&yorg);
  getsize(&xsize,&ysize);
  GlgSetViewport(xorg, yorg, xsize, ysize);
  frontbuffer(FALSE);
  color(bgnd);
  clear();
  GlgDrawAll();
  swapbuffers();
}  

static int
  s1_proc(x)
double x;
{
  printf("s1 set to %f\n", x);
}

static int
  s2_proc(n)
int n;
{
  printf("s1 set to %1d\n", n);
}

static int
  b1_proc(n)
int n;
{
  printf("b1 set to %1d\n", n);
}

static int
  m_proc(mp)
GlgMessage *mp;
{
  if (mp == &m1)
    printf("Message #1 selected.\n");
  else if (mp == &m2)
    printf("Message #2 selected.\n");
  else
    printf("Unknown message selected.\n");
}

