/*
 * internal.h: internal header file for gadget submodules
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef GLGADGETSINTERNAL

extern int GlgXorg, GlgYorg, GlgXsize, GlgYsize;
extern double GlgXMIN, GlgXMAX, GlgYMIN, GlgYMAX;

/*-----------------------------------------------------------------------
 * MACRO:	GlgEventInRect
 * Description:	check to see if an event lies in a rectangle
 * Args:	event: the event to check
 *		x,y: lower left corner of rect
 *		w,y: width and height of rect
 * Returns:	1 if event lies in rect, 0 if not.
 * Author:	mbp
 * Date:	Mon Jun  4 15:53:49 1990
 * Notes:	The boundary of the rect is considered in.
 */
#define GlgEventInRect(event, x0, y0, w, h) \
  ((x0 <= event.x) && (event.x <= x0+w) && \
   (y0 <= event.y) && (event.y <= y0+h))


/*-----------------------------------------------------------------------
 * MACRO:	GLGWXLEN
 * Description:	convert a screen x length to the corresponding length
 *		  in world coords
 * Args:	x: the screen x length
 * Returns:	world coord version of x
 * Author:	mbp
 * Date:	Mon Jun  4 21:33:26 1990
 */
#define GLGWXLEN(x) ((x)*(GlgXMAX-GlgXMIN)/GlgXsize)

/*-----------------------------------------------------------------------
 * MACRO:	GLGWYLEN
 * Description:	convert a screen y length to the corresponding length
 *		  in world coords
 * Args:	y: the screen y length
 * Returns:	world coord version of y
 * Author:	mbp
 * Date:	Mon Jun  4 21:33:26 1990
 */
#define GLGWYLEN(y) ((y)*(GlgYMAX-GlgYMIN)/GlgYsize)

#define GLGADGETSINTERNAL

#endif
