/*
 * messages.c: message submodule
 */

/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include <stdio.h>
#include <device.h>
#include <get.h>
#include "glg.h"
#include "internal.h"
#include "messages.h"

static int (*DrawWindow)() = NULL;

/*-----------------------------------------------------------------------
 * Function:	GlgMessageInit
 * Description:	initialize the message subpackage
 * Args  IN:	drawwindow: procedure for redrawing entire window.
 *		  Call syntax is just 'drawwindow()'.
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 14:12:16 1990
 * Notes:	Call this once before processing any gadget events.
 */
int
  GlgMessageInit(drawwindow)
int (*drawwindow)();
{
  DrawWindow = drawwindow;
}

/*-----------------------------------------------------------------------
 * Function:	GlgMessageDraw
 * Description:	draw a message
 * Args  IN:	*mp: the message to draw
 * Returns:	nothing
 * Author:	mbp
 * Date:	Mon Jun  4 17:25:31 1990
 */
int
  GlgMessageDraw(data)
char *data;
{
  register GlgMessage *mp = (GlgMessage*)data;
  double x1,y1;

  color(mp->bgnd);
  x1 = GLGWXLEN(1);
  y1 = GLGWYLEN(1);
  rectf(mp->x - x1, mp->y - y1,
	mp->x + GLGWXLEN(strwidth(mp->string)) + x1,
	mp->y + GLGWYLEN(getheight()) + y1);

  if (mp->string != NULL)
    GlgWriteString(mp->string, mp->x, mp->y, 0, 0, 0, mp->bgnd, mp->txtcol);
}

/*-----------------------------------------------------------------------
 * Function:	GlgMessageEvent
 * Description:	Let a message process an event
 * Args  IN:	*data: the message
 *		event: the event
 * Returns:	1 if the message acts on the event, 0 if not.
 * Author:	mbp
 * Date:	Mon Jun  4 17:26:53 1990
 */
int
  GlgMessageEvent(data, event)
register char *data;
GlgEvent event;
{
  register GlgMessage *mp = (GlgMessage*)data;
  double xsz, ysz;
  
  xsz = GLGWXLEN(strwidth(mp->string));
  ysz = GLGWYLEN(getheight());
  if (!GlgEventInRect(event, mp->x, mp->y, xsz, ysz))
    return(0);

  switch (event.dev) {
  case LEFTMOUSE:
    if ( (event.val) && (mp->proc != NULL) )
      (*(mp->proc))(mp);
    break;

  case MIDDLEMOUSE:
    if (DrawWindow != NULL) {

      double xold = event.x;
      int first = 1;
      while (getbutton(event.dev)) {
	GlgGetMouseXY(&event.x,&event.y);
	if ((first) || (event.x != xold)) {
	  first = 0;
	  xold = event.x;
	  mp->x = event.x;
	  mp->y = event.y;
	  (*DrawWindow)();
	}
      }
    }
    break;
    
  case RIGHTMOUSE:
    if (getbutton(RIGHTMOUSE))
      printf("message is at (%5.3f, %5.3f)\n", mp->x,mp->y);
    break;
    
  }
  
  return(1);
}
