/***************************************************************************
 *                Copyright (C) 1990 by Mark B. Phillips                   *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both      *
 *      that copyright notice and this permission notice appear in         *
 *      supporting documentation, and that the names of Mark B.            *
 *      Phillips, or the University of Maryland not be used in             *
 *      advertising or publicity pertaining to distribution of the         *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the author Mark B. Phillips    *
 *      in any publication which uses part or all of any image produced    *
 *      by this software.                                                  *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#ifndef GLGMESSAGEDEF

typedef struct {

  /* message string */
  char *string;

  /* Callback procedure - gets called when user clicks left mouse
     button over message */
  int (*proc)();

  /* lower left corner of message */
  double x, y;

  /* Background and text colors */
  Colorindex bgnd, txtcol;

} GlgMessage;

extern int GlgMessageDraw();
extern int GlgMessageEvent();

/*-----------------------------------------------------------------------
 * MACRO:	GlgMessage
 * Description:	define a message
 * Args:	message: name for GlgMessage object
 *		gadget: name for corresponding GlGadget object
 *		proc: callback procedure - gets called when user
 *		  clicks left mouse button over message.  Syntax is
 *			proc(mp)
 *			GlgMessage *mp;
 *		string: message string
 *		x,y: location of lower left corner of message
 *		bgnd: background color
 *		txtcol: text color
 * Author:	mbp
 * Date:	Mon Jun  4 13:22:19 1990
 */
#define GLGMESSAGE(message, gadget, string, proc, x, y, bgnd, txtcol)	\
  GlgMessage message =							\
   { string, proc, x, y, bgnd, txtcol };				\
  GlGadget gadget =							\
   { (char*)(&message), GlgMessageDraw, GlgMessageEvent }

#define GLGMESSAGEDEF

#endif
