/* $Id: heisenberg.h,v 4.0 89/06/06 15:38:43 mbp Exp $
 *
 * heisenberg.h: global include file; everybody uses this
 */

/***************************************************************************
 *                          Copyright (C) 1990 by                          *
 *        Mark B. Phillips, William M. Goldman, and Robert R. Miner        *
 *                                                                         *
 *  Permission to use, copy, modify, and distribute this software, its     *
 *  documentation, and any images it generates for any purpose and without *
 *  fee is hereby granted, provided that                                   *
 *                                                                         *
 *  (1) the above copyright notice appear in all copies and that both that *
 *      copyright notice and this permission notice appear in supporting   *
 *      documentation, and that the names of Mark B.  Phillips, William M. *
 *      Goldman, Robert R.  Miner, or the University of Maryland not be    *
 *      used in advertising or publicity pertaining to distribution of the *
 *      software without specific, written prior permission.               *
 *                                                                         *
 *  (2) Explicit written credit be given to the authors Mark B. Phillips,  *
 *      William M. Goldman, and Robert R. Miner in any publication which   *
 *      uses part or all of any image produced by this software.           *
 *                                                                         *
 * This software is provided "as is" without express or implied warranty.  *
 ***************************************************************************/

#include "complex.h"		/* complex numbers header */
#include "datatypes.h"		/* Global typedefs */
#include <math.h>
#include <stdio.h>

/************************************************************************/
/* Definitions which can be changed for debugging purposes:		*/

  /* This one should be commented out to compile a non-debugging version: */
#define DEBUG

/* this can be set to null to make private procs public for debugging: */
#define STATIC static

/************************************************************************/
/* Some miscellaneous numerical definitions:				*/ 

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

#define M_TWO_PI 6.2831853071795862

#ifdef DEVICE_IRIS
#define FUDGE_DEFAULT (0.1)	/* Iris's fudge factor must be much */
#define fudge hfudge
#else				/* larger.  (Single precision only?) */
#define FUDGE_DEFAULT (1.0E-6)
#endif

/* Various constants and macros */

#define YES 1
#define NO  0

#define CHAIN_VERTICAL -1	/* this is used for the radius of */
				/* vertical chains */

#define DEGTORAD(x) ((x)*M_PI/180)
#define RADTODEG(x) ((x)*180/M_PI)

/************************************************************************/
/* Global parameters: (these are given their initial values in		*/
/* heisenberg.c)							*/

  /* number of line segments to use in drawing chains: */
extern int chain_resolution;

  /* number of slices to draw in spinals */
extern int slice_count;

  /* number of line segments to use in drawing rcircles: */
extern int rcircle_resolution;

  /* minimum vertical coordinate for drawing vertical chains: */
extern double vert_chain_min;

  /* maximum vertical coordinate for drawing vertical chains: */
extern double vert_chain_max;

  /* number of meridians of spinals to draw: */
extern int meridian_count;

  /* fudge factor for floating point calculations: */
extern double fudge;

  /* draw type for spinal hyperspheres */
extern int spinaldrawtype;

  /* values for spinaldrawtype: */
#define CHAINS   0
#define RCIRCLES 1
#define BOTH	 2

  /* lower corner of world box: */
extern double wbox_low[];

  /* upper corner of world box: */
extern double wbox_high[];

  /* Maximum length of a line in our world box (i.e. lengh of diag) */
extern double maxlinelen;

/************************************************************************/
/* Public procedures which need to be pre-declared, either because they */
/* return something other than an int, or because we need to be able to */
/* take their addresses:						*/

char *segment_name();
char *type_string();
double ang_inv();
double chain_v_coord();
extern char *color_name();
extern int lgd_put_string();
extern int cmd_msg();
extern char *lgd_get_string();
extern char *cmd_get_string();
extern int parse_command();

#ifndef HAVE_ACOSH_DEC
extern double acosh();		/* because acosh isn't always in math lib */
#endif
