#ifndef lint
static       char    rcsid[] = "$Header: data.c,v 1.2 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	data.c,v $
 * 
 * Revision 1.1  90/03/13  23:24:22  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

CHAR	*ProgName = NULL;		/* name of the program */

CHAR	*DxfFileName = NULL;		/* current DXF file name */

INT	DxfAscOrBin = 0;		/* 0 if current DXF file is ASCII */
					/* 1 if it is BINARY */
INT	DxfFileLine = 0;		/* current DXF file line counter */
					/* for ASCII DXF file parsing */
INT	DxfFileByte = 0;		/* current DXF file byte counter */
					/* for BINARY DXF file parsing */
INT	OutFileType = -1;		/* output file type, 0 for DEF, */
					/* 1 for NFF, 2 for DXF, -1 for none */

FILE	*OutFile = NULL;		/* output file handler */

GROUP	*Group = NULL;			/* global group of code and value */

NAME	*NameList = NULL;		/* list of object name for output */

BLOCK	*BlockList = NULL;		/* list of blocks defined in BLOCKS */
					/* or defined in block libaries */

ENTITY	*EntityList = NULL;		/* list of entities defined in */
					/* ENTITIES section */

LAYER	*LayerList = NULL;		/* list of layers defined in */
					/* ENTITIES section */

FLOAT	MinCircleRadius = DefaultMinCircleRadius;
					/* min circle radius for circle/arc */
					/* tesselation */

FLOAT	XAxis[3] = { 1.0, 0.0, 0.0 };	/* default X axis direction */

FLOAT	YAxis[3] = { 0.0, 1.0, 0.0 };	/* default Y axis direction */

FLOAT	ZAxis[3] = { 0.0, 0.0, 1.0 };	/* default Z axis direction */

STACK	*CurrentStack = NULL;		/* current stack for handling a block */
					/* its value is &StackCurrent defined */
					/* in stack.c, if not null */

CHAR    *JoinStr = "_";			/* string linking block name and */
					/* layer name, defalut "_" */

CHAR    *PrefixStr = "_";		/* string as prefix of a name */
					/* starting with non-alpha char */
					/* default "-" */

INT	JoinMode = 1;			/* method for linking block name */
					/* and layer name, default 1 for */
					/* block name + layer name, 0 for */
					/* layer name only */

INT	RadId = 0;			/* for unique id in RAD file */

/*
 * define globle GetNextGroup functions
 * parsing ASCII and BINARY DXF files
 */

VOID	(*GlobleGetNextGroup[2]) () = {
	AsciiGetNextGroup, BinaryGetNextGroup
};

/*
 * define functions processing entities
 */

ENTITYPROCS	EntityProcs[21]	=	{
{ ENTITY_NULL     ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
                                           NullDxfOutput,     NullRadOutput },
{ ENTITY_LINE     ,      LineDxfParse,     LineDefOutput,     LineDefOutput,
					   LineDefOutput,     LineDefOutput },
{ ENTITY_POINT    ,     PointDxfParse,    PointDefOutput,    PointNffOutput,
					  PointDxfOutput,    PointRadOutput },
{ ENTITY_CIRCLE   ,    CircleDxfParse,   CircleDefOutput,   CircleNffOutput,
					 CircleDefOutput,   CircleRadOutput },
{ ENTITY_ARC      ,       ArcDxfParse,      ArcDefOutput,      ArcDefOutput,
					    ArcDefOutput,      ArcDefOutput },
{ ENTITY_TRACE    ,     TraceDxfParse,    TraceDefOutput,    TraceDefOutput,
					  TraceDefOutput,    TraceDefOutput },
{ ENTITY_SOLID    ,     SolidDxfParse,    SolidDefOutput,    SolidDefOutput,
					  SolidDefOutput,    SolidDefOutput },
{ ENTITY_TEXT     ,      TextDxfParse,     TextDefOutput,     TextNffOutput,
					   TextDxfOutput,     TextRadOutput },
{ ENTITY_SHAPE    ,     ShapeDxfParse,    ShapeDefOutput,    ShapeNffOutput,
					  ShapeDxfOutput,    ShapeRadOutput },
{ ENTITY_BLOCK    ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
					   NullDxfOutput,     NullRadOutput },
{ ENTITY_ENDBLK   ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
					   NullDxfOutput,     NullRadOutput },
{ ENTITY_INSERT   ,    InsertDxfParse,   InsertDefOutput,   InsertDefOutput,
					 InsertDefOutput,   InsertDefOutput },
{ ENTITY_ATTDEF   ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
					   NullDxfOutput,     NullRadOutput },
{ ENTITY_ATTRIB   ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
					   NullDxfOutput,     NullRadOutput },
{ ENTITY_POLYLINE ,  PolylineDxfParse, PolylineDefOutput, PolylineDefOutput,
				       PolylineDefOutput, PolylineDefOutput },
{ ENTITY_VERTEX   ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
					   NullDxfOutput,     NullRadOutput },
{ ENTITY_SEQEND   ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
					   NullDxfOutput,     NullRadOutput },
{ ENTITY_3DLINE   ,      LineDxfParse,     LineDefOutput,     LineDefOutput,
					   LineDefOutput,     LineDefOutput },
{ ENTITY_3DFACE   ,      FaceDxfParse,     FaceDefOutput,     FaceDefOutput,
					   FaceDefOutput,     FaceDefOutput },
{ ENTITY_DIMENSION, DimensionDxfParse,DimensionDefOutput,DimensionNffOutput,
				      DimensionDxfOutput,DimensionRadOutput },
{ -1              ,      NullDxfParse,     NullDefOutput,     NullNffOutput,
				           NullDxfOutput,     NullRadOutput }
};
