#include <stdio.h>
#include "vort.h"

/*
 * writergbline
 *
 *	writes out the rgb scanline described by red, green, and blue into out.
 */
int
writergbline(out, red, green, blue)
	image		*out;
	unsigned char	*red, *green, *blue;
{
	register int	i, x;
	unsigned char	count, run, r, g, b, rbuf[127], gbuf[127], bbuf[127];

	switch (imagetype(out)) {
	case PIX_RGB:
		for (x = 0; x < imagewidth(out); x++) {
			if (writebyte(out, red[x]) == EOF)
				return(0);
			writebyte(out, green[x]);
			writebyte(out, blue[x]);
		}
		break;
	case PIX_RLE:
		r = red[0];
		g = green[0];
		b = blue[0];
		count = 0;
		run = 0;
		for (x = 1; x < imagewidth(out); x++) {
			if (red[x] != r || green[x] != g || blue[x] != b) {
				if (run != 0) {
					if (writebyte(out, run) == EOF)
						return(0);
					writebyte(out, r);
					writebyte(out, g);
					writebyte(out, b);
					run = 0;
				} else {
					if (count == 127) {
						if (writebyte(out, 255) == EOF)
							return(0);
						for (i = 0; i != 127; i++) {
							writebyte(out, rbuf[i]);
							writebyte(out, gbuf[i]);
							writebyte(out, bbuf[i]);
						}
						count = 0;
					}
					rbuf[count] = r;
					gbuf[count] = g;
					bbuf[count] = b;
					count++;
				}
			} else if (run == 127) {
				if (writebyte(out, 127) == EOF)
					return(0);
				writebyte(out, r);
				writebyte(out, g);
				writebyte(out, b);
				run = 0;
			} else {
				if (count != 0) {
					if (writebyte(out, count | 0x80) == EOF)
						return(0);
					for (i = 0; i != count; i++) {
						writebyte(out, rbuf[i]);
						writebyte(out, gbuf[i]);
						writebyte(out, bbuf[i]);
					}
					count = 0;
				}
				run++;
			}
			r = red[x];
			g = green[x];
			b = blue[x];
		}
		if (count != 0) {
			if (writebyte(out, count | 0x80) == EOF)
				return(0);
			for (i = 0; i != count; i++) {
				writebyte(out, rbuf[i]);
				writebyte(out, gbuf[i]);
				writebyte(out, bbuf[i]);
			}
		} 
		if (writebyte(out, run) == EOF)
			return(0);
		writebyte(out, r);
		writebyte(out, g);
		writebyte(out, b);
		break;
	default:
		fprintf(stderr, "writergbline: bad output file format.\n");
		return(0);
	}

	return(1);
}

