/*
 *	This file implements the Unidata memory-allocation abstraction.
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stddef.h>		/* for size_t */
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include "uderrmsg.h"
#include "udalloc.h"

#ifdef lint
    static void	lint_malloc(n) size_t n; { ++n; }
    static void	lint_realloc(p,n) VOIDP p; size_t n; { n+=(size_t)p; }
#   define	malloc(n)	(lint_malloc(n), (VOIDP)NULL)
#   define	realloc(p,n)	(lint_realloc(p,n), (VOIDP)NULL)
#else
    static char	rcsid[]	= "$Id: udalloc.c,v 2.7 1991/06/10 15:44:05 steve Exp $";
    static char	afsid[]	= "$__Header$";
#endif


/*
 *	Allocate storage.  If unsuccessful, print error message and return
 *	a null pointer.  A null pointer is also returned if the requested 
 *	size is non-positive.
 */

    VOIDP
udmalloc(nbytes)
    size_t	nbytes;
{
    static char	me[]	= "udmalloc";

    if (nbytes > 0) {
	VOIDP	mem	= malloc(nbytes);

	if (mem == NULL) {
	    uderror(me);
	    udadvise("%s: Couldn't allocate %u bytes.", me, (unsigned)nbytes);
	}

	return mem;

    } else {
	return NULL;
    }
}


/*
 *	Reallocate storage.  If unsuccessful, print error message and return
 *	a null pointer.  A null pointer is also returned if the requested 
 *	size is non-positive.  If a null pointer is returned, then the
 *	contents pointed at by the original pointer should be unchanged.
 */

    VOIDP
udrealloc(ptr, nbytes)
    VOIDP	ptr;
    size_t	nbytes;
{
    static char	me[]	= "udrealloc";

    if (nbytes > 0) {
	VOIDP	mem	= ptr == NULL 
				?         udmalloc(nbytes) 
				: (VOIDP) realloc(ptr, nbytes);

	if (mem == NULL) {
	    uderror(me);
	    udadvise("%s: Couldn't allocate %u bytes.", me, (unsigned)nbytes);
	}

	return mem;

    } else {
	return NULL;
    }
}
