/*
 * $Id: udposix.h,v 1.2 1991/09/17 20:38:47 steve Exp $
 *
 * Header-file for the ConvexOS 9.1 version of the Unidata POSIX
 * programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#define	UDPOSIX_H_INCLUDED

/*
 * Set NDEBUG according to DEBUG.
 */
#ifdef DEBUG
#   undef NDEBUG
#else
#   define NDEBUG
#endif

typedef	int		bool;
#define	NO		0
#define	YES		1
typedef void		*VOIDP;
typedef void		*voidp;
#define FREE_ARG	void*			/* argument to free(3) */

#undef UD_STD_C
#ifdef __STDC__
#  define UD_STD_C
#ifdef __GNUC__
#  undef UD_STD_C
#  define UD_STD_C
#endif
#ifdef __cplusplus
#  undef UD_STD_C
#  define UD_STD_C
#endif
#ifdef c_plusplus
#  undef UD_STD_C
#  define UD_STD_C
#endif

/*
 *	The macro PROTO() is for declaring functions regardless of the 
 *	availability of function prototypes.  NB: will need double parens 
 *	in actual use (e.g.  "int func PROTO((int a, char *cp))").
 */
#ifdef UD_STD_C
#   define	PROTO(a)	a
#   define	MAKESTRING(s)	# s
#   define	GLUE(a,b)	a##b
#else
#   define	PROTO(a)	()
#   define	volatile
#   define	const
#   define	signed
#   define	MAKESTRING(s)	"s"
#   define	GLUE(a,b)	a/**/b
#endif

#undef UD_STD_C

#endif	/* UDPOSIX_H_INCLUDED undefined */
