/*
 * $Id: stdlib.h,v 1.4 1991/03/28 00:12:22 steve Exp $
 * $__Header$
 *
 * <stdlib.h> header-file for the Ultrix 3.5 version of the Unidata POSIX
 * programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#   include "/usr//include//stdlib.h"
#else

#ifndef	UD_STDLIB_H_INCLUDED
#define	UD_STDLIB_H_INCLUDED

/*
 *	Include appropriate implementation-supplied header files.
 */
#include <math.h>	/* atof, atol */
#include <malloc.h>	/* malloc, realloc, free */

/*
 *	Handle missing symbols that need definitions.
 */
extern double	strtod	PROTO((char *s, char **endp));
extern long	strtol	PROTO((char *s, char **endp, int base));
extern void	srand	PROTO((int seed));
extern char	*calloc	PROTO((unsigned nobj, unsigned size));
extern void	abort	PROTO((void));
extern void	exit	PROTO((int status));
extern char	*getenv	PROTO((char *name));
extern char	*bsearch	PROTO((char *key, char *base, unsigned n,
			    unsigned size, int (*cmp)()));
extern int	qsort	PROTO((char *base, int n, int size, int (*cmp)()));

#define	labs(i)	((long)abs(i))
#define	EXIT_SUCCESS	0
#define	EXIT_FAILURE	1

/*
 *	The following functions don't appear to exist in the library:
 *
 *	unsigned long	strtoul	(const char *s, char **endp, int base)
 *	int		atexit	(void (*fcn)(void))
 *	div_t		div	(int num, int denom)
 *	ldiv_t		ldiv	(long num, long denom)
 */

#endif	/* !UD_STDLIB_H_INCLUDED */

#endif	/* UDPOSIX_H_INCLUDED defined */
