/*
 * $Id: limits.h,v 1.1 1991/07/22 20:17:58 steve Exp $
 *
 * <limits.h> header-file for the UNICOS UNICOS 5.1.9 of the Unidata
 * programming environment.
 */

#ifndef	UD_LIMITS_H_INCLUDED
#define	UD_LIMITS_H_INCLUDED

#ifdef UDPOSIX_H_INCLUDED

/*
 * POSIX Table 2.2
 */
#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_MAX_INPUT	255
#define _POSIX_NAME_MAX		14
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_OPEN_MAX		16
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512

/*
 * POSIX Table 2.3
 */
#define NGROUPS_MAX		16

/*
 * POSIX Table 2.4
 */
#define ARG_MAX		_POSIX_ARG_MAX
#define CHILD_MAX	_POSIX_CHILD_MAX
#define OPEN_MAX	_POSIX_OPEN_MAX

/*
 * POSIX Table 2.5
 */
#define LINK_MAX	_POSIX_LINK_MAX
#define MAX_CANON	_POSIX_MAX_CANON
#define MAX_INPUT	_POSIX_MAX_INPUT
#define NAME_MAX	_POSIX_NAME_MAX
#define PATH_MAX	_POSIX_PATH_MAX
#define PIPE_BUF	_POSIX_PIPE_BUF

/*
 * Standard C
 *
 * NB: The following are appropriate for SunOS; not UNICOS.
 */
#if 0
#define CHAR_BIT	            8
#define CHAR_MAX	    SCHAR_MAX
#define CHAR_MIN	    SCHAR_MIN
#define INT_MAX		 017777777777
#define INT_MIN		-020000000000
#define LONG_MAX	      INT_MAX
#define LONG_MIN	      INT_MIN
#define SCHAR_MAX	         0177
#define SCHAR_MIN	        -0200
#define SHRT_MAX	       077777
#define SHRT_MIN	     -0100000
#define UCHAR_MAX	         0377
#define UINT_MAX	 037777777777
#define ULONG_MAX	     UINT_MAX
#define USHRT_MAX	      0177777
#endif

#endif	/* UD_LIMITS_H_INCLUDED not defined */

#endif	/* UDPOSIX_H_INCLUDED defined */
