/*
 * $Id: limits.h,v 1.1 1991/07/25 17:07:56 steve Exp $
 *
 * <limits.h> header-file for the VMS 5.3 version of the Unidata
 * programming environment.
 */

#include limits.h

#ifdef UDPOSIX_H_INCLUDED

#ifndef	UD_LIMITS_H_INCLUDED
#define	UD_LIMITS_H_INCLUDED

/*
 * POSIX Table 2.2
 */
#define _POSIX_ARG_MAX		4096
#define _POSIX_CHILD_MAX	6
#define _POSIX_LINK_MAX		8
#define _POSIX_MAX_CANON	255
#define _POSIX_MAX_INPUT	255
#define _POSIX_NAME_MAX		14
#define _POSIX_NGROUPS_MAX	0
#define _POSIX_OPEN_MAX		16
#define _POSIX_PATH_MAX		255
#define _POSIX_PIPE_BUF		512

/*
 * POSIX Table 2.3
 */
#define NGROUPS_MAX		16

/*
 * POSIX Table 2.4
 */
#define ARG_MAX		_POSIX_ARG_MAX
#define CHILD_MAX	_POSIX_CHILD_MAX
#define OPEN_MAX	_POSIX_OPEN_MAX

/*
 * POSIX Table 2.5
 */
#define LINK_MAX	_POSIX_LINK_MAX
#define MAX_CANON	_POSIX_MAX_CANON
#define MAX_INPUT	_POSIX_MAX_INPUT
#define NAME_MAX	_POSIX_NAME_MAX
#define PATH_MAX	_POSIX_PATH_MAX
#define PIPE_BUF	_POSIX_PIPE_BUF

#endif	/* UD_LIMITS_H_INCLUDED not defined above */

#endif	/* UDPOSIX_H_INCLUDED defined above */
