/*
 * $Id: stat.h,v 1.1 1991/07/26 20:32:58 steve Exp $
 *
 * <sys/stat.h> header-file for the VMS 5.4 version of the Unidata POSIX 
 * programming environment.
 */

#ifndef UDPOSIX_H_INCLUDED
#   include stat
#else

#ifndef UD_SYS_STAT_H_INCLUDED
#define	UD_SYS_STAT_H_INCLUDED

#include stat

#define	S_ISBLK(m)	(((m)&S_IFMT) == S_IFBLK)
#define	S_ISCHR(m)	(((m)&S_IFMT) == S_IFCHR)
#define	S_ISDIR(m)	(((m)&S_IFMT) == S_IFDIR)
#define	S_ISREG(m)	(((m)&S_IFMT) == S_IFREG)
#define S_ISFIFO(m)	0	/* No FIFOs under VMS */

#define	S_IRWXU	0000700	/* rwx, owner */
#define		S_IRUSR	0000400	/* read permission, owner */
#define		S_IWUSR	0000200	/* write permission, owner */
#define		S_IXUSR	0000100	/* execute/search permission, owner */

#define	S_IRWXG	0000070	/* rwx, group */
#define		S_IRGRP	0000040	/* read permission, group */
#define		S_IWGRP	0000020	/* write permission, grougroup */
#define		S_IXGRP	0000010	/* execute/search permission, group */

#define	S_IRWXO	0000007	/* rwx, other */
#define		S_IROTH	0000004	/* read permission, other */
#define		S_IWOTH	0000002	/* write permission, other */
#define		S_IXOTH	0000001	/* execute/search permission, other */

#endif	/* UD_SYS_STAT_H_INCLUDED */

#endif	/* UDPOSIX_H_INCLUDED defined */
