/*
 * $Id: udinfile.c,v 2.9 1991/06/28 16:19:06 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include "udres.h"
#include "uderrmsg.h"
#include "udpath.h"


/*
 * Convert an input file.
 */
    int
UdInFile(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		success	= 1;		/* Routine status = success */
    static char	me[]	= "UdInFile";

    if (success = UdString(str, bin, mode)) {

	if (mode == UD_MNEMONIC) {
	    *(char**)str	= "InFile";

	} else if (mode == UD_TO_BINARY && str != NULL) {
	    int		type, accessmode;

	    success	= 0;			/* Make success an exception */

	    if (strcmp((char*)str, "-") == 0) {
		if (fdopen(0, "r") == (FILE*)0) {
		    udadvise("%s: Can't open standard input \"-\".", me);
		} else {
		    success	= 1;
		}
	    } else {
		if (!udpath((char*)str, &type, &accessmode)) {
		    uderror("udpath");
		    udadvise("%s: Can't access file \"%s\".", me, (char*)str);
		} else if (type != UD_FREG && 
			   type != UD_FCHR &&
			   type != UD_FFIFO &&
			   type != UD_FBLK) {
		    udadvise("%s: \"%s\" is not file-like.", me, (char*)str);
		} else if (!(accessmode & UD_FREAD)) {
		    udadvise("%s Input file \"%s\" is not readable.", me, 
			(char*)str);
		} else {
		    success	= 1;
		}
	    }
	}
    }

    return success;
}
