/*
 * $Id: udint.c,v 2.5 1991/04/10 19:30:33 steve Exp $
 *
 * $__Header$
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stdio.h>
#include <string.h>
#include "udres.h"
#include "uderrmsg.h"

extern char	*udstrdup();


/*
 * Convert an integer.
 */
int
UdInt(str, bin, mode)
    VOIDP	str;
    VOIDP	bin;
    int		mode;
{
    int		status	= 1;
    static char	me[]	= "UdInt";

    if (mode == UD_MNEMONIC) {
	*(char**)str	= "int";

    } else if (mode == UD_POINTER) {
	*(int**)bin	= (int*)str;

    } else if (mode == UD_BIN_SIZE) {
	status	= sizeof(int);

    } else if (mode == UD_TO_STRING) {
	char	buf[80];

	(void)sprintf(buf, "%d", *(int*)bin);
	*(char**)str	= udstrdup(buf);

    } else if (mode == UD_TO_BINARY) {
	if (str != NULL) {
	    int		val;

	    if (sscanf((char*)str, "%d", &val) != 1) {
		udadvise("%s: \"%s\" is an invalid integer.", me, (char*)str);
		status	= 0;
	    } else if (bin != NULL) {
		*(int*)bin	= val;
	    }
	}

    } else {
	status	= 0;
    }

    return status;
}
