//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : lidia_vector.h 
// Author      : Frank Lehmann (FL), Markus Maurer (MM), 
//               Thomas Papanikolaou (TP)
// Last change : FL/MM, Feb 15 1995, initial version
//               FL/MM, May 10 1995, clean-up
//		 FL/MM, May 15 1995, changed type of size variables to base_vector<T>::size_type
//		 FL/MM, May 23 1995, removed math_sort_vector and file_sort_vector;
//				     changed vector into lidia_vector
//		 FL/MM, Jul  6 1995, replaced base_vector<T>::size_type by lidia_size_t
//               FL/MM, Jul 24 1995, added 'const' to T* parameters of constructors


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
// *
// *    File        :  lidia_vector.h
// *
// *    Description :  -) definition of template class 'lidia_vector<T>'
// *                      to combine the capabilities of the classes
// *    	          'base_vector<T>', 'math_vector<T>', 'sort_vector<T>',
// *                      and 'file_vector<T>'
// *
// *                   -) virtual base classes are 'sort_vector<T>',
// * 			  'math_vector<T>', and 'file_vector<T>'
// *
// * 		       -) the requirements on type T are derived by those
// *			  of the corresponding base classes
// *
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


#ifndef LIDIA_LIDIA_VECTOR_H
#define LIDIA_LIDIA_VECTOR_H

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:math_vector.h>
#include <LiDIA:sort_vector.h>
#include <LiDIA:file_vector.h>
#else
#include <LiDIA/math_vector.h>
#include <LiDIA/sort_vector.h>
#include <LiDIA/file_vector.h>
#endif

template <class T> class  lidia_vector : virtual public file_vector < T >,
					 virtual public sort_vector < T >,
					 virtual public math_vector < T >
{

  /**
   ** constructors
   **/

 public:

  inline lidia_vector() : base_vector < T > (0, FIXED) {}
  inline lidia_vector(lidia_size_t all, char md) : base_vector < T > (all, md) {} 
  inline lidia_vector(lidia_size_t all, lidia_size_t len) : base_vector < T > (all, len, FIXED) {}
  inline lidia_vector(lidia_size_t all, lidia_size_t len, char md) : base_vector < T > (all, len, md) {}
  inline lidia_vector(const base_vector < T > & v) : base_vector < T > (v, FIXED) {}
  inline lidia_vector(const base_vector < T > & v, char md) : base_vector < T > (v, md) {}
  inline lidia_vector(const  T *v, lidia_size_t len) : base_vector < T > (v, len, FIXED) {}
  inline lidia_vector(const  T *v, lidia_size_t len, char md) : base_vector < T > (v, len, md) {}

  /**		
   ** destructor 
   **/

 public:

  inline ~lidia_vector() {}

  /**
   ** assignment 
   **/

  lidia_vector < T > & operator = (const lidia_vector < T > & v) 
     {
       debug_handler_l ( "lidia_vector", "operator=", LDBL_VECTOR +2 ) ;
       
       if ( & v != this )
	 base_vector < T >::operator = (v);
       return *this;
     }   			
};

#endif








