//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : memory.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_MEMORY_H
#define LIDIA_MEMORY_H

typedef void (*memory_handler_ptr)(char *, char *);

extern memory_handler_ptr lidia_memory_handler;
extern void default_memory_handler(char *, char *);
extern memory_handler_ptr set_memory_handler(memory_handler_ptr);

#ifdef LIDIA_MEMORY
#define memory_handler(vec, name, message) if ((vec) == 0) \
				     lidia_memory_handler(name, message)
#else
#define memory_handler(vec, name, message) { }
#endif

#endif
