#ifndef LIDIA_QUADRATIC_FORM_H
#define LIDIA_QUADRATIC_FORM_H

#include <LiDIA/bigint.h>
#include <LiDIA/matrix_GL2Z.h>

class quadratic_form
{
  bigint a, b, c, delta;

 public:

  quadratic_form();
  quadratic_form(const bigint &, const bigint &, const bigint &);
  quadratic_form(const long & , const long &,const long &);
  quadratic_form(const quadratic_form &);
  ~quadratic_form();
  int definiteness();
  
  int is_regular() const;
  int is_bin_quad() const;
  int is_pos_def() const;
  int is_neg_def() const;
  int is_pos_semidef() const;
  int is_neg_semidef() const;
  int is_indef() const;
  void assign(const quadratic_form &);
  int abs_compare(const quadratic_form &) const;
  int compare(const quadratic_form &) const;
 
  void neutral(const bigint &);
  void inverse();

  const bigint & get_a() const;
  const bigint & get_b() const;
  const bigint & get_c() const;
  const bigint & get_delta() const;

  quadratic_form & operator = (const quadratic_form & a);
  bigint operator () (const bigint &, const bigint &);
  friend int operator < (quadratic_form, quadratic_form);	//Lexic. Or.
  friend int operator <= (quadratic_form, quadratic_form); 
  friend int operator > (quadratic_form, quadratic_form);
  friend int operator >= (quadratic_form, quadratic_form);
  friend int operator ==(quadratic_form, quadratic_form);
  
  bigint eval(const bigint & , const bigint &);	//returns f(x,y)
  
  friend void  transform   (quadratic_form & , matrix_GL2Z  ); //f=f*U
  
  void t();			//f=f*T
  void u();			//f=f* U U=(-1,0,0,1)
  
  bigint norm_number();		// returns the normalization number
  bigint norm_number_pos_def();
  bigint norm_number_indef();
  
  int is_reduced();		// returns one if *This is reduced 0 else
  int is_reduced_pos_def();
  int is_reduced_indef();
  int is_reduced_irregular();
  
  int normalize();
  int  normalize(matrix_GL2Z &);
  
  int rho();
  int rho(matrix_GL2Z &);
  void reduce();
  void reduce_irregular();
  void almost_reduce_irregular(matrix_GL2Z &);
  void reduce_irregular(matrix_GL2Z & );
  void reduce(matrix_GL2Z &);
  
friend int prop_equivalent(const quadratic_form &, const quadratic_form &);
friend int prop_equivalent_pos_def(const quadratic_form &, const quadratic_form &);
friend int prop_equivalent_indef(const quadratic_form &, const quadratic_form &);
friend int prop_equivalent_irregular(const quadratic_form &, const quadratic_form &);
friend int prop_equivalent_neg_def(const quadratic_form &, const quadratic_form &);
friend int prop_equivalent(const quadratic_form &, const quadratic_form &, matrix_GL2Z &);
friend int prop_equivalent_pos_def(const quadratic_form &, const quadratic_form &, matrix_GL2Z &);
friend int prop_equivalent_neg_def(const quadratic_form &, const quadratic_form &, matrix_GL2Z &);
friend int prop_equivalent_indef(const quadratic_form &, const quadratic_form & ,matrix_GL2Z &);
friend int prop_equivalent_irregular(const quadratic_form &, const quadratic_form & ,matrix_GL2Z &);
friend int equivalent(const quadratic_form &, const quadratic_form & ,matrix_GL2Z &);
friend int equivalent(const quadratic_form &, const quadratic_form & );
  
  
  void fundamental_automorphism(matrix_GL2Z &);
  friend istream & operator >> (istream & in, quadratic_form & a);
  friend ostream & operator << (ostream & out, const quadratic_form & a);
};				

#endif
