//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : error_handling.h
// Author      : Patrick Theobald (PT)
// Last change : PT, Oct 28, 1995, initial version
//             

/*
$Id: xerror.h,v 1.2 1995/11/17 09:05:04 theobald Exp $
*/

#ifndef LIDIA_ERROR_HANDLING_H
#define LIDIA_ERROR_HANDLING_H

#include <LiDIA/error.h>
#include <LiDIA/bigint.h>

inline void lidia_error_handler_para(char *file, char *msg)
{lidia_error_handler(file,msg);}

inline void lidia_error_handler_para(const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const char& para1, const char *name1, const char *cond1, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const bigint& para1, const char *name1, const char *cond1, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int& para1, const char *name1, const char *cond1, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const float& para1, const char *name1, const char *cond1, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const char *const & para1, const char *name1, const char *cond1, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const char & para2, const char *name2, const char *cond2, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2, 
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const int & para3, const char *name3, const char *cond3,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const char * para3, const char *name3, const char *cond3,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}


inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const int & para3, const char *name3, const char *cond3,
				     const int & para4, const char *name4, const char *cond4,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name4 << " = " << para4 << "\t  condition: " << cond4 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const int & para3, const char *name3, const char *cond3,
				     const int & para4, const char *name4, const char *cond4,
				     const char * para5, const char *name5, const char *cond5,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name5 << " = " << para5 << "\t  condition: " << cond5 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const int & para3, const char *name3, const char *cond3,
				     const int & para4, const char *name4, const char *cond4,
				     const int & para5, const char *name5, const char *cond5,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name5 << " = " << para5 << "\t  condition: " << cond5 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}


inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const int & para3, const char *name3, const char *cond3,
				     const int & para4, const char *name4, const char *cond4,
				     const int & para5, const char *name5, const char *cond5,
				     const int & para6, const char *name6, const char *cond6,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name5 << " = " << para5 << "\t  condition: " << cond5 << endl;
  cerr << "actual parameter: " << name6 << " = " << para6 << "\t  condition: " << cond6 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

inline void lidia_error_handler_para(const int & para1, const char *name1, const char *cond1, 
				     const int & para2, const char *name2, const char *cond2,
				     const int & para3, const char *name3, const char *cond3,
				     const int & para4, const char *name4, const char *cond4,
				     const int & para5, const char *name5, const char *cond5,
				     const int & para6, const char *name6, const char *cond6,
				     const int & para7, const char *name7, const char *cond7,
				     const int & para8, const char *name8, const char *cond8,
				     const int & para9, const char *name9, const char *cond9,
				     const int & para10, const char *name10, const char *cond10,
				     const char *proto, char *file, char *msg)
{
  cerr << "FUNCTION: " << endl << proto << endl << endl;
  cerr << "PARAMETERS: " << endl;
  cerr << "actual parameter: " << name1 << " = " << para1 << "\t  condition: " << cond1 << endl;
  cerr << "actual parameter: " << name2 << " = " << para2 << "\t  condition: " << cond2 << endl;
  cerr << "actual parameter: " << name3 << " = " << para3 << "\t  condition: " << cond3 << endl;
  cerr << "actual parameter: " << name4 << " = " << para4 << "\t  condition: " << cond4 << endl;
  cerr << "actual parameter: " << name5 << " = " << para5 << "\t  condition: " << cond5 << endl;
  cerr << "actual parameter: " << name6 << " = " << para6 << "\t  condition: " << cond6 << endl;
  cerr << "actual parameter: " << name7 << " = " << para7 << "\t  condition: " << cond7 << endl;
  cerr << "actual parameter: " << name8 << " = " << para8 << "\t  condition: " << cond8 << endl;
  cerr << "actual parameter: " << name9 << " = " << para9 << "\t  condition: " << cond9 << endl;
  cerr << "actual parameter: " << name10 << " = " << para10 << "\t  condition: " << cond10 << endl << endl;
  cerr << "MESSAGE: " << endl;
  lidia_error_handler(file, msg);
}

#endif
