SET I osakkeet / RAUTA, SOFTA, VIIHDE, KIINTKORKO / ;
ALIAS (I,J);

SCALAR TAVOITE keskim. vuosittainen tuotto (%) / 10 / ;

PARAMETER KESKIM(I) keskim. vuosittainen tuotto (%)
     / RAUTA 8, SOFTA 9, VIIHDE 12, KIINTKORKO 7 / ;

TABLE V(I,J) varianssit ja kovarianssit
                RAUTA   SOFTA   VIIHDE   KIINTKORKO
  RAUTA           4       3       -1         0
  SOFTA           3       6        1         0
  VIIHDE         -1       1       10         0
  KIINTKORKO      0       0        0         0

SCALARS MINTUOTTO pienimman sijoituskohteen tuotto
        MAXRISKI sijoituskohteiden suurin varianssi ;

POSITIVE VARIABLE X(I) kohteeseen I sijoitettu osuus ;
VARIABLE VARIANSSI osakesalkun varianssi ;

EQUATIONS SIJSUMMA sijoitusten osuudet yhteensa 1.0
          KESKITUOT osakesalkun keskimaarainen tuotto
          VAREQ varianssin maaritelma ;

SIJSUMMA.. SUM(I, X(I)) =E= 1.0 ;
KESKITUOT.. SUM(I, KESKIM(I)*X(I)) =G= TAVOITE ;
VAREQ.. SUM(I, X(I)*SUM(J, V(I,J)*X(J))) =E= VARIANSSI ;

MODEL OSAKKEET / ALL / ;
SOLVE OSAKKEET USING NLP MINIMIZING VARIANSSI ;
