SET I tuotteet / T1 * T4 /;

PARAMETERS YLARAJAT(I) / T1 250, T2 170, T3 150, T4 300 /
           HINNAT(I)   / T1 4.5, T2 2.6, T3 4.0, T4 1.5 /
           KUSTANN(I)  / T1 4.0, T2 2.0, T3 4.0, T4 1.0 /
           ALOITUS(I)  / T1 10.0, T2 25.0, T3 5.0, T4 15.0 / ;

SCALAR MAXTUOT maksimi kokonaistuotannolle / 450 /;

POSITIVE VARIABLE TUOTANTO(I) tuotantomaara ;
BINARY VARIABLE BINTUOT(I)    binaarimuuttuja tuotannolle ;
FREE VARIABLE TUOTTO          voiton kokonaissumma ;

EQUATION EQ1(I) tuotantorajat
         EQ2 kokonaistuotanto
         OBJ kohdefunktio;

EQ1(I).. TUOTANTO(I) =L= YLARAJAT(I)*BINTUOT(I);
EQ2.. SUM(I, TUOTANTO(I)) =L= MAXTUOT;
OBJ.. TUOTTO =E= SUM(I, (HINNAT(I) - KUSTANN(I))*TUOTANTO(I)) - 
                 SUM(I, ALOITUS(I)*BINTUOT(I));

MODEL TMALLI / ALL /;
OPTION OPTCR = 0.0;
SOLVE TMALLI USING MIP MAXIMIZING TUOTTO;
