SUBROUTINE objfun(mode,n,x,objf,objgrd,nstate)
  ! Kohdefunktio ja gradienttivektori
  IMPLICIT NONE
  REAL, INTENT(OUT) :: objf
  INTEGER, INTENT(IN) :: mode, n, nstate
  REAL, DIMENSION(n), INTENT(IN) :: x
  REAL, DIMENSION(n), INTENT(OUT) :: objgrd
  objf = (x(1)-2.0d0)**2 + (x(2)-1.0d0)**2
  objgrd(1) = 2.0d0*(x(1)-2.0d0)
  objgrd(2) = 2.0d0*(x(2)-1.0d0)
END SUBROUTINE objfun

SUBROUTINE confun(mode,ncnln,n,nrowj,x,c,cjac,nstate)
  ! Rajoitteet ja Jacobin matriisi
  IMPLICIT NONE
  INTEGER, INTENT(IN) :: mode, ncnln, n, nrowj, nstate
  REAL, DIMENSION(n), INTENT(IN) :: x
  REAL, DIMENSION(nrowj), INTENT(OUT) :: c
  REAL, DIMENSION(nrowj,n), INTENT(INOUT) :: cjac
  ! Alustetaan Jacobin matriisi
  IF (nstate == 1) cjac(1:ncnln,1:n) = 0.0d0
  ! Eplineaarinen rajoite 1
  c(1) = -(x(1)**2)/4.0d0 - x(2)**2
  ! Jacobin matriisin rivi 1
  cjac(1,1) = -0.5d0*x(1)
  cjac(1,2) = -2.0d0*x(2)
END SUBROUTINE confun
