SET i Tuotteet / T1 * T4 /;

SCALAR Maxtuot Maksimi kokonaistuotannolle / 450 /;
PARAMETERS Ylarajat(i) / T1 250, T2 170, T3 150, T4 300 /
           Hinnat(i)   / T1 4.5, T2 2.6, T3 4.0, T4 1.5 /
           Kust(i)     / T1 4.0, T2 2.0, T3 4.0, T4 1.0 /
           Aloitus(i)  / T1 10.0, T2 25.0, T3 5.0, T4 15.0 /;

POSITIVE VARIABLE Tuotanto(i) Tuotantomaara;
BINARY VARIABLE Bintuot(i)    Binaarimuuttuja tuotannolle;
FREE VARIABLE Tuotto          Voiton kokonaissumma;

EQUATIONS Eq1(i), Eq2, Obj;

Eq1(i).. Tuotanto(i) =L= Ylarajat(i)*Bintuot(i);
Eq2.. SUM(i, Tuotanto(i)) =L= Maxtuot;
Obj.. Tuotto =E= SUM(i, (Hinnat(i) - Kust(i))*Tuotanto(i)) - 
                 SUM(i, Aloitus(i)*Bintuot(i));

MODEL Tmalli / ALL /;
OPTION OPTCR = 0.0;
SOLVE Tmalli USING MIP MAXIMIZING Tuotto;
