/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import java.util.Date;
import java.util.GregorianCalendar;
import org.gnu.pilotlink.Record;

public class DatebookRecord
extends Record {
    byte[] buffer = new byte[65535];
    public static final int REP_WEEKLY = 2;
    public static final int REP_DAYLY = 1;
    public static final int REP_MONTHLY_BY_DAY = 3;
    public static final int REP_MONTHLY_BY_DATE = 4;
    public static final int REP_YEARLY = 5;
    public static final int REP_NONE = 6;
    public static final int NO_REP = 0;
    public static final int ALARM_MINUTES = 0;
    public static final int ALARM_HOURS = 1;
    public static final int ALARM_DAYS = 2;
    public static final int ALARM_NONE = 3;
    private Date startDate;
    private Date endDate;
    private Date repeatEnd;
    private String description;
    private String note;
    private int alarmAdvance;
    private int alarmUnits;
    private int repAdvance;
    private int repType;
    private int repDay;
    private int repWeekstart;
    private int dist;
    private Date[] repExceptions;
    private boolean[] repDays;
    private boolean hasNote;
    private boolean hasAlarm;
    private boolean hasTime;
    private boolean isRepeated;
    private boolean hasDescription;
    private boolean hasExceptions;
    private boolean repeatForever;

    public boolean hasNote() {
        return this.hasNote;
    }

    public boolean hasTime() {
        return this.hasTime;
    }

    public boolean hasAlarm() {
        return this.hasAlarm;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public boolean hasDescription() {
        return this.hasDescription;
    }

    public boolean hasExceptions() {
        return this.hasExceptions;
    }

    public boolean repeatForever() {
        return this.repeatForever;
    }

    public DatebookRecord(Date date, Date date2, String string, String string2) {
        this.resetVars();
        this.startDate = date;
        this.endDate = date2;
        this.description = string;
        this.note = string2;
        if (string2 != null && string2.length() != 0) {
            this.hasNote = true;
        }
        if (string != null && string.length() != 0) {
            this.hasDescription = true;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        if (gregorianCalendar.get(11) != 0 && gregorianCalendar.get(12) != 0) {
            this.hasTime = true;
        }
        this.setSize(this.getBuffer().length);
    }

    public DatebookRecord(Record record) {
        super(record);
    }

    public DatebookRecord() {
        this.startDate = new Date();
        this.resetVars();
        this.endDate = new Date();
    }

    private void resetVars() {
        this.description = "";
        this.note = "";
        this.alarmAdvance = 0;
        this.alarmUnits = 3;
        this.repAdvance = 0;
        this.repType = 6;
        this.repDay = 0;
        this.repWeekstart = 0;
        this.repAdvance = 0;
        this.dist = 0;
        this.repDays = new boolean[]{false, false, false, false, false, false, false};
        this.hasNote = false;
        this.hasAlarm = false;
        this.hasTime = false;
        this.isRepeated = false;
        this.hasDescription = false;
        this.hasExceptions = false;
        this.repeatForever = false;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        int n;
        this.resetVars();
        if (byArray[0] == -1 && byArray[1] == -1) {
            this.hasTime = false;
            this.endDate = this.startDate = Record.getDateAt(byArray, 4);
        } else {
            this.hasTime = true;
            this.startDate = Record.getDateTimeAt(byArray, 4, 0);
            this.endDate = Record.getDateTimeAt(byArray, 4, 2);
        }
        byte by = byArray[6];
        if ((by & 0x40) != 0) {
            this.hasAlarm = true;
        }
        if ((by & 0x20) != 0) {
            this.isRepeated = true;
        }
        if ((by & 8) != 0) {
            this.hasExceptions = true;
        }
        if ((by & 0x10) != 0) {
            this.hasNote = true;
        }
        if ((by & 4) != 0) {
            this.hasDescription = true;
        }
        int n2 = 8;
        if (this.hasAlarm) {
            this.alarmAdvance = byArray[n2];
            this.alarmUnits = byArray[++n2];
            ++n2;
        }
        if (this.isRepeated) {
            this.repType = byArray[n2];
            this.dist = 256 * byArray[n2 += 2] + byArray[n2] + 1;
            if (this.dist == 65535) {
                this.repeatForever = true;
            } else {
                this.repeatEnd = Record.getDateAt(byArray, n2);
            }
            this.repAdvance = byArray[n2 += 2];
            n = byArray[++n2];
            if (this.repType == 3) {
                this.repDay = n;
            } else {
                for (int i = 0; i < 7; ++i) {
                }
            }
            this.repWeekstart = byArray[++n2];
            n2 += 2;
        }
        if (this.hasExceptions) {
            this.repExceptions = new Date[byArray[n2]];
            n2 += 2;
            n = 0;
            while (n < this.repExceptions.length) {
                this.repExceptions[n] = Record.getDateAt(byArray, n2);
                ++n;
                n2 += 2;
            }
        }
        if (this.hasDescription) {
            this.description = Record.getStringAt(byArray, n2);
            n2 += this.description.length() + 1;
        }
        if (this.hasNote) {
            this.note = Record.getStringAt(byArray, n2);
            n2 += this.note.length() + 1;
        }
        this.setSize(n2);
    }

    @Override
    public byte[] getBuffer() {
        int n;
        int n2;
        int n3 = 0;
        if (!this.hasTime) {
            this.buffer[0] = -1;
            this.buffer[1] = -1;
            this.buffer[2] = -1;
            this.buffer[3] = -1;
            Record.setDateAt(this.buffer, this.startDate, 4);
        } else {
            Record.setDateTimeAt(this.buffer, this.startDate, 4, 0);
            Record.setDateTimeAt(this.buffer, this.endDate, 4, 2);
        }
        int n4 = 0;
        if (this.hasAlarm) {
            n4 |= 0x40;
        }
        if (this.isRepeated) {
            n4 |= 0x20;
        }
        if (this.hasExceptions) {
            n4 |= 8;
        }
        if (this.hasNote) {
            n4 |= 0x10;
        }
        if (this.hasDescription) {
            n4 |= 4;
        }
        this.buffer[6] = (byte)n4;
        n3 = 8;
        if (this.hasAlarm) {
            this.buffer[n3] = (byte)this.alarmAdvance;
            this.buffer[++n3] = (byte)this.alarmUnits;
            ++n3;
        }
        if (this.isRepeated) {
            this.buffer[n3] = (byte)this.repType;
            n3 += 2;
            if (this.repeatForever) {
                this.buffer[n3] = -1;
                this.buffer[n3 + 1] = -1;
            } else {
                Record.setIntAt(this.buffer, this.dist - 1, n3);
            }
            this.buffer[n3 += 2] = (byte)this.repAdvance;
            ++n3;
            if (this.repType == 3) {
                this.buffer[n3] = (byte)this.repDay;
            } else {
                n2 = 0;
                for (n = 0; n < 7; ++n) {
                    if (!this.repDays[n]) continue;
                    n2 |= 1 << n;
                }
            }
            this.buffer[++n3] = (byte)this.repWeekstart;
            n3 += 2;
        }
        if (this.hasExceptions) {
            this.buffer[n3] = (byte)this.repExceptions.length;
            n3 += 2;
            n2 = 0;
            while (n2 < this.repExceptions.length) {
                Record.setDateAt(this.buffer, this.repExceptions[n2], n3);
                ++n2;
                n3 += 2;
            }
        }
        if (this.hasDescription) {
            n3 = Record.setStringAt(this.buffer, this.description, n3);
        }
        if (this.hasNote) {
            n3 = Record.setStringAt(this.buffer, this.note, n3);
        }
        byte[] byArray = new byte[n3];
        for (n = 0; n < n3; ++n) {
            byArray[n] = this.buffer[n];
        }
        return byArray;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date repeatUntil() {
        return this.repeatEnd;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNote() {
        return this.note;
    }

    public Date getRepeatEnd() {
        return this.repeatEnd;
    }

    public Date[] getRepExceptions() {
        return this.repExceptions;
    }

    public int getRepWeekstart() {
        return this.repWeekstart;
    }

    public int getRepDay() {
        return this.repDay;
    }

    public int getRepType() {
        return this.repType;
    }

    public int getRepAdvance() {
        return this.repAdvance;
    }

    public int getAlarmAdvance() {
        return this.alarmAdvance;
    }

    public int getAlarmUnits() {
        return this.alarmUnits;
    }

    public boolean[] getRepDays() {
        return this.repDays;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
        this.setSize(this.getBuffer().length);
    }

    public void setEndDate(Date date) {
        this.endDate = date;
        if (date != null) {
            this.hasTime = true;
        }
        this.setSize(this.getBuffer().length);
    }

    public void setRepeated(boolean bl) {
        this.isRepeated = bl;
    }

    public void setRepeatForever(boolean bl) {
        this.repeatForever = bl;
    }

    public void setRepeatEnd(Date date) {
        this.repeatEnd = date;
        if (date != null) {
            this.setRepeatForever(false);
        }
        this.setSize(this.getBuffer().length);
    }

    public void setDescription(String string) {
        this.description = string;
        this.hasDescription = string != null;
        this.setSize(this.getBuffer().length);
    }

    public void setNote(String string) {
        this.note = string;
        this.hasNote = string != null;
        this.setSize(this.getBuffer().length);
    }

    public void setAlarm(boolean bl) {
        this.hasAlarm = bl;
    }

    public void setAlarmAdvance(int n) {
        this.alarmAdvance = n;
        this.setSize(this.getBuffer().length);
    }

    public void setAlarmUnits(int n) {
        this.alarmUnits = n;
        this.setSize(this.getBuffer().length);
    }

    public void setRepAdvance(int n) {
        this.repAdvance = n;
        this.setSize(this.getBuffer().length);
    }

    public void setRepType(int n) {
        this.repType = n;
        this.setSize(this.getBuffer().length);
    }

    public void setRepDay(int n) {
        this.repDay = n;
        this.setSize(this.getBuffer().length);
    }

    public void setRepWeekstart(int n) {
        this.repWeekstart = n;
        this.setSize(this.getBuffer().length);
    }

    public void setRepExceptions(Date[] dateArray) {
        this.repExceptions = dateArray;
        this.setSize(this.getBuffer().length);
    }

    public void setRepDays(boolean[] blArray) {
        this.repDays = blArray;
        this.setSize(this.getBuffer().length);
    }
}

