/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* utils.c - misc utility functions for htimp
 *
 * Jim McBeath, November 18, 1993
 */

#include <varargs.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>

int ImpUseUnderExit;

extern int sys_nerr;
extern char *sys_errlist[];

extern int ImpMasterListenConn;

void
ImpExit(n)
int n;
{
	if (ImpMasterListenConn)
		ImpMasterDisconnect(ImpMasterListenConn);
	if (ImpUseUnderExit)
		_exit(n);
	else
		exit(n);
	/* NOTREACHED */
}

ImpFatal(fmt,va_alist)
char *fmt;
va_dcl
{
	va_list plist;

	va_start(plist);
	ImpMessage("Error",fmt,plist);
	va_end(plist);
	ImpExit(1);
}

char *
ImpUnixErrstr(e)
int e;	/* errno */
{
	static char buf[20];

	if (e<0 || e>=sys_nerr) {
		sprintf(buf,"errno=%d",e);
		return buf;
	}
	else
		return sys_errlist[e];
}

/* returns a single random lowercase alpha character */
int
ImpRandChar()
{
	static int inited=0;
	int n;

	if (!inited) {
		time_t t;
		time(&t);
		srand(t);
		inited = 1;
	}
	n = rand();
	return ('a' + n%26);
}

void *
ImpMalloc(n)
unsigned int n;
{
	void *p;
	void *malloc();

	p = malloc(n);
	if (!p) {
		ImpFatal("No more memory - last request size=%d\n",n);
		/* NOTREACHED */
	}
	return p;
}

void *
ImpRealloc(oldp,n)
void *oldp;
unsigned int n;
{
	void *p;
	void *realloc();

	p = realloc(oldp,n);
	if (!p) {
		ImpFatal("No more memory - last request size=%d\n",n);
		/* NOTREACHED */
	}
	return p;
}

void
ImpFree(p)
void *p;
{
	free(p);
}

char *
ImpStrSave(s)
char *s;
{
	char *d;

	if (!s) return s;
	d = ImpMalloc(strlen(s)+1);
	strcpy(d,s);
	return d;
}

/* Replacement for getdtablesize */
int
ImpGetDescCount()
{
	struct rlimit rl;
	static int ndesc=0;

	if (ndesc)
		return ndesc;
	getrlimit(RLIMIT_NOFILE,&rl);
	ndesc = (int)rl.rlim_cur;
	return ndesc;
}

/* returns pointer to static buf, or returns rel */
char *
ImpGetAbsoluteDir(root,rel)
char *root;		/* used if rel does not start with / */
char *rel;
{
	static int alloc=0;
	static char *buf=0;
	int l;

	if (rel[0]=='/')
		return rel;	/* relative path */
	l = strlen(root)+strlen(rel)+2;
	if (l>alloc) {
		if (buf) ImpFree(buf);
		buf = ImpMalloc(l);
		alloc = l;
	}
	strcpy(buf,root);
	strcat(buf,"/");
	strcat(buf,rel);
	return buf;
}

/* end */
