#ifndef __BDK_CSRS_AP_H__
#define __BDK_CSRS_AP_H__
/* This file is auto-generated. Do not edit */

/***********************license start***************
 * Copyright (c) 2003-2017  Cavium Inc. (support@cavium.com). All rights
 * reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.

 *   * Neither the name of Cavium Inc. nor the names of
 *     its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written
 *     permission.

 * This Software, including technical data, may be subject to U.S. export  control
 * laws, including the U.S. Export Administration Act and its  associated
 * regulations, and may be subject to export or import  regulations in other
 * countries.

 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND CAVIUM  NETWORKS MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE, INCLUDING ITS CONDITION, ITS CONFORMITY TO ANY REPRESENTATION OR
 * DESCRIPTION, OR THE EXISTENCE OF ANY LATENT OR PATENT DEFECTS, AND CAVIUM
 * SPECIFICALLY DISCLAIMS ALL IMPLIED (IF ANY) WARRANTIES OF TITLE,
 * MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE, LACK OF
 * VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR
 * CORRESPONDENCE TO DESCRIPTION. THE ENTIRE  RISK ARISING OUT OF USE OR
 * PERFORMANCE OF THE SOFTWARE LIES WITH YOU.
 ***********************license end**************************************/


/**
 * @file
 *
 * Configuration and status register (CSR) address and type definitions for
 * Cavium AP.
 *
 * This file is auto generated. Do not edit.
 *
 */

/**
 * Enumeration ap_clidr_el1_ctype_e
 *
 * Cache Type Field Enumeration
 * Enumerates the CTYPEn fields of AP_CLIDR_EL1. All other values are reserved.
 */
#define BDK_AP_CLIDR_EL1_CTYPE_E_DATA (2)
#define BDK_AP_CLIDR_EL1_CTYPE_E_INSTRUCTION (1)
#define BDK_AP_CLIDR_EL1_CTYPE_E_NONE (0)
#define BDK_AP_CLIDR_EL1_CTYPE_E_SEPARATE (3)
#define BDK_AP_CLIDR_EL1_CTYPE_E_UNIFIED (4)

/**
 * Enumeration ap_psb_accum_sel_e
 *
 * AP Power Serial Bus Accumulator Selection Enumeration
 * Enumerates the AP accumulator events used by PSBS_AP()_ACCUM()_SEL.
 */
#define BDK_AP_PSB_ACCUM_SEL_E_TBD0 (0)

/**
 * Enumeration ap_psb_event_e
 *
 * AP Power Serial Bus Event Enumeration
 * Enumerates the event numbers for AP slaves, which correspond to index {b} of PSBS_AP()_EVENT()_CFG.
 */
#define BDK_AP_PSB_EVENT_E_TBD0 (0)

/**
 * Register (SYSREG) ap_actlr_el#
 *
 * AP Auxiliary Control Register
 * These registers are implementation defined for implementation specific control functionality
 * while executing at the associated execution level, or, in the case of ACTLR_EL1, while
 * executing at EL0.
 */
union bdk_ap_actlr_elx
{
    uint64_t u;
    struct bdk_ap_actlr_elx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_actlr_elx_s cn; */
};
typedef union bdk_ap_actlr_elx bdk_ap_actlr_elx_t;

static inline uint64_t BDK_AP_ACTLR_ELX(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ACTLR_ELX(unsigned long a)
{
    if ((a>=1)&&(a<=3))
        return 0x30001000100ll + 0ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_ACTLR_ELX", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_ACTLR_ELX(a) bdk_ap_actlr_elx_t
#define bustype_BDK_AP_ACTLR_ELX(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ACTLR_ELX(a) "AP_ACTLR_ELX"
#define busnum_BDK_AP_ACTLR_ELX(a) (a)
#define arguments_BDK_AP_ACTLR_ELX(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_afsr#_el#
 *
 * AP Auxiliary Fault Status 0 and 1 Registers
 * Provides additional implementation defined fault status
 *     information for exceptions taken to EL*.
 */
union bdk_ap_afsrx_elx
{
    uint32_t u;
    struct bdk_ap_afsrx_elx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_afsrx_elx_s cn; */
};
typedef union bdk_ap_afsrx_elx bdk_ap_afsrx_elx_t;

static inline uint64_t BDK_AP_AFSRX_ELX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_AFSRX_ELX(unsigned long a, unsigned long b)
{
    if ((a<=1) && ((b>=1)&&(b<=3)))
        return 0x30005010000ll + 0x100ll * ((a) & 0x1) + 0ll * ((b) & 0x3);
    __bdk_csr_fatal("AP_AFSRX_ELX", 2, a, b, 0, 0);
}

#define typedef_BDK_AP_AFSRX_ELX(a,b) bdk_ap_afsrx_elx_t
#define bustype_BDK_AP_AFSRX_ELX(a,b) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_AFSRX_ELX(a,b) "AP_AFSRX_ELX"
#define busnum_BDK_AP_AFSRX_ELX(a,b) (a)
#define arguments_BDK_AP_AFSRX_ELX(a,b) (a),(b),-1,-1

/**
 * Register (SYSREG) ap_afsr#_el12
 *
 * AP Auxiliary Fault Status 0 and 1 Alias Registers
 * Alias of AFSR(n)_EL1 when accessed from EL2 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_afsrx_el12
{
    uint32_t u;
    struct bdk_ap_afsrx_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_afsrx_el12_s cn; */
};
typedef union bdk_ap_afsrx_el12 bdk_ap_afsrx_el12_t;

static inline uint64_t BDK_AP_AFSRX_EL12(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_AFSRX_EL12(unsigned long a)
{
    if (a<=1)
        return 0x30505010000ll + 0x100ll * ((a) & 0x1);
    __bdk_csr_fatal("AP_AFSRX_EL12", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_AFSRX_EL12(a) bdk_ap_afsrx_el12_t
#define bustype_BDK_AP_AFSRX_EL12(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_AFSRX_EL12(a) "AP_AFSRX_EL12"
#define busnum_BDK_AP_AFSRX_EL12(a) (a)
#define arguments_BDK_AP_AFSRX_EL12(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_aidr_el1
 *
 * AP Auxiliary ID Register
 * Provides implementation defined identification information.
 */
union bdk_ap_aidr_el1
{
    uint64_t u;
    struct bdk_ap_aidr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_aidr_el1_s cn; */
};
typedef union bdk_ap_aidr_el1 bdk_ap_aidr_el1_t;

#define BDK_AP_AIDR_EL1 BDK_AP_AIDR_EL1_FUNC()
static inline uint64_t BDK_AP_AIDR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_AIDR_EL1_FUNC(void)
{
    return 0x30100000700ll;
}

#define typedef_BDK_AP_AIDR_EL1 bdk_ap_aidr_el1_t
#define bustype_BDK_AP_AIDR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_AIDR_EL1 "AP_AIDR_EL1"
#define busnum_BDK_AP_AIDR_EL1 0
#define arguments_BDK_AP_AIDR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_amair_el#
 *
 * AP Auxiliary Memory Attribute Indirection Register
 * Provides implementation defined memory attributes for the
 *     memory regions specified by MAIR_EL*.
 */
union bdk_ap_amair_elx
{
    uint64_t u;
    struct bdk_ap_amair_elx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_amair_elx_s cn; */
};
typedef union bdk_ap_amair_elx bdk_ap_amair_elx_t;

static inline uint64_t BDK_AP_AMAIR_ELX(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_AMAIR_ELX(unsigned long a)
{
    if ((a>=1)&&(a<=3))
        return 0x3000a030000ll + 0ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_AMAIR_ELX", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_AMAIR_ELX(a) bdk_ap_amair_elx_t
#define bustype_BDK_AP_AMAIR_ELX(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_AMAIR_ELX(a) "AP_AMAIR_ELX"
#define busnum_BDK_AP_AMAIR_ELX(a) (a)
#define arguments_BDK_AP_AMAIR_ELX(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_amair_el12
 *
 * AP Auxiliary Memory Attribute Indirection Register
 * Alias of AMAIR_EL1 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_amair_el12
{
    uint64_t u;
    struct bdk_ap_amair_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_amair_el12_s cn; */
};
typedef union bdk_ap_amair_el12 bdk_ap_amair_el12_t;

#define BDK_AP_AMAIR_EL12 BDK_AP_AMAIR_EL12_FUNC()
static inline uint64_t BDK_AP_AMAIR_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_AMAIR_EL12_FUNC(void)
{
    return 0x3050a030000ll;
}

#define typedef_BDK_AP_AMAIR_EL12 bdk_ap_amair_el12_t
#define bustype_BDK_AP_AMAIR_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_AMAIR_EL12 "AP_AMAIR_EL12"
#define busnum_BDK_AP_AMAIR_EL12 0
#define arguments_BDK_AP_AMAIR_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_ccsidr_el1
 *
 * AP Current Cache Size ID Register
 * This register provides information about the architecture of the currently selected
 * cache. AP_CSSELR_EL1 selects which Cache Size ID Register is accessible.
 */
union bdk_ap_ccsidr_el1
{
    uint32_t u;
    struct bdk_ap_ccsidr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 7.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 15.

                                                                 For CN88XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 8191. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 31.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 38.

                                                                 For CN88XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 15. */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
#else /* Word 0 - Little Endian */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 31.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 38.

                                                                 For CN88XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 15. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 7.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 15.

                                                                 For CN88XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 8191. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_ccsidr_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is TBD.

                                                                 For CN98XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CN98XX L3 (AP_CSSELR_EL1[LEVEL] = 0x2, AP_CSSELR_EL1[IND] = 0), is TBD. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is TBD.

                                                                 For CN98XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CN98XX L3 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is TBD. */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
#else /* Word 0 - Little Endian */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is TBD.

                                                                 For CN98XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CN98XX L3 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is TBD. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is TBD.

                                                                 For CN98XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is TBD.

                                                                 For CN98XX L3 (AP_CSSELR_EL1[LEVEL] = 0x2, AP_CSSELR_EL1[IND] = 0), is TBD. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
#endif /* Word 0 - End */
    } cn9;
    struct bdk_ap_ccsidr_el1_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 7.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 15.

                                                                 For CN81XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 1023.

                                                                 For CN80XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 1023. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 31.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 38.

                                                                 For CN81XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 15.

                                                                 For CN80XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 7. */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
#else /* Word 0 - Little Endian */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 31.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 38.

                                                                 For CN81XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 15.

                                                                 For CN80XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 7. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 7.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 15.

                                                                 For CN81XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 1023.

                                                                 For CN80XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 1023. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_ap_ccsidr_el1_s cn88xx; */
    struct bdk_ap_ccsidr_el1_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 7.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 15.

                                                                 For CN83XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 4095. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 31.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 38.

                                                                 For CN83XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 15. */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
#else /* Word 0 - Little Endian */
        uint32_t linesize              : 3;  /**< [  2:  0](RO) Cache-line size, in (Log2(Number of bytes in cache line)) - 4.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t associativity         : 10; /**< [ 12:  3](RO) Associativity of cache minus 1, therefore a value of 0 indicates
                                                                 an associativity of 1. The associativity does not have to be a
                                                                 power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 31.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 38.

                                                                 For CN83XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 15. */
        uint32_t numsets               : 15; /**< [ 27: 13](RO) Number of sets in cache minus 1, therefore a value of 0
                                                                 indicates 1 set in the cache. The number of sets does not have
                                                                 to be a power of 2.

                                                                 For CNXXXX L1D (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 0), is 7.

                                                                 For CNXXXX L1I (AP_CSSELR_EL1[LEVEL] = 0x0, AP_CSSELR_EL1[IND] = 1), is 15.

                                                                 For CN83XX L2 (AP_CSSELR_EL1[LEVEL] = 0x1, AP_CSSELR_EL1[IND] = 0), is 4095. */
        uint32_t wa                    : 1;  /**< [ 28: 28](RO) Indicates whether the selected cache level supports write-allocation.
                                                                 0 = Write-allocation not supported.
                                                                 1 = Write-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t ra                    : 1;  /**< [ 29: 29](RO) Indicates whether the selected cache level supports read-allocation.
                                                                 0 = Read-allocation not supported.
                                                                 1 = Read-allocation supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wb                    : 1;  /**< [ 30: 30](RO) Indicates whether the selected cache level supports write-back.
                                                                 0 = Write-back not supported.
                                                                 1 = Write-back supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
        uint32_t wt                    : 1;  /**< [ 31: 31](RO) Indicates whether the selected cache level supports write-through.
                                                                 0 = Write-through not supported.
                                                                 1 = Write-through supported.

                                                                 For CNXXXX does not apply as hardware managed coherence. */
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_ap_ccsidr_el1 bdk_ap_ccsidr_el1_t;

#define BDK_AP_CCSIDR_EL1 BDK_AP_CCSIDR_EL1_FUNC()
static inline uint64_t BDK_AP_CCSIDR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CCSIDR_EL1_FUNC(void)
{
    return 0x30100000000ll;
}

#define typedef_BDK_AP_CCSIDR_EL1 bdk_ap_ccsidr_el1_t
#define bustype_BDK_AP_CCSIDR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CCSIDR_EL1 "AP_CCSIDR_EL1"
#define busnum_BDK_AP_CCSIDR_EL1 0
#define arguments_BDK_AP_CCSIDR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_clidr_el1
 *
 * AP Cache Level ID Register
 * This register identifies the type of cache, or caches, implemented at each level, up
 * to a maximum of seven levels. Also identifies the Level of Coherence (LoC) and Level
 * of Unification (LoU) for the cache hierarchy.
 */
union bdk_ap_clidr_el1
{
    uint32_t u;
    struct bdk_ap_clidr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_30_31        : 2;
        uint32_t louu                  : 3;  /**< [ 29: 27](RO) Level of unification uniprocessor for the cache hierarchy. */
        uint32_t loc                   : 3;  /**< [ 26: 24](RO) Level of coherence for the cache hierarchy.

                                                                 For CN88XX, 0x1 for pass 1, 0x0 for pass 2 and subsequent chips. */
        uint32_t louis                 : 3;  /**< [ 23: 21](RO) Level of unification inner shareable for the cache hierarchy. */
        uint32_t ctype7                : 3;  /**< [ 20: 18](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 All other values are reserved.

                                                                 For CNXXXX, no L7 cache. */
        uint32_t ctype6                : 3;  /**< [ 17: 15](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L6 cache. */
        uint32_t ctype5                : 3;  /**< [ 14: 12](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L5 cache. */
        uint32_t ctype4                : 3;  /**< [ 11:  9](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L4 cache. */
        uint32_t ctype3                : 3;  /**< [  8:  6](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L3 cache. */
        uint32_t ctype2                : 3;  /**< [  5:  3](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L2 cache is unified. */
        uint32_t ctype1                : 3;  /**< [  2:  0](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L1 Dcache and Icache are independent. */
#else /* Word 0 - Little Endian */
        uint32_t ctype1                : 3;  /**< [  2:  0](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L1 Dcache and Icache are independent. */
        uint32_t ctype2                : 3;  /**< [  5:  3](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L2 cache is unified. */
        uint32_t ctype3                : 3;  /**< [  8:  6](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L3 cache. */
        uint32_t ctype4                : 3;  /**< [ 11:  9](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L4 cache. */
        uint32_t ctype5                : 3;  /**< [ 14: 12](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L5 cache. */
        uint32_t ctype6                : 3;  /**< [ 17: 15](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L6 cache. */
        uint32_t ctype7                : 3;  /**< [ 20: 18](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 All other values are reserved.

                                                                 For CNXXXX, no L7 cache. */
        uint32_t louis                 : 3;  /**< [ 23: 21](RO) Level of unification inner shareable for the cache hierarchy. */
        uint32_t loc                   : 3;  /**< [ 26: 24](RO) Level of coherence for the cache hierarchy.

                                                                 For CN88XX, 0x1 for pass 1, 0x0 for pass 2 and subsequent chips. */
        uint32_t louu                  : 3;  /**< [ 29: 27](RO) Level of unification uniprocessor for the cache hierarchy. */
        uint32_t reserved_30_31        : 2;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_clidr_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_30_31        : 2;
        uint32_t louu                  : 3;  /**< [ 29: 27](RO) Level of unification uniprocessor for the cache hierarchy. */
        uint32_t loc                   : 3;  /**< [ 26: 24](RO) Level of coherence for the cache hierarchy.

                                                                 For CNXXXX, 0x0. */
        uint32_t louis                 : 3;  /**< [ 23: 21](RO) Level of unification inner shareable for the cache hierarchy. */
        uint32_t ctype7                : 3;  /**< [ 20: 18](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L7 cache. */
        uint32_t ctype6                : 3;  /**< [ 17: 15](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L6 cache. */
        uint32_t ctype5                : 3;  /**< [ 14: 12](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L5 cache. */
        uint32_t ctype4                : 3;  /**< [ 11:  9](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L4 cache. */
        uint32_t ctype3                : 3;  /**< [  8:  6](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, L3 cache is unified. */
        uint32_t ctype2                : 3;  /**< [  5:  3](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, L2 cache is an instruction cache only.

                                                                 Internal:
                                                                 L2 can be NONE if fused-off. */
        uint32_t ctype1                : 3;  /**< [  2:  0](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, L1 Dcache and Icache are independent. */
#else /* Word 0 - Little Endian */
        uint32_t ctype1                : 3;  /**< [  2:  0](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, L1 Dcache and Icache are independent. */
        uint32_t ctype2                : 3;  /**< [  5:  3](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, L2 cache is an instruction cache only.

                                                                 Internal:
                                                                 L2 can be NONE if fused-off. */
        uint32_t ctype3                : 3;  /**< [  8:  6](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, L3 cache is unified. */
        uint32_t ctype4                : 3;  /**< [ 11:  9](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L4 cache. */
        uint32_t ctype5                : 3;  /**< [ 14: 12](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L5 cache. */
        uint32_t ctype6                : 3;  /**< [ 17: 15](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L6 cache. */
        uint32_t ctype7                : 3;  /**< [ 20: 18](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.

                                                                 Enumerated by AP_CLIDR_EL1_CTYPE_E.

                                                                 For CNXXXX, no L7 cache. */
        uint32_t louis                 : 3;  /**< [ 23: 21](RO) Level of unification inner shareable for the cache hierarchy. */
        uint32_t loc                   : 3;  /**< [ 26: 24](RO) Level of coherence for the cache hierarchy.

                                                                 For CNXXXX, 0x0. */
        uint32_t louu                  : 3;  /**< [ 29: 27](RO) Level of unification uniprocessor for the cache hierarchy. */
        uint32_t reserved_30_31        : 2;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_ap_clidr_el1_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_30_31        : 2;
        uint32_t louu                  : 3;  /**< [ 29: 27](RO) Level of unification uniprocessor for the cache hierarchy. */
        uint32_t loc                   : 3;  /**< [ 26: 24](RO) Level of coherence for the cache hierarchy.

                                                                 For CNXXXX, 0x0. */
        uint32_t louis                 : 3;  /**< [ 23: 21](RO) Level of unification inner shareable for the cache hierarchy. */
        uint32_t ctype7                : 3;  /**< [ 20: 18](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 All other values are reserved.

                                                                 For CNXXXX, no L7 cache. */
        uint32_t ctype6                : 3;  /**< [ 17: 15](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L6 cache. */
        uint32_t ctype5                : 3;  /**< [ 14: 12](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L5 cache. */
        uint32_t ctype4                : 3;  /**< [ 11:  9](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L4 cache. */
        uint32_t ctype3                : 3;  /**< [  8:  6](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L3 cache. */
        uint32_t ctype2                : 3;  /**< [  5:  3](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L2 cache is unified. */
        uint32_t ctype1                : 3;  /**< [  2:  0](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L1 Dcache and Icache are independent. */
#else /* Word 0 - Little Endian */
        uint32_t ctype1                : 3;  /**< [  2:  0](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L1 Dcache and Icache are independent. */
        uint32_t ctype2                : 3;  /**< [  5:  3](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, L2 cache is unified. */
        uint32_t ctype3                : 3;  /**< [  8:  6](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L3 cache. */
        uint32_t ctype4                : 3;  /**< [ 11:  9](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L4 cache. */
        uint32_t ctype5                : 3;  /**< [ 14: 12](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L5 cache. */
        uint32_t ctype6                : 3;  /**< [ 17: 15](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 For CNXXXX, no L6 cache. */
        uint32_t ctype7                : 3;  /**< [ 20: 18](RO) Cache type fields. Indicate the type of cache implemented at
                                                                     each level, from Level 1 up to a maximum of seven levels of
                                                                     cache hierarchy.
                                                                 0x0 = No cache.
                                                                 0x1 = Instruction cache only.
                                                                 0x2 = Data cache only.
                                                                 0x3 = Separate instruction and data caches.
                                                                 0x4 = Unified cache.

                                                                 All other values are reserved.

                                                                 For CNXXXX, no L7 cache. */
        uint32_t louis                 : 3;  /**< [ 23: 21](RO) Level of unification inner shareable for the cache hierarchy. */
        uint32_t loc                   : 3;  /**< [ 26: 24](RO) Level of coherence for the cache hierarchy.

                                                                 For CNXXXX, 0x0. */
        uint32_t louu                  : 3;  /**< [ 29: 27](RO) Level of unification uniprocessor for the cache hierarchy. */
        uint32_t reserved_30_31        : 2;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_ap_clidr_el1_s cn88xx; */
    /* struct bdk_ap_clidr_el1_cn81xx cn83xx; */
};
typedef union bdk_ap_clidr_el1 bdk_ap_clidr_el1_t;

#define BDK_AP_CLIDR_EL1 BDK_AP_CLIDR_EL1_FUNC()
static inline uint64_t BDK_AP_CLIDR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CLIDR_EL1_FUNC(void)
{
    return 0x30100000100ll;
}

#define typedef_BDK_AP_CLIDR_EL1 bdk_ap_clidr_el1_t
#define bustype_BDK_AP_CLIDR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CLIDR_EL1 "AP_CLIDR_EL1"
#define busnum_BDK_AP_CLIDR_EL1 0
#define arguments_BDK_AP_CLIDR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntfrq_el0
 *
 * AP Counter-timer Frequency Register
 * Holds the clock frequency of the system counter.
 */
union bdk_ap_cntfrq_el0
{
    uint32_t u;
    struct bdk_ap_cntfrq_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) Clock frequency. Indicates the system counter clock frequency,
                                                                     in Hz. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) Clock frequency. Indicates the system counter clock frequency,
                                                                     in Hz. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntfrq_el0_s cn; */
};
typedef union bdk_ap_cntfrq_el0 bdk_ap_cntfrq_el0_t;

#define BDK_AP_CNTFRQ_EL0 BDK_AP_CNTFRQ_EL0_FUNC()
static inline uint64_t BDK_AP_CNTFRQ_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTFRQ_EL0_FUNC(void)
{
    return 0x3030e000000ll;
}

#define typedef_BDK_AP_CNTFRQ_EL0 bdk_ap_cntfrq_el0_t
#define bustype_BDK_AP_CNTFRQ_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTFRQ_EL0 "AP_CNTFRQ_EL0"
#define busnum_BDK_AP_CNTFRQ_EL0 0
#define arguments_BDK_AP_CNTFRQ_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthctl_el2
 *
 * AP Counter-timer Hypervisor Control Non-E2H Register
 * Controls the generation of an event stream from the physical
 *     counter, and access from nonsecure EL1 to the physical
 *     counter and the nonsecure EL1 physical timer.
 *
 * This register is at the same select as AP_CNTHCTL_EL2_E2H and is used when E2H=0.
 */
union bdk_ap_cnthctl_el2
{
    uint32_t u;
    struct bdk_ap_cnthctl_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_8_31         : 24;
        uint32_t evnti                 : 4;  /**< [  7:  4](R/W) Selects which bit (0 to 15) of the corresponding counter
                                                                     register ( AP_CNTPCT_EL0 or AP_CNTVCT_EL0) is the trigger for the
                                                                     event stream generated from that counter, when that stream is
                                                                     enabled. */
        uint32_t evntdir               : 1;  /**< [  3:  3](R/W) Controls which transition of the counter register ( AP_CNTPCT_EL0
                                                                     or AP_CNTVCT_EL0) trigger bit, defined by EVNTI, generates an
                                                                     event when the event stream is enabled:
                                                                 0 = A 0 to 1 transition of the trigger bit triggers an event.
                                                                 1 = A 1 to 0 transition of the trigger bit triggers an event. */
        uint32_t evnten                : 1;  /**< [  2:  2](R/W) Enables the generation of an event stream from the
                                                                     corresponding counter:
                                                                 0 = Disables the event stream.
                                                                 1 = Enables the event stream. */
        uint32_t el1pcen               : 1;  /**< [  1:  1](R/W) Controls whether the physical timer registers are accessible
                                                                     from nonsecure EL1 and EL0 modes:
                                                                 If EL3 is implemented and EL2 is not implemented, this bit is
                                                                     treated as if it is 1 for all purposes other than reading the
                                                                     register.
                                                                 0 = The AP_CNTP_CVAL_EL0, AP_CNTP_TVAL_EL0, and AP_CNTP_CTL_EL0 registers
                                                                     are not accessible from nonsecure EL1 and EL0 modes.
                                                                 1 = The AP_CNTP_CVAL_EL0, AP_CNTP_TVAL_EL0, and AP_CNTP_CTL_EL0 registers
                                                                     are accessible from nonsecure EL1 and EL0 modes. */
        uint32_t el1pcten              : 1;  /**< [  0:  0](R/W) Controls whether the physical counter, AP_CNTPCT_EL0, is
                                                                     accessible from nonsecure EL1 and EL0 modes:
                                                                 If EL3 is implemented and EL2 is not implemented, this bit is
                                                                     treated as if it is 1 for all purposes other than reading the
                                                                     register.
                                                                 0 = The AP_CNTPCT_EL0 register is not accessible from nonsecure EL1
                                                                     and EL0 modes.
                                                                 1 = The AP_CNTPCT_EL0 register is accessible from nonsecure EL1 and
                                                                     EL0 modes. */
#else /* Word 0 - Little Endian */
        uint32_t el1pcten              : 1;  /**< [  0:  0](R/W) Controls whether the physical counter, AP_CNTPCT_EL0, is
                                                                     accessible from nonsecure EL1 and EL0 modes:
                                                                 If EL3 is implemented and EL2 is not implemented, this bit is
                                                                     treated as if it is 1 for all purposes other than reading the
                                                                     register.
                                                                 0 = The AP_CNTPCT_EL0 register is not accessible from nonsecure EL1
                                                                     and EL0 modes.
                                                                 1 = The AP_CNTPCT_EL0 register is accessible from nonsecure EL1 and
                                                                     EL0 modes. */
        uint32_t el1pcen               : 1;  /**< [  1:  1](R/W) Controls whether the physical timer registers are accessible
                                                                     from nonsecure EL1 and EL0 modes:
                                                                 If EL3 is implemented and EL2 is not implemented, this bit is
                                                                     treated as if it is 1 for all purposes other than reading the
                                                                     register.
                                                                 0 = The AP_CNTP_CVAL_EL0, AP_CNTP_TVAL_EL0, and AP_CNTP_CTL_EL0 registers
                                                                     are not accessible from nonsecure EL1 and EL0 modes.
                                                                 1 = The AP_CNTP_CVAL_EL0, AP_CNTP_TVAL_EL0, and AP_CNTP_CTL_EL0 registers
                                                                     are accessible from nonsecure EL1 and EL0 modes. */
        uint32_t evnten                : 1;  /**< [  2:  2](R/W) Enables the generation of an event stream from the
                                                                     corresponding counter:
                                                                 0 = Disables the event stream.
                                                                 1 = Enables the event stream. */
        uint32_t evntdir               : 1;  /**< [  3:  3](R/W) Controls which transition of the counter register ( AP_CNTPCT_EL0
                                                                     or AP_CNTVCT_EL0) trigger bit, defined by EVNTI, generates an
                                                                     event when the event stream is enabled:
                                                                 0 = A 0 to 1 transition of the trigger bit triggers an event.
                                                                 1 = A 1 to 0 transition of the trigger bit triggers an event. */
        uint32_t evnti                 : 4;  /**< [  7:  4](R/W) Selects which bit (0 to 15) of the corresponding counter
                                                                     register ( AP_CNTPCT_EL0 or AP_CNTVCT_EL0) is the trigger for the
                                                                     event stream generated from that counter, when that stream is
                                                                     enabled. */
        uint32_t reserved_8_31         : 24;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthctl_el2_s cn; */
};
typedef union bdk_ap_cnthctl_el2 bdk_ap_cnthctl_el2_t;

#define BDK_AP_CNTHCTL_EL2 BDK_AP_CNTHCTL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHCTL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHCTL_EL2_FUNC(void)
{
    return 0x3040e010000ll;
}

#define typedef_BDK_AP_CNTHCTL_EL2 bdk_ap_cnthctl_el2_t
#define bustype_BDK_AP_CNTHCTL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHCTL_EL2 "AP_CNTHCTL_EL2"
#define busnum_BDK_AP_CNTHCTL_EL2 0
#define arguments_BDK_AP_CNTHCTL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthctl_el2_e2h
 *
 * AP Counter-timer Hypervisor Control E2H Register
 * This register is at the same select as AP_CNTHCTL_EL2 and is used when E2H=1.
 */
union bdk_ap_cnthctl_el2_e2h
{
    uint32_t u;
    struct bdk_ap_cnthctl_el2_e2h_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_12_31        : 20;
        uint32_t el1pcen               : 1;  /**< [ 11: 11](R/W) Controls whether physical timer register accessing instuctions
                                                                 are accessible from nonsecure EL1 and EL0:
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 0 and the instructions are executed at
                                                                     nonsecure EL1, or nonsecure EL0 unless trapped to EL1 as a
                                                                     result of controls in the AP_CNTKCTL_EL1
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=0   AP_CNTP_TVAL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=1   AP_CNTP_CTL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=2   AP_CNTP_CVAL_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==1.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el1pten               : 1;  /**< [ 10: 10](R/W) Controls whether the physical counter is accessible from nonsecure
                                                                 EL1 and EL0.
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 0 and the instructions are executed at nonsecure
                                                                     EL1, or nonsecure EL0 unless trapped to EL1 as a result of controls
                                                                     in AP_CNTKCTL_EL1.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=1   AP_CNTPCT_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el0pten               : 1;  /**< [  9:  9](R/W) Controls whether the physical timer register accessing instructions are
                                                                 accessible from nonsecure EL0 when AP_HCR_EL2[TGE]==1.
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=0   AP_CNTP_TVAL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=1   AP_CNTP_CTL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=2   AP_CNTP_CVAL_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el0vten               : 1;  /**< [  8:  8](R/W) Controls whether the virtual timer register accessing instructions are
                                                                 accessible from nonsecure EL0 when AP_HCR_EL2[TGE]==1.
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=3, Op2=0   AP_CNTV_TVAL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=3, Op2=1   AP_CNTV_CTL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=3, Op2=2   AP_CNTV_CVAL_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t evnti                 : 4;  /**< [  7:  4](R/W) Selects which bit (0 to 15) of the corresponding counter
                                                                     register ( AP_CNTPCT_EL0 or AP_CNTVCT_EL0) is the trigger for the
                                                                     event stream generated from that counter, when that stream is
                                                                     enabled. */
        uint32_t evntdir               : 1;  /**< [  3:  3](R/W) Controls which transition of the counter register ( AP_CNTPCT_EL0
                                                                     or AP_CNTVCT_EL0) trigger bit, defined by EVNTI, generates an
                                                                     event when the event stream is enabled:
                                                                 0 = A 0 to 1 transition of the trigger bit triggers an event.
                                                                 1 = A 1 to 0 transition of the trigger bit triggers an event. */
        uint32_t evnten                : 1;  /**< [  2:  2](R/W) Enables the generation of an event stream from the
                                                                     corresponding counter:
                                                                 0 = Disables the event stream.
                                                                 1 = Enables the event stream. */
        uint32_t el0vcten              : 1;  /**< [  1:  1](R/W) Controls whether the virtual counter registers are accessible
                                                                     from nonsecure EL1 and EL0 when AP_HCR_EL2[TGE]==1:
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=2   AP_CNTVCT_EL0
                                                                     In addition, if EL0PCTEN == 0, then the following System Register
                                                                     accessing instructions in AARCH64, and their equivalent instructions
                                                                     in AARCH32, are trapped to EL2 when executed at nonsecure EL0 when
                                                                     AP_HCR_EL2[TGE]==1.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=0   AP_CNTFRQ_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el0pcten              : 1;  /**< [  0:  0](R/W) Controls whether physical counter register accessing instructions
                                                                 are accessible from nonsecure EL0 when AP_HCR_EL2[TGE]==1:
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=1   AP_CNTPCT_EL0
                                                                     In addition, if EL0PCTEN == 0, then the following System Register
                                                                     accessing instructions in AARCH64, and their equivalent instructions
                                                                     in AARCH32, are trapped to EL2 when executed at nonsecure EL0 when
                                                                     AP_HCR_EL2[TGE]==1.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=0   AP_CNTFRQ_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
#else /* Word 0 - Little Endian */
        uint32_t el0pcten              : 1;  /**< [  0:  0](R/W) Controls whether physical counter register accessing instructions
                                                                 are accessible from nonsecure EL0 when AP_HCR_EL2[TGE]==1:
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=1   AP_CNTPCT_EL0
                                                                     In addition, if EL0PCTEN == 0, then the following System Register
                                                                     accessing instructions in AARCH64, and their equivalent instructions
                                                                     in AARCH32, are trapped to EL2 when executed at nonsecure EL0 when
                                                                     AP_HCR_EL2[TGE]==1.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=0   AP_CNTFRQ_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el0vcten              : 1;  /**< [  1:  1](R/W) Controls whether the virtual counter registers are accessible
                                                                     from nonsecure EL1 and EL0 when AP_HCR_EL2[TGE]==1:
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=2   AP_CNTVCT_EL0
                                                                     In addition, if EL0PCTEN == 0, then the following System Register
                                                                     accessing instructions in AARCH64, and their equivalent instructions
                                                                     in AARCH32, are trapped to EL2 when executed at nonsecure EL0 when
                                                                     AP_HCR_EL2[TGE]==1.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=0   AP_CNTFRQ_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t evnten                : 1;  /**< [  2:  2](R/W) Enables the generation of an event stream from the
                                                                     corresponding counter:
                                                                 0 = Disables the event stream.
                                                                 1 = Enables the event stream. */
        uint32_t evntdir               : 1;  /**< [  3:  3](R/W) Controls which transition of the counter register ( AP_CNTPCT_EL0
                                                                     or AP_CNTVCT_EL0) trigger bit, defined by EVNTI, generates an
                                                                     event when the event stream is enabled:
                                                                 0 = A 0 to 1 transition of the trigger bit triggers an event.
                                                                 1 = A 1 to 0 transition of the trigger bit triggers an event. */
        uint32_t evnti                 : 4;  /**< [  7:  4](R/W) Selects which bit (0 to 15) of the corresponding counter
                                                                     register ( AP_CNTPCT_EL0 or AP_CNTVCT_EL0) is the trigger for the
                                                                     event stream generated from that counter, when that stream is
                                                                     enabled. */
        uint32_t el0vten               : 1;  /**< [  8:  8](R/W) Controls whether the virtual timer register accessing instructions are
                                                                 accessible from nonsecure EL0 when AP_HCR_EL2[TGE]==1.
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=3, Op2=0   AP_CNTV_TVAL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=3, Op2=1   AP_CNTV_CTL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=3, Op2=2   AP_CNTV_CVAL_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el0pten               : 1;  /**< [  9:  9](R/W) Controls whether the physical timer register accessing instructions are
                                                                 accessible from nonsecure EL0 when AP_HCR_EL2[TGE]==1.
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1 and the instructions are executed at nonsecure
                                                                     EL0.
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=0   AP_CNTP_TVAL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=1   AP_CNTP_CTL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=2   AP_CNTP_CVAL_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==0.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el1pten               : 1;  /**< [ 10: 10](R/W) Controls whether the physical counter is accessible from nonsecure
                                                                 EL1 and EL0.
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 0 and the instructions are executed at nonsecure
                                                                     EL1, or nonsecure EL0 unless trapped to EL1 as a result of controls
                                                                     in AP_CNTKCTL_EL1.
                                                                       Op0=3, op1=3, CRn=14, CRm=0, Op2=1   AP_CNTPCT_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 1.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t el1pcen               : 1;  /**< [ 11: 11](R/W) Controls whether physical timer register accessing instuctions
                                                                 are accessible from nonsecure EL1 and EL0:
                                                                 0 = The following system register accessing instructions in AARCH64,
                                                                     and their equivalent instructions in AARCH32, are trapped to EL2
                                                                     when AP_HCR_EL2[TGE] == 0 and the instructions are executed at
                                                                     nonsecure EL1, or nonsecure EL0 unless trapped to EL1 as a
                                                                     result of controls in the AP_CNTKCTL_EL1
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=0   AP_CNTP_TVAL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=1   AP_CNTP_CTL_EL0
                                                                       Op0=3, op1=3, CRn=14, CRm=2, Op2=2   AP_CNTP_CVAL_EL0
                                                                     This bit does not cause any instructions to be trapped to EL2
                                                                     when AP_HCR_EL2[TGE]==1.

                                                                 1 = This bit does not cause any instructions to be trapped to EL2. */
        uint32_t reserved_12_31        : 20;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthctl_el2_e2h_s cn; */
};
typedef union bdk_ap_cnthctl_el2_e2h bdk_ap_cnthctl_el2_e2h_t;

#define BDK_AP_CNTHCTL_EL2_E2H BDK_AP_CNTHCTL_EL2_E2H_FUNC()
static inline uint64_t BDK_AP_CNTHCTL_EL2_E2H_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHCTL_EL2_E2H_FUNC(void)
{
    return 0x3040e010010ll;
}

#define typedef_BDK_AP_CNTHCTL_EL2_E2H bdk_ap_cnthctl_el2_e2h_t
#define bustype_BDK_AP_CNTHCTL_EL2_E2H BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHCTL_EL2_E2H "AP_CNTHCTL_EL2_E2H"
#define busnum_BDK_AP_CNTHCTL_EL2_E2H 0
#define arguments_BDK_AP_CNTHCTL_EL2_E2H -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthp_ctl_el2
 *
 * AP Counter-timer Hypervisor Physical Timer Control Register
 * Control register for the EL2 physical timer.
 */
union bdk_ap_cnthp_ctl_el2
{
    uint32_t u;
    struct bdk_ap_cnthp_ctl_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
#else /* Word 0 - Little Endian */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t reserved_3_31         : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthp_ctl_el2_s cn; */
};
typedef union bdk_ap_cnthp_ctl_el2 bdk_ap_cnthp_ctl_el2_t;

#define BDK_AP_CNTHP_CTL_EL2 BDK_AP_CNTHP_CTL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHP_CTL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHP_CTL_EL2_FUNC(void)
{
    return 0x3040e020100ll;
}

#define typedef_BDK_AP_CNTHP_CTL_EL2 bdk_ap_cnthp_ctl_el2_t
#define bustype_BDK_AP_CNTHP_CTL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHP_CTL_EL2 "AP_CNTHP_CTL_EL2"
#define busnum_BDK_AP_CNTHP_CTL_EL2 0
#define arguments_BDK_AP_CNTHP_CTL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthp_cval_el2
 *
 * AP Counter-timer Hypervisor Physical Timer Compare Value Register
 * Holds the compare value for the EL2 physical timer.
 */
union bdk_ap_cnthp_cval_el2
{
    uint64_t u;
    struct bdk_ap_cnthp_cval_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) EL2 physical timer compare value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) EL2 physical timer compare value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthp_cval_el2_s cn; */
};
typedef union bdk_ap_cnthp_cval_el2 bdk_ap_cnthp_cval_el2_t;

#define BDK_AP_CNTHP_CVAL_EL2 BDK_AP_CNTHP_CVAL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHP_CVAL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHP_CVAL_EL2_FUNC(void)
{
    return 0x3040e020200ll;
}

#define typedef_BDK_AP_CNTHP_CVAL_EL2 bdk_ap_cnthp_cval_el2_t
#define bustype_BDK_AP_CNTHP_CVAL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHP_CVAL_EL2 "AP_CNTHP_CVAL_EL2"
#define busnum_BDK_AP_CNTHP_CVAL_EL2 0
#define arguments_BDK_AP_CNTHP_CVAL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthp_tval_el2
 *
 * AP Counter-timer Hypervisor Physical Timer Value Register
 * Holds the timer value for the EL2 physical timer.
 */
union bdk_ap_cnthp_tval_el2
{
    uint32_t u;
    struct bdk_ap_cnthp_tval_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) EL2 physical timer value. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) EL2 physical timer value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthp_tval_el2_s cn; */
};
typedef union bdk_ap_cnthp_tval_el2 bdk_ap_cnthp_tval_el2_t;

#define BDK_AP_CNTHP_TVAL_EL2 BDK_AP_CNTHP_TVAL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHP_TVAL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHP_TVAL_EL2_FUNC(void)
{
    return 0x3040e020000ll;
}

#define typedef_BDK_AP_CNTHP_TVAL_EL2 bdk_ap_cnthp_tval_el2_t
#define bustype_BDK_AP_CNTHP_TVAL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHP_TVAL_EL2 "AP_CNTHP_TVAL_EL2"
#define busnum_BDK_AP_CNTHP_TVAL_EL2 0
#define arguments_BDK_AP_CNTHP_TVAL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthv_ctl_el2
 *
 * AP v8.1 Counter-timer Hypervisor Virtual Timer Control Register
 * v8.1 Control register for the EL2 virtual timer.
 */
union bdk_ap_cnthv_ctl_el2
{
    uint32_t u;
    struct bdk_ap_cnthv_ctl_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
#else /* Word 0 - Little Endian */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t reserved_3_31         : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthv_ctl_el2_s cn; */
};
typedef union bdk_ap_cnthv_ctl_el2 bdk_ap_cnthv_ctl_el2_t;

#define BDK_AP_CNTHV_CTL_EL2 BDK_AP_CNTHV_CTL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHV_CTL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHV_CTL_EL2_FUNC(void)
{
    return 0x3040e030100ll;
}

#define typedef_BDK_AP_CNTHV_CTL_EL2 bdk_ap_cnthv_ctl_el2_t
#define bustype_BDK_AP_CNTHV_CTL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHV_CTL_EL2 "AP_CNTHV_CTL_EL2"
#define busnum_BDK_AP_CNTHV_CTL_EL2 0
#define arguments_BDK_AP_CNTHV_CTL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthv_cval_el2
 *
 * AP v8.1 Counter-timer Hypervisor Virtual Timer Compare Value Register
 * v8.1 Holds the compare value for the EL2 virtual timer.
 */
union bdk_ap_cnthv_cval_el2
{
    uint64_t u;
    struct bdk_ap_cnthv_cval_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) EL2 physical timer compare value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) EL2 physical timer compare value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthv_cval_el2_s cn; */
};
typedef union bdk_ap_cnthv_cval_el2 bdk_ap_cnthv_cval_el2_t;

#define BDK_AP_CNTHV_CVAL_EL2 BDK_AP_CNTHV_CVAL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHV_CVAL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHV_CVAL_EL2_FUNC(void)
{
    return 0x3040e030200ll;
}

#define typedef_BDK_AP_CNTHV_CVAL_EL2 bdk_ap_cnthv_cval_el2_t
#define bustype_BDK_AP_CNTHV_CVAL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHV_CVAL_EL2 "AP_CNTHV_CVAL_EL2"
#define busnum_BDK_AP_CNTHV_CVAL_EL2 0
#define arguments_BDK_AP_CNTHV_CVAL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cnthv_tval_el2
 *
 * AP v8.1 Counter-timer Hypervisor Virtual Timer Value Register
 * v8.1 Holds the timer value for the EL2 virtual timer.
 */
union bdk_ap_cnthv_tval_el2
{
    uint32_t u;
    struct bdk_ap_cnthv_tval_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) EL2 virtual timer value. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) EL2 virtual timer value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cnthv_tval_el2_s cn; */
};
typedef union bdk_ap_cnthv_tval_el2 bdk_ap_cnthv_tval_el2_t;

#define BDK_AP_CNTHV_TVAL_EL2 BDK_AP_CNTHV_TVAL_EL2_FUNC()
static inline uint64_t BDK_AP_CNTHV_TVAL_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTHV_TVAL_EL2_FUNC(void)
{
    return 0x3040e030000ll;
}

#define typedef_BDK_AP_CNTHV_TVAL_EL2 bdk_ap_cnthv_tval_el2_t
#define bustype_BDK_AP_CNTHV_TVAL_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTHV_TVAL_EL2 "AP_CNTHV_TVAL_EL2"
#define busnum_BDK_AP_CNTHV_TVAL_EL2 0
#define arguments_BDK_AP_CNTHV_TVAL_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntkctl_el1
 *
 * AP Counter-timer Kernel Control Register
 * Controls the generation of an event stream from the virtual
 *     counter, and access from EL0 to the physical counter, virtual
 *     counter, EL1 physical timers, and the virtual timer.
 */
union bdk_ap_cntkctl_el1
{
    uint32_t u;
    struct bdk_ap_cntkctl_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_10_31        : 22;
        uint32_t el0pten               : 1;  /**< [  9:  9](R/W) Controls whether the physical timer registers are accessible
                                                                     from EL0 modes:
                                                                 0 = The AP_CNTP_CVAL_EL0, AP_CNTP_CTL_EL0, and AP_CNTP_TVAL_EL0 registers
                                                                     are not accessible from EL0.
                                                                 1 = The AP_CNTP_CVAL_EL0, AP_CNTP_CTL_EL0, and AP_CNTP_TVAL_EL0 registers
                                                                     are accessible from EL0. */
        uint32_t el0vten               : 1;  /**< [  8:  8](R/W) Controls whether the virtual timer registers are accessible
                                                                     from EL0 modes:
                                                                 0 = The AP_CNTV_CVAL_EL0, AP_CNTV_CTL_EL0, and AP_CNTV_TVAL_EL0 registers
                                                                     are not accessible from EL0.
                                                                 1 = The AP_CNTV_CVAL_EL0, AP_CNTV_CTL_EL0, and AP_CNTV_TVAL_EL0 registers
                                                                     are accessible from EL0. */
        uint32_t evnti                 : 4;  /**< [  7:  4](R/W) Selects which bit (0 to 15) of the corresponding counter
                                                                     register ( AP_CNTPCT_EL0 or AP_CNTVCT_EL0) is the trigger for the
                                                                     event stream generated from that counter, when that stream is
                                                                     enabled. */
        uint32_t evntdir               : 1;  /**< [  3:  3](R/W) Controls which transition of the counter register ( AP_CNTPCT_EL0
                                                                     or AP_CNTVCT_EL0) trigger bit, defined by EVNTI, generates an
                                                                     event when the event stream is enabled:
                                                                 0 = A 0 to 1 transition of the trigger bit triggers an event.
                                                                 1 = A 1 to 0 transition of the trigger bit triggers an event. */
        uint32_t evnten                : 1;  /**< [  2:  2](R/W) Enables the generation of an event stream from the
                                                                     corresponding counter:
                                                                 0 = Disables the event stream.
                                                                 1 = Enables the event stream. */
        uint32_t el0vcten              : 1;  /**< [  1:  1](R/W) Controls whether the virtual counter, AP_CNTVCT_EL0, and the
                                                                     frequency register AP_CNTFRQ_EL0, are accessible from EL0 modes:
                                                                 0 =  AP_CNTVCT_EL0 is not accessible from EL0. If EL0PCTEN is set to
                                                                     0, AP_CNTFRQ_EL0 is not accessible from EL0.
                                                                 1 =  AP_CNTVCT_EL0 and AP_CNTFRQ_EL0 are accessible from EL0. */
        uint32_t el0pcten              : 1;  /**< [  0:  0](R/W) Controls whether the physical counter, AP_CNTPCT_EL0, and the
                                                                     frequency register AP_CNTFRQ_EL0, are accessible from EL0 modes:
                                                                 0 =  AP_CNTPCT_EL0 is not accessible from EL0 modes. If EL0VCTEN is
                                                                     set to 0, AP_CNTFRQ_EL0 is not accessible from EL0.
                                                                 1 =  AP_CNTPCT_EL0 and AP_CNTFRQ_EL0 are accessible from EL0. */
#else /* Word 0 - Little Endian */
        uint32_t el0pcten              : 1;  /**< [  0:  0](R/W) Controls whether the physical counter, AP_CNTPCT_EL0, and the
                                                                     frequency register AP_CNTFRQ_EL0, are accessible from EL0 modes:
                                                                 0 =  AP_CNTPCT_EL0 is not accessible from EL0 modes. If EL0VCTEN is
                                                                     set to 0, AP_CNTFRQ_EL0 is not accessible from EL0.
                                                                 1 =  AP_CNTPCT_EL0 and AP_CNTFRQ_EL0 are accessible from EL0. */
        uint32_t el0vcten              : 1;  /**< [  1:  1](R/W) Controls whether the virtual counter, AP_CNTVCT_EL0, and the
                                                                     frequency register AP_CNTFRQ_EL0, are accessible from EL0 modes:
                                                                 0 =  AP_CNTVCT_EL0 is not accessible from EL0. If EL0PCTEN is set to
                                                                     0, AP_CNTFRQ_EL0 is not accessible from EL0.
                                                                 1 =  AP_CNTVCT_EL0 and AP_CNTFRQ_EL0 are accessible from EL0. */
        uint32_t evnten                : 1;  /**< [  2:  2](R/W) Enables the generation of an event stream from the
                                                                     corresponding counter:
                                                                 0 = Disables the event stream.
                                                                 1 = Enables the event stream. */
        uint32_t evntdir               : 1;  /**< [  3:  3](R/W) Controls which transition of the counter register ( AP_CNTPCT_EL0
                                                                     or AP_CNTVCT_EL0) trigger bit, defined by EVNTI, generates an
                                                                     event when the event stream is enabled:
                                                                 0 = A 0 to 1 transition of the trigger bit triggers an event.
                                                                 1 = A 1 to 0 transition of the trigger bit triggers an event. */
        uint32_t evnti                 : 4;  /**< [  7:  4](R/W) Selects which bit (0 to 15) of the corresponding counter
                                                                     register ( AP_CNTPCT_EL0 or AP_CNTVCT_EL0) is the trigger for the
                                                                     event stream generated from that counter, when that stream is
                                                                     enabled. */
        uint32_t el0vten               : 1;  /**< [  8:  8](R/W) Controls whether the virtual timer registers are accessible
                                                                     from EL0 modes:
                                                                 0 = The AP_CNTV_CVAL_EL0, AP_CNTV_CTL_EL0, and AP_CNTV_TVAL_EL0 registers
                                                                     are not accessible from EL0.
                                                                 1 = The AP_CNTV_CVAL_EL0, AP_CNTV_CTL_EL0, and AP_CNTV_TVAL_EL0 registers
                                                                     are accessible from EL0. */
        uint32_t el0pten               : 1;  /**< [  9:  9](R/W) Controls whether the physical timer registers are accessible
                                                                     from EL0 modes:
                                                                 0 = The AP_CNTP_CVAL_EL0, AP_CNTP_CTL_EL0, and AP_CNTP_TVAL_EL0 registers
                                                                     are not accessible from EL0.
                                                                 1 = The AP_CNTP_CVAL_EL0, AP_CNTP_CTL_EL0, and AP_CNTP_TVAL_EL0 registers
                                                                     are accessible from EL0. */
        uint32_t reserved_10_31        : 22;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntkctl_el1_s cn; */
};
typedef union bdk_ap_cntkctl_el1 bdk_ap_cntkctl_el1_t;

#define BDK_AP_CNTKCTL_EL1 BDK_AP_CNTKCTL_EL1_FUNC()
static inline uint64_t BDK_AP_CNTKCTL_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTKCTL_EL1_FUNC(void)
{
    return 0x3000e010000ll;
}

#define typedef_BDK_AP_CNTKCTL_EL1 bdk_ap_cntkctl_el1_t
#define bustype_BDK_AP_CNTKCTL_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTKCTL_EL1 "AP_CNTKCTL_EL1"
#define busnum_BDK_AP_CNTKCTL_EL1 0
#define arguments_BDK_AP_CNTKCTL_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntkctl_el12
 *
 * AP Counter-timer Kernel Control Register
 * Alias of AP_CNTKCTL_EL1 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntkctl_el12
{
    uint32_t u;
    struct bdk_ap_cntkctl_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntkctl_el12_s cn; */
};
typedef union bdk_ap_cntkctl_el12 bdk_ap_cntkctl_el12_t;

#define BDK_AP_CNTKCTL_EL12 BDK_AP_CNTKCTL_EL12_FUNC()
static inline uint64_t BDK_AP_CNTKCTL_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTKCTL_EL12_FUNC(void)
{
    return 0x3050e010000ll;
}

#define typedef_BDK_AP_CNTKCTL_EL12 bdk_ap_cntkctl_el12_t
#define bustype_BDK_AP_CNTKCTL_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTKCTL_EL12 "AP_CNTKCTL_EL12"
#define busnum_BDK_AP_CNTKCTL_EL12 0
#define arguments_BDK_AP_CNTKCTL_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntp_ctl_el0
 *
 * AP Counter-timer Physical Timer Control Register
 * Control register for the EL1 physical timer.
 */
union bdk_ap_cntp_ctl_el0
{
    uint32_t u;
    struct bdk_ap_cntp_ctl_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
#else /* Word 0 - Little Endian */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t reserved_3_31         : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntp_ctl_el0_s cn; */
};
typedef union bdk_ap_cntp_ctl_el0 bdk_ap_cntp_ctl_el0_t;

#define BDK_AP_CNTP_CTL_EL0 BDK_AP_CNTP_CTL_EL0_FUNC()
static inline uint64_t BDK_AP_CNTP_CTL_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTP_CTL_EL0_FUNC(void)
{
    return 0x3030e020100ll;
}

#define typedef_BDK_AP_CNTP_CTL_EL0 bdk_ap_cntp_ctl_el0_t
#define bustype_BDK_AP_CNTP_CTL_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTP_CTL_EL0 "AP_CNTP_CTL_EL0"
#define busnum_BDK_AP_CNTP_CTL_EL0 0
#define arguments_BDK_AP_CNTP_CTL_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntp_ctl_el02
 *
 * AP Counter-timer Physical Timer Control Register
 * Alias of AP_CNTP_CTL_EL0 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntp_ctl_el02
{
    uint32_t u;
    struct bdk_ap_cntp_ctl_el02_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntp_ctl_el02_s cn; */
};
typedef union bdk_ap_cntp_ctl_el02 bdk_ap_cntp_ctl_el02_t;

#define BDK_AP_CNTP_CTL_EL02 BDK_AP_CNTP_CTL_EL02_FUNC()
static inline uint64_t BDK_AP_CNTP_CTL_EL02_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTP_CTL_EL02_FUNC(void)
{
    return 0x3050e020100ll;
}

#define typedef_BDK_AP_CNTP_CTL_EL02 bdk_ap_cntp_ctl_el02_t
#define bustype_BDK_AP_CNTP_CTL_EL02 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTP_CTL_EL02 "AP_CNTP_CTL_EL02"
#define busnum_BDK_AP_CNTP_CTL_EL02 0
#define arguments_BDK_AP_CNTP_CTL_EL02 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntp_cval_el0
 *
 * AP Counter-timer Physical Timer Compare Value Register
 * Holds the compare value for the EL1 physical timer.
 */
union bdk_ap_cntp_cval_el0
{
    uint64_t u;
    struct bdk_ap_cntp_cval_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) EL1 physical timer compare value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) EL1 physical timer compare value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntp_cval_el0_s cn; */
};
typedef union bdk_ap_cntp_cval_el0 bdk_ap_cntp_cval_el0_t;

#define BDK_AP_CNTP_CVAL_EL0 BDK_AP_CNTP_CVAL_EL0_FUNC()
static inline uint64_t BDK_AP_CNTP_CVAL_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTP_CVAL_EL0_FUNC(void)
{
    return 0x3030e020200ll;
}

#define typedef_BDK_AP_CNTP_CVAL_EL0 bdk_ap_cntp_cval_el0_t
#define bustype_BDK_AP_CNTP_CVAL_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTP_CVAL_EL0 "AP_CNTP_CVAL_EL0"
#define busnum_BDK_AP_CNTP_CVAL_EL0 0
#define arguments_BDK_AP_CNTP_CVAL_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntp_cval_el02
 *
 * AP Counter-timer Physical Timer Compare Value Register
 * Alias of AP_CNTP_CVAL_EL0 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntp_cval_el02
{
    uint64_t u;
    struct bdk_ap_cntp_cval_el02_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntp_cval_el02_s cn; */
};
typedef union bdk_ap_cntp_cval_el02 bdk_ap_cntp_cval_el02_t;

#define BDK_AP_CNTP_CVAL_EL02 BDK_AP_CNTP_CVAL_EL02_FUNC()
static inline uint64_t BDK_AP_CNTP_CVAL_EL02_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTP_CVAL_EL02_FUNC(void)
{
    return 0x3050e020200ll;
}

#define typedef_BDK_AP_CNTP_CVAL_EL02 bdk_ap_cntp_cval_el02_t
#define bustype_BDK_AP_CNTP_CVAL_EL02 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTP_CVAL_EL02 "AP_CNTP_CVAL_EL02"
#define busnum_BDK_AP_CNTP_CVAL_EL02 0
#define arguments_BDK_AP_CNTP_CVAL_EL02 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntp_tval_el0
 *
 * AP Counter-timer Physical Timer Value Register
 * Holds the timer value for the EL1 physical timer.
 */
union bdk_ap_cntp_tval_el0
{
    uint32_t u;
    struct bdk_ap_cntp_tval_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) EL1 physical timer value. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) EL1 physical timer value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntp_tval_el0_s cn; */
};
typedef union bdk_ap_cntp_tval_el0 bdk_ap_cntp_tval_el0_t;

#define BDK_AP_CNTP_TVAL_EL0 BDK_AP_CNTP_TVAL_EL0_FUNC()
static inline uint64_t BDK_AP_CNTP_TVAL_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTP_TVAL_EL0_FUNC(void)
{
    return 0x3030e020000ll;
}

#define typedef_BDK_AP_CNTP_TVAL_EL0 bdk_ap_cntp_tval_el0_t
#define bustype_BDK_AP_CNTP_TVAL_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTP_TVAL_EL0 "AP_CNTP_TVAL_EL0"
#define busnum_BDK_AP_CNTP_TVAL_EL0 0
#define arguments_BDK_AP_CNTP_TVAL_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntp_tval_el02
 *
 * AP Counter-timer Physical Timer Value Register
 * Alias of CNTP_TVAL_EL1 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntp_tval_el02
{
    uint32_t u;
    struct bdk_ap_cntp_tval_el02_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntp_tval_el02_s cn; */
};
typedef union bdk_ap_cntp_tval_el02 bdk_ap_cntp_tval_el02_t;

#define BDK_AP_CNTP_TVAL_EL02 BDK_AP_CNTP_TVAL_EL02_FUNC()
static inline uint64_t BDK_AP_CNTP_TVAL_EL02_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTP_TVAL_EL02_FUNC(void)
{
    return 0x3050e020000ll;
}

#define typedef_BDK_AP_CNTP_TVAL_EL02 bdk_ap_cntp_tval_el02_t
#define bustype_BDK_AP_CNTP_TVAL_EL02 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTP_TVAL_EL02 "AP_CNTP_TVAL_EL02"
#define busnum_BDK_AP_CNTP_TVAL_EL02 0
#define arguments_BDK_AP_CNTP_TVAL_EL02 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntpct_el0
 *
 * AP Counter-timer Physical Count Register
 * Holds the 64-bit physical count value.
 */
union bdk_ap_cntpct_el0
{
    uint64_t u;
    struct bdk_ap_cntpct_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Physical count value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Physical count value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntpct_el0_s cn; */
};
typedef union bdk_ap_cntpct_el0 bdk_ap_cntpct_el0_t;

#define BDK_AP_CNTPCT_EL0 BDK_AP_CNTPCT_EL0_FUNC()
static inline uint64_t BDK_AP_CNTPCT_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTPCT_EL0_FUNC(void)
{
    return 0x3030e000100ll;
}

#define typedef_BDK_AP_CNTPCT_EL0 bdk_ap_cntpct_el0_t
#define bustype_BDK_AP_CNTPCT_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTPCT_EL0 "AP_CNTPCT_EL0"
#define busnum_BDK_AP_CNTPCT_EL0 0
#define arguments_BDK_AP_CNTPCT_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntps_ctl_el1
 *
 * AP Counter-timer Physical Secure Timer Control Register
 * Control register for the secure physical timer, usually
 *     accessible at EL3 but configurably accessible at EL1 in Secure
 *     state.
 */
union bdk_ap_cntps_ctl_el1
{
    uint32_t u;
    struct bdk_ap_cntps_ctl_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
#else /* Word 0 - Little Endian */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t reserved_3_31         : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntps_ctl_el1_s cn; */
};
typedef union bdk_ap_cntps_ctl_el1 bdk_ap_cntps_ctl_el1_t;

#define BDK_AP_CNTPS_CTL_EL1 BDK_AP_CNTPS_CTL_EL1_FUNC()
static inline uint64_t BDK_AP_CNTPS_CTL_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTPS_CTL_EL1_FUNC(void)
{
    return 0x3070e020100ll;
}

#define typedef_BDK_AP_CNTPS_CTL_EL1 bdk_ap_cntps_ctl_el1_t
#define bustype_BDK_AP_CNTPS_CTL_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTPS_CTL_EL1 "AP_CNTPS_CTL_EL1"
#define busnum_BDK_AP_CNTPS_CTL_EL1 0
#define arguments_BDK_AP_CNTPS_CTL_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntps_cval_el1
 *
 * AP Counter-timer Physical Secure Timer Compare Value Register
 * Holds the compare value for the secure physical timer, usually
 *     accessible at EL3 but configurably accessible at EL1 in Secure
 *     state.
 */
union bdk_ap_cntps_cval_el1
{
    uint64_t u;
    struct bdk_ap_cntps_cval_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Secure physical timer compare value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Secure physical timer compare value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntps_cval_el1_s cn; */
};
typedef union bdk_ap_cntps_cval_el1 bdk_ap_cntps_cval_el1_t;

#define BDK_AP_CNTPS_CVAL_EL1 BDK_AP_CNTPS_CVAL_EL1_FUNC()
static inline uint64_t BDK_AP_CNTPS_CVAL_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTPS_CVAL_EL1_FUNC(void)
{
    return 0x3070e020200ll;
}

#define typedef_BDK_AP_CNTPS_CVAL_EL1 bdk_ap_cntps_cval_el1_t
#define bustype_BDK_AP_CNTPS_CVAL_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTPS_CVAL_EL1 "AP_CNTPS_CVAL_EL1"
#define busnum_BDK_AP_CNTPS_CVAL_EL1 0
#define arguments_BDK_AP_CNTPS_CVAL_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntps_tval_el1
 *
 * AP Counter-timer Physical Secure Timer Value Register
 * This register holds the timer value for the secure physical timer, usually
 * accessible at EL3 but configurably accessible at EL1 in the secure state.
 */
union bdk_ap_cntps_tval_el1
{
    uint32_t u;
    struct bdk_ap_cntps_tval_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) Secure physical timer value. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) Secure physical timer value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntps_tval_el1_s cn; */
};
typedef union bdk_ap_cntps_tval_el1 bdk_ap_cntps_tval_el1_t;

#define BDK_AP_CNTPS_TVAL_EL1 BDK_AP_CNTPS_TVAL_EL1_FUNC()
static inline uint64_t BDK_AP_CNTPS_TVAL_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTPS_TVAL_EL1_FUNC(void)
{
    return 0x3070e020000ll;
}

#define typedef_BDK_AP_CNTPS_TVAL_EL1 bdk_ap_cntps_tval_el1_t
#define bustype_BDK_AP_CNTPS_TVAL_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTPS_TVAL_EL1 "AP_CNTPS_TVAL_EL1"
#define busnum_BDK_AP_CNTPS_TVAL_EL1 0
#define arguments_BDK_AP_CNTPS_TVAL_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntv_ctl_el0
 *
 * AP Counter-timer Virtual Timer Control Register
 * Control register for the virtual timer.
 */
union bdk_ap_cntv_ctl_el0
{
    uint32_t u;
    struct bdk_ap_cntv_ctl_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
#else /* Word 0 - Little Endian */
        uint32_t enable                : 1;  /**< [  0:  0](R/W) Enables the timer.
                                                                 Disabling the timer masks the timer interrupt, but the timer
                                                                     value continues to count down.
                                                                 0 = Timer disabled.
                                                                 1 = Timer enabled. */
        uint32_t imask                 : 1;  /**< [  1:  1](R/W) Timer interrupt mask bit.
                                                                 0 = Timer interrupt is not masked.
                                                                 1 = Timer interrupt is masked. */
        uint32_t istatus               : 1;  /**< [  2:  2](RO) The status of the timer interrupt. This bit is read-only.
                                                                 A register write that sets IMASK to 1 latches this bit to
                                                                     reflect the status of the interrupt immediately before that
                                                                     write.
                                                                 0 = Interrupt not asserted.
                                                                 1 = Interrupt asserted. */
        uint32_t reserved_3_31         : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntv_ctl_el0_s cn; */
};
typedef union bdk_ap_cntv_ctl_el0 bdk_ap_cntv_ctl_el0_t;

#define BDK_AP_CNTV_CTL_EL0 BDK_AP_CNTV_CTL_EL0_FUNC()
static inline uint64_t BDK_AP_CNTV_CTL_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTV_CTL_EL0_FUNC(void)
{
    return 0x3030e030100ll;
}

#define typedef_BDK_AP_CNTV_CTL_EL0 bdk_ap_cntv_ctl_el0_t
#define bustype_BDK_AP_CNTV_CTL_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTV_CTL_EL0 "AP_CNTV_CTL_EL0"
#define busnum_BDK_AP_CNTV_CTL_EL0 0
#define arguments_BDK_AP_CNTV_CTL_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntv_ctl_el02
 *
 * AP Counter-timer Virtual Timer Control Register
 * Alias of AP_CNTV_CTL_EL0 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntv_ctl_el02
{
    uint32_t u;
    struct bdk_ap_cntv_ctl_el02_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntv_ctl_el02_s cn; */
};
typedef union bdk_ap_cntv_ctl_el02 bdk_ap_cntv_ctl_el02_t;

#define BDK_AP_CNTV_CTL_EL02 BDK_AP_CNTV_CTL_EL02_FUNC()
static inline uint64_t BDK_AP_CNTV_CTL_EL02_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTV_CTL_EL02_FUNC(void)
{
    return 0x3050e030100ll;
}

#define typedef_BDK_AP_CNTV_CTL_EL02 bdk_ap_cntv_ctl_el02_t
#define bustype_BDK_AP_CNTV_CTL_EL02 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTV_CTL_EL02 "AP_CNTV_CTL_EL02"
#define busnum_BDK_AP_CNTV_CTL_EL02 0
#define arguments_BDK_AP_CNTV_CTL_EL02 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntv_cval_el0
 *
 * AP Counter-timer Virtual Timer Compare Value Register
 * Holds the compare value for the virtual timer.
 */
union bdk_ap_cntv_cval_el0
{
    uint64_t u;
    struct bdk_ap_cntv_cval_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Virtual timer compare value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Virtual timer compare value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntv_cval_el0_s cn; */
};
typedef union bdk_ap_cntv_cval_el0 bdk_ap_cntv_cval_el0_t;

#define BDK_AP_CNTV_CVAL_EL0 BDK_AP_CNTV_CVAL_EL0_FUNC()
static inline uint64_t BDK_AP_CNTV_CVAL_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTV_CVAL_EL0_FUNC(void)
{
    return 0x3030e030200ll;
}

#define typedef_BDK_AP_CNTV_CVAL_EL0 bdk_ap_cntv_cval_el0_t
#define bustype_BDK_AP_CNTV_CVAL_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTV_CVAL_EL0 "AP_CNTV_CVAL_EL0"
#define busnum_BDK_AP_CNTV_CVAL_EL0 0
#define arguments_BDK_AP_CNTV_CVAL_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntv_cval_el02
 *
 * AP Counter-timer Virtual Timer Compare Value Register
 * Alias of AP_CNTV_CVAL_EL0 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntv_cval_el02
{
    uint64_t u;
    struct bdk_ap_cntv_cval_el02_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntv_cval_el02_s cn; */
};
typedef union bdk_ap_cntv_cval_el02 bdk_ap_cntv_cval_el02_t;

#define BDK_AP_CNTV_CVAL_EL02 BDK_AP_CNTV_CVAL_EL02_FUNC()
static inline uint64_t BDK_AP_CNTV_CVAL_EL02_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTV_CVAL_EL02_FUNC(void)
{
    return 0x3050e030200ll;
}

#define typedef_BDK_AP_CNTV_CVAL_EL02 bdk_ap_cntv_cval_el02_t
#define bustype_BDK_AP_CNTV_CVAL_EL02 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTV_CVAL_EL02 "AP_CNTV_CVAL_EL02"
#define busnum_BDK_AP_CNTV_CVAL_EL02 0
#define arguments_BDK_AP_CNTV_CVAL_EL02 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntv_tval_el0
 *
 * AP Counter-timer Virtual Timer Value Register
 * Holds the timer value for the virtual timer.
 */
union bdk_ap_cntv_tval_el0
{
    uint32_t u;
    struct bdk_ap_cntv_tval_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) Virtual timer value. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](R/W) Virtual timer value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntv_tval_el0_s cn; */
};
typedef union bdk_ap_cntv_tval_el0 bdk_ap_cntv_tval_el0_t;

#define BDK_AP_CNTV_TVAL_EL0 BDK_AP_CNTV_TVAL_EL0_FUNC()
static inline uint64_t BDK_AP_CNTV_TVAL_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTV_TVAL_EL0_FUNC(void)
{
    return 0x3030e030000ll;
}

#define typedef_BDK_AP_CNTV_TVAL_EL0 bdk_ap_cntv_tval_el0_t
#define bustype_BDK_AP_CNTV_TVAL_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTV_TVAL_EL0 "AP_CNTV_TVAL_EL0"
#define busnum_BDK_AP_CNTV_TVAL_EL0 0
#define arguments_BDK_AP_CNTV_TVAL_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntv_tval_el02
 *
 * AP Counter-timer Virtual Timer Value Register
 * Alias of AP_CNTV_TVAL_EL0 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cntv_tval_el02
{
    uint32_t u;
    struct bdk_ap_cntv_tval_el02_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntv_tval_el02_s cn; */
};
typedef union bdk_ap_cntv_tval_el02 bdk_ap_cntv_tval_el02_t;

#define BDK_AP_CNTV_TVAL_EL02 BDK_AP_CNTV_TVAL_EL02_FUNC()
static inline uint64_t BDK_AP_CNTV_TVAL_EL02_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTV_TVAL_EL02_FUNC(void)
{
    return 0x3050e030000ll;
}

#define typedef_BDK_AP_CNTV_TVAL_EL02 bdk_ap_cntv_tval_el02_t
#define bustype_BDK_AP_CNTV_TVAL_EL02 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTV_TVAL_EL02 "AP_CNTV_TVAL_EL02"
#define busnum_BDK_AP_CNTV_TVAL_EL02 0
#define arguments_BDK_AP_CNTV_TVAL_EL02 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntvct_el0
 *
 * AP Counter-timer Virtual Count Register
 * Holds the 64-bit virtual count value.
 */
union bdk_ap_cntvct_el0
{
    uint64_t u;
    struct bdk_ap_cntvct_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Virtual count value. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Virtual count value. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntvct_el0_s cn; */
};
typedef union bdk_ap_cntvct_el0 bdk_ap_cntvct_el0_t;

#define BDK_AP_CNTVCT_EL0 BDK_AP_CNTVCT_EL0_FUNC()
static inline uint64_t BDK_AP_CNTVCT_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTVCT_EL0_FUNC(void)
{
    return 0x3030e000200ll;
}

#define typedef_BDK_AP_CNTVCT_EL0 bdk_ap_cntvct_el0_t
#define bustype_BDK_AP_CNTVCT_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTVCT_EL0 "AP_CNTVCT_EL0"
#define busnum_BDK_AP_CNTVCT_EL0 0
#define arguments_BDK_AP_CNTVCT_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cntvoff_el2
 *
 * AP Counter-timer Virtual Offset Register
 * Holds the 64-bit virtual offset.
 */
union bdk_ap_cntvoff_el2
{
    uint64_t u;
    struct bdk_ap_cntvoff_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Virtual offset. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Virtual offset. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cntvoff_el2_s cn; */
};
typedef union bdk_ap_cntvoff_el2 bdk_ap_cntvoff_el2_t;

#define BDK_AP_CNTVOFF_EL2 BDK_AP_CNTVOFF_EL2_FUNC()
static inline uint64_t BDK_AP_CNTVOFF_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CNTVOFF_EL2_FUNC(void)
{
    return 0x3040e000300ll;
}

#define typedef_BDK_AP_CNTVOFF_EL2 bdk_ap_cntvoff_el2_t
#define bustype_BDK_AP_CNTVOFF_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CNTVOFF_EL2 "AP_CNTVOFF_EL2"
#define busnum_BDK_AP_CNTVOFF_EL2 0
#define arguments_BDK_AP_CNTVOFF_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_contextidr_el1
 *
 * AP Context ID Register
 * Identifies the current Process Identifier.
 */
union bdk_ap_contextidr_el1
{
    uint32_t u;
    struct bdk_ap_contextidr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t procid                : 32; /**< [ 31:  0](R/W) Process Identifier. This field must be programmed with a
                                                                     unique value that identifies the current process. The bottom 8
                                                                     bits of this register are not used to hold the ASID. */
#else /* Word 0 - Little Endian */
        uint32_t procid                : 32; /**< [ 31:  0](R/W) Process Identifier. This field must be programmed with a
                                                                     unique value that identifies the current process. The bottom 8
                                                                     bits of this register are not used to hold the ASID. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_contextidr_el1_s cn; */
};
typedef union bdk_ap_contextidr_el1 bdk_ap_contextidr_el1_t;

#define BDK_AP_CONTEXTIDR_EL1 BDK_AP_CONTEXTIDR_EL1_FUNC()
static inline uint64_t BDK_AP_CONTEXTIDR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CONTEXTIDR_EL1_FUNC(void)
{
    return 0x3000d000100ll;
}

#define typedef_BDK_AP_CONTEXTIDR_EL1 bdk_ap_contextidr_el1_t
#define bustype_BDK_AP_CONTEXTIDR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CONTEXTIDR_EL1 "AP_CONTEXTIDR_EL1"
#define busnum_BDK_AP_CONTEXTIDR_EL1 0
#define arguments_BDK_AP_CONTEXTIDR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_contextidr_el12
 *
 * AP Context ID Register
 * Alias of AP_CONTEXTIDR_EL1 when accessed at EL2/2 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_contextidr_el12
{
    uint32_t u;
    struct bdk_ap_contextidr_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_contextidr_el12_s cn; */
};
typedef union bdk_ap_contextidr_el12 bdk_ap_contextidr_el12_t;

#define BDK_AP_CONTEXTIDR_EL12 BDK_AP_CONTEXTIDR_EL12_FUNC()
static inline uint64_t BDK_AP_CONTEXTIDR_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CONTEXTIDR_EL12_FUNC(void)
{
    return 0x3050d000100ll;
}

#define typedef_BDK_AP_CONTEXTIDR_EL12 bdk_ap_contextidr_el12_t
#define bustype_BDK_AP_CONTEXTIDR_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CONTEXTIDR_EL12 "AP_CONTEXTIDR_EL12"
#define busnum_BDK_AP_CONTEXTIDR_EL12 0
#define arguments_BDK_AP_CONTEXTIDR_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_contextidr_el2
 *
 * AP Context ID EL2 Register
 * v8.1: Identifies the current Process Identifier.
 */
union bdk_ap_contextidr_el2
{
    uint32_t u;
    struct bdk_ap_contextidr_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t procid                : 32; /**< [ 31:  0](R/W) v8.1: Process Identifier. This field must be programmed with a
                                                                     unique value that identifies the current process. The bottom 8
                                                                     bits of this register are not used to hold the ASID. */
#else /* Word 0 - Little Endian */
        uint32_t procid                : 32; /**< [ 31:  0](R/W) v8.1: Process Identifier. This field must be programmed with a
                                                                     unique value that identifies the current process. The bottom 8
                                                                     bits of this register are not used to hold the ASID. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_contextidr_el2_s cn; */
};
typedef union bdk_ap_contextidr_el2 bdk_ap_contextidr_el2_t;

#define BDK_AP_CONTEXTIDR_EL2 BDK_AP_CONTEXTIDR_EL2_FUNC()
static inline uint64_t BDK_AP_CONTEXTIDR_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CONTEXTIDR_EL2_FUNC(void)
{
    return 0x3040d000100ll;
}

#define typedef_BDK_AP_CONTEXTIDR_EL2 bdk_ap_contextidr_el2_t
#define bustype_BDK_AP_CONTEXTIDR_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CONTEXTIDR_EL2 "AP_CONTEXTIDR_EL2"
#define busnum_BDK_AP_CONTEXTIDR_EL2 0
#define arguments_BDK_AP_CONTEXTIDR_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cpacr_el1
 *
 * AP Architectural Feature Access Control Register
 * Controls access to Trace, Floating-point, and Advanced SIMD
 *     functionality.
 */
union bdk_ap_cpacr_el1
{
    uint32_t u;
    struct bdk_ap_cpacr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_22_31        : 10;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) Causes instructions that access the registers associated with
                                                                     Floating Point and Advanced SIMD execution to trap to EL1 when
                                                                     executed from EL0 or EL1.
                                                                 0x0 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x1 = Causes any instructions in EL0 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped, but does not cause any instruction in EL1 to be
                                                                     trapped.
                                                                 0x2 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x3 = Does not cause any instruction to be trapped. */
        uint32_t reserved_0_19         : 20;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_19         : 20;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) Causes instructions that access the registers associated with
                                                                     Floating Point and Advanced SIMD execution to trap to EL1 when
                                                                     executed from EL0 or EL1.
                                                                 0x0 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x1 = Causes any instructions in EL0 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped, but does not cause any instruction in EL1 to be
                                                                     trapped.
                                                                 0x2 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x3 = Does not cause any instruction to be trapped. */
        uint32_t reserved_22_31        : 10;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cpacr_el1_cn
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_29_31        : 3;
        uint32_t reserved_28           : 1;
        uint32_t reserved_22_27        : 6;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) Causes instructions that access the registers associated with
                                                                     Floating Point and Advanced SIMD execution to trap to EL1 when
                                                                     executed from EL0 or EL1.
                                                                 0x0 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x1 = Causes any instructions in EL0 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped, but does not cause any instruction in EL1 to be
                                                                     trapped.
                                                                 0x2 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x3 = Does not cause any instruction to be trapped. */
        uint32_t reserved_0_19         : 20;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_19         : 20;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) Causes instructions that access the registers associated with
                                                                     Floating Point and Advanced SIMD execution to trap to EL1 when
                                                                     executed from EL0 or EL1.
                                                                 0x0 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x1 = Causes any instructions in EL0 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped, but does not cause any instruction in EL1 to be
                                                                     trapped.
                                                                 0x2 = Causes any instructions in EL0 or EL1 that use the registers
                                                                     associated with Floating Point and Advanced SIMD execution to
                                                                     be trapped.
                                                                 0x3 = Does not cause any instruction to be trapped. */
        uint32_t reserved_22_27        : 6;
        uint32_t reserved_28           : 1;
        uint32_t reserved_29_31        : 3;
#endif /* Word 0 - End */
    } cn;
};
typedef union bdk_ap_cpacr_el1 bdk_ap_cpacr_el1_t;

#define BDK_AP_CPACR_EL1 BDK_AP_CPACR_EL1_FUNC()
static inline uint64_t BDK_AP_CPACR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CPACR_EL1_FUNC(void)
{
    return 0x30001000200ll;
}

#define typedef_BDK_AP_CPACR_EL1 bdk_ap_cpacr_el1_t
#define bustype_BDK_AP_CPACR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CPACR_EL1 "AP_CPACR_EL1"
#define busnum_BDK_AP_CPACR_EL1 0
#define arguments_BDK_AP_CPACR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cpacr_el12
 *
 * AP Architectural Feature Access Control Register
 * Alias of AP_CPACR_EL1 when accessed from EL2 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_cpacr_el12
{
    uint32_t u;
    struct bdk_ap_cpacr_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cpacr_el12_s cn; */
};
typedef union bdk_ap_cpacr_el12 bdk_ap_cpacr_el12_t;

#define BDK_AP_CPACR_EL12 BDK_AP_CPACR_EL12_FUNC()
static inline uint64_t BDK_AP_CPACR_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CPACR_EL12_FUNC(void)
{
    return 0x30501000200ll;
}

#define typedef_BDK_AP_CPACR_EL12 bdk_ap_cpacr_el12_t
#define bustype_BDK_AP_CPACR_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CPACR_EL12 "AP_CPACR_EL12"
#define busnum_BDK_AP_CPACR_EL12 0
#define arguments_BDK_AP_CPACR_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cptr_el2
 *
 * AP Architectural Feature Trap EL2 Non-E2H Register
 * Controls trapping to EL2 of access to CPACR, AP_CPACR_EL1, Trace
 *     functionality and registers associated with Floating Point and
 *     Advanced SIMD execution. Also controls EL2 access to this
 *     functionality.
 *
 * This register is at the same select as AP_CPTR_EL2_E2H and is used when E2H=0.
 */
union bdk_ap_cptr_el2
{
    uint32_t u;
    struct bdk_ap_cptr_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2.
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped. */
        uint32_t reserved_14_30        : 17;
        uint32_t rsvd_12_13            : 2;  /**< [ 13: 12](RO) Reserved 1. */
        uint32_t reserved_11           : 1;
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL2
                                                                     when executed from EL0, EL1, or EL2, unless trapped to EL1.

                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t rsvd_0_9              : 10; /**< [  9:  0](RO) Reserved 1. */
#else /* Word 0 - Little Endian */
        uint32_t rsvd_0_9              : 10; /**< [  9:  0](RO) Reserved 1. */
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL2
                                                                     when executed from EL0, EL1, or EL2, unless trapped to EL1.

                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t reserved_11           : 1;
        uint32_t rsvd_12_13            : 2;  /**< [ 13: 12](RO) Reserved 1. */
        uint32_t reserved_14_30        : 17;
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2.
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped. */
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cptr_el2_cn
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2.
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped. */
        uint32_t reserved_29_30        : 2;
        uint32_t reserved_28           : 1;
        uint32_t reserved_20_27        : 8;
        uint32_t reserved_14_19        : 6;
        uint32_t rsvd_12_13            : 2;  /**< [ 13: 12](RO) Reserved 1. */
        uint32_t reserved_11           : 1;
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL2
                                                                     when executed from EL0, EL1, or EL2, unless trapped to EL1.

                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t rsvd_0_9              : 10; /**< [  9:  0](RO) Reserved 1. */
#else /* Word 0 - Little Endian */
        uint32_t rsvd_0_9              : 10; /**< [  9:  0](RO) Reserved 1. */
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL2
                                                                     when executed from EL0, EL1, or EL2, unless trapped to EL1.

                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t reserved_11           : 1;
        uint32_t rsvd_12_13            : 2;  /**< [ 13: 12](RO) Reserved 1. */
        uint32_t reserved_14_19        : 6;
        uint32_t reserved_20_27        : 8;
        uint32_t reserved_28           : 1;
        uint32_t reserved_29_30        : 2;
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2.
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped. */
#endif /* Word 0 - End */
    } cn;
};
typedef union bdk_ap_cptr_el2 bdk_ap_cptr_el2_t;

#define BDK_AP_CPTR_EL2 BDK_AP_CPTR_EL2_FUNC()
static inline uint64_t BDK_AP_CPTR_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CPTR_EL2_FUNC(void)
{
    return 0x30401010200ll;
}

#define typedef_BDK_AP_CPTR_EL2 bdk_ap_cptr_el2_t
#define bustype_BDK_AP_CPTR_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CPTR_EL2 "AP_CPTR_EL2"
#define busnum_BDK_AP_CPTR_EL2 0
#define arguments_BDK_AP_CPTR_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cptr_el2_e2h
 *
 * AP Architectural Feature Trap EL2 E2H Register
 * Controls trapping to EL2 of access to CPACR, AP_CPACR_EL1, Trace
 *     functionality and registers associated with Floating Point and
 *     Advanced SIMD execution. Also controls EL2 access to this
 *     functionality.
 *
 * This register is at the same select as AP_CPTR_EL2 and is used when E2H=1.
 */
union bdk_ap_cptr_el2_e2h
{
    uint32_t u;
    struct bdk_ap_cptr_el2_e2h_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2. When AP_HCR_EL2[TGE] == 0:
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped.

                                                                 When AP_HCR_EL2[TGE] == 1, this bit is ignored by hardware and
                                                                 does not cause access to the AP_CPACR_EL1 to be trapped. */
        uint32_t reserved_22_30        : 9;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) This causes instructions that access the registers associated with
                                                                 Floating Point and Advanced SIMD execution to trap to EL2 when executed
                                                                 from EL0 or EL2.
                                                                 0x0 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL1 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x1 = This field value causes any instructions executed at EL0 that use
                                                                      the registerss associated with Floating Point or Advanced SIMD
                                                                      execution to be trapped when AP_HCR_EL2[TGE]==1 only.  It does not
                                                                      cause any instruction executed at EL1 or EL2 to be trapped and
                                                                      it does not cause any instruction to be trapped when AP_HCR_EL2[TGE]==0.

                                                                 0x2 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL2 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x3 = This field value does not cause any instruction to be trapped. */
        uint32_t reserved_0_19         : 20;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_19         : 20;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) This causes instructions that access the registers associated with
                                                                 Floating Point and Advanced SIMD execution to trap to EL2 when executed
                                                                 from EL0 or EL2.
                                                                 0x0 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL1 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x1 = This field value causes any instructions executed at EL0 that use
                                                                      the registerss associated with Floating Point or Advanced SIMD
                                                                      execution to be trapped when AP_HCR_EL2[TGE]==1 only.  It does not
                                                                      cause any instruction executed at EL1 or EL2 to be trapped and
                                                                      it does not cause any instruction to be trapped when AP_HCR_EL2[TGE]==0.

                                                                 0x2 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL2 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x3 = This field value does not cause any instruction to be trapped. */
        uint32_t reserved_22_30        : 9;
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2. When AP_HCR_EL2[TGE] == 0:
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped.

                                                                 When AP_HCR_EL2[TGE] == 1, this bit is ignored by hardware and
                                                                 does not cause access to the AP_CPACR_EL1 to be trapped. */
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cptr_el2_e2h_cn
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2. When AP_HCR_EL2[TGE] == 0:
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped.

                                                                 When AP_HCR_EL2[TGE] == 1, this bit is ignored by hardware and
                                                                 does not cause access to the AP_CPACR_EL1 to be trapped. */
        uint32_t reserved_29_30        : 2;
        uint32_t reserved_28           : 1;
        uint32_t reserved_22_27        : 6;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) This causes instructions that access the registers associated with
                                                                 Floating Point and Advanced SIMD execution to trap to EL2 when executed
                                                                 from EL0 or EL2.
                                                                 0x0 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL1 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x1 = This field value causes any instructions executed at EL0 that use
                                                                      the registerss associated with Floating Point or Advanced SIMD
                                                                      execution to be trapped when AP_HCR_EL2[TGE]==1 only.  It does not
                                                                      cause any instruction executed at EL1 or EL2 to be trapped and
                                                                      it does not cause any instruction to be trapped when AP_HCR_EL2[TGE]==0.

                                                                 0x2 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL2 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x3 = This field value does not cause any instruction to be trapped. */
        uint32_t reserved_0_19         : 20;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_19         : 20;
        uint32_t fpen                  : 2;  /**< [ 21: 20](R/W) This causes instructions that access the registers associated with
                                                                 Floating Point and Advanced SIMD execution to trap to EL2 when executed
                                                                 from EL0 or EL2.
                                                                 0x0 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL1 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x1 = This field value causes any instructions executed at EL0 that use
                                                                      the registerss associated with Floating Point or Advanced SIMD
                                                                      execution to be trapped when AP_HCR_EL2[TGE]==1 only.  It does not
                                                                      cause any instruction executed at EL1 or EL2 to be trapped and
                                                                      it does not cause any instruction to be trapped when AP_HCR_EL2[TGE]==0.

                                                                 0x2 = This field value causes any instructions that use the registers
                                                                      associated with Floating Point and Advanced SIMD execution to be
                                                                      trapped in the following cases:
                                                                        * When AP_HCR_EL2[TGE] == 0, when the instruction is executed at
                                                                          EL0, EL1 or EL2 unless the instruction is trapped to EL2 as
                                                                          a result of the AP_CPACR_EL1[FPEN] bit.
                                                                        * When AP_HCR_EL2[TGE] == 1, when the instruction is executed at
                                                                          EL0 or EL2.

                                                                 0x3 = This field value does not cause any instruction to be trapped. */
        uint32_t reserved_22_27        : 6;
        uint32_t reserved_28           : 1;
        uint32_t reserved_29_30        : 2;
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to CPACR or AP_CPACR_EL1 from EL1 to
                                                                     trap to EL2. When AP_HCR_EL2[TGE] == 0:
                                                                 0 = Does not cause access to CPACR or AP_CPACR_EL1 to be trapped.
                                                                 1 = Causes access to CPACR or AP_CPACR_EL1 to be trapped.

                                                                 When AP_HCR_EL2[TGE] == 1, this bit is ignored by hardware and
                                                                 does not cause access to the AP_CPACR_EL1 to be trapped. */
#endif /* Word 0 - End */
    } cn;
};
typedef union bdk_ap_cptr_el2_e2h bdk_ap_cptr_el2_e2h_t;

#define BDK_AP_CPTR_EL2_E2H BDK_AP_CPTR_EL2_E2H_FUNC()
static inline uint64_t BDK_AP_CPTR_EL2_E2H_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CPTR_EL2_E2H_FUNC(void)
{
    return 0x30401010210ll;
}

#define typedef_BDK_AP_CPTR_EL2_E2H bdk_ap_cptr_el2_e2h_t
#define bustype_BDK_AP_CPTR_EL2_E2H BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CPTR_EL2_E2H "AP_CPTR_EL2_E2H"
#define busnum_BDK_AP_CPTR_EL2_E2H 0
#define arguments_BDK_AP_CPTR_EL2_E2H -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cptr_el3
 *
 * AP Architectural Feature Trap EL3 Register
 * Controls trapping to EL3 of access to AP_CPACR_EL1, Trace
 *     functionality and registers associated with Floating Point and
 *     Advanced SIMD execution. Also controls EL3 access to this
 *     functionality.
 */
union bdk_ap_cptr_el3
{
    uint32_t u;
    struct bdk_ap_cptr_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to the AP_CPACR_EL1 from EL1 or the
                                                                     AP_CPTR_EL2 from EL2 to trap to EL3 unless it is trapped at EL2.

                                                                 0 = Does not cause access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be
                                                                     trapped.
                                                                 1 = Causes access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be trapped. */
        uint32_t reserved_11_30        : 20;
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL3
                                                                     when executed from any Exception level, unless trapped to EL1
                                                                     or EL2.
                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t reserved_0_9          : 10;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_9          : 10;
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL3
                                                                     when executed from any Exception level, unless trapped to EL1
                                                                     or EL2.
                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t reserved_11_30        : 20;
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to the AP_CPACR_EL1 from EL1 or the
                                                                     AP_CPTR_EL2 from EL2 to trap to EL3 unless it is trapped at EL2.

                                                                 0 = Does not cause access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be
                                                                     trapped.
                                                                 1 = Causes access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be trapped. */
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cptr_el3_cn
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to the AP_CPACR_EL1 from EL1 or the
                                                                     AP_CPTR_EL2 from EL2 to trap to EL3 unless it is trapped at EL2.

                                                                 0 = Does not cause access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be
                                                                     trapped.
                                                                 1 = Causes access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be trapped. */
        uint32_t reserved_21_30        : 10;
        uint32_t reserved_20           : 1;
        uint32_t reserved_11_19        : 9;
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL3
                                                                     when executed from any Exception level, unless trapped to EL1
                                                                     or EL2.
                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t reserved_0_9          : 10;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_9          : 10;
        uint32_t tfp                   : 1;  /**< [ 10: 10](R/W) This causes instructions that access the registers associated
                                                                     with Floating Point and Advanced SIMD execution to trap to EL3
                                                                     when executed from any Exception level, unless trapped to EL1
                                                                     or EL2.
                                                                 0 = Does not cause any instruction to be trapped.
                                                                 1 = Causes any instructions that use the registers associated with
                                                                     Floating Point and Advanced SIMD execution to be trapped. */
        uint32_t reserved_11_19        : 9;
        uint32_t reserved_20           : 1;
        uint32_t reserved_21_30        : 10;
        uint32_t tcpac                 : 1;  /**< [ 31: 31](R/W) This causes a direct access to the AP_CPACR_EL1 from EL1 or the
                                                                     AP_CPTR_EL2 from EL2 to trap to EL3 unless it is trapped at EL2.

                                                                 0 = Does not cause access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be
                                                                     trapped.
                                                                 1 = Causes access to the AP_CPACR_EL1 or AP_CPTR_EL2 to be trapped. */
#endif /* Word 0 - End */
    } cn;
};
typedef union bdk_ap_cptr_el3 bdk_ap_cptr_el3_t;

#define BDK_AP_CPTR_EL3 BDK_AP_CPTR_EL3_FUNC()
static inline uint64_t BDK_AP_CPTR_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CPTR_EL3_FUNC(void)
{
    return 0x30601010200ll;
}

#define typedef_BDK_AP_CPTR_EL3 bdk_ap_cptr_el3_t
#define bustype_BDK_AP_CPTR_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CPTR_EL3 "AP_CPTR_EL3"
#define busnum_BDK_AP_CPTR_EL3 0
#define arguments_BDK_AP_CPTR_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_csselr_el1
 *
 * AP Cache Size Selection Register
 * Selects the current Cache Size ID Register, AP_CCSIDR_EL1, by
 *     specifying the required cache level and the cache type (either
 *     instruction or data cache).
 */
union bdk_ap_csselr_el1
{
    uint32_t u;
    struct bdk_ap_csselr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_4_31         : 28;
        uint32_t level                 : 3;  /**< [  3:  1](R/W) Cache level of required cache. */
        uint32_t ind                   : 1;  /**< [  0:  0](R/W) Instruction not Data bit.
                                                                 0 = Data or unified cache.
                                                                 1 = Instruction cache. */
#else /* Word 0 - Little Endian */
        uint32_t ind                   : 1;  /**< [  0:  0](R/W) Instruction not Data bit.
                                                                 0 = Data or unified cache.
                                                                 1 = Instruction cache. */
        uint32_t level                 : 3;  /**< [  3:  1](R/W) Cache level of required cache. */
        uint32_t reserved_4_31         : 28;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_csselr_el1_s cn; */
};
typedef union bdk_ap_csselr_el1 bdk_ap_csselr_el1_t;

#define BDK_AP_CSSELR_EL1 BDK_AP_CSSELR_EL1_FUNC()
static inline uint64_t BDK_AP_CSSELR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CSSELR_EL1_FUNC(void)
{
    return 0x30200000000ll;
}

#define typedef_BDK_AP_CSSELR_EL1 bdk_ap_csselr_el1_t
#define bustype_BDK_AP_CSSELR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CSSELR_EL1 "AP_CSSELR_EL1"
#define busnum_BDK_AP_CSSELR_EL1 0
#define arguments_BDK_AP_CSSELR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_ctr_el0
 *
 * AP Cache Type Register
 * This register provides information about the architecture of the caches.
 */
union bdk_ap_ctr_el0
{
    uint32_t u;
    struct bdk_ap_ctr_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t rsvd_31               : 1;  /**< [ 31: 31](RO) Reserved 1. */
        uint32_t reserved_28_30        : 3;
        uint32_t cwg                   : 4;  /**< [ 27: 24](RO) Cache writeback granule. Log2 of the number of
                                                                     words of the maximum size of memory that can be overwritten as
                                                                     a result of the eviction of a cache entry that has had a
                                                                     memory location in it modified.

                                                                  The architectural maximum of 512 words (2KB) must be assumed.

                                                                  The cache writeback granule can be determined from maximum
                                                                     cache line size encoded in the Cache Size ID Registers. */
        uint32_t erg                   : 4;  /**< [ 23: 20](RO) Exclusives reservation granule. Log2 of the number
                                                                     of words of the maximum size of the reservation granule that
                                                                     has been implemented for the Load-Exclusive and
                                                                     Store-Exclusive instructions. */
        uint32_t dminline              : 4;  /**< [ 19: 16](RO) Log2 of the number of words in the smallest cache
                                                                     line of all the data caches and unified caches that are
                                                                     controlled by the PE.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t l1ip                  : 2;  /**< [ 15: 14](RO) Level 1 instruction cache policy. Indicates the indexing and
                                                                     tagging policy for the L1 instruction cache.

                                                                 0x1 = ASID-tagged virtual index, virtual tag (AIVIVT).
                                                                 0x2 = Virtual index, physical tag (VIPT).
                                                                 0x3 = Physical index, physical tag (PIPT). */
        uint32_t reserved_4_13         : 10;
        uint32_t iminline              : 4;  /**< [  3:  0](RO) Log2 of the number of words in the smallest cache line of all the instruction
                                                                 caches that are controlled by the PE.

                                                                 For CNXXXX, 128 bytes. */
#else /* Word 0 - Little Endian */
        uint32_t iminline              : 4;  /**< [  3:  0](RO) Log2 of the number of words in the smallest cache line of all the instruction
                                                                 caches that are controlled by the PE.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t reserved_4_13         : 10;
        uint32_t l1ip                  : 2;  /**< [ 15: 14](RO) Level 1 instruction cache policy. Indicates the indexing and
                                                                     tagging policy for the L1 instruction cache.

                                                                 0x1 = ASID-tagged virtual index, virtual tag (AIVIVT).
                                                                 0x2 = Virtual index, physical tag (VIPT).
                                                                 0x3 = Physical index, physical tag (PIPT). */
        uint32_t dminline              : 4;  /**< [ 19: 16](RO) Log2 of the number of words in the smallest cache
                                                                     line of all the data caches and unified caches that are
                                                                     controlled by the PE.

                                                                 For CNXXXX, 128 bytes. */
        uint32_t erg                   : 4;  /**< [ 23: 20](RO) Exclusives reservation granule. Log2 of the number
                                                                     of words of the maximum size of the reservation granule that
                                                                     has been implemented for the Load-Exclusive and
                                                                     Store-Exclusive instructions. */
        uint32_t cwg                   : 4;  /**< [ 27: 24](RO) Cache writeback granule. Log2 of the number of
                                                                     words of the maximum size of memory that can be overwritten as
                                                                     a result of the eviction of a cache entry that has had a
                                                                     memory location in it modified.

                                                                  The architectural maximum of 512 words (2KB) must be assumed.

                                                                  The cache writeback granule can be determined from maximum
                                                                     cache line size encoded in the Cache Size ID Registers. */
        uint32_t reserved_28_30        : 3;
        uint32_t rsvd_31               : 1;  /**< [ 31: 31](RO) Reserved 1. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_ctr_el0_s cn; */
};
typedef union bdk_ap_ctr_el0 bdk_ap_ctr_el0_t;

#define BDK_AP_CTR_EL0 BDK_AP_CTR_EL0_FUNC()
static inline uint64_t BDK_AP_CTR_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CTR_EL0_FUNC(void)
{
    return 0x30300000100ll;
}

#define typedef_BDK_AP_CTR_EL0 bdk_ap_ctr_el0_t
#define bustype_BDK_AP_CTR_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CTR_EL0 "AP_CTR_EL0"
#define busnum_BDK_AP_CTR_EL0 0
#define arguments_BDK_AP_CTR_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_currentel
 *
 * AP Current Exception Level Register
 * Holds the current Exception level.
 */
union bdk_ap_currentel
{
    uint32_t u;
    struct bdk_ap_currentel_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_4_31         : 28;
        uint32_t el                    : 2;  /**< [  3:  2](RO) Current Exception level.
                                                                 0x0 = EL0.
                                                                 0x1 = EL1.
                                                                 0x2 = EL2.
                                                                 0x3 = EL3. */
        uint32_t reserved_0_1          : 2;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_1          : 2;
        uint32_t el                    : 2;  /**< [  3:  2](RO) Current Exception level.
                                                                 0x0 = EL0.
                                                                 0x1 = EL1.
                                                                 0x2 = EL2.
                                                                 0x3 = EL3. */
        uint32_t reserved_4_31         : 28;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_currentel_s cn; */
};
typedef union bdk_ap_currentel bdk_ap_currentel_t;

#define BDK_AP_CURRENTEL BDK_AP_CURRENTEL_FUNC()
static inline uint64_t BDK_AP_CURRENTEL_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CURRENTEL_FUNC(void)
{
    return 0x30004020200ll;
}

#define typedef_BDK_AP_CURRENTEL bdk_ap_currentel_t
#define bustype_BDK_AP_CURRENTEL BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CURRENTEL "AP_CURRENTEL"
#define busnum_BDK_AP_CURRENTEL 0
#define arguments_BDK_AP_CURRENTEL -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_access_el1
 *
 * AP Cavium Access EL1 Register
 * This register controls trapping on register accesses.
 *
 * Read/write access at EL1, EL2 and EL3.
 *
 * Note that AP_HCR_EL2[TIDCP] can also prevent all CVM* access at EL1
 * and below and takes priority over AP_CVM_ACCESS_EL1.
 *
 * Note that AP_CVM_ACCESS_EL1 can grant access to EL0 for AP_CVM_*_EL1
 * registers. This is non standard. A some point AP_CVM_ACCESS_EL1 may be
 * depreciated.
 *
 * A 1 in the appropriate bit in the AP_CVM_ACCESS_ELn register prevents
 * any access at lower exception levels.
 *
 * Internal:
 * If access is denied at multiple exception levels then the
 * trap occurs at the lowest. This is similar to ARM's
 * AP_CPACR_EL1/AP_CPTR_EL2/AP_CPTR_EL3.
 */
union bdk_ap_cvm_access_el1
{
    uint64_t u;
    struct bdk_ap_cvm_access_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 1 traps
                                                                 to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_Icache* or AP_CVM_Dcache* with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_Icache* or AP_CVM_Dcache* with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 1 traps
                                                                 to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvm_access_el1_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t reserved_6_7          : 2;
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 1 traps
                                                                 to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_Icache* or AP_CVM_Dcache* with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_Icache* or AP_CVM_Dcache* with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 1 traps
                                                                 to EL1 unless AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t reserved_6_7          : 2;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && !AP_SCR_EL3[NS], then EL2. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn8;
    struct bdk_ap_cvm_access_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 1 traps
                                                                 to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_Icache* or AP_CVM_Dcache* with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then
                                                                 EL2. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_Icache* or AP_CVM_Dcache* with the exception
                                                                 level lower than 1 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then
                                                                 EL2. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 1 traps
                                                                 to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 1
                                                                 traps to EL1 unless AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 1 traps to EL1 unless
                                                                 AP_HCR_EL2[TGE] && AP_SCR_EL3[NS], then EL2. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_access_el1 bdk_ap_cvm_access_el1_t;

#define BDK_AP_CVM_ACCESS_EL1 BDK_AP_CVM_ACCESS_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_ACCESS_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ACCESS_EL1_FUNC(void)
{
    return 0x3000b000300ll;
}

#define typedef_BDK_AP_CVM_ACCESS_EL1 bdk_ap_cvm_access_el1_t
#define bustype_BDK_AP_CVM_ACCESS_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ACCESS_EL1 "AP_CVM_ACCESS_EL1"
#define busnum_BDK_AP_CVM_ACCESS_EL1 0
#define arguments_BDK_AP_CVM_ACCESS_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_access_el2
 *
 * AP Cavium Access EL2 Register
 * This register controls trap/access of Cavium registers. Read/write access at EL2 and EL3.
 */
union bdk_ap_cvm_access_el2
{
    uint64_t u;
    struct bdk_ap_cvm_access_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 2 traps to EL2 unless
                                                                 prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 2 traps to EL2 unless prohibited by
                                                                 AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 2 traps
                                                                 to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 2 traps to
                                                                 EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 2 traps to
                                                                 EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 2 traps
                                                                 to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 2 traps to EL2 unless prohibited by
                                                                 AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 2 traps to EL2 unless
                                                                 prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvm_access_el2_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 2 traps to EL2 unless
                                                                 prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t reserved_6_7          : 2;
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 2 traps
                                                                 to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 2 traps to
                                                                 EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 2 traps to
                                                                 EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 2
                                                                 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception
                                                                 level lower than 2 traps to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or
                                                                 AP_SCR_EL3[NS] = 0. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read operation to AP_CVM_EVATTID with the exception level lower than 2 traps
                                                                 to EL2 unless prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t reserved_6_7          : 2;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 2 traps to EL2 unless
                                                                 prohibited by AP_CVM_ACCESS_EL1 or AP_SCR_EL3[NS] = 0. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn8;
    /* struct bdk_ap_cvm_access_el2_s cn9; */
};
typedef union bdk_ap_cvm_access_el2 bdk_ap_cvm_access_el2_t;

#define BDK_AP_CVM_ACCESS_EL2 BDK_AP_CVM_ACCESS_EL2_FUNC()
static inline uint64_t BDK_AP_CVM_ACCESS_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ACCESS_EL2_FUNC(void)
{
    return 0x3040b000300ll;
}

#define typedef_BDK_AP_CVM_ACCESS_EL2 bdk_ap_cvm_access_el2_t
#define bustype_BDK_AP_CVM_ACCESS_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ACCESS_EL2 "AP_CVM_ACCESS_EL2"
#define busnum_BDK_AP_CVM_ACCESS_EL2 0
#define arguments_BDK_AP_CVM_ACCESS_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_access_el3
 *
 * AP Cavium Access EL3 Register
 * Internal:
 * Software should expose the CvmCACHE instruction to EL2 or
 * EL1 with extreme caution. Exposing this instruction to lower
 * exception levels may cause nonsecure state to mess with secure
 * state, which would cause a security hole.
 */
union bdk_ap_cvm_access_el3
{
    uint64_t u;
    struct bdk_ap_cvm_access_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 3 traps to EL3. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 3 traps to EL3 unless prohibited by
                                                                 AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read or write operation to AP_CVM_EVATTID with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception level
                                                                 lower
                                                                 than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception level
                                                                 lower
                                                                 than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read or write operation to AP_CVM_EVATTID with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 3 traps to EL3 unless prohibited by
                                                                 AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 3 traps to EL3. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvm_access_el3_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 3 traps to EL3. */
        uint64_t reserved_6_7          : 2;
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read or write operation to AP_CVM_EVATTID with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception level
                                                                 lower
                                                                 than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 3 traps to
                                                                 EL3
                                                                 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception level
                                                                 lower
                                                                 than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read or write operation to AP_CVM_EVATTID with the exception level lower than 3 traps to
                                                                 EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t reserved_6_7          : 2;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 3 traps to EL3. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn8;
    struct bdk_ap_cvm_access_el3_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 3 traps to EL3. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 3 traps to EL3 unless prohibited by
                                                                 AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read or write operation to AP_CVM_EVATTID with the exception level lower than
                                                                 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
#else /* Word 0 - Little Endian */
        uint64_t cvm_ctl               : 1;  /**< [  0:  0](R/W) A read or write operation to AP_CVM_CTL or AP_CVM_MEMCTL with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t powthrottle           : 1;  /**< [  1:  1](R/W) A read or write operation to PowThrottle with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_bist              : 1;  /**< [  2:  2](R/W) A read or write operation to AP_CVM_BIST* with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_err               : 1;  /**< [  3:  3](R/W) A read or write operation to AP_CVM_ERR* with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_i_d_cache         : 1;  /**< [  4:  4](R/W) A read or write operation to AP_CVM_ICACHE* or AP_CVM_DCACHE* with the exception
                                                                 level lower than 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2,
                                                                 AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_evattid           : 1;  /**< [  5:  5](R/W) A read or write operation to AP_CVM_EVATTID with the exception level lower than
                                                                 3 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_statprof          : 1;  /**< [  6:  6](R/W) A read or write operation to AP_CVM_STATPROFCTL_EL1 or AP_CVM_STATPROFCMP_EL1
                                                                 with the exception level lower than 3 traps to EL3 unless prohibited by
                                                                 AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_pn                : 1;  /**< [  7:  7](R/W) A read or write operation to AP_CVM_PN_EL1 with the exception level lower than 3
                                                                 traps to EL3 unless prohibited by AP_CVM_ACCESS_EL2, AP_CVM_ACCESS_EL1, or
                                                                 AP_HCR_EL2[TIDCP]. */
        uint64_t cvm_cache             : 1;  /**< [  8:  8](R/W) A Cvm_Cache instruction with the exception level lower than 3 traps to EL3. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_access_el3 bdk_ap_cvm_access_el3_t;

#define BDK_AP_CVM_ACCESS_EL3 BDK_AP_CVM_ACCESS_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_ACCESS_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ACCESS_EL3_FUNC(void)
{
    return 0x3060b000300ll;
}

#define typedef_BDK_AP_CVM_ACCESS_EL3 bdk_ap_cvm_access_el3_t
#define bustype_BDK_AP_CVM_ACCESS_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ACCESS_EL3 "AP_CVM_ACCESS_EL3"
#define busnum_BDK_AP_CVM_ACCESS_EL3 0
#define arguments_BDK_AP_CVM_ACCESS_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_bist0_el1
 *
 * AP Cavium BIST0 Register
 * This register indicates BIST status, where a 1 in a bit position indicates defective.
 */
union bdk_ap_cvm_bist0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_bist0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_35_63        : 29;
        uint64_t fuse_controller_reports_hard_repair : 1;/**< [ 34: 34](RO) Fuse controller reports hard repair. */
        uint64_t clear_bist_was_run    : 1;  /**< [ 33: 33](RO) Clear BIST was run. */
        uint64_t manufacturing_mode    : 1;  /**< [ 32: 32](RO) Manufacturing mode. */
        uint64_t icache_data_banks_with_unrepairable_defects : 8;/**< [ 31: 24](RO) Icache data banks with unrepairable defects. */
        uint64_t icache_data_banks_with_defects : 8;/**< [ 23: 16](RO) Icache data banks with defects. */
        uint64_t reserved_8_15         : 8;
        uint64_t aes_roms_defective    : 1;  /**< [  7:  7](RO) AES ROMs defective. */
        uint64_t fpu_roms_defective    : 1;  /**< [  6:  6](RO) FPU ROMs defective. */
        uint64_t fpu_rf_defective      : 1;  /**< [  5:  5](RO) FPU/SIMD RF defective. */
        uint64_t integer_rf_defective  : 1;  /**< [  4:  4](RO) Integer RF defective. */
        uint64_t jrt_defective         : 1;  /**< [  3:  3](RO) JRT defective. */
        uint64_t bht_defective         : 1;  /**< [  2:  2](RO) BHT defective. */
        uint64_t icache_tag_defective  : 1;  /**< [  1:  1](RO) Icache tag defective. */
        uint64_t icache_data_defective : 1;  /**< [  0:  0](RO) Icache data defective/unrepairable. */
#else /* Word 0 - Little Endian */
        uint64_t icache_data_defective : 1;  /**< [  0:  0](RO) Icache data defective/unrepairable. */
        uint64_t icache_tag_defective  : 1;  /**< [  1:  1](RO) Icache tag defective. */
        uint64_t bht_defective         : 1;  /**< [  2:  2](RO) BHT defective. */
        uint64_t jrt_defective         : 1;  /**< [  3:  3](RO) JRT defective. */
        uint64_t integer_rf_defective  : 1;  /**< [  4:  4](RO) Integer RF defective. */
        uint64_t fpu_rf_defective      : 1;  /**< [  5:  5](RO) FPU/SIMD RF defective. */
        uint64_t fpu_roms_defective    : 1;  /**< [  6:  6](RO) FPU ROMs defective. */
        uint64_t aes_roms_defective    : 1;  /**< [  7:  7](RO) AES ROMs defective. */
        uint64_t reserved_8_15         : 8;
        uint64_t icache_data_banks_with_defects : 8;/**< [ 23: 16](RO) Icache data banks with defects. */
        uint64_t icache_data_banks_with_unrepairable_defects : 8;/**< [ 31: 24](RO) Icache data banks with unrepairable defects. */
        uint64_t manufacturing_mode    : 1;  /**< [ 32: 32](RO) Manufacturing mode. */
        uint64_t clear_bist_was_run    : 1;  /**< [ 33: 33](RO) Clear BIST was run. */
        uint64_t fuse_controller_reports_hard_repair : 1;/**< [ 34: 34](RO) Fuse controller reports hard repair. */
        uint64_t reserved_35_63        : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_bist0_el1_s cn8; */
    struct bdk_ap_cvm_bist0_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_35_63        : 29;
        uint64_t fuse_controller_reports_hard_repair : 1;/**< [ 34: 34](RO) Fuse controller reports hard repair. */
        uint64_t reserved_33           : 1;
        uint64_t manufacturing_mode    : 1;  /**< [ 32: 32](RO) Manufacturing mode. */
        uint64_t icache_data_banks_with_unrepairable_defects : 8;/**< [ 31: 24](RO) Icache data banks with unrepairable defects. */
        uint64_t icache_data_banks_with_defects : 8;/**< [ 23: 16](RO) Icache data banks with defects. */
        uint64_t reserved_8_15         : 8;
        uint64_t aes_roms_defective    : 1;  /**< [  7:  7](RO) AES ROMs defective. */
        uint64_t fpu_roms_defective    : 1;  /**< [  6:  6](RO) FPU ROMs defective. */
        uint64_t fpu_rf_defective      : 1;  /**< [  5:  5](RO) FPU/SIMD RF defective. */
        uint64_t integer_rf_defective  : 1;  /**< [  4:  4](RO) Integer RF defective. */
        uint64_t jrt_defective         : 1;  /**< [  3:  3](RO) JRT defective. */
        uint64_t bht_defective         : 1;  /**< [  2:  2](RO) BHT defective. */
        uint64_t icache_tag_defective  : 1;  /**< [  1:  1](RO) Icache tag defective. */
        uint64_t icache_data_defective : 1;  /**< [  0:  0](RO) Icache data defective/unrepairable. */
#else /* Word 0 - Little Endian */
        uint64_t icache_data_defective : 1;  /**< [  0:  0](RO) Icache data defective/unrepairable. */
        uint64_t icache_tag_defective  : 1;  /**< [  1:  1](RO) Icache tag defective. */
        uint64_t bht_defective         : 1;  /**< [  2:  2](RO) BHT defective. */
        uint64_t jrt_defective         : 1;  /**< [  3:  3](RO) JRT defective. */
        uint64_t integer_rf_defective  : 1;  /**< [  4:  4](RO) Integer RF defective. */
        uint64_t fpu_rf_defective      : 1;  /**< [  5:  5](RO) FPU/SIMD RF defective. */
        uint64_t fpu_roms_defective    : 1;  /**< [  6:  6](RO) FPU ROMs defective. */
        uint64_t aes_roms_defective    : 1;  /**< [  7:  7](RO) AES ROMs defective. */
        uint64_t reserved_8_15         : 8;
        uint64_t icache_data_banks_with_defects : 8;/**< [ 23: 16](RO) Icache data banks with defects. */
        uint64_t icache_data_banks_with_unrepairable_defects : 8;/**< [ 31: 24](RO) Icache data banks with unrepairable defects. */
        uint64_t manufacturing_mode    : 1;  /**< [ 32: 32](RO) Manufacturing mode. */
        uint64_t reserved_33           : 1;
        uint64_t fuse_controller_reports_hard_repair : 1;/**< [ 34: 34](RO) Fuse controller reports hard repair. */
        uint64_t reserved_35_63        : 29;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_bist0_el1 bdk_ap_cvm_bist0_el1_t;

#define BDK_AP_CVM_BIST0_EL1 BDK_AP_CVM_BIST0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_BIST0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_BIST0_EL1_FUNC(void)
{
    return 0x3000b010000ll;
}

#define typedef_BDK_AP_CVM_BIST0_EL1 bdk_ap_cvm_bist0_el1_t
#define bustype_BDK_AP_CVM_BIST0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_BIST0_EL1 "AP_CVM_BIST0_EL1"
#define busnum_BDK_AP_CVM_BIST0_EL1 0
#define arguments_BDK_AP_CVM_BIST0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_bist1_el1
 *
 * AP Cavium BIST1 Register
 * This register indicates BIST status, where a 1 in a bit position indicates defective.
 */
union bdk_ap_cvm_bist1_el1
{
    uint64_t u;
    struct bdk_ap_cvm_bist1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_48_63        : 16;
        uint64_t icache_bank7          : 6;  /**< [ 47: 42](RO) Icache bank7 bad set, 0x3F means no defect. */
        uint64_t icache_bank6          : 6;  /**< [ 41: 36](RO) Icache bank6 bad set, 0x3F means no defect. */
        uint64_t icache_bank5          : 6;  /**< [ 35: 30](RO) Icache bank5 bad set, 0x3F means no defect. */
        uint64_t icache_bank4          : 6;  /**< [ 29: 24](RO) Icache bank4 bad set, 0x3F means no defect. */
        uint64_t icache_bank3          : 6;  /**< [ 23: 18](RO) Icache bank3 bad set, 0x3F means no defect. */
        uint64_t icache_bank2          : 6;  /**< [ 17: 12](RO) Icache bank2 bad set, 0x3F means no defect. */
        uint64_t icache_bank1          : 6;  /**< [ 11:  6](RO) Icache bank1 bad set, 0x3F means no defect. */
        uint64_t icache_bank0          : 6;  /**< [  5:  0](RO) Icache bank0 bad set, 0x3F means no defect. */
#else /* Word 0 - Little Endian */
        uint64_t icache_bank0          : 6;  /**< [  5:  0](RO) Icache bank0 bad set, 0x3F means no defect. */
        uint64_t icache_bank1          : 6;  /**< [ 11:  6](RO) Icache bank1 bad set, 0x3F means no defect. */
        uint64_t icache_bank2          : 6;  /**< [ 17: 12](RO) Icache bank2 bad set, 0x3F means no defect. */
        uint64_t icache_bank3          : 6;  /**< [ 23: 18](RO) Icache bank3 bad set, 0x3F means no defect. */
        uint64_t icache_bank4          : 6;  /**< [ 29: 24](RO) Icache bank4 bad set, 0x3F means no defect. */
        uint64_t icache_bank5          : 6;  /**< [ 35: 30](RO) Icache bank5 bad set, 0x3F means no defect. */
        uint64_t icache_bank6          : 6;  /**< [ 41: 36](RO) Icache bank6 bad set, 0x3F means no defect. */
        uint64_t icache_bank7          : 6;  /**< [ 47: 42](RO) Icache bank7 bad set, 0x3F means no defect. */
        uint64_t reserved_48_63        : 16;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_bist1_el1_s cn8; */
    struct bdk_ap_cvm_bist1_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_bist1_el1 bdk_ap_cvm_bist1_el1_t;

#define BDK_AP_CVM_BIST1_EL1 BDK_AP_CVM_BIST1_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_BIST1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_BIST1_EL1_FUNC(void)
{
    return 0x3000b010100ll;
}

#define typedef_BDK_AP_CVM_BIST1_EL1 bdk_ap_cvm_bist1_el1_t
#define bustype_BDK_AP_CVM_BIST1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_BIST1_EL1 "AP_CVM_BIST1_EL1"
#define busnum_BDK_AP_CVM_BIST1_EL1 0
#define arguments_BDK_AP_CVM_BIST1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_bist2_el1
 *
 * AP Cavium BIST2 Register
 * This register indicates BIST status, where a 1 in a bit position indicates defective.
 */
union bdk_ap_cvm_bist2_el1
{
    uint64_t u;
    struct bdk_ap_cvm_bist2_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t wcu                   : 1;  /**< [  8:  8](RO) WCU defective. */
        uint64_t dut                   : 1;  /**< [  7:  7](RO) DUT defective. */
        uint64_t wbf                   : 1;  /**< [  6:  6](RO) WBF defective. */
        uint64_t maf                   : 1;  /**< [  5:  5](RO) MAF defective. */
        uint64_t utlb                  : 1;  /**< [  4:  4](RO) UTLB defective. */
        uint64_t mtlb                  : 1;  /**< [  3:  3](RO) MTLB defective. */
        uint64_t l1dp                  : 1;  /**< [  2:  2](RO) Dcache PTAG defective. */
        uint64_t l1dv                  : 1;  /**< [  1:  1](RO) Dcache VTAG defective. */
        uint64_t l1dd                  : 1;  /**< [  0:  0](RO) Dcache Data defective. */
#else /* Word 0 - Little Endian */
        uint64_t l1dd                  : 1;  /**< [  0:  0](RO) Dcache Data defective. */
        uint64_t l1dv                  : 1;  /**< [  1:  1](RO) Dcache VTAG defective. */
        uint64_t l1dp                  : 1;  /**< [  2:  2](RO) Dcache PTAG defective. */
        uint64_t mtlb                  : 1;  /**< [  3:  3](RO) MTLB defective. */
        uint64_t utlb                  : 1;  /**< [  4:  4](RO) UTLB defective. */
        uint64_t maf                   : 1;  /**< [  5:  5](RO) MAF defective. */
        uint64_t wbf                   : 1;  /**< [  6:  6](RO) WBF defective. */
        uint64_t dut                   : 1;  /**< [  7:  7](RO) DUT defective. */
        uint64_t wcu                   : 1;  /**< [  8:  8](RO) WCU defective. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_bist2_el1_s cn8; */
    struct bdk_ap_cvm_bist2_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_bist2_el1 bdk_ap_cvm_bist2_el1_t;

#define BDK_AP_CVM_BIST2_EL1 BDK_AP_CVM_BIST2_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_BIST2_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_BIST2_EL1_FUNC(void)
{
    return 0x3000b010400ll;
}

#define typedef_BDK_AP_CVM_BIST2_EL1 bdk_ap_cvm_bist2_el1_t
#define bustype_BDK_AP_CVM_BIST2_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_BIST2_EL1 "AP_CVM_BIST2_EL1"
#define busnum_BDK_AP_CVM_BIST2_EL1 0
#define arguments_BDK_AP_CVM_BIST2_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_bist3_el1
 *
 * AP Cavium BIST3 Register
 * This register indicates BIST status, where a 1 in a bit position indicates defective.
 */
union bdk_ap_cvm_bist3_el1
{
    uint64_t u;
    struct bdk_ap_cvm_bist3_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_48_63        : 16;
        uint64_t set7                  : 6;  /**< [ 47: 42](RO) Dcache set7 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set6                  : 6;  /**< [ 41: 36](RO) Dcache set6 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set5                  : 6;  /**< [ 35: 30](RO) Dcache set5 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set4                  : 6;  /**< [ 29: 24](RO) Dcache set4 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set3                  : 6;  /**< [ 23: 18](RO) Dcache set3 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set2                  : 6;  /**< [ 17: 12](RO) Dcache set2 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set1                  : 6;  /**< [ 11:  6](RO) Dcache set1 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set0                  : 6;  /**< [  5:  0](RO) Dcache set0 bad way, 0x3F = no defect, 0x3E = multiple defects. */
#else /* Word 0 - Little Endian */
        uint64_t set0                  : 6;  /**< [  5:  0](RO) Dcache set0 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set1                  : 6;  /**< [ 11:  6](RO) Dcache set1 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set2                  : 6;  /**< [ 17: 12](RO) Dcache set2 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set3                  : 6;  /**< [ 23: 18](RO) Dcache set3 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set4                  : 6;  /**< [ 29: 24](RO) Dcache set4 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set5                  : 6;  /**< [ 35: 30](RO) Dcache set5 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set6                  : 6;  /**< [ 41: 36](RO) Dcache set6 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t set7                  : 6;  /**< [ 47: 42](RO) Dcache set7 bad way, 0x3F = no defect, 0x3E = multiple defects. */
        uint64_t reserved_48_63        : 16;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_bist3_el1_s cn8; */
    struct bdk_ap_cvm_bist3_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_48_63        : 16;
        uint64_t reserved_0_47         : 48;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_47         : 48;
        uint64_t reserved_48_63        : 16;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_bist3_el1 bdk_ap_cvm_bist3_el1_t;

#define BDK_AP_CVM_BIST3_EL1 BDK_AP_CVM_BIST3_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_BIST3_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_BIST3_EL1_FUNC(void)
{
    return 0x3000b010500ll;
}

#define typedef_BDK_AP_CVM_BIST3_EL1 bdk_ap_cvm_bist3_el1_t
#define bustype_BDK_AP_CVM_BIST3_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_BIST3_EL1 "AP_CVM_BIST3_EL1"
#define busnum_BDK_AP_CVM_BIST3_EL1 0
#define arguments_BDK_AP_CVM_BIST3_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_cpid_el2
 *
 * AP Cavium Cache Partitioning EL2 Register
 * This register provides Cavium-specific control information.
 */
union bdk_ap_cvm_cpid_el2
{
    uint64_t u;
    struct bdk_ap_cvm_cpid_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_7_63         : 57;
        uint64_t cpid                  : 7;  /**< [  6:  0](R/W) Cache partition ID. */
#else /* Word 0 - Little Endian */
        uint64_t cpid                  : 7;  /**< [  6:  0](R/W) Cache partition ID. */
        uint64_t reserved_7_63         : 57;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_cpid_el2_s cn; */
};
typedef union bdk_ap_cvm_cpid_el2 bdk_ap_cvm_cpid_el2_t;

#define BDK_AP_CVM_CPID_EL2 BDK_AP_CVM_CPID_EL2_FUNC()
static inline uint64_t BDK_AP_CVM_CPID_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_CPID_EL2_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3040b060400ll;
    __bdk_csr_fatal("AP_CVM_CPID_EL2", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_CPID_EL2 bdk_ap_cvm_cpid_el2_t
#define bustype_BDK_AP_CVM_CPID_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_CPID_EL2 "AP_CVM_CPID_EL2"
#define busnum_BDK_AP_CVM_CPID_EL2 0
#define arguments_BDK_AP_CVM_CPID_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_cpid_el3
 *
 * AP Cavium Cache Partitioning EL3 Register
 * This register provides Cavium-specific control information.
 */
union bdk_ap_cvm_cpid_el3
{
    uint64_t u;
    struct bdk_ap_cvm_cpid_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_7_63         : 57;
        uint64_t cpid                  : 7;  /**< [  6:  0](R/W) Cache partition ID. */
#else /* Word 0 - Little Endian */
        uint64_t cpid                  : 7;  /**< [  6:  0](R/W) Cache partition ID. */
        uint64_t reserved_7_63         : 57;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_cpid_el3_s cn; */
};
typedef union bdk_ap_cvm_cpid_el3 bdk_ap_cvm_cpid_el3_t;

#define BDK_AP_CVM_CPID_EL3 BDK_AP_CVM_CPID_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_CPID_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_CPID_EL3_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3060b060400ll;
    __bdk_csr_fatal("AP_CVM_CPID_EL3", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_CPID_EL3 bdk_ap_cvm_cpid_el3_t
#define bustype_BDK_AP_CVM_CPID_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_CPID_EL3 "AP_CVM_CPID_EL3"
#define busnum_BDK_AP_CVM_CPID_EL3 0
#define arguments_BDK_AP_CVM_CPID_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_dcachedata0_el1
 *
 * AP Cavium Dcache Data 0 Register
 */
union bdk_ap_cvm_dcachedata0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_dcachedata0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Dcache data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Dcache data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_dcachedata0_el1_s cn; */
};
typedef union bdk_ap_cvm_dcachedata0_el1 bdk_ap_cvm_dcachedata0_el1_t;

#define BDK_AP_CVM_DCACHEDATA0_EL1 BDK_AP_CVM_DCACHEDATA0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_DCACHEDATA0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DCACHEDATA0_EL1_FUNC(void)
{
    return 0x3000b030400ll;
}

#define typedef_BDK_AP_CVM_DCACHEDATA0_EL1 bdk_ap_cvm_dcachedata0_el1_t
#define bustype_BDK_AP_CVM_DCACHEDATA0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DCACHEDATA0_EL1 "AP_CVM_DCACHEDATA0_EL1"
#define busnum_BDK_AP_CVM_DCACHEDATA0_EL1 0
#define arguments_BDK_AP_CVM_DCACHEDATA0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_dcachedata1_el1
 *
 * AP Cavium Dcache Data 1 Register
 */
union bdk_ap_cvm_dcachedata1_el1
{
    uint64_t u;
    struct bdk_ap_cvm_dcachedata1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_8_63         : 56;
        uint64_t parity                : 8;  /**< [  7:  0](RO) Parity bits. */
#else /* Word 0 - Little Endian */
        uint64_t parity                : 8;  /**< [  7:  0](RO) Parity bits. */
        uint64_t reserved_8_63         : 56;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_dcachedata1_el1_s cn; */
};
typedef union bdk_ap_cvm_dcachedata1_el1 bdk_ap_cvm_dcachedata1_el1_t;

#define BDK_AP_CVM_DCACHEDATA1_EL1 BDK_AP_CVM_DCACHEDATA1_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_DCACHEDATA1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DCACHEDATA1_EL1_FUNC(void)
{
    return 0x3000b030500ll;
}

#define typedef_BDK_AP_CVM_DCACHEDATA1_EL1 bdk_ap_cvm_dcachedata1_el1_t
#define bustype_BDK_AP_CVM_DCACHEDATA1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DCACHEDATA1_EL1 "AP_CVM_DCACHEDATA1_EL1"
#define busnum_BDK_AP_CVM_DCACHEDATA1_EL1 0
#define arguments_BDK_AP_CVM_DCACHEDATA1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_dcacheptag0_el1
 *
 * AP Cavium Dcache Ptag 0 Register
 */
union bdk_ap_cvm_dcacheptag0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_dcacheptag0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_44_63        : 20;
        uint64_t nsec                  : 1;  /**< [ 43: 43](RO) Not-shared. */
        uint64_t ptag                  : 33; /**< [ 42: 10](RO) Physical tag \<42:10\>. */
        uint64_t reserved_1_9          : 9;
        uint64_t valid                 : 1;  /**< [  0:  0](RO) Valid. */
#else /* Word 0 - Little Endian */
        uint64_t valid                 : 1;  /**< [  0:  0](RO) Valid. */
        uint64_t reserved_1_9          : 9;
        uint64_t ptag                  : 33; /**< [ 42: 10](RO) Physical tag \<42:10\>. */
        uint64_t nsec                  : 1;  /**< [ 43: 43](RO) Not-shared. */
        uint64_t reserved_44_63        : 20;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_dcacheptag0_el1_s cn; */
};
typedef union bdk_ap_cvm_dcacheptag0_el1 bdk_ap_cvm_dcacheptag0_el1_t;

#define BDK_AP_CVM_DCACHEPTAG0_EL1 BDK_AP_CVM_DCACHEPTAG0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_DCACHEPTAG0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DCACHEPTAG0_EL1_FUNC(void)
{
    return 0x3000b040400ll;
}

#define typedef_BDK_AP_CVM_DCACHEPTAG0_EL1 bdk_ap_cvm_dcacheptag0_el1_t
#define bustype_BDK_AP_CVM_DCACHEPTAG0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DCACHEPTAG0_EL1 "AP_CVM_DCACHEPTAG0_EL1"
#define busnum_BDK_AP_CVM_DCACHEPTAG0_EL1 0
#define arguments_BDK_AP_CVM_DCACHEPTAG0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_dcachevtag0_el1
 *
 * AP Cavium Dcache Vtag 0 Register
 */
union bdk_ap_cvm_dcachevtag0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_dcachevtag0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_60_63        : 4;
        uint64_t eva_vmid              : 4;  /**< [ 59: 56](RO) Entry EVA_VMID. */
        uint64_t reserved_49_55        : 7;
        uint64_t r                     : 1;  /**< [ 48: 48](RO) Entry R. */
        uint64_t vtag                  : 38; /**< [ 47: 10](RO) Entry VTAG\<47:10\>. */
        uint64_t eva_asid              : 6;  /**< [  9:  4](RO) Entry EVA_ASID. */
        uint64_t ng                    : 1;  /**< [  3:  3](RO) Entry NG. */
        uint64_t el_1or0               : 1;  /**< [  2:  2](RO) Entry is EL0 or EL1. */
        uint64_t nsec                  : 1;  /**< [  1:  1](RO) Entry is NS. */
        uint64_t valid                 : 1;  /**< [  0:  0](RO) Entry valid. */
#else /* Word 0 - Little Endian */
        uint64_t valid                 : 1;  /**< [  0:  0](RO) Entry valid. */
        uint64_t nsec                  : 1;  /**< [  1:  1](RO) Entry is NS. */
        uint64_t el_1or0               : 1;  /**< [  2:  2](RO) Entry is EL0 or EL1. */
        uint64_t ng                    : 1;  /**< [  3:  3](RO) Entry NG. */
        uint64_t eva_asid              : 6;  /**< [  9:  4](RO) Entry EVA_ASID. */
        uint64_t vtag                  : 38; /**< [ 47: 10](RO) Entry VTAG\<47:10\>. */
        uint64_t r                     : 1;  /**< [ 48: 48](RO) Entry R. */
        uint64_t reserved_49_55        : 7;
        uint64_t eva_vmid              : 4;  /**< [ 59: 56](RO) Entry EVA_VMID. */
        uint64_t reserved_60_63        : 4;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_dcachevtag0_el1_s cn; */
};
typedef union bdk_ap_cvm_dcachevtag0_el1 bdk_ap_cvm_dcachevtag0_el1_t;

#define BDK_AP_CVM_DCACHEVTAG0_EL1 BDK_AP_CVM_DCACHEVTAG0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_DCACHEVTAG0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DCACHEVTAG0_EL1_FUNC(void)
{
    return 0x3000b030600ll;
}

#define typedef_BDK_AP_CVM_DCACHEVTAG0_EL1 bdk_ap_cvm_dcachevtag0_el1_t
#define bustype_BDK_AP_CVM_DCACHEVTAG0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DCACHEVTAG0_EL1 "AP_CVM_DCACHEVTAG0_EL1"
#define busnum_BDK_AP_CVM_DCACHEVTAG0_EL1 0
#define arguments_BDK_AP_CVM_DCACHEVTAG0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_dcachevtag1_el1
 *
 * AP Cavium Dcache Vtag 1 Register
 */
union bdk_ap_cvm_dcachevtag1_el1
{
    uint64_t u;
    struct bdk_ap_cvm_dcachevtag1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_25_63        : 39;
        uint64_t ent1                  : 9;  /**< [ 24: 16](RO) ENT1. */
        uint64_t reserved_9_15         : 7;
        uint64_t ent2                  : 9;  /**< [  8:  0](RO) ENT2. */
#else /* Word 0 - Little Endian */
        uint64_t ent2                  : 9;  /**< [  8:  0](RO) ENT2. */
        uint64_t reserved_9_15         : 7;
        uint64_t ent1                  : 9;  /**< [ 24: 16](RO) ENT1. */
        uint64_t reserved_25_63        : 39;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_dcachevtag1_el1_s cn; */
};
typedef union bdk_ap_cvm_dcachevtag1_el1 bdk_ap_cvm_dcachevtag1_el1_t;

#define BDK_AP_CVM_DCACHEVTAG1_EL1 BDK_AP_CVM_DCACHEVTAG1_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_DCACHEVTAG1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DCACHEVTAG1_EL1_FUNC(void)
{
    return 0x3000b030700ll;
}

#define typedef_BDK_AP_CVM_DCACHEVTAG1_EL1 bdk_ap_cvm_dcachevtag1_el1_t
#define bustype_BDK_AP_CVM_DCACHEVTAG1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DCACHEVTAG1_EL1 "AP_CVM_DCACHEVTAG1_EL1"
#define busnum_BDK_AP_CVM_DCACHEVTAG1_EL1 0
#define arguments_BDK_AP_CVM_DCACHEVTAG1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug0_el3
 *
 * INTERNAL: AP Cavium Debug 0 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug0_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug0_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t current_pc            : 64; /**< [ 63:  0](RO) Current PC. */
#else /* Word 0 - Little Endian */
        uint64_t current_pc            : 64; /**< [ 63:  0](RO) Current PC. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug0_el3_s cn; */
};
typedef union bdk_ap_cvm_debug0_el3 bdk_ap_cvm_debug0_el3_t;

#define BDK_AP_CVM_DEBUG0_EL3 BDK_AP_CVM_DEBUG0_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG0_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG0_EL3_FUNC(void)
{
    return 0x3060b040000ll;
}

#define typedef_BDK_AP_CVM_DEBUG0_EL3 bdk_ap_cvm_debug0_el3_t
#define bustype_BDK_AP_CVM_DEBUG0_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG0_EL3 "AP_CVM_DEBUG0_EL3"
#define busnum_BDK_AP_CVM_DEBUG0_EL3 0
#define arguments_BDK_AP_CVM_DEBUG0_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug1_el3
 *
 * INTERNAL: AP Cavium Debug 1 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug1_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug1_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t current_fetch         : 64; /**< [ 63:  0](RO) Current fetcher address. */
#else /* Word 0 - Little Endian */
        uint64_t current_fetch         : 64; /**< [ 63:  0](RO) Current fetcher address. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug1_el3_s cn; */
};
typedef union bdk_ap_cvm_debug1_el3 bdk_ap_cvm_debug1_el3_t;

#define BDK_AP_CVM_DEBUG1_EL3 BDK_AP_CVM_DEBUG1_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG1_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG1_EL3_FUNC(void)
{
    return 0x3060b040100ll;
}

#define typedef_BDK_AP_CVM_DEBUG1_EL3 bdk_ap_cvm_debug1_el3_t
#define bustype_BDK_AP_CVM_DEBUG1_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG1_EL3 "AP_CVM_DEBUG1_EL3"
#define busnum_BDK_AP_CVM_DEBUG1_EL3 0
#define arguments_BDK_AP_CVM_DEBUG1_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug2_el3
 *
 * INTERNAL: AP Cavium Debug 2 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug2_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug2_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t last_ifill            : 64; /**< [ 63:  0](RO) Last ifill address. */
#else /* Word 0 - Little Endian */
        uint64_t last_ifill            : 64; /**< [ 63:  0](RO) Last ifill address. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug2_el3_s cn; */
};
typedef union bdk_ap_cvm_debug2_el3 bdk_ap_cvm_debug2_el3_t;

#define BDK_AP_CVM_DEBUG2_EL3 BDK_AP_CVM_DEBUG2_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG2_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG2_EL3_FUNC(void)
{
    return 0x3060b040200ll;
}

#define typedef_BDK_AP_CVM_DEBUG2_EL3 bdk_ap_cvm_debug2_el3_t
#define bustype_BDK_AP_CVM_DEBUG2_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG2_EL3 "AP_CVM_DEBUG2_EL3"
#define busnum_BDK_AP_CVM_DEBUG2_EL3 0
#define arguments_BDK_AP_CVM_DEBUG2_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug3_el3
 *
 * INTERNAL: AP Cavium Debug 3 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug3_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug3_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t last_committed        : 64; /**< [ 63:  0](RO) Last committed instruction PC. */
#else /* Word 0 - Little Endian */
        uint64_t last_committed        : 64; /**< [ 63:  0](RO) Last committed instruction PC. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug3_el3_s cn; */
};
typedef union bdk_ap_cvm_debug3_el3 bdk_ap_cvm_debug3_el3_t;

#define BDK_AP_CVM_DEBUG3_EL3 BDK_AP_CVM_DEBUG3_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG3_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG3_EL3_FUNC(void)
{
    return 0x3060b040300ll;
}

#define typedef_BDK_AP_CVM_DEBUG3_EL3 bdk_ap_cvm_debug3_el3_t
#define bustype_BDK_AP_CVM_DEBUG3_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG3_EL3 "AP_CVM_DEBUG3_EL3"
#define busnum_BDK_AP_CVM_DEBUG3_EL3 0
#define arguments_BDK_AP_CVM_DEBUG3_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug4_el3
 *
 * INTERNAL: AP Cavium Debug 4 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug4_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug4_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_24_63        : 40;
        uint64_t dual_issue_reason     : 8;  /**< [ 23: 16](RO) Reason dual issue didn't occur. */
        uint64_t issue_reason          : 8;  /**< [ 15:  8](RO) Reason issue didn't occur. */
        uint64_t reserved_5_7          : 3;
        uint64_t mem_stall_4a          : 1;  /**< [  4:  4](RO) Memory Stall stage 4a. */
        uint64_t waiting_for_pfill_4a  : 1;  /**< [  3:  3](RO) Waiting for PFILL stage 4a. */
        uint64_t waiting_for_ifill_4a  : 1;  /**< [  2:  2](RO) Waiting for IFILL stage 4a. */
        uint64_t exception_level       : 2;  /**< [  1:  0](RO) Current exception level. */
#else /* Word 0 - Little Endian */
        uint64_t exception_level       : 2;  /**< [  1:  0](RO) Current exception level. */
        uint64_t waiting_for_ifill_4a  : 1;  /**< [  2:  2](RO) Waiting for IFILL stage 4a. */
        uint64_t waiting_for_pfill_4a  : 1;  /**< [  3:  3](RO) Waiting for PFILL stage 4a. */
        uint64_t mem_stall_4a          : 1;  /**< [  4:  4](RO) Memory Stall stage 4a. */
        uint64_t reserved_5_7          : 3;
        uint64_t issue_reason          : 8;  /**< [ 15:  8](RO) Reason issue didn't occur. */
        uint64_t dual_issue_reason     : 8;  /**< [ 23: 16](RO) Reason dual issue didn't occur. */
        uint64_t reserved_24_63        : 40;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug4_el3_s cn; */
};
typedef union bdk_ap_cvm_debug4_el3 bdk_ap_cvm_debug4_el3_t;

#define BDK_AP_CVM_DEBUG4_EL3 BDK_AP_CVM_DEBUG4_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG4_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG4_EL3_FUNC(void)
{
    return 0x3060b050000ll;
}

#define typedef_BDK_AP_CVM_DEBUG4_EL3 bdk_ap_cvm_debug4_el3_t
#define bustype_BDK_AP_CVM_DEBUG4_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG4_EL3 "AP_CVM_DEBUG4_EL3"
#define busnum_BDK_AP_CVM_DEBUG4_EL3 0
#define arguments_BDK_AP_CVM_DEBUG4_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug6_el3
 *
 * INTERNAL: AP Cavium Debug 6 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug6_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug6_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_41_63        : 23;
        uint64_t power_off             : 1;  /**< [ 40: 40](RO)  */
        uint64_t power_longterm        : 8;  /**< [ 39: 32](RO)  */
        uint64_t power_setting         : 8;  /**< [ 31: 24](RO)  */
        uint64_t reserved_22_23        : 2;
        uint64_t interval_power        : 22; /**< [ 21:  0](RO)  */
#else /* Word 0 - Little Endian */
        uint64_t interval_power        : 22; /**< [ 21:  0](RO)  */
        uint64_t reserved_22_23        : 2;
        uint64_t power_setting         : 8;  /**< [ 31: 24](RO)  */
        uint64_t power_longterm        : 8;  /**< [ 39: 32](RO)  */
        uint64_t power_off             : 1;  /**< [ 40: 40](RO)  */
        uint64_t reserved_41_63        : 23;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug6_el3_s cn; */
};
typedef union bdk_ap_cvm_debug6_el3 bdk_ap_cvm_debug6_el3_t;

#define BDK_AP_CVM_DEBUG6_EL3 BDK_AP_CVM_DEBUG6_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG6_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG6_EL3_FUNC(void)
{
    return 0x3060b050200ll;
}

#define typedef_BDK_AP_CVM_DEBUG6_EL3 bdk_ap_cvm_debug6_el3_t
#define bustype_BDK_AP_CVM_DEBUG6_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG6_EL3 "AP_CVM_DEBUG6_EL3"
#define busnum_BDK_AP_CVM_DEBUG6_EL3 0
#define arguments_BDK_AP_CVM_DEBUG6_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug7_el3
 *
 * INTERNAL: AP Cavium Debug 7 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug7_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug7_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug7_el3_s cn; */
};
typedef union bdk_ap_cvm_debug7_el3 bdk_ap_cvm_debug7_el3_t;

#define BDK_AP_CVM_DEBUG7_EL3 BDK_AP_CVM_DEBUG7_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG7_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG7_EL3_FUNC(void)
{
    return 0x3060b050300ll;
}

#define typedef_BDK_AP_CVM_DEBUG7_EL3 bdk_ap_cvm_debug7_el3_t
#define bustype_BDK_AP_CVM_DEBUG7_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG7_EL3 "AP_CVM_DEBUG7_EL3"
#define busnum_BDK_AP_CVM_DEBUG7_EL3 0
#define arguments_BDK_AP_CVM_DEBUG7_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug8_el3
 *
 * INTERNAL: AP Cavium Debug 8 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug8_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug8_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t rdb_dsc_set_arry_1    : 18; /**< [ 63: 46](RO) Bits 17..0 of rdb_dsc_set_arry[1]. */
        uint64_t rdb_dsc_set_arry_0    : 36; /**< [ 45: 10](RO) Rdb_dsc_set_arry[0]. */
        uint64_t uwr_ack_def_cnt       : 2;  /**< [  9:  8](RO) Upstream write message ack count. */
        uint64_t sgi_ack_def_cnt       : 2;  /**< [  7:  6](RO) SGI generate message ack count. */
        uint64_t dct_ack_def_cnt       : 2;  /**< [  5:  4](RO) Deactivate message ack count. */
        uint64_t act_ack_def_cnt       : 2;  /**< [  3:  2](RO) Activate message ack count. */
        uint64_t clr_ack_def_cnt       : 2;  /**< [  1:  0](RO) Clear message ack count. */
#else /* Word 0 - Little Endian */
        uint64_t clr_ack_def_cnt       : 2;  /**< [  1:  0](RO) Clear message ack count. */
        uint64_t act_ack_def_cnt       : 2;  /**< [  3:  2](RO) Activate message ack count. */
        uint64_t dct_ack_def_cnt       : 2;  /**< [  5:  4](RO) Deactivate message ack count. */
        uint64_t sgi_ack_def_cnt       : 2;  /**< [  7:  6](RO) SGI generate message ack count. */
        uint64_t uwr_ack_def_cnt       : 2;  /**< [  9:  8](RO) Upstream write message ack count. */
        uint64_t rdb_dsc_set_arry_0    : 36; /**< [ 45: 10](RO) Rdb_dsc_set_arry[0]. */
        uint64_t rdb_dsc_set_arry_1    : 18; /**< [ 63: 46](RO) Bits 17..0 of rdb_dsc_set_arry[1]. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug8_el3_s cn; */
};
typedef union bdk_ap_cvm_debug8_el3 bdk_ap_cvm_debug8_el3_t;

#define BDK_AP_CVM_DEBUG8_EL3 BDK_AP_CVM_DEBUG8_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG8_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG8_EL3_FUNC(void)
{
    return 0x3060b070000ll;
}

#define typedef_BDK_AP_CVM_DEBUG8_EL3 bdk_ap_cvm_debug8_el3_t
#define bustype_BDK_AP_CVM_DEBUG8_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG8_EL3 "AP_CVM_DEBUG8_EL3"
#define busnum_BDK_AP_CVM_DEBUG8_EL3 0
#define arguments_BDK_AP_CVM_DEBUG8_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_debug9_el3
 *
 * INTERNAL: AP Cavium Debug 9 Register
 *
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_debug9_el3
{
    uint64_t u;
    struct bdk_ap_cvm_debug9_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_48_63        : 16;
        uint64_t dsc_fsm_enc_state_1   : 4;  /**< [ 47: 44](RO) DSC FSM ENC state\<1\>. */
        uint64_t dsc_fsm_enc_state_0   : 4;  /**< [ 43: 40](RO) DSC FSM ENC state\<0\>. */
        uint64_t clr_fsm_enc_state     : 3;  /**< [ 39: 37](RO) CLR FSM ENC state. */
        uint64_t qsc_fsm_enc_state     : 3;  /**< [ 36: 34](RO) QSC FSM ENC state. */
        uint64_t dsc_fifo              : 4;  /**< [ 33: 30](RO) DSC FIFO. */
        uint64_t ppi_fifo              : 4;  /**< [ 29: 26](RO) PPI FIFO. */
        uint64_t cdc_fifo              : 4;  /**< [ 25: 22](RO) CDC FIFO. */
        uint64_t eac_fifo              : 4;  /**< [ 21: 18](RO) EAC FIFO. */
        uint64_t rdb_dsc_set_arry_1    : 18; /**< [ 17:  0](RO) rdb_dsc_set_arry[1]\<35:18\>. */
#else /* Word 0 - Little Endian */
        uint64_t rdb_dsc_set_arry_1    : 18; /**< [ 17:  0](RO) rdb_dsc_set_arry[1]\<35:18\>. */
        uint64_t eac_fifo              : 4;  /**< [ 21: 18](RO) EAC FIFO. */
        uint64_t cdc_fifo              : 4;  /**< [ 25: 22](RO) CDC FIFO. */
        uint64_t ppi_fifo              : 4;  /**< [ 29: 26](RO) PPI FIFO. */
        uint64_t dsc_fifo              : 4;  /**< [ 33: 30](RO) DSC FIFO. */
        uint64_t qsc_fsm_enc_state     : 3;  /**< [ 36: 34](RO) QSC FSM ENC state. */
        uint64_t clr_fsm_enc_state     : 3;  /**< [ 39: 37](RO) CLR FSM ENC state. */
        uint64_t dsc_fsm_enc_state_0   : 4;  /**< [ 43: 40](RO) DSC FSM ENC state\<0\>. */
        uint64_t dsc_fsm_enc_state_1   : 4;  /**< [ 47: 44](RO) DSC FSM ENC state\<1\>. */
        uint64_t reserved_48_63        : 16;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_debug9_el3_s cn; */
};
typedef union bdk_ap_cvm_debug9_el3 bdk_ap_cvm_debug9_el3_t;

#define BDK_AP_CVM_DEBUG9_EL3 BDK_AP_CVM_DEBUG9_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DEBUG9_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DEBUG9_EL3_FUNC(void)
{
    return 0x3060b070100ll;
}

#define typedef_BDK_AP_CVM_DEBUG9_EL3 bdk_ap_cvm_debug9_el3_t
#define bustype_BDK_AP_CVM_DEBUG9_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DEBUG9_EL3 "AP_CVM_DEBUG9_EL3"
#define busnum_BDK_AP_CVM_DEBUG9_EL3 0
#define arguments_BDK_AP_CVM_DEBUG9_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_dll_observabilty_el3
 *
 * INTERNAL: AP Cavium DLL Observability Register
 */
union bdk_ap_cvm_dll_observabilty_el3
{
    uint64_t u;
    struct bdk_ap_cvm_dll_observabilty_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_60_63        : 4;
        uint64_t max_seen              : 12; /**< [ 59: 48](RO) Maximum setting seen. */
        uint64_t min_seen              : 12; /**< [ 47: 36](RO) Minimum setting seen. */
        uint64_t rclk_dll_lock         : 1;  /**< [ 35: 35](RO) rclk_dll__lock. */
        uint64_t dll_state             : 3;  /**< [ 34: 32](RO) dll_state\<2:0\>. */
        uint64_t dll_setting           : 12; /**< [ 31: 20](RO) dll_setting\<11:0\>. */
        uint64_t raw_dly_elem_enable   : 16; /**< [ 19:  4](RO) raw_dly_elem_enable\<15:0\>. */
        uint64_t clk_invert            : 1;  /**< [  3:  3](RO) clk_invert. */
        uint64_t pd_pos_rclk_refclk    : 1;  /**< [  2:  2](RO) pd_pos_rclk_refclk. */
        uint64_t pdl_rclk_refclk       : 1;  /**< [  1:  1](RO) pdl_rclk_refclk. */
        uint64_t pdr_rclk_refclk       : 1;  /**< [  0:  0](RO) pdr_rclk_refclk. */
#else /* Word 0 - Little Endian */
        uint64_t pdr_rclk_refclk       : 1;  /**< [  0:  0](RO) pdr_rclk_refclk. */
        uint64_t pdl_rclk_refclk       : 1;  /**< [  1:  1](RO) pdl_rclk_refclk. */
        uint64_t pd_pos_rclk_refclk    : 1;  /**< [  2:  2](RO) pd_pos_rclk_refclk. */
        uint64_t clk_invert            : 1;  /**< [  3:  3](RO) clk_invert. */
        uint64_t raw_dly_elem_enable   : 16; /**< [ 19:  4](RO) raw_dly_elem_enable\<15:0\>. */
        uint64_t dll_setting           : 12; /**< [ 31: 20](RO) dll_setting\<11:0\>. */
        uint64_t dll_state             : 3;  /**< [ 34: 32](RO) dll_state\<2:0\>. */
        uint64_t rclk_dll_lock         : 1;  /**< [ 35: 35](RO) rclk_dll__lock. */
        uint64_t min_seen              : 12; /**< [ 47: 36](RO) Minimum setting seen. */
        uint64_t max_seen              : 12; /**< [ 59: 48](RO) Maximum setting seen. */
        uint64_t reserved_60_63        : 4;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_dll_observabilty_el3_s cn; */
};
typedef union bdk_ap_cvm_dll_observabilty_el3 bdk_ap_cvm_dll_observabilty_el3_t;

#define BDK_AP_CVM_DLL_OBSERVABILTY_EL3 BDK_AP_CVM_DLL_OBSERVABILTY_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_DLL_OBSERVABILTY_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_DLL_OBSERVABILTY_EL3_FUNC(void)
{
    return 0x3060b050100ll;
}

#define typedef_BDK_AP_CVM_DLL_OBSERVABILTY_EL3 bdk_ap_cvm_dll_observabilty_el3_t
#define bustype_BDK_AP_CVM_DLL_OBSERVABILTY_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_DLL_OBSERVABILTY_EL3 "AP_CVM_DLL_OBSERVABILTY_EL3"
#define busnum_BDK_AP_CVM_DLL_OBSERVABILTY_EL3 0
#define arguments_BDK_AP_CVM_DLL_OBSERVABILTY_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_erricache_el1
 *
 * AP Cavium Error Icache Register
 */
union bdk_ap_cvm_erricache_el1
{
    uint64_t u;
    struct bdk_ap_cvm_erricache_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_17_63        : 47;
        uint64_t set                   : 6;  /**< [ 16: 11](R/W) Set which had the parity error. */
        uint64_t va                    : 8;  /**< [ 10:  3](R/W) VA\<10:3\> of address which had the parity error. */
        uint64_t reserved_1_2          : 2;
        uint64_t icache_data_error     : 1;  /**< [  0:  0](R/W) Icache corrected a data error. */
#else /* Word 0 - Little Endian */
        uint64_t icache_data_error     : 1;  /**< [  0:  0](R/W) Icache corrected a data error. */
        uint64_t reserved_1_2          : 2;
        uint64_t va                    : 8;  /**< [ 10:  3](R/W) VA\<10:3\> of address which had the parity error. */
        uint64_t set                   : 6;  /**< [ 16: 11](R/W) Set which had the parity error. */
        uint64_t reserved_17_63        : 47;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_erricache_el1_s cn; */
};
typedef union bdk_ap_cvm_erricache_el1 bdk_ap_cvm_erricache_el1_t;

#define BDK_AP_CVM_ERRICACHE_EL1 BDK_AP_CVM_ERRICACHE_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_ERRICACHE_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ERRICACHE_EL1_FUNC(void)
{
    return 0x3000b020000ll;
}

#define typedef_BDK_AP_CVM_ERRICACHE_EL1 bdk_ap_cvm_erricache_el1_t
#define bustype_BDK_AP_CVM_ERRICACHE_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ERRICACHE_EL1 "AP_CVM_ERRICACHE_EL1"
#define busnum_BDK_AP_CVM_ERRICACHE_EL1 0
#define arguments_BDK_AP_CVM_ERRICACHE_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_errmem_el1
 *
 * AP Cavium Error Memory Register
 */
union bdk_ap_cvm_errmem_el1
{
    uint64_t u;
    struct bdk_ap_cvm_errmem_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](RO) Reserved. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t reserved_40           : 1;
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t reserved_36           : 1;
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
#else /* Word 0 - Little Endian */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t reserved_36           : 1;
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t reserved_40           : 1;
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](RO) Reserved. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvm_errmem_el1_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](RO) Reserved. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t barriertoforce        : 1;  /**< [ 40: 40](R/W/H) Barrier timeout force. Bit is cleared when error is forced. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t rbftoforce            : 1;  /**< [ 36: 36](R/W/H) Read buffer timeout force. Bit is cleared when error is forced. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
#else /* Word 0 - Little Endian */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t rbftoforce            : 1;  /**< [ 36: 36](R/W/H) Read buffer timeout force. Bit is cleared when error is forced. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t barriertoforce        : 1;  /**< [ 40: 40](R/W/H) Barrier timeout force. Bit is cleared when error is forced. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](RO) Reserved. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_ap_cvm_errmem_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t reserved_0_48         : 49;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_48         : 49;
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_ap_cvm_errmem_el1_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](RO) Reserved. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t spare40               : 1;  /**< [ 40: 40](R/W/H) Reserved. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t spare36               : 1;  /**< [ 36: 36](R/W/H) Reserved. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
#else /* Word 0 - Little Endian */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t spare36               : 1;  /**< [ 36: 36](R/W/H) Reserved. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t spare40               : 1;  /**< [ 40: 40](R/W/H) Reserved. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](RO) Reserved. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_ap_cvm_errmem_el1_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](R/W/H) Write-buffer single-bit error. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t spare40               : 1;  /**< [ 40: 40](R/W/H) Reserved. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t spare36               : 1;  /**< [ 36: 36](R/W/H) Reserved. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
#else /* Word 0 - Little Endian */
        uint64_t l1dset                : 3;  /**< [  2:  0](R/W/H) Indicates Dcache set. */
        uint64_t l1dway                : 5;  /**< [  7:  3](R/W/H) Indicates Dcache way. */
        uint64_t l1dperr               : 1;  /**< [  8:  8](R/W/H) Dcache corrected a parity error. */
        uint64_t l1dperrdis            : 1;  /**< [  9:  9](R/W) Dcache correctable parity error disable. */
        uint64_t l1dperrnosw           : 1;  /**< [ 10: 10](R/W) Dcache correctable parity error, no report to software. */
        uint64_t l1dperrforce          : 1;  /**< [ 11: 11](R/W/H) Dcache correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mtlbperr              : 1;  /**< [ 12: 12](R/W/H) MTLB corrected a parity error. */
        uint64_t mtlbperrdis           : 1;  /**< [ 13: 13](R/W) MTLB correctable parity error disable. */
        uint64_t mtlbperrnosw          : 1;  /**< [ 14: 14](R/W) MTLB correctable parity error, no report to software. */
        uint64_t mtlbperrforce         : 1;  /**< [ 15: 15](R/W/H) MTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t utlbperr              : 1;  /**< [ 16: 16](R/W/H) uTLB corrected a parity error. */
        uint64_t utlbperrdis           : 1;  /**< [ 17: 17](R/W) uTLB correctable parity error disable. */
        uint64_t utlbperrnosw          : 1;  /**< [ 18: 18](R/W) uTLB correctable parity error, no report to software. */
        uint64_t utlbperrforce         : 1;  /**< [ 19: 19](R/W/H) uTLB correctable parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t mafperr               : 1;  /**< [ 20: 20](R/W/H) MAF parity error. */
        uint64_t mafperrdis            : 1;  /**< [ 21: 21](R/W) MAF parity error disable. */
        uint64_t mafperrnosw           : 1;  /**< [ 22: 22](R/W) MAF parity error, no report to software. */
        uint64_t mafperrforce          : 1;  /**< [ 23: 23](R/W/H) MAF parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfperr               : 1;  /**< [ 24: 24](R/W/H) Write-buffer double-bit error. */
        uint64_t wbfperrdis            : 1;  /**< [ 25: 25](R/W) Write-buffer double-bit error disable. */
        uint64_t wbfperrnosw           : 1;  /**< [ 26: 26](R/W) Write-buffer single-bit error, no report to software. */
        uint64_t wbfsbeforce           : 1;  /**< [ 27: 27](R/W/H) Write-buffer SBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wbfdbeforce           : 1;  /**< [ 28: 28](R/W/H) Write-buffer DBE force. Bit is cleared when error is forced on next write operation. */
        uint64_t wcuperr               : 1;  /**< [ 29: 29](R/W/H) WCU corrected parity error. */
        uint64_t wcuperrdis            : 1;  /**< [ 30: 30](R/W) WCU parity error disable. */
        uint64_t wcuperrnosw           : 1;  /**< [ 31: 31](R/W) WCU parity error, no report to software. */
        uint64_t wcuperrforce          : 1;  /**< [ 32: 32](R/W/H) WCU parity error force. Bit is cleared when error is forced on next write operation. */
        uint64_t rbfto                 : 1;  /**< [ 33: 33](R/W/H) Read buffer timeout. */
        uint64_t rbftodis              : 1;  /**< [ 34: 34](R/W) Read buffer timeout disable. */
        uint64_t rbftonosw             : 1;  /**< [ 35: 35](R/W) Read buffer timeout, no report to software. */
        uint64_t spare36               : 1;  /**< [ 36: 36](R/W/H) Reserved. */
        uint64_t barrierto             : 1;  /**< [ 37: 37](R/W/H) Barrier timeout. */
        uint64_t barriertodis          : 1;  /**< [ 38: 38](R/W) Barrier timeout disable. */
        uint64_t barriertonosw         : 1;  /**< [ 39: 39](R/W) Barrier timeout, no report to software. */
        uint64_t spare40               : 1;  /**< [ 40: 40](R/W/H) Reserved. */
        uint64_t mtlbmult              : 1;  /**< [ 41: 41](R/W/H) MTLB multiple match error. */
        uint64_t mtlbmultdis           : 1;  /**< [ 42: 42](R/W) MTLB multiple match error disable. */
        uint64_t wcumult               : 1;  /**< [ 43: 43](R/W/H) WCU multiple match error. */
        uint64_t wcumultdis            : 1;  /**< [ 44: 44](R/W) WCU multiple match error disable. */
        uint64_t gsyncto               : 1;  /**< [ 45: 45](R/W/H) Global sync timeout. */
        uint64_t gsynctodis            : 1;  /**< [ 46: 46](R/W) Global sync timeout disable. */
        uint64_t gsynctonosw           : 1;  /**< [ 47: 47](R/W) Global sync timeout, no report to software. */
        uint64_t wbfsbeerr             : 1;  /**< [ 48: 48](R/W/H) Write-buffer single-bit error. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn83xx;
    /* struct bdk_ap_cvm_errmem_el1_cn81xx cn88xxp2; */
};
typedef union bdk_ap_cvm_errmem_el1 bdk_ap_cvm_errmem_el1_t;

#define BDK_AP_CVM_ERRMEM_EL1 BDK_AP_CVM_ERRMEM_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_ERRMEM_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ERRMEM_EL1_FUNC(void)
{
    return 0x3000b020400ll;
}

#define typedef_BDK_AP_CVM_ERRMEM_EL1 bdk_ap_cvm_errmem_el1_t
#define bustype_BDK_AP_CVM_ERRMEM_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ERRMEM_EL1 "AP_CVM_ERRMEM_EL1"
#define busnum_BDK_AP_CVM_ERRMEM_EL1 0
#define arguments_BDK_AP_CVM_ERRMEM_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_evattid_el1
 *
 * AP Cavium EVATTID Register
 * This register is for diagnostic use only.
 */
union bdk_ap_cvm_evattid_el1
{
    uint64_t u;
    struct bdk_ap_cvm_evattid_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_60_63        : 4;
        uint64_t el3_vmid              : 4;  /**< [ 59: 56](R/W) Current EL3 EVA VMID. */
        uint64_t reserved_55           : 1;
        uint64_t el3_asid              : 7;  /**< [ 54: 48](R/W) Current EL3 EVA ASID. */
        uint64_t el2_vmid              : 4;  /**< [ 47: 44](R/W) Current EL2 EVA VMID. */
        uint64_t reserved_31_43        : 13;
        uint64_t el2_asid_e2h          : 7;  /**< [ 30: 24](R/W) Current EL2 E2H EVA ASID. */
        uint64_t el1_vmid_s            : 4;  /**< [ 23: 20](R/W) Current EL1 secure EVA VMID. */
        uint64_t reserved_12_19        : 8;
        uint64_t el1_vmid_ns           : 4;  /**< [ 11:  8](R/W) Current EL1 nonsecure EVA VMID. */
        uint64_t reserved_0_7          : 8;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_7          : 8;
        uint64_t el1_vmid_ns           : 4;  /**< [ 11:  8](R/W) Current EL1 nonsecure EVA VMID. */
        uint64_t reserved_12_19        : 8;
        uint64_t el1_vmid_s            : 4;  /**< [ 23: 20](R/W) Current EL1 secure EVA VMID. */
        uint64_t el2_asid_e2h          : 7;  /**< [ 30: 24](R/W) Current EL2 E2H EVA ASID. */
        uint64_t reserved_31_43        : 13;
        uint64_t el2_vmid              : 4;  /**< [ 47: 44](R/W) Current EL2 EVA VMID. */
        uint64_t el3_asid              : 7;  /**< [ 54: 48](R/W) Current EL3 EVA ASID. */
        uint64_t reserved_55           : 1;
        uint64_t el3_vmid              : 4;  /**< [ 59: 56](R/W) Current EL3 EVA VMID. */
        uint64_t reserved_60_63        : 4;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvm_evattid_el1_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_38_63        : 26;
        uint64_t el2_asid              : 6;  /**< [ 37: 32](R/W) Current EL2 EVA ASID. */
        uint64_t reserved_20_31        : 12;
        uint64_t el1_vmid              : 4;  /**< [ 19: 16](R/W) Current EL1 EVA VMID. */
        uint64_t reserved_6_15         : 10;
        uint64_t el1_asid              : 6;  /**< [  5:  0](R/W) Current EL1 EVA ASID. */
#else /* Word 0 - Little Endian */
        uint64_t el1_asid              : 6;  /**< [  5:  0](R/W) Current EL1 EVA ASID. */
        uint64_t reserved_6_15         : 10;
        uint64_t el1_vmid              : 4;  /**< [ 19: 16](R/W) Current EL1 EVA VMID. */
        uint64_t reserved_20_31        : 12;
        uint64_t el2_asid              : 6;  /**< [ 37: 32](R/W) Current EL2 EVA ASID. */
        uint64_t reserved_38_63        : 26;
#endif /* Word 0 - End */
    } cn8;
    struct bdk_ap_cvm_evattid_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_60_63        : 4;
        uint64_t el3_vmid              : 4;  /**< [ 59: 56](R/W) Current EL3 EVA VMID. */
        uint64_t reserved_55           : 1;
        uint64_t el3_asid              : 7;  /**< [ 54: 48](R/W) Current EL3 EVA ASID. */
        uint64_t el2_vmid              : 4;  /**< [ 47: 44](R/W) Current EL2 EVA VMID. */
        uint64_t reserved_43           : 1;
        uint64_t el2_asid              : 7;  /**< [ 42: 36](R/W) Current EL2 EVA ASID. */
        uint64_t el2_vmid_e2h          : 4;  /**< [ 35: 32](R/W) Current EL2 E2H EVA VMID. */
        uint64_t reserved_31           : 1;
        uint64_t el2_asid_e2h          : 7;  /**< [ 30: 24](R/W) Current EL2 E2H EVA ASID. */
        uint64_t el1_vmid_s            : 4;  /**< [ 23: 20](R/W) Current EL1 secure EVA VMID. */
        uint64_t reserved_19           : 1;
        uint64_t el1_asid_s            : 7;  /**< [ 18: 12](R/W) Current EL1 secure EVA ASID. */
        uint64_t el1_vmid_ns           : 4;  /**< [ 11:  8](R/W) Current EL1 nonsecure EVA VMID. */
        uint64_t reserved_7            : 1;
        uint64_t el1_asid_ns           : 7;  /**< [  6:  0](R/W) Current EL1 nonsecure EVA ASID. */
#else /* Word 0 - Little Endian */
        uint64_t el1_asid_ns           : 7;  /**< [  6:  0](R/W) Current EL1 nonsecure EVA ASID. */
        uint64_t reserved_7            : 1;
        uint64_t el1_vmid_ns           : 4;  /**< [ 11:  8](R/W) Current EL1 nonsecure EVA VMID. */
        uint64_t el1_asid_s            : 7;  /**< [ 18: 12](R/W) Current EL1 secure EVA ASID. */
        uint64_t reserved_19           : 1;
        uint64_t el1_vmid_s            : 4;  /**< [ 23: 20](R/W) Current EL1 secure EVA VMID. */
        uint64_t el2_asid_e2h          : 7;  /**< [ 30: 24](R/W) Current EL2 E2H EVA ASID. */
        uint64_t reserved_31           : 1;
        uint64_t el2_vmid_e2h          : 4;  /**< [ 35: 32](R/W) Current EL2 E2H EVA VMID. */
        uint64_t el2_asid              : 7;  /**< [ 42: 36](R/W) Current EL2 EVA ASID. */
        uint64_t reserved_43           : 1;
        uint64_t el2_vmid              : 4;  /**< [ 47: 44](R/W) Current EL2 EVA VMID. */
        uint64_t el3_asid              : 7;  /**< [ 54: 48](R/W) Current EL3 EVA ASID. */
        uint64_t reserved_55           : 1;
        uint64_t el3_vmid              : 4;  /**< [ 59: 56](R/W) Current EL3 EVA VMID. */
        uint64_t reserved_60_63        : 4;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_evattid_el1 bdk_ap_cvm_evattid_el1_t;

#define BDK_AP_CVM_EVATTID_EL1 BDK_AP_CVM_EVATTID_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_EVATTID_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_EVATTID_EL1_FUNC(void)
{
    return 0x3000b020500ll;
}

#define typedef_BDK_AP_CVM_EVATTID_EL1 bdk_ap_cvm_evattid_el1_t
#define bustype_BDK_AP_CVM_EVATTID_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_EVATTID_EL1 "AP_CVM_EVATTID_EL1"
#define busnum_BDK_AP_CVM_EVATTID_EL1 0
#define arguments_BDK_AP_CVM_EVATTID_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_icachedata0_el1
 *
 * INTERNAL: AP Cavium Icache Data 0 Register
 */
union bdk_ap_cvm_icachedata0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_icachedata0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Icache data\<63:0\> from an Icache read operation. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](RO) Icache data\<63:0\> from an Icache read operation. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_icachedata0_el1_s cn; */
};
typedef union bdk_ap_cvm_icachedata0_el1 bdk_ap_cvm_icachedata0_el1_t;

#define BDK_AP_CVM_ICACHEDATA0_EL1 BDK_AP_CVM_ICACHEDATA0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_ICACHEDATA0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ICACHEDATA0_EL1_FUNC(void)
{
    return 0x3000b030000ll;
}

#define typedef_BDK_AP_CVM_ICACHEDATA0_EL1 bdk_ap_cvm_icachedata0_el1_t
#define bustype_BDK_AP_CVM_ICACHEDATA0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ICACHEDATA0_EL1 "AP_CVM_ICACHEDATA0_EL1"
#define busnum_BDK_AP_CVM_ICACHEDATA0_EL1 0
#define arguments_BDK_AP_CVM_ICACHEDATA0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_icachedata1_el1
 *
 * INTERNAL: AP Cavium Icache Data 1 Register
 */
union bdk_ap_cvm_icachedata1_el1
{
    uint64_t u;
    struct bdk_ap_cvm_icachedata1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_2_63         : 62;
        uint64_t data                  : 2;  /**< [  1:  0](RO) Icache data\<65:64\> from an Icache read operation. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 2;  /**< [  1:  0](RO) Icache data\<65:64\> from an Icache read operation. */
        uint64_t reserved_2_63         : 62;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_icachedata1_el1_s cn; */
};
typedef union bdk_ap_cvm_icachedata1_el1 bdk_ap_cvm_icachedata1_el1_t;

#define BDK_AP_CVM_ICACHEDATA1_EL1 BDK_AP_CVM_ICACHEDATA1_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_ICACHEDATA1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ICACHEDATA1_EL1_FUNC(void)
{
    return 0x3000b030100ll;
}

#define typedef_BDK_AP_CVM_ICACHEDATA1_EL1 bdk_ap_cvm_icachedata1_el1_t
#define bustype_BDK_AP_CVM_ICACHEDATA1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ICACHEDATA1_EL1 "AP_CVM_ICACHEDATA1_EL1"
#define busnum_BDK_AP_CVM_ICACHEDATA1_EL1 0
#define arguments_BDK_AP_CVM_ICACHEDATA1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_icachetag0_el1
 *
 * INTERNAL: AP Cavium Icache Tag 0 Register
 */
union bdk_ap_cvm_icachetag0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_icachetag0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_52_63        : 12;
        uint64_t valid                 : 1;  /**< [ 51: 51](RO) Valid. */
        uint64_t va                    : 40; /**< [ 50: 11](RO) VA in tags. */
        uint64_t asid_valid_ignored    : 1;  /**< [ 10: 10](RO) ASID valid is ignored. */
        uint64_t asid_index            : 6;  /**< [  9:  4](RO) ASID index. */
        uint64_t vmid_index            : 4;  /**< [  3:  0](RO) VMID index. */
#else /* Word 0 - Little Endian */
        uint64_t vmid_index            : 4;  /**< [  3:  0](RO) VMID index. */
        uint64_t asid_index            : 6;  /**< [  9:  4](RO) ASID index. */
        uint64_t asid_valid_ignored    : 1;  /**< [ 10: 10](RO) ASID valid is ignored. */
        uint64_t va                    : 40; /**< [ 50: 11](RO) VA in tags. */
        uint64_t valid                 : 1;  /**< [ 51: 51](RO) Valid. */
        uint64_t reserved_52_63        : 12;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_icachetag0_el1_s cn; */
};
typedef union bdk_ap_cvm_icachetag0_el1 bdk_ap_cvm_icachetag0_el1_t;

#define BDK_AP_CVM_ICACHETAG0_EL1 BDK_AP_CVM_ICACHETAG0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_ICACHETAG0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_ICACHETAG0_EL1_FUNC(void)
{
    return 0x3000b030200ll;
}

#define typedef_BDK_AP_CVM_ICACHETAG0_EL1 bdk_ap_cvm_icachetag0_el1_t
#define bustype_BDK_AP_CVM_ICACHETAG0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_ICACHETAG0_EL1 "AP_CVM_ICACHETAG0_EL1"
#define busnum_BDK_AP_CVM_ICACHETAG0_EL1 0
#define arguments_BDK_AP_CVM_ICACHETAG0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug0_el3
 *
 * INTERNAL: AP Cavium Memory Debug 0 Register
 */
union bdk_ap_cvm_memdebug0_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug0_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug0_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug0_el3 bdk_ap_cvm_memdebug0_el3_t;

#define BDK_AP_CVM_MEMDEBUG0_EL3 BDK_AP_CVM_MEMDEBUG0_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG0_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG0_EL3_FUNC(void)
{
    return 0x3060b040400ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG0_EL3 bdk_ap_cvm_memdebug0_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG0_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG0_EL3 "AP_CVM_MEMDEBUG0_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG0_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG0_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug1_el3
 *
 * INTERNAL: AP Cavium Memory Debug 1 Register
 */
union bdk_ap_cvm_memdebug1_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug1_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug1_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug1_el3 bdk_ap_cvm_memdebug1_el3_t;

#define BDK_AP_CVM_MEMDEBUG1_EL3 BDK_AP_CVM_MEMDEBUG1_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG1_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG1_EL3_FUNC(void)
{
    return 0x3060b040500ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG1_EL3 bdk_ap_cvm_memdebug1_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG1_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG1_EL3 "AP_CVM_MEMDEBUG1_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG1_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG1_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug2_el3
 *
 * INTERNAL: AP Cavium Memory Debug 2 Register
 */
union bdk_ap_cvm_memdebug2_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug2_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug2_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug2_el3 bdk_ap_cvm_memdebug2_el3_t;

#define BDK_AP_CVM_MEMDEBUG2_EL3 BDK_AP_CVM_MEMDEBUG2_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG2_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG2_EL3_FUNC(void)
{
    return 0x3060b040600ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG2_EL3 bdk_ap_cvm_memdebug2_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG2_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG2_EL3 "AP_CVM_MEMDEBUG2_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG2_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG2_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug3_el3
 *
 * INTERNAL: AP Cavium Memory Debug 3 Register
 */
union bdk_ap_cvm_memdebug3_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug3_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug3_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug3_el3 bdk_ap_cvm_memdebug3_el3_t;

#define BDK_AP_CVM_MEMDEBUG3_EL3 BDK_AP_CVM_MEMDEBUG3_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG3_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG3_EL3_FUNC(void)
{
    return 0x3060b040700ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG3_EL3 bdk_ap_cvm_memdebug3_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG3_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG3_EL3 "AP_CVM_MEMDEBUG3_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG3_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG3_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug4_el3
 *
 * INTERNAL: AP Cavium Memory Debug 4 Register
 */
union bdk_ap_cvm_memdebug4_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug4_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug4_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug4_el3 bdk_ap_cvm_memdebug4_el3_t;

#define BDK_AP_CVM_MEMDEBUG4_EL3 BDK_AP_CVM_MEMDEBUG4_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG4_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG4_EL3_FUNC(void)
{
    return 0x3060b050400ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG4_EL3 bdk_ap_cvm_memdebug4_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG4_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG4_EL3 "AP_CVM_MEMDEBUG4_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG4_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG4_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug5_el3
 *
 * INTERNAL: AP Cavium Memory Debug 5 Register
 */
union bdk_ap_cvm_memdebug5_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug5_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug5_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug5_el3 bdk_ap_cvm_memdebug5_el3_t;

#define BDK_AP_CVM_MEMDEBUG5_EL3 BDK_AP_CVM_MEMDEBUG5_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG5_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG5_EL3_FUNC(void)
{
    return 0x3060b050500ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG5_EL3 bdk_ap_cvm_memdebug5_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG5_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG5_EL3 "AP_CVM_MEMDEBUG5_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG5_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG5_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug6_el3
 *
 * INTERNAL: AP Cavium Memory Debug 6 Register
 */
union bdk_ap_cvm_memdebug6_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug6_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug6_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug6_el3 bdk_ap_cvm_memdebug6_el3_t;

#define BDK_AP_CVM_MEMDEBUG6_EL3 BDK_AP_CVM_MEMDEBUG6_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG6_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG6_EL3_FUNC(void)
{
    return 0x3060b050600ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG6_EL3 bdk_ap_cvm_memdebug6_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG6_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG6_EL3 "AP_CVM_MEMDEBUG6_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG6_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG6_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_memdebug7_el3
 *
 * INTERNAL: AP Cavium Memory Debug 7 Register
 */
union bdk_ap_cvm_memdebug7_el3
{
    uint64_t u;
    struct bdk_ap_cvm_memdebug7_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#else /* Word 0 - Little Endian */
        uint64_t debug                 : 64; /**< [ 63:  0](RO) Undocumented debug. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_memdebug7_el3_s cn; */
};
typedef union bdk_ap_cvm_memdebug7_el3 bdk_ap_cvm_memdebug7_el3_t;

#define BDK_AP_CVM_MEMDEBUG7_EL3 BDK_AP_CVM_MEMDEBUG7_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_MEMDEBUG7_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_MEMDEBUG7_EL3_FUNC(void)
{
    return 0x3060b050700ll;
}

#define typedef_BDK_AP_CVM_MEMDEBUG7_EL3 bdk_ap_cvm_memdebug7_el3_t
#define bustype_BDK_AP_CVM_MEMDEBUG7_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_MEMDEBUG7_EL3 "AP_CVM_MEMDEBUG7_EL3"
#define busnum_BDK_AP_CVM_MEMDEBUG7_EL3 0
#define arguments_BDK_AP_CVM_MEMDEBUG7_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_nvbar_el3
 *
 * AP Cavium DEL3T Address Register
 */
union bdk_ap_cvm_nvbar_el3
{
    uint64_t u;
    struct bdk_ap_cvm_nvbar_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t vector_address        : 53; /**< [ 63: 11](R/W) Cavium-specific exception vector address. */
        uint64_t reserved_0_10         : 11;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_10         : 11;
        uint64_t vector_address        : 53; /**< [ 63: 11](R/W) Cavium-specific exception vector address. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_nvbar_el3_s cn; */
};
typedef union bdk_ap_cvm_nvbar_el3 bdk_ap_cvm_nvbar_el3_t;

#define BDK_AP_CVM_NVBAR_EL3 BDK_AP_CVM_NVBAR_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_NVBAR_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_NVBAR_EL3_FUNC(void)
{
    return 0x3060b060000ll;
}

#define typedef_BDK_AP_CVM_NVBAR_EL3 bdk_ap_cvm_nvbar_el3_t
#define bustype_BDK_AP_CVM_NVBAR_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_NVBAR_EL3 "AP_CVM_NVBAR_EL3"
#define busnum_BDK_AP_CVM_NVBAR_EL3 0
#define arguments_BDK_AP_CVM_NVBAR_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_pn_el1
 *
 * AP Cavium Processor Number Register
 * This register is accessible at EL1, but subject to the access controls in AP_CVM_ACCESS_EL1/EL2/EL3
 */
union bdk_ap_cvm_pn_el1
{
    uint64_t u;
    struct bdk_ap_cvm_pn_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_40_63        : 24;
        uint64_t clu                   : 8;  /**< [ 39: 32](RO) The cluster this core resides in. */
        uint64_t reserved_16_31        : 16;
        uint64_t pn                    : 16; /**< [ 15:  0](RO) The flat processor number value for the core. */
#else /* Word 0 - Little Endian */
        uint64_t pn                    : 16; /**< [ 15:  0](RO) The flat processor number value for the core. */
        uint64_t reserved_16_31        : 16;
        uint64_t clu                   : 8;  /**< [ 39: 32](RO) The cluster this core resides in. */
        uint64_t reserved_40_63        : 24;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_pn_el1_s cn; */
};
typedef union bdk_ap_cvm_pn_el1 bdk_ap_cvm_pn_el1_t;

#define BDK_AP_CVM_PN_EL1 BDK_AP_CVM_PN_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_PN_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_PN_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000b040200ll;
    __bdk_csr_fatal("AP_CVM_PN_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_PN_EL1 bdk_ap_cvm_pn_el1_t
#define bustype_BDK_AP_CVM_PN_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_PN_EL1 "AP_CVM_PN_EL1"
#define busnum_BDK_AP_CVM_PN_EL1 0
#define arguments_BDK_AP_CVM_PN_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_power_el1
 *
 * AP Cavium Power Control Register
 * This register controls power management.
 */
union bdk_ap_cvm_power_el1
{
    uint64_t u;
    struct bdk_ap_cvm_power_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t maxpow                : 8;  /**< [ 63: 56](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum power. */
        uint64_t average_power         : 8;  /**< [ 55: 48](R/W) Average power.
                                                                 Time-averaged dynamic-power estimate for this core, in mA/GHz.
                                                                 An approximation of this core's power is calculated with:

                                                                   _ core_power = core_const * core_powered_on + [AVERAGE_POWER] * voltage * freq.

                                                                 Where:

                                                                 _ core_power is in mW.

                                                                 _ core_const is a per-core constant leakage from the HRM power application note, and is in
                                                                 mA.

                                                                 _ core_powered_on is a boolean indicating power applied, from RST_PP_POWER\<core_number\>.

                                                                 _ voltage is determined by the platform, perhaps by reading a VRM setting.

                                                                 _ freq is in GHz and is from RST_BOOT[C_MUL] * 0.050, assuming standard 50 MHz ref-clock. */
        uint64_t current_setting       : 8;  /**< [ 47: 40](R/W) Reserved.
                                                                 Internal:
                                                                 Current setting. */
        uint64_t hrm_adjustment        : 8;  /**< [ 39: 32](R/W) Reserved.
                                                                 Internal:
                                                                 HRM adjustment. */
        uint64_t reserved_29_31        : 3;
        uint64_t override              : 1;  /**< [ 28: 28](R/W) Reserved.
                                                                 Internal:
                                                                 Override. */
        uint64_t disable_stagger       : 1;  /**< [ 27: 27](R/W) Reserved.
                                                                 Internal:
                                                                 Disable stagger. */
        uint64_t period                : 3;  /**< [ 26: 24](R/W) Reserved.
                                                                 Internal:
                                                                 Period. */
        uint64_t powlim                : 8;  /**< [ 23: 16](R/W) Reserved.
                                                                 Internal:
                                                                 Power limit. */
        uint64_t max_setting           : 8;  /**< [ 15:  8](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum setting. */
        uint64_t min_setting           : 8;  /**< [  7:  0](R/W) Reserved.
                                                                 Internal:
                                                                 Minimum setting. */
#else /* Word 0 - Little Endian */
        uint64_t min_setting           : 8;  /**< [  7:  0](R/W) Reserved.
                                                                 Internal:
                                                                 Minimum setting. */
        uint64_t max_setting           : 8;  /**< [ 15:  8](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum setting. */
        uint64_t powlim                : 8;  /**< [ 23: 16](R/W) Reserved.
                                                                 Internal:
                                                                 Power limit. */
        uint64_t period                : 3;  /**< [ 26: 24](R/W) Reserved.
                                                                 Internal:
                                                                 Period. */
        uint64_t disable_stagger       : 1;  /**< [ 27: 27](R/W) Reserved.
                                                                 Internal:
                                                                 Disable stagger. */
        uint64_t override              : 1;  /**< [ 28: 28](R/W) Reserved.
                                                                 Internal:
                                                                 Override. */
        uint64_t reserved_29_31        : 3;
        uint64_t hrm_adjustment        : 8;  /**< [ 39: 32](R/W) Reserved.
                                                                 Internal:
                                                                 HRM adjustment. */
        uint64_t current_setting       : 8;  /**< [ 47: 40](R/W) Reserved.
                                                                 Internal:
                                                                 Current setting. */
        uint64_t average_power         : 8;  /**< [ 55: 48](R/W) Average power.
                                                                 Time-averaged dynamic-power estimate for this core, in mA/GHz.
                                                                 An approximation of this core's power is calculated with:

                                                                   _ core_power = core_const * core_powered_on + [AVERAGE_POWER] * voltage * freq.

                                                                 Where:

                                                                 _ core_power is in mW.

                                                                 _ core_const is a per-core constant leakage from the HRM power application note, and is in
                                                                 mA.

                                                                 _ core_powered_on is a boolean indicating power applied, from RST_PP_POWER\<core_number\>.

                                                                 _ voltage is determined by the platform, perhaps by reading a VRM setting.

                                                                 _ freq is in GHz and is from RST_BOOT[C_MUL] * 0.050, assuming standard 50 MHz ref-clock. */
        uint64_t maxpow                : 8;  /**< [ 63: 56](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum power. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_power_el1_s cn8; */
    struct bdk_ap_cvm_power_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t maxpow                : 8;  /**< [ 63: 56](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum power. */
        uint64_t average_power         : 8;  /**< [ 55: 48](R/W) Average power.
                                                                 Time-averaged dynamic-power estimate for this core, in mA/GHz.
                                                                 An approximation of this core's power is calculated with:

                                                                   _ core_power = core_const * core_powered_on + [AVERAGE_POWER] * voltage * freq.

                                                                 Where:

                                                                 _ core_power is in mW.

                                                                 _ core_const is a per-core constant leakage from the HRM power application note, and is in
                                                                 mA.

                                                                 _ core_powered_on is a boolean indicating power applied, from RST_PP_POWER\<core_number\>.

                                                                 _ voltage is determined by the platform, perhaps by reading a AVS setting.

                                                                 _ freq is in GHz and is from RST_BOOT[C_MUL] * 0.050, assuming standard 50 MHz ref-clock. */
        uint64_t current_setting       : 8;  /**< [ 47: 40](R/W) Reserved.
                                                                 Internal:
                                                                 Current setting. */
        uint64_t hrm_adjustment        : 8;  /**< [ 39: 32](R/W) Reserved.
                                                                 Internal:
                                                                 HRM adjustment. */
        uint64_t reserved_29_31        : 3;
        uint64_t override              : 1;  /**< [ 28: 28](R/W) Reserved.
                                                                 Internal:
                                                                 Override. */
        uint64_t disable_stagger       : 1;  /**< [ 27: 27](R/W) Reserved.
                                                                 Internal:
                                                                 Disable stagger. */
        uint64_t period                : 3;  /**< [ 26: 24](R/W) Reserved.
                                                                 Internal:
                                                                 Period. */
        uint64_t powlim                : 8;  /**< [ 23: 16](R/W) Reserved.
                                                                 Internal:
                                                                 Power limit. */
        uint64_t max_setting           : 8;  /**< [ 15:  8](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum setting. */
        uint64_t min_setting           : 8;  /**< [  7:  0](R/W) Reserved.
                                                                 Internal:
                                                                 Minimum setting. */
#else /* Word 0 - Little Endian */
        uint64_t min_setting           : 8;  /**< [  7:  0](R/W) Reserved.
                                                                 Internal:
                                                                 Minimum setting. */
        uint64_t max_setting           : 8;  /**< [ 15:  8](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum setting. */
        uint64_t powlim                : 8;  /**< [ 23: 16](R/W) Reserved.
                                                                 Internal:
                                                                 Power limit. */
        uint64_t period                : 3;  /**< [ 26: 24](R/W) Reserved.
                                                                 Internal:
                                                                 Period. */
        uint64_t disable_stagger       : 1;  /**< [ 27: 27](R/W) Reserved.
                                                                 Internal:
                                                                 Disable stagger. */
        uint64_t override              : 1;  /**< [ 28: 28](R/W) Reserved.
                                                                 Internal:
                                                                 Override. */
        uint64_t reserved_29_31        : 3;
        uint64_t hrm_adjustment        : 8;  /**< [ 39: 32](R/W) Reserved.
                                                                 Internal:
                                                                 HRM adjustment. */
        uint64_t current_setting       : 8;  /**< [ 47: 40](R/W) Reserved.
                                                                 Internal:
                                                                 Current setting. */
        uint64_t average_power         : 8;  /**< [ 55: 48](R/W) Average power.
                                                                 Time-averaged dynamic-power estimate for this core, in mA/GHz.
                                                                 An approximation of this core's power is calculated with:

                                                                   _ core_power = core_const * core_powered_on + [AVERAGE_POWER] * voltage * freq.

                                                                 Where:

                                                                 _ core_power is in mW.

                                                                 _ core_const is a per-core constant leakage from the HRM power application note, and is in
                                                                 mA.

                                                                 _ core_powered_on is a boolean indicating power applied, from RST_PP_POWER\<core_number\>.

                                                                 _ voltage is determined by the platform, perhaps by reading a AVS setting.

                                                                 _ freq is in GHz and is from RST_BOOT[C_MUL] * 0.050, assuming standard 50 MHz ref-clock. */
        uint64_t maxpow                : 8;  /**< [ 63: 56](R/W) Reserved.
                                                                 Internal:
                                                                 Maximum power. */
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_cvm_power_el1 bdk_ap_cvm_power_el1_t;

#define BDK_AP_CVM_POWER_EL1 BDK_AP_CVM_POWER_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_POWER_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_POWER_EL1_FUNC(void)
{
    return 0x3000b000200ll;
}

#define typedef_BDK_AP_CVM_POWER_EL1 bdk_ap_cvm_power_el1_t
#define bustype_BDK_AP_CVM_POWER_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_POWER_EL1 "AP_CVM_POWER_EL1"
#define busnum_BDK_AP_CVM_POWER_EL1 0
#define arguments_BDK_AP_CVM_POWER_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_scratch#_el1
 *
 * AP Cavium Scratchpad Register
 * This register provides aid to post silicon debug as a scratchpad for software.
 */
union bdk_ap_cvm_scratchx_el1
{
    uint64_t u;
    struct bdk_ap_cvm_scratchx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Scratch. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Scratch. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_scratchx_el1_s cn; */
};
typedef union bdk_ap_cvm_scratchx_el1 bdk_ap_cvm_scratchx_el1_t;

static inline uint64_t BDK_AP_CVM_SCRATCHX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_SCRATCHX_EL1(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x3000b050000ll + 0x100ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_CVM_SCRATCHX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_SCRATCHX_EL1(a) bdk_ap_cvm_scratchx_el1_t
#define bustype_BDK_AP_CVM_SCRATCHX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_SCRATCHX_EL1(a) "AP_CVM_SCRATCHX_EL1"
#define busnum_BDK_AP_CVM_SCRATCHX_EL1(a) (a)
#define arguments_BDK_AP_CVM_SCRATCHX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_statprofcmp_el1
 *
 * AP Cavium Statistical Profiling Comparator Value Register
 */
union bdk_ap_cvm_statprofcmp_el1
{
    uint64_t u;
    struct bdk_ap_cvm_statprofcmp_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t cmp_val               : 64; /**< [ 63:  0](R/W) When enabled (AP_CVM_STATPROFCTL_EL1[DIR_SAMPLE]=1), this register provides
                                                                 the value of the address or op-code and mask to be used in directed sample mode.
                                                                 The compare mode is indicated by AP_CVM_STATPROFCTL_EL1.OC_PC */
#else /* Word 0 - Little Endian */
        uint64_t cmp_val               : 64; /**< [ 63:  0](R/W) When enabled (AP_CVM_STATPROFCTL_EL1[DIR_SAMPLE]=1), this register provides
                                                                 the value of the address or op-code and mask to be used in directed sample mode.
                                                                 The compare mode is indicated by AP_CVM_STATPROFCTL_EL1.OC_PC */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_statprofcmp_el1_s cn; */
};
typedef union bdk_ap_cvm_statprofcmp_el1 bdk_ap_cvm_statprofcmp_el1_t;

#define BDK_AP_CVM_STATPROFCMP_EL1 BDK_AP_CVM_STATPROFCMP_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_STATPROFCMP_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_STATPROFCMP_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000b040100ll;
    __bdk_csr_fatal("AP_CVM_STATPROFCMP_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_STATPROFCMP_EL1 bdk_ap_cvm_statprofcmp_el1_t
#define bustype_BDK_AP_CVM_STATPROFCMP_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_STATPROFCMP_EL1 "AP_CVM_STATPROFCMP_EL1"
#define busnum_BDK_AP_CVM_STATPROFCMP_EL1 0
#define arguments_BDK_AP_CVM_STATPROFCMP_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_statprofctl_el1
 *
 * AP Cavium Statistical Profiling Configuration Register
 */
union bdk_ap_cvm_statprofctl_el1
{
    uint64_t u;
    struct bdk_ap_cvm_statprofctl_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_6_63         : 58;
        uint64_t el                    : 3;  /**< [  5:  3](R/W) When in directed sample mode, indicates whether the instruction matching
                                                                 logic includes a comparison of the EL of the target instruction.
                                                                 0x0 = Do not include an EL compare.
                                                                 0x4 = Instruction match if value match and instruction EL=0.
                                                                 0x5 = Instruction match if value match and instruction EL=1.
                                                                 0x6 = Instruction match if value match and instruction EL=2.
                                                                 0x7 = Instruction match if value match and instruction EL=3. */
        uint64_t oc_pc                 : 1;  /**< [  2:  2](R/W) When in directed sample mode, indicates whether the instruction to be
                                                                 sample is found by matching the PC or the OpCode.
                                                                 0 = Comparator matches AP_CVM_STATPROFCMP_EL1[52:2] against instruction PC.
                                                                 1 = Comparator matches AP_CVM_STATPROFCMP_EL1[31:0] against instruction opcode
                                                                    with bits enabled for comparison with a corresponding 1 in AP_CVM_STATPROFCMP_EL1[63:32]. */
        uint64_t dir_sample            : 1;  /**< [  1:  1](R/W) When set, replaces statistical profile's random sample selection logic
                                                                 with the output of the instruction and/or address comparators from the
                                                                 trace logic. This provides the ability to profile a specific instruction.
                                                                 Note that this feature will not function if trace is enabled. */
        uint64_t ernd                  : 1;  /**< [  0:  0](R/W) Provides the value for AP_PMSIDR_EL1[ERND]. This field describes how
                                                                 randomization is used in selecting the sample. See AP_PMSIDR_EL1[ERND]. */
#else /* Word 0 - Little Endian */
        uint64_t ernd                  : 1;  /**< [  0:  0](R/W) Provides the value for AP_PMSIDR_EL1[ERND]. This field describes how
                                                                 randomization is used in selecting the sample. See AP_PMSIDR_EL1[ERND]. */
        uint64_t dir_sample            : 1;  /**< [  1:  1](R/W) When set, replaces statistical profile's random sample selection logic
                                                                 with the output of the instruction and/or address comparators from the
                                                                 trace logic. This provides the ability to profile a specific instruction.
                                                                 Note that this feature will not function if trace is enabled. */
        uint64_t oc_pc                 : 1;  /**< [  2:  2](R/W) When in directed sample mode, indicates whether the instruction to be
                                                                 sample is found by matching the PC or the OpCode.
                                                                 0 = Comparator matches AP_CVM_STATPROFCMP_EL1[52:2] against instruction PC.
                                                                 1 = Comparator matches AP_CVM_STATPROFCMP_EL1[31:0] against instruction opcode
                                                                    with bits enabled for comparison with a corresponding 1 in AP_CVM_STATPROFCMP_EL1[63:32]. */
        uint64_t el                    : 3;  /**< [  5:  3](R/W) When in directed sample mode, indicates whether the instruction matching
                                                                 logic includes a comparison of the EL of the target instruction.
                                                                 0x0 = Do not include an EL compare.
                                                                 0x4 = Instruction match if value match and instruction EL=0.
                                                                 0x5 = Instruction match if value match and instruction EL=1.
                                                                 0x6 = Instruction match if value match and instruction EL=2.
                                                                 0x7 = Instruction match if value match and instruction EL=3. */
        uint64_t reserved_6_63         : 58;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_statprofctl_el1_s cn; */
};
typedef union bdk_ap_cvm_statprofctl_el1 bdk_ap_cvm_statprofctl_el1_t;

#define BDK_AP_CVM_STATPROFCTL_EL1 BDK_AP_CVM_STATPROFCTL_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_STATPROFCTL_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_STATPROFCTL_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000b040000ll;
    __bdk_csr_fatal("AP_CVM_STATPROFCTL_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_STATPROFCTL_EL1 bdk_ap_cvm_statprofctl_el1_t
#define bustype_BDK_AP_CVM_STATPROFCTL_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_STATPROFCTL_EL1 "AP_CVM_STATPROFCTL_EL1"
#define busnum_BDK_AP_CVM_STATPROFCTL_EL1 0
#define arguments_BDK_AP_CVM_STATPROFCTL_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_trapaddr#_el3
 *
 * AP Cavium Trap Address Register
 * This register provides ternary match bits for physical address traps.
 *
 * Usage Constraints:
 *   This register is R/W at EL3.
 *
 * Traps and Enables:
 *   There are no traps nor enables affecting this register.
 *
 * Configurations:
 *   R/W fields in this register reset to IMPLEMENTATION DEFINED values that might be UNKNOWN.
 *   Cavium implementations will reset to 0x0.
 */
union bdk_ap_cvm_trapaddrx_el3
{
    uint64_t u;
    struct bdk_ap_cvm_trapaddrx_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t stld                  : 2;  /**< [ 63: 62](R/W) 0x0 = Don't match (though redundant with enable bits in AP_CVM_TRAPCTL()_EL3).
                                                                 0x1 = Match load.
                                                                 0x2 = Match store.
                                                                 0x3 = Match load and store. */
        uint64_t reserved_52_61        : 10;
        uint64_t pa                    : 45; /**< [ 51:  7](R/W) Physical address match bits \<51:7\>. */
        uint64_t reserved_0_6          : 7;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_6          : 7;
        uint64_t pa                    : 45; /**< [ 51:  7](R/W) Physical address match bits \<51:7\>. */
        uint64_t reserved_52_61        : 10;
        uint64_t stld                  : 2;  /**< [ 63: 62](R/W) 0x0 = Don't match (though redundant with enable bits in AP_CVM_TRAPCTL()_EL3).
                                                                 0x1 = Match load.
                                                                 0x2 = Match store.
                                                                 0x3 = Match load and store. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_trapaddrx_el3_s cn; */
};
typedef union bdk_ap_cvm_trapaddrx_el3 bdk_ap_cvm_trapaddrx_el3_t;

static inline uint64_t BDK_AP_CVM_TRAPADDRX_EL3(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_TRAPADDRX_EL3(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a>=4)&&(a<=7)))
        return 0x3060b070000ll + 0x100ll * ((a) & 0x7);
    __bdk_csr_fatal("AP_CVM_TRAPADDRX_EL3", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_TRAPADDRX_EL3(a) bdk_ap_cvm_trapaddrx_el3_t
#define bustype_BDK_AP_CVM_TRAPADDRX_EL3(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_TRAPADDRX_EL3(a) "AP_CVM_TRAPADDRX_EL3"
#define busnum_BDK_AP_CVM_TRAPADDRX_EL3(a) (a)
#define arguments_BDK_AP_CVM_TRAPADDRX_EL3(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_trapaddrena#_el3
 *
 * AP Cavium Trap Address Enable Register
 * This register provides ternary enable bits for physical address traps.
 *
 * Usage Constraints:
 *   This register is R/W at EL3.
 *
 * Traps and Enables:
 *   There are no traps nor enables affecting this register.
 *
 * Configurations:
 *   R/W fields in this register reset to IMPLEMENTATION DEFINED values that might be UNKNOWN.
 *   Cavium implementations will reset to 0x0.
 */
union bdk_ap_cvm_trapaddrenax_el3
{
    uint64_t u;
    struct bdk_ap_cvm_trapaddrenax_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_52_63        : 12;
        uint64_t pa_ena                : 45; /**< [ 51:  7](R/W) Physical address match enable bits \<51:7\>. */
        uint64_t reserved_0_6          : 7;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_6          : 7;
        uint64_t pa_ena                : 45; /**< [ 51:  7](R/W) Physical address match enable bits \<51:7\>. */
        uint64_t reserved_52_63        : 12;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_trapaddrenax_el3_s cn; */
};
typedef union bdk_ap_cvm_trapaddrenax_el3 bdk_ap_cvm_trapaddrenax_el3_t;

static inline uint64_t BDK_AP_CVM_TRAPADDRENAX_EL3(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_TRAPADDRENAX_EL3(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a>=4)&&(a<=7)))
        return 0x3060b090000ll + 0x100ll * ((a) & 0x7);
    __bdk_csr_fatal("AP_CVM_TRAPADDRENAX_EL3", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_TRAPADDRENAX_EL3(a) bdk_ap_cvm_trapaddrenax_el3_t
#define bustype_BDK_AP_CVM_TRAPADDRENAX_EL3(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_TRAPADDRENAX_EL3(a) "AP_CVM_TRAPADDRENAX_EL3"
#define busnum_BDK_AP_CVM_TRAPADDRENAX_EL3(a) (a)
#define arguments_BDK_AP_CVM_TRAPADDRENAX_EL3(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_trapctl#_el3
 *
 * AP Cavium Trap Control Register
 * This register provides control and identification of the Cavium physical address and
 * instruction trap functionality. There are eight of these registers. Registers zero
 * through three apply to the instruction matchers and registers four through seven apply
 * to the address matchers.
 *
 * Usage Constraints:
 *   This register is R/W at EL3.
 *
 * Traps and Enables:
 *   There are no traps nor enables affecting this register.
 *
 * Configurations:
 *   R/W fields in this register reset to IMPLEMENTATION DEFINED values that might be UNKNOWN.
 *   Cavium implementations will reset to 0x0.
 */
union bdk_ap_cvm_trapctlx_el3
{
    uint64_t u;
    struct bdk_ap_cvm_trapctlx_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_37_63        : 27;
        uint64_t el2                   : 1;  /**< [ 36: 36](R/W) Trap accesses from EL2. */
        uint64_t el1ns                 : 1;  /**< [ 35: 35](R/W) Trap accesses from EL1NS. */
        uint64_t el1s                  : 1;  /**< [ 34: 34](R/W) Trap accesses from EL1S. */
        uint64_t el0ns                 : 1;  /**< [ 33: 33](R/W) Trap accesses from EL0NS. */
        uint64_t el0s                  : 1;  /**< [ 32: 32](R/W) Trap accesses from EL0S. */
        uint64_t reserved_8_31         : 24;
        uint64_t action                : 4;  /**< [  7:  4](R/W) Trap action:
                                                                   0x0 = Trap to EL3 on a match.
                                                                   0x1 = Flush the instruction pipeline and reissue instruction. For instruction matches
                                                                 only, otherwise UNPREDICTABLE.
                                                                   0x2-0xF = Reserved. */
        uint64_t mtype                 : 3;  /**< [  3:  1](R/W) Read-only. Typs of matcher for software capability discovery:
                                                                   0x0 = Not present.
                                                                   0x1 = Physical address matcher. This value is advertised in indices 4..7.
                                                                   0x2 = Instruction matcher. This value is advertised in indices 0..3. */
        uint64_t ena                   : 1;  /**< [  0:  0](R/W) Enable. */
#else /* Word 0 - Little Endian */
        uint64_t ena                   : 1;  /**< [  0:  0](R/W) Enable. */
        uint64_t mtype                 : 3;  /**< [  3:  1](R/W) Read-only. Typs of matcher for software capability discovery:
                                                                   0x0 = Not present.
                                                                   0x1 = Physical address matcher. This value is advertised in indices 4..7.
                                                                   0x2 = Instruction matcher. This value is advertised in indices 0..3. */
        uint64_t action                : 4;  /**< [  7:  4](R/W) Trap action:
                                                                   0x0 = Trap to EL3 on a match.
                                                                   0x1 = Flush the instruction pipeline and reissue instruction. For instruction matches
                                                                 only, otherwise UNPREDICTABLE.
                                                                   0x2-0xF = Reserved. */
        uint64_t reserved_8_31         : 24;
        uint64_t el0s                  : 1;  /**< [ 32: 32](R/W) Trap accesses from EL0S. */
        uint64_t el0ns                 : 1;  /**< [ 33: 33](R/W) Trap accesses from EL0NS. */
        uint64_t el1s                  : 1;  /**< [ 34: 34](R/W) Trap accesses from EL1S. */
        uint64_t el1ns                 : 1;  /**< [ 35: 35](R/W) Trap accesses from EL1NS. */
        uint64_t el2                   : 1;  /**< [ 36: 36](R/W) Trap accesses from EL2. */
        uint64_t reserved_37_63        : 27;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_trapctlx_el3_s cn; */
};
typedef union bdk_ap_cvm_trapctlx_el3 bdk_ap_cvm_trapctlx_el3_t;

static inline uint64_t BDK_AP_CVM_TRAPCTLX_EL3(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_TRAPCTLX_EL3(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=7))
        return 0x3060b080000ll + 0x100ll * ((a) & 0x7);
    __bdk_csr_fatal("AP_CVM_TRAPCTLX_EL3", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_TRAPCTLX_EL3(a) bdk_ap_cvm_trapctlx_el3_t
#define bustype_BDK_AP_CVM_TRAPCTLX_EL3(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_TRAPCTLX_EL3(a) "AP_CVM_TRAPCTLX_EL3"
#define busnum_BDK_AP_CVM_TRAPCTLX_EL3(a) (a)
#define arguments_BDK_AP_CVM_TRAPCTLX_EL3(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_trapinsn#_el3
 *
 * AP Cavium Trap Instructions Register
 * This register provides ternary match and enable bits for instruction word traps.
 *
 * Usage Constraints:
 *   This register is R/W at EL3.
 *
 * Traps and Enables:
 *   There are no traps nor enables affecting this register.
 *
 * Configurations:
 *   R/W fields in this register reset to IMPLEMENTATION DEFINED values that might be UNKNOWN.
 *   Cavium implementations will reset to 0x0.
 */
union bdk_ap_cvm_trapinsnx_el3
{
    uint64_t u;
    struct bdk_ap_cvm_trapinsnx_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t insn_ena              : 32; /**< [ 63: 32](R/W) Instruction match bits. */
        uint64_t insn                  : 32; /**< [ 31:  0](R/W) Instruction match enable bits. */
#else /* Word 0 - Little Endian */
        uint64_t insn                  : 32; /**< [ 31:  0](R/W) Instruction match enable bits. */
        uint64_t insn_ena              : 32; /**< [ 63: 32](R/W) Instruction match bits. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_trapinsnx_el3_s cn; */
};
typedef union bdk_ap_cvm_trapinsnx_el3 bdk_ap_cvm_trapinsnx_el3_t;

static inline uint64_t BDK_AP_CVM_TRAPINSNX_EL3(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_TRAPINSNX_EL3(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x3060b090000ll + 0x100ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_CVM_TRAPINSNX_EL3", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_TRAPINSNX_EL3(a) bdk_ap_cvm_trapinsnx_el3_t
#define bustype_BDK_AP_CVM_TRAPINSNX_EL3(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_TRAPINSNX_EL3(a) "AP_CVM_TRAPINSNX_EL3"
#define busnum_BDK_AP_CVM_TRAPINSNX_EL3(a) (a)
#define arguments_BDK_AP_CVM_TRAPINSNX_EL3(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_trapopc_el3
 *
 * AP Cavium Trap Exception Opcode Register
 * This register stores syndrome information on a trap fault.
 *
 * Usage Constraints:
 *   This register is R/W at EL3.
 * Traps and Enables:
 *   There are no traps nor enables affecting this register.
 * Configurations:
 *   RW fields in this register reset to IMPLEMENTATION DEFINED values that might be UNKNOWN.
 *   Cavium implementations will reset to 0x0.
 */
union bdk_ap_cvm_trapopc_el3
{
    uint64_t u;
    struct bdk_ap_cvm_trapopc_el3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_37_63        : 27;
        uint64_t regset                : 5;  /**< [ 36: 32](R/W) Matching register set.
                                                                 Values zero through 15 refer to physical address match register sets and values 16-31
                                                                 refer to instruction match register sets. */
        uint64_t insn                  : 32; /**< [ 31:  0](R/W) Instruction word that caused the fault. */
#else /* Word 0 - Little Endian */
        uint64_t insn                  : 32; /**< [ 31:  0](R/W) Instruction word that caused the fault. */
        uint64_t regset                : 5;  /**< [ 36: 32](R/W) Matching register set.
                                                                 Values zero through 15 refer to physical address match register sets and values 16-31
                                                                 refer to instruction match register sets. */
        uint64_t reserved_37_63        : 27;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_trapopc_el3_s cn; */
};
typedef union bdk_ap_cvm_trapopc_el3 bdk_ap_cvm_trapopc_el3_t;

#define BDK_AP_CVM_TRAPOPC_EL3 BDK_AP_CVM_TRAPOPC_EL3_FUNC()
static inline uint64_t BDK_AP_CVM_TRAPOPC_EL3_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_TRAPOPC_EL3_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3060b060100ll;
    __bdk_csr_fatal("AP_CVM_TRAPOPC_EL3", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVM_TRAPOPC_EL3 bdk_ap_cvm_trapopc_el3_t
#define bustype_BDK_AP_CVM_TRAPOPC_EL3 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_TRAPOPC_EL3 "AP_CVM_TRAPOPC_EL3"
#define busnum_BDK_AP_CVM_TRAPOPC_EL3 0
#define arguments_BDK_AP_CVM_TRAPOPC_EL3 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_xlatdata0_el1
 *
 * AP Cavium Translation Data 0 EL1 Register
 */
union bdk_ap_cvm_xlatdata0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_xlatdata0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t par                   : 2;  /**< [ 63: 62](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_54_61        : 8;
        uint64_t walk                  : 2;  /**< [ 53: 52](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ng                    : 1;  /**< [ 51: 51](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_50           : 1;
        uint64_t nsec                  : 1;  /**< [ 49: 49](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_48           : 1;
        uint64_t ppn                   : 36; /**< [ 47: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_10_11        : 2;
        uint64_t sh1                   : 2;  /**< [  9:  8](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ap1                   : 2;  /**< [  7:  6](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t xn1                   : 1;  /**< [  5:  5](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t pxn1                  : 1;  /**< [  4:  4](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t attr1                 : 4;  /**< [  3:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
#else /* Word 0 - Little Endian */
        uint64_t attr1                 : 4;  /**< [  3:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t pxn1                  : 1;  /**< [  4:  4](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t xn1                   : 1;  /**< [  5:  5](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ap1                   : 2;  /**< [  7:  6](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t sh1                   : 2;  /**< [  9:  8](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_10_11        : 2;
        uint64_t ppn                   : 36; /**< [ 47: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_48           : 1;
        uint64_t nsec                  : 1;  /**< [ 49: 49](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_50           : 1;
        uint64_t ng                    : 1;  /**< [ 51: 51](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t walk                  : 2;  /**< [ 53: 52](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_54_61        : 8;
        uint64_t par                   : 2;  /**< [ 63: 62](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_xlatdata0_el1_s cn; */
};
typedef union bdk_ap_cvm_xlatdata0_el1 bdk_ap_cvm_xlatdata0_el1_t;

#define BDK_AP_CVM_XLATDATA0_EL1 BDK_AP_CVM_XLATDATA0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_XLATDATA0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_XLATDATA0_EL1_FUNC(void)
{
    return 0x3000b050400ll;
}

#define typedef_BDK_AP_CVM_XLATDATA0_EL1 bdk_ap_cvm_xlatdata0_el1_t
#define bustype_BDK_AP_CVM_XLATDATA0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_XLATDATA0_EL1 "AP_CVM_XLATDATA0_EL1"
#define busnum_BDK_AP_CVM_XLATDATA0_EL1 0
#define arguments_BDK_AP_CVM_XLATDATA0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_xlatdata1_el1
 *
 * AP Cavium Translation Data 1 EL1 Register
 */
union bdk_ap_cvm_xlatdata1_el1
{
    uint64_t u;
    struct bdk_ap_cvm_xlatdata1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_63           : 1;
        uint64_t ent2                  : 9;  /**< [ 62: 54](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_45_53        : 9;
        uint64_t ent1                  : 9;  /**< [ 44: 36](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_34_35        : 2;
        uint64_t mask                  : 22; /**< [ 33: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_10_11        : 2;
        uint64_t sh2                   : 2;  /**< [  9:  8](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ap2                   : 2;  /**< [  7:  6](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t xn2                   : 1;  /**< [  5:  5](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t pxn2                  : 1;  /**< [  4:  4](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t attr2                 : 4;  /**< [  3:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
#else /* Word 0 - Little Endian */
        uint64_t attr2                 : 4;  /**< [  3:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t pxn2                  : 1;  /**< [  4:  4](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t xn2                   : 1;  /**< [  5:  5](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ap2                   : 2;  /**< [  7:  6](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t sh2                   : 2;  /**< [  9:  8](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_10_11        : 2;
        uint64_t mask                  : 22; /**< [ 33: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_34_35        : 2;
        uint64_t ent1                  : 9;  /**< [ 44: 36](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_45_53        : 9;
        uint64_t ent2                  : 9;  /**< [ 62: 54](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_63           : 1;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_xlatdata1_el1_s cn; */
};
typedef union bdk_ap_cvm_xlatdata1_el1 bdk_ap_cvm_xlatdata1_el1_t;

#define BDK_AP_CVM_XLATDATA1_EL1 BDK_AP_CVM_XLATDATA1_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_XLATDATA1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_XLATDATA1_EL1_FUNC(void)
{
    return 0x3000b050500ll;
}

#define typedef_BDK_AP_CVM_XLATDATA1_EL1 bdk_ap_cvm_xlatdata1_el1_t
#define bustype_BDK_AP_CVM_XLATDATA1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_XLATDATA1_EL1 "AP_CVM_XLATDATA1_EL1"
#define busnum_BDK_AP_CVM_XLATDATA1_EL1 0
#define arguments_BDK_AP_CVM_XLATDATA1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_xlatvtag0_el1
 *
 * AP Cavium Translation Tag 0 EL1 Register
 */
union bdk_ap_cvm_xlatvtag0_el1
{
    uint64_t u;
    struct bdk_ap_cvm_xlatvtag0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t level                 : 2;  /**< [ 63: 62](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t eva_asid              : 6;  /**< [ 61: 56](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t eva_vmid              : 4;  /**< [ 55: 52](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ng                    : 1;  /**< [ 51: 51](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t el_1or0               : 1;  /**< [ 50: 50](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t nsec                  : 1;  /**< [ 49: 49](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t r                     : 1;  /**< [ 48: 48](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t vpn                   : 36; /**< [ 47: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_1_11         : 11;
        uint64_t val                   : 1;  /**< [  0:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
#else /* Word 0 - Little Endian */
        uint64_t val                   : 1;  /**< [  0:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_1_11         : 11;
        uint64_t vpn                   : 36; /**< [ 47: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t r                     : 1;  /**< [ 48: 48](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t nsec                  : 1;  /**< [ 49: 49](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t el_1or0               : 1;  /**< [ 50: 50](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t ng                    : 1;  /**< [ 51: 51](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t eva_vmid              : 4;  /**< [ 55: 52](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t eva_asid              : 6;  /**< [ 61: 56](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t level                 : 2;  /**< [ 63: 62](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_xlatvtag0_el1_s cn; */
};
typedef union bdk_ap_cvm_xlatvtag0_el1 bdk_ap_cvm_xlatvtag0_el1_t;

#define BDK_AP_CVM_XLATVTAG0_EL1 BDK_AP_CVM_XLATVTAG0_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_XLATVTAG0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_XLATVTAG0_EL1_FUNC(void)
{
    return 0x3000b050600ll;
}

#define typedef_BDK_AP_CVM_XLATVTAG0_EL1 bdk_ap_cvm_xlatvtag0_el1_t
#define bustype_BDK_AP_CVM_XLATVTAG0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_XLATVTAG0_EL1 "AP_CVM_XLATVTAG0_EL1"
#define busnum_BDK_AP_CVM_XLATVTAG0_EL1 0
#define arguments_BDK_AP_CVM_XLATVTAG0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvm_xlatvtag1_el1
 *
 * AP Cavium Translation Tag 1 EL1 Register
 */
union bdk_ap_cvm_xlatvtag1_el1
{
    uint64_t u;
    struct bdk_ap_cvm_xlatvtag1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t ent2                  : 9;  /**< [ 56: 48](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_45_47        : 3;
        uint64_t ent1                  : 9;  /**< [ 44: 36](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_34_35        : 2;
        uint64_t mask                  : 22; /**< [ 33: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_2_11         : 10;
        uint64_t stage2                : 1;  /**< [  1:  1](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t stage1                : 1;  /**< [  0:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
#else /* Word 0 - Little Endian */
        uint64_t stage1                : 1;  /**< [  0:  0](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t stage2                : 1;  /**< [  1:  1](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_2_11         : 10;
        uint64_t mask                  : 22; /**< [ 33: 12](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_34_35        : 2;
        uint64_t ent1                  : 9;  /**< [ 44: 36](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_45_47        : 3;
        uint64_t ent2                  : 9;  /**< [ 56: 48](RO) SYS[CvmCACHE] debug read data from uTLB/MTLB/WCU. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvm_xlatvtag1_el1_s cn; */
};
typedef union bdk_ap_cvm_xlatvtag1_el1 bdk_ap_cvm_xlatvtag1_el1_t;

#define BDK_AP_CVM_XLATVTAG1_EL1 BDK_AP_CVM_XLATVTAG1_EL1_FUNC()
static inline uint64_t BDK_AP_CVM_XLATVTAG1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVM_XLATVTAG1_EL1_FUNC(void)
{
    return 0x3000b050700ll;
}

#define typedef_BDK_AP_CVM_XLATVTAG1_EL1 bdk_ap_cvm_xlatvtag1_el1_t
#define bustype_BDK_AP_CVM_XLATVTAG1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVM_XLATVTAG1_EL1 "AP_CVM_XLATVTAG1_EL1"
#define busnum_BDK_AP_CVM_XLATVTAG1_EL1 0
#define arguments_BDK_AP_CVM_XLATVTAG1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvmctl2_el1
 *
 * AP Cavium Control Register
 * This register provides Cavium-specific control information.
 */
union bdk_ap_cvmctl2_el1
{
    uint64_t u;
    struct bdk_ap_cvmctl2_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_12_63        : 52;
        uint64_t livelock_stall_detect : 4;  /**< [ 11:  8](R/W) Livelock stall detector. 0=disable, cycles 16*1\<\<[[11:8] */
        uint64_t reserved_4_7          : 4;
        uint64_t reduce_map_bandwidth  : 2;  /**< [  3:  2](R/W) Reduce map bandwidth to 1-3 instr/cycle (also reduces max inflight instructions to 32,64,96) */
        uint64_t allow_one_ifi         : 1;  /**< [  1:  1](R/W) Allow only one inflight instruction. */
        uint64_t allow_one_ifmr        : 1;  /**< [  0:  0](R/W) Allow only one inflight memory reference. */
#else /* Word 0 - Little Endian */
        uint64_t allow_one_ifmr        : 1;  /**< [  0:  0](R/W) Allow only one inflight memory reference. */
        uint64_t allow_one_ifi         : 1;  /**< [  1:  1](R/W) Allow only one inflight instruction. */
        uint64_t reduce_map_bandwidth  : 2;  /**< [  3:  2](R/W) Reduce map bandwidth to 1-3 instr/cycle (also reduces max inflight instructions to 32,64,96) */
        uint64_t reserved_4_7          : 4;
        uint64_t livelock_stall_detect : 4;  /**< [ 11:  8](R/W) Livelock stall detector. 0=disable, cycles 16*1\<\<[[11:8] */
        uint64_t reserved_12_63        : 52;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvmctl2_el1_s cn; */
};
typedef union bdk_ap_cvmctl2_el1 bdk_ap_cvmctl2_el1_t;

#define BDK_AP_CVMCTL2_EL1 BDK_AP_CVMCTL2_EL1_FUNC()
static inline uint64_t BDK_AP_CVMCTL2_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVMCTL2_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000b000100ll;
    __bdk_csr_fatal("AP_CVMCTL2_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVMCTL2_EL1 bdk_ap_cvmctl2_el1_t
#define bustype_BDK_AP_CVMCTL2_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVMCTL2_EL1 "AP_CVMCTL2_EL1"
#define busnum_BDK_AP_CVMCTL2_EL1 0
#define arguments_BDK_AP_CVMCTL2_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvmctl_el1
 *
 * AP Cavium Control Register
 * This register provides Cavium-specific control information.
 */
union bdk_ap_cvmctl_el1
{
    uint64_t u;
    struct bdk_ap_cvmctl_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t disable_const         : 1;  /**< [ 56: 56](R/W) Disable constant optimization. */
        uint64_t disable_alias         : 1;  /**< [ 55: 55](R/W) Disable alias optimization. */
        uint64_t disable_ldp_stp_fiss  : 1;  /**< [ 54: 54](R/W) Disable ldp/stp fissioning with unaligned prediction. */
        uint64_t disable_io_pred       : 1;  /**< [ 53: 53](R/W) Disable IO space prediction. */
        uint64_t disable_unaligned_pred : 1; /**< [ 52: 52](R/W) Disable unaligned prediction. */
        uint64_t disable_ldst_ordering_pred : 1;/**< [ 51: 51](R/W) Disable load/store ordering prediction. */
        uint64_t reserved_50           : 1;
        uint64_t disable_branch_elimination : 1;/**< [ 49: 49](R/W) Disable branch elimination. */
        uint64_t disable_optimum_occupancy : 1;/**< [ 48: 48](R/W) Increase ibuf occupancy time. */
        uint64_t disable_load2         : 1;  /**< [ 47: 47](R/W) Disable second load port. */
        uint64_t force_strong_ordering : 1;  /**< [ 46: 46](R/W) Force strong load ordering.
                                                                 0 = Weak ordering.
                                                                 1 = Strong ordering.

                                                                 Internal:
                                                                 CN8XXX is always strong ordering. */
        uint64_t disable_mem_ooo       : 1;  /**< [ 45: 45](R/W) Disable all memory out-of-order. */
        uint64_t disable_ooo           : 1;  /**< [ 44: 44](R/W) Disable all out-of-order. */
        uint64_t dpref_bp_dis          : 1;  /**< [ 43: 43](R/W) When set, hardware data prefetcher ignores memory system backpressure for next line prefetcher. */
        uint64_t dpref_lookahead       : 1;  /**< [ 42: 42](R/W) When set, hardware data prefetcher uses a lookahead of 2. When clear, lookahead of 1. */
        uint64_t dpref_next_line       : 1;  /**< [ 41: 41](R/W) Enable next line hardware data prefetcher. */
        uint64_t dpref_delta           : 1;  /**< [ 40: 40](R/W) Enable delta stream hardware data prefetcher. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](R/W) Set CIM AP_ICH_VTR_EL2[LISTREGS] to 0x1 (i.e. two LRs) on Pass 1. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t reserved_23           : 1;
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t reserved_10_15        : 6;
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t reserved_6            : 1;
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t reserved_2            : 1;
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
#else /* Word 0 - Little Endian */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t reserved_2            : 1;
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t reserved_6            : 1;
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t reserved_10_15        : 6;
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t reserved_23           : 1;
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](R/W) Set CIM AP_ICH_VTR_EL2[LISTREGS] to 0x1 (i.e. two LRs) on Pass 1. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t dpref_delta           : 1;  /**< [ 40: 40](R/W) Enable delta stream hardware data prefetcher. */
        uint64_t dpref_next_line       : 1;  /**< [ 41: 41](R/W) Enable next line hardware data prefetcher. */
        uint64_t dpref_lookahead       : 1;  /**< [ 42: 42](R/W) When set, hardware data prefetcher uses a lookahead of 2. When clear, lookahead of 1. */
        uint64_t dpref_bp_dis          : 1;  /**< [ 43: 43](R/W) When set, hardware data prefetcher ignores memory system backpressure for next line prefetcher. */
        uint64_t disable_ooo           : 1;  /**< [ 44: 44](R/W) Disable all out-of-order. */
        uint64_t disable_mem_ooo       : 1;  /**< [ 45: 45](R/W) Disable all memory out-of-order. */
        uint64_t force_strong_ordering : 1;  /**< [ 46: 46](R/W) Force strong load ordering.
                                                                 0 = Weak ordering.
                                                                 1 = Strong ordering.

                                                                 Internal:
                                                                 CN8XXX is always strong ordering. */
        uint64_t disable_load2         : 1;  /**< [ 47: 47](R/W) Disable second load port. */
        uint64_t disable_optimum_occupancy : 1;/**< [ 48: 48](R/W) Increase ibuf occupancy time. */
        uint64_t disable_branch_elimination : 1;/**< [ 49: 49](R/W) Disable branch elimination. */
        uint64_t reserved_50           : 1;
        uint64_t disable_ldst_ordering_pred : 1;/**< [ 51: 51](R/W) Disable load/store ordering prediction. */
        uint64_t disable_unaligned_pred : 1; /**< [ 52: 52](R/W) Disable unaligned prediction. */
        uint64_t disable_io_pred       : 1;  /**< [ 53: 53](R/W) Disable IO space prediction. */
        uint64_t disable_ldp_stp_fiss  : 1;  /**< [ 54: 54](R/W) Disable ldp/stp fissioning with unaligned prediction. */
        uint64_t disable_alias         : 1;  /**< [ 55: 55](R/W) Disable alias optimization. */
        uint64_t disable_const         : 1;  /**< [ 56: 56](R/W) Disable constant optimization. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvmctl_el1_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_40_63        : 24;
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](R/W) Set CIM AP_ICH_VTR_EL2[LISTREGS] to 0x1 (i.e. two LRs) on Pass 1. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t disable_icache_probes : 1;  /**< [ 23: 23](R/W) Disable Icache probes. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t reserved_10_15        : 6;
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_fetch_under_fill : 1;/**< [  6:  6](R/W) Disable fetch-under-fill. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t disable_icache_prefetching : 1;/**< [  2:  2](R/W) Disable Icache prefetching. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
#else /* Word 0 - Little Endian */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache_prefetching : 1;/**< [  2:  2](R/W) Disable Icache prefetching. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t disable_fetch_under_fill : 1;/**< [  6:  6](R/W) Disable fetch-under-fill. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t reserved_10_15        : 6;
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t disable_icache_probes : 1;  /**< [ 23: 23](R/W) Disable Icache probes. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](R/W) Set CIM AP_ICH_VTR_EL2[LISTREGS] to 0x1 (i.e. two LRs) on Pass 1. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t reserved_40_63        : 24;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_ap_cvmctl_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t disable_const         : 1;  /**< [ 56: 56](R/W) Disable constant optimization. */
        uint64_t disable_alias         : 1;  /**< [ 55: 55](R/W) Disable alias optimization. */
        uint64_t disable_ldp_stp_fiss  : 1;  /**< [ 54: 54](R/W) Disable ldp/stp fissioning with unaligned prediction. */
        uint64_t disable_io_pred       : 1;  /**< [ 53: 53](R/W) Disable IO space prediction. */
        uint64_t disable_unaligned_pred : 1; /**< [ 52: 52](R/W) Disable unaligned prediction. */
        uint64_t disable_ldst_ordering_pred : 1;/**< [ 51: 51](R/W) Disable load/store ordering prediction. */
        uint64_t reserved_50           : 1;
        uint64_t disable_branch_elimination : 1;/**< [ 49: 49](R/W) Disable branch elimination. */
        uint64_t disable_optimum_occupancy : 1;/**< [ 48: 48](R/W) Increase ibuf occupancy time. */
        uint64_t disable_load2         : 1;  /**< [ 47: 47](R/W) Disable second load port. */
        uint64_t force_strong_ordering : 1;  /**< [ 46: 46](R/W) Force strong load ordering.
                                                                 0 = Weak ordering.
                                                                 1 = Strong ordering.

                                                                 Internal:
                                                                 CN8XXX is always strong ordering. */
        uint64_t disable_mem_ooo       : 1;  /**< [ 45: 45](R/W) Disable all memory out-of-order. */
        uint64_t disable_ooo           : 1;  /**< [ 44: 44](R/W) Disable all out-of-order. */
        uint64_t dpref_bp_dis          : 1;  /**< [ 43: 43](R/W) When set, hardware data prefetcher ignores memory system backpressure for next line prefetcher. */
        uint64_t dpref_lookahead       : 1;  /**< [ 42: 42](R/W) When set, hardware data prefetcher uses a lookahead of 2. When clear, lookahead of 1. */
        uint64_t dpref_next_line       : 1;  /**< [ 41: 41](R/W) Enable next line hardware data prefetcher. */
        uint64_t dpref_delta           : 1;  /**< [ 40: 40](R/W) Enable delta stream hardware data prefetcher. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t reserved_35           : 1;
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](RO) Enable v8.1 features, modifying the ID registers to show v8.1.
                                                                 Internal:
                                                                 FIXME does this go away with CN98XX. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t ldil1hwprefdis        : 1;  /**< [ 23: 23](R/W) Disable Istream LDI L1 hardware prefetcher. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t reserved_16_19        : 4;
        uint64_t reserved_10_15        : 6;
        uint64_t reserved_9            : 1;
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding and other fusions. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t ldil1swprefdis        : 1;  /**< [  6:  6](R/W) Disable LDI L1 software prefetch instructions (PRFM). */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t ldil1specdis          : 1;  /**< [  2:  2](R/W) Disable all LDI L1 speculative fill requests (only demand fills with machine drained).
                                                                 Internal:
                                                                 CN88XX-like mode. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
#else /* Word 0 - Little Endian */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t ldil1specdis          : 1;  /**< [  2:  2](R/W) Disable all LDI L1 speculative fill requests (only demand fills with machine drained).
                                                                 Internal:
                                                                 CN88XX-like mode. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t ldil1swprefdis        : 1;  /**< [  6:  6](R/W) Disable LDI L1 software prefetch instructions (PRFM). */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding and other fusions. */
        uint64_t reserved_9            : 1;
        uint64_t reserved_10_15        : 6;
        uint64_t reserved_16_19        : 4;
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t ldil1hwprefdis        : 1;  /**< [ 23: 23](R/W) Disable Istream LDI L1 hardware prefetcher. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](RO) Enable v8.1 features, modifying the ID registers to show v8.1.
                                                                 Internal:
                                                                 FIXME does this go away with CN98XX. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t reserved_35           : 1;
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t dpref_delta           : 1;  /**< [ 40: 40](R/W) Enable delta stream hardware data prefetcher. */
        uint64_t dpref_next_line       : 1;  /**< [ 41: 41](R/W) Enable next line hardware data prefetcher. */
        uint64_t dpref_lookahead       : 1;  /**< [ 42: 42](R/W) When set, hardware data prefetcher uses a lookahead of 2. When clear, lookahead of 1. */
        uint64_t dpref_bp_dis          : 1;  /**< [ 43: 43](R/W) When set, hardware data prefetcher ignores memory system backpressure for next line prefetcher. */
        uint64_t disable_ooo           : 1;  /**< [ 44: 44](R/W) Disable all out-of-order. */
        uint64_t disable_mem_ooo       : 1;  /**< [ 45: 45](R/W) Disable all memory out-of-order. */
        uint64_t force_strong_ordering : 1;  /**< [ 46: 46](R/W) Force strong load ordering.
                                                                 0 = Weak ordering.
                                                                 1 = Strong ordering.

                                                                 Internal:
                                                                 CN8XXX is always strong ordering. */
        uint64_t disable_load2         : 1;  /**< [ 47: 47](R/W) Disable second load port. */
        uint64_t disable_optimum_occupancy : 1;/**< [ 48: 48](R/W) Increase ibuf occupancy time. */
        uint64_t disable_branch_elimination : 1;/**< [ 49: 49](R/W) Disable branch elimination. */
        uint64_t reserved_50           : 1;
        uint64_t disable_ldst_ordering_pred : 1;/**< [ 51: 51](R/W) Disable load/store ordering prediction. */
        uint64_t disable_unaligned_pred : 1; /**< [ 52: 52](R/W) Disable unaligned prediction. */
        uint64_t disable_io_pred       : 1;  /**< [ 53: 53](R/W) Disable IO space prediction. */
        uint64_t disable_ldp_stp_fiss  : 1;  /**< [ 54: 54](R/W) Disable ldp/stp fissioning with unaligned prediction. */
        uint64_t disable_alias         : 1;  /**< [ 55: 55](R/W) Disable alias optimization. */
        uint64_t disable_const         : 1;  /**< [ 56: 56](R/W) Disable constant optimization. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_ap_cvmctl_el1_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_44_63        : 20;
        uint64_t dpref_bp_dis          : 1;  /**< [ 43: 43](R/W) When set, hardware data prefetcher ignores memory system backpressure for next line prefetcher. */
        uint64_t dpref_lookahead       : 1;  /**< [ 42: 42](R/W) When set, hardware data prefetcher uses a lookahead of 2. When clear, lookahead of 1. */
        uint64_t dpref_next_line       : 1;  /**< [ 41: 41](R/W) Enable next line hardware data prefetcher. */
        uint64_t dpref_delta           : 1;  /**< [ 40: 40](R/W) Enable delta stream hardware data prefetcher. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](RAZ) Reserved. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t disable_icache_probes : 1;  /**< [ 23: 23](R/W) Disable Icache probes. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t reserved_10_15        : 6;
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_fetch_under_fill : 1;/**< [  6:  6](R/W) Disable fetch-under-fill. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t disable_icache_prefetching : 1;/**< [  2:  2](R/W) Disable Icache prefetching. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
#else /* Word 0 - Little Endian */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache_prefetching : 1;/**< [  2:  2](R/W) Disable Icache prefetching. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t disable_fetch_under_fill : 1;/**< [  6:  6](R/W) Disable fetch-under-fill. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t reserved_10_15        : 6;
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t disable_icache_probes : 1;  /**< [ 23: 23](R/W) Disable Icache probes. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](RAZ) Reserved. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t dpref_delta           : 1;  /**< [ 40: 40](R/W) Enable delta stream hardware data prefetcher. */
        uint64_t dpref_next_line       : 1;  /**< [ 41: 41](R/W) Enable next line hardware data prefetcher. */
        uint64_t dpref_lookahead       : 1;  /**< [ 42: 42](R/W) When set, hardware data prefetcher uses a lookahead of 2. When clear, lookahead of 1. */
        uint64_t dpref_bp_dis          : 1;  /**< [ 43: 43](R/W) When set, hardware data prefetcher ignores memory system backpressure for next line prefetcher. */
        uint64_t reserved_44_63        : 20;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_ap_cvmctl_el1_cn81xx cn83xx; */
    struct bdk_ap_cvmctl_el1_cn88xxp2
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_40_63        : 24;
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](RAZ) Reserved. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t disable_icache_probes : 1;  /**< [ 23: 23](R/W) Disable Icache probes. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t reserved_10_15        : 6;
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_fetch_under_fill : 1;/**< [  6:  6](R/W) Disable fetch-under-fill. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t disable_icache_prefetching : 1;/**< [  2:  2](R/W) Disable Icache prefetching. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
#else /* Word 0 - Little Endian */
        uint64_t disable_icache        : 1;  /**< [  0:  0](R/W) Disable Icache. */
        uint64_t random_icache         : 1;  /**< [  1:  1](R/W) Random Icache replacement. */
        uint64_t disable_icache_prefetching : 1;/**< [  2:  2](R/W) Disable Icache prefetching. */
        uint64_t force_csr_clock       : 1;  /**< [  3:  3](R/W) Force CSR clock. */
        uint64_t force_exe_clock       : 1;  /**< [  4:  4](R/W) Force execution-unit clock. */
        uint64_t force_issue_clock     : 1;  /**< [  5:  5](R/W) Force issue-unit clock. */
        uint64_t disable_fetch_under_fill : 1;/**< [  6:  6](R/W) Disable fetch-under-fill. */
        uint64_t disable_wfi           : 1;  /**< [  7:  7](R/W) Disable WFI/WFE. */
        uint64_t disable_branch_folding : 1; /**< [  8:  8](R/W) Disable branch folding. */
        uint64_t disable_flex_execution : 1; /**< [  9:  9](R/W) Disable flex execution; also prevents overlapped execution of DIV/SQRT and other
                                                                 instructions (to prevent a DIV load collision). */
        uint64_t reserved_10_15        : 6;
        uint64_t step_rate             : 4;  /**< [ 19: 16](R/W) Step rate. */
        uint64_t no_exc_icache_parity  : 1;  /**< [ 20: 20](R/W) Suppress exception on Icache correctable parity error. */
        uint64_t suppress_parity_checking : 1;/**< [ 21: 21](R/W) Suppress Icache correctable parity checking. */
        uint64_t force_icache_parity   : 1;  /**< [ 22: 22](R/W) Force icache correctable parity error on next Icache fill. This bit clears itself after
                                                                 the fill operation. */
        uint64_t disable_icache_probes : 1;  /**< [ 23: 23](R/W) Disable Icache probes. */
        uint64_t wfe_defer             : 8;  /**< [ 31: 24](R/W) WFE defer timer setting.  Time in core-clocks = {| WFE_DEFER, WFE_DEFER\<3:0\>} \<\<
                                                                 WFE_DEFER\<7:4\>. */
        uint64_t isb_flush             : 1;  /**< [ 32: 32](R/W) Enable pipeline flush after an ISB. */
        uint64_t enable_v81            : 1;  /**< [ 33: 33](R/W) Enable v8.1 features, modifying the ID registers to show v8.1. */
        uint64_t disable_wfe           : 1;  /**< [ 34: 34](R/W) Disable WFE. */
        uint64_t force_cim_ich_vtr_to1 : 1;  /**< [ 35: 35](RAZ) Reserved. */
        uint64_t disable_cas           : 1;  /**< [ 36: 36](R/W) Disable the CAS instruction. */
        uint64_t disable_casp          : 1;  /**< [ 37: 37](R/W) Disable the CASP instruction. */
        uint64_t disable_eret_pred     : 1;  /**< [ 38: 38](R/W) Disable ERET prediction. */
        uint64_t mrs_msr_hazard        : 1;  /**< [ 39: 39](R/W) Disable MRS/MSR pipelining, assume hazards. */
        uint64_t reserved_40_63        : 24;
#endif /* Word 0 - End */
    } cn88xxp2;
};
typedef union bdk_ap_cvmctl_el1 bdk_ap_cvmctl_el1_t;

#define BDK_AP_CVMCTL_EL1 BDK_AP_CVMCTL_EL1_FUNC()
static inline uint64_t BDK_AP_CVMCTL_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVMCTL_EL1_FUNC(void)
{
    return 0x3000b000000ll;
}

#define typedef_BDK_AP_CVMCTL_EL1 bdk_ap_cvmctl_el1_t
#define bustype_BDK_AP_CVMCTL_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVMCTL_EL1 "AP_CVMCTL_EL1"
#define busnum_BDK_AP_CVMCTL_EL1 0
#define arguments_BDK_AP_CVMCTL_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvmmemctl0_el1
 *
 * AP Cavium Memory Control 0 Register
 * This register controls memory features.
 */
union bdk_ap_cvmmemctl0_el1
{
    uint64_t u;
    struct bdk_ap_cvmmemctl0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_63           : 1;
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t wfeldex1dis           : 1;  /**< [ 57: 57](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) causes SEV to local core.
                                                                 1 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) does not cause SEV to local core. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization (pass 2.0 only).

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush (pass 2.0 only).
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout. (pass 2.0 only.)
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass (pass 2.0 only).
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.  uTLB is flushed when this value is changed.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is flushed when this value is changed. */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.
                                                                 uTLB is flushed when this value is changed. */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO].
                                                                 Must be \>=0x6. The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO]. Must be \>= 0x6. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries - 1.  Future allocation is limited to this size (pass 1, pass 2) */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
#else /* Word 0 - Little Endian */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries - 1.  Future allocation is limited to this size (pass 1, pass 2) */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO]. Must be \>= 0x6. */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO].
                                                                 Must be \>=0x6. The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.
                                                                 uTLB is flushed when this value is changed. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is flushed when this value is changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.  uTLB is flushed when this value is changed.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass (pass 2.0 only).
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout. (pass 2.0 only.)
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush (pass 2.0 only).
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization (pass 2.0 only).

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t wfeldex1dis           : 1;  /**< [ 57: 57](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) causes SEV to local core.
                                                                 1 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) does not cause SEV to local core. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t reserved_63           : 1;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvmmemctl0_el1_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_63           : 1;
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t reserved_57           : 1;
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization (pass 2.0 only).

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush (pass 2.0 only).
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout. (pass 2.0 only.)
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass (pass 2.0 only).
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.  uTLB is flushed when this value is changed.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is flushed when this value is changed. */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.
                                                                 uTLB is flushed when this value is changed. */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO].
                                                                 Must be \>=0x6. The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO]. Must be \>= 0x6. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries - 1.  Future allocation is limited to this size (pass 1, pass 2) */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
#else /* Word 0 - Little Endian */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries - 1.  Future allocation is limited to this size (pass 1, pass 2) */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO]. Must be \>= 0x6. */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO].
                                                                 Must be \>=0x6. The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.
                                                                 uTLB is flushed when this value is changed. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is flushed when this value is changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.  uTLB is flushed when this value is changed.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is flushed when this value is
                                                                 changed. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass (pass 2.0 only).
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout. (pass 2.0 only.)
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush (pass 2.0 only).
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization (pass 2.0 only).

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed (pass 2.0 only).
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t reserved_57           : 1;
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t reserved_63           : 1;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_ap_cvmmemctl0_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_63           : 1;
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t wfeldex1dis           : 1;  /**< [ 57: 57](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) causes SEV to local core.
                                                                 1 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) does not cause SEV to local core. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization.

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush.
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout.
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass.
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is not flushed with this value is changed. */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.

                                                                 uTLB is not flushed with this value is changed. */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO+6].
                                                                 The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO+6]. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries minus one.  uTLB is flushed when this value is changed. */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
#else /* Word 0 - Little Endian */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries minus one.  uTLB is flushed when this value is changed. */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO+6]. */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO+6].
                                                                 The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.

                                                                 uTLB is not flushed with this value is changed. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is not flushed with this value is changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass.
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout.
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush.
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization.

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t wfeldex1dis           : 1;  /**< [ 57: 57](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) causes SEV to local core.
                                                                 1 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) does not cause SEV to local core. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t reserved_63           : 1;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_ap_cvmmemctl0_el1_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_63           : 1;
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t wfeldex1dis           : 1;  /**< [ 57: 57](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) causes SEV to local core.
                                                                 1 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) does not cause SEV to local core. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization.

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush.
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout.
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass.
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is not flushed with this value is changed. */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.

                                                                 uTLB is not flushed with this value is changed. */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO].
                                                                 Must be \>=0x6. The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO]. Must be \>= 0x6. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries - 1.  uTLB is flushed when this value is changed. */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
#else /* Word 0 - Little Endian */
        uint64_t mclkforce             : 1;  /**< [  0:  0](R/W) Force memory clock enable. When set, force memory conditional clocking. */
        uint64_t cclkforce             : 1;  /**< [  1:  1](R/W) Force CSR clock enable. When set, force CSR conditional clocking. */
        uint64_t utlbentriesm1         : 5;  /**< [  6:  2](R/W) Number of uTLB entries - 1.  uTLB is flushed when this value is changed. */
        uint64_t wbfthresh             : 5;  /**< [ 11:  7](R/W) Write-buffer threshold. The write-buffer starts flushing entries to the L2 cache once the
                                                                 number of valid write-buffer entries reaches this threshold value. */
        uint64_t wbfto                 : 5;  /**< [ 16: 12](R/W) Write-buffer timeout for non-NSH entries; timeout = 2^WBFTO. */
        uint64_t wbftomrgclrena        : 1;  /**< [ 17: 17](R/W) Write-buffer timeout clear-on-merge enable. */
        uint64_t wbftonshena           : 1;  /**< [ 18: 18](R/W) Write-buffer timeout for NSH entries enable.
                                                                 0 = Write-buffer time out for NSH entries = 218 cycles.
                                                                 1 = Write-buffer time out for NSH entries = 2^[WBFTO] (see [WBFTO]). */
        uint64_t wbfnomerge            : 1;  /**< [ 19: 19](R/W) Write-buffer merge disable. */
        uint64_t wbfallbarrier         : 1;  /**< [ 20: 20](R/W) Write-buffer apply barrier to all ST instructions. */
        uint64_t rbfto                 : 5;  /**< [ 25: 21](R/W) Read buffer timeout; timeout = 2^[RBFTO]. Must be \>= 0x6. */
        uint64_t rbfshortto            : 5;  /**< [ 30: 26](R/W) Read buffer short timeout; timeout = 2^[RBFSHORTTO].
                                                                 Must be \>=0x6. The L2C directs the core to use either RBFSHORTTO or RBFTO. The short
                                                                 timeout is used when an CCPI link goes down to expedite error indication. */
        uint64_t wfito                 : 3;  /**< [ 33: 31](R/W) Wait-for-interrupt timeout; timeout=2^(8+[WFITO]). */
        uint64_t wfildexdis            : 1;  /**< [ 34: 34](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = L2C invalidates to global monitor cause SEV to local core.
                                                                 1 = L2C invalidates have no effect on global monitor (i.e. lock_register).

                                                                 This field should never be set to 1; setting to 1 does not
                                                                 conform to the ARMv8 specification. */
        uint64_t ldprefdis             : 1;  /**< [ 35: 35](R/W) LD PREF instructions disable. */
        uint64_t stprefdis             : 1;  /**< [ 36: 36](R/W) ST PREF instructions disable. */
        uint64_t dcva47                : 1;  /**< [ 37: 37](R/W) If MMU translations are disabled,
                                                                 apply memory attributes to physical addresses where bit\<47\>
                                                                 is zero and device attributes to physical address bit\<47\> is
                                                                 one. */
        uint64_t ldil2cdis             : 1;  /**< [ 38: 38](R/W) LDI instruction L2C usage.
                                                                 0 = LDI instructions to L2C are LDI (don't allocate in L1, allocates L2 at requester).
                                                                 1 = LDI instructions to L2C are LDT (don't allocate in L2 or L1 at home or requester). */
        uint64_t zval2cdis             : 1;  /**< [ 39: 39](R/W) ZVA bypass L2C.
                                                                 0 = DC_ZVA instructions to L2C are STFIL1 (full block store operation allocating in
                                                                 requester L2, fill 0s, self-invalidate L1 cache).
                                                                 1 = DC_ZVA instructions to L2C are STTIL1 (full block store operation through to DRAM,
                                                                 bypass home and requester L2, fill 0s, self-invalidate L1 cache). */
        uint64_t replayprefdis         : 1;  /**< [ 40: 40](R/W) Replay PREF disable. uTLB miss PREF instruction behavior (see chapter body).
                                                                 0 = PREF instructions do attempt a replay for MTLB to uTLB refill.
                                                                 1 = PREF instructions do not attempt a replay for MTLB to uTLB refill.

                                                                 uTLB is not flushed with this value is changed. */
        uint64_t wcumissforce          : 1;  /**< [ 41: 41](R/W) Force all walker cache lookups to miss.  uTLB is not flushed with this value is changed. */
        uint64_t ioglobalforce         : 1;  /**< [ 42: 42](R/W) Reserved.
                                                                 Internal:
                                                                 Force global order for IO references. */
        uint64_t stexl2cforce          : 1;  /**< [ 43: 43](R/W) Send all store-exclusive instructions to L2 cache.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t wbfdmbflushnext       : 1;  /**< [ 44: 44](R/W) DMB instruction to !NSH flushes next ST to !NSH.  uTLB is not flushed with this value is
                                                                 changed. */
        uint64_t wbfdsbflushall        : 1;  /**< [ 45: 45](R/W) Any DSB instruction flushes the write buffer. */
        uint64_t tlbiall               : 1;  /**< [ 46: 46](R/W) Treat all TLBIs like TLBI ALL for a specific exception level. */
        uint64_t utlbfillbypdis        : 1;  /**< [ 47: 47](R/W) Disable uTLB fill bypass.
                                                                 0 = On a stage1-only translation, the uTLB is written along with the MTLB.
                                                                 1 = On a stage1-only translation, the uTLB is not written along with the MTLB causing a
                                                                 uTLB miss replay to complete the uTLB fill. */
        uint64_t gsyncto               : 5;  /**< [ 52: 48](R/W) GlobalSync timeout.
                                                                 timeout = 2^[GSYNCTO].
                                                                 0x0 = disable timeout. */
        uint64_t tlbiicflush           : 1;  /**< [ 53: 53](R/W) Some local TLBI instructions cause ICache flush.
                                                                 0 = Icache flush operation do not happen on the TLBI instructions listed below.
                                                                 1 = Icache is flushed on the TLBI instructions listed below:
                                                                   * TLBI ALLE2{IS}.
                                                                   * TLBI ALLE3{IS}.
                                                                   * TLBI VAE1{IS}.
                                                                   * TLBI VALE1{IS}.
                                                                   * TLBI VAAE1{IS}.
                                                                   * TLBI VAALE1{IS}.
                                                                   * TLBI VAE2{IS}.
                                                                   * TLBI VALE2{IS}.
                                                                   * TLBI VAE3{IS}.
                                                                   * TLBI VALE3{IS}.
                                                                   * TLBI IPAS2E1{IS}.
                                                                   * TLBI IPAS2LE1{IS}. */
        uint64_t tlbinopdis            : 1;  /**< [ 54: 54](R/W) Disable broadcast TLBI optimization.

                                                                 Address-based broadcast TLBI instructions that go to remote cores are converted
                                                                 from address-based TLBI instructions to context-based TLBI instructions. The
                                                                 actions on the local core generating the TLBI instruction are still precise.

                                                                 0 = The converted context-based TLBI instructions or original context-based
                                                                 TLBIs to remote cores (without intervening interruptions, such as a DSB) are
                                                                 coalesced into a single context-based TLBI. Converted and original ones do not
                                                                 coalesce.

                                                                 1 = The above-mentioned coalescing is suppressed and converted context-based
                                                                 remote TLBIs still go out as such. */
        uint64_t dmbstallforce         : 1;  /**< [ 55: 55](R/W) Force DMB to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = DMB instructions mark prior relevant write-buffer entries for flush, but do not wait
                                                                 for the ACKs to return.
                                                                 1 = DMB instructions mark prior relevant write-buffer entries for flush and wait for all
                                                                 the ACKs to return. */
        uint64_t stlstallforce         : 1;  /**< [ 56: 56](R/W) Force ST_release to wait for flushed write-buffer entries to be ACKed.
                                                                 0 = Store-release instructions mark prior relevant write-buffer entries for flush but do
                                                                 not wait for the ACKs to return.
                                                                 1 = Store-release instructions mark prior relevant write-buffer entries for flush and wait
                                                                 for all the ACKs to return. */
        uint64_t wfeldex1dis           : 1;  /**< [ 57: 57](R/W) WFE release behavior for LD-exclusive.
                                                                 0 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) causes SEV to local core.
                                                                 1 = A global monitor transition from exclusive to open (lock flag transition
                                                                 from 1 to 0) does not cause SEV to local core. */
        uint64_t stexfailcnt           : 3;  /**< [ 60: 58](RO) ST exclusive fail count. */
        uint64_t node                  : 2;  /**< [ 62: 61](RO) Local node ID. */
        uint64_t reserved_63           : 1;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_ap_cvmmemctl0_el1_cn81xx cn83xx; */
    /* struct bdk_ap_cvmmemctl0_el1_s cn88xxp2; */
};
typedef union bdk_ap_cvmmemctl0_el1 bdk_ap_cvmmemctl0_el1_t;

#define BDK_AP_CVMMEMCTL0_EL1 BDK_AP_CVMMEMCTL0_EL1_FUNC()
static inline uint64_t BDK_AP_CVMMEMCTL0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVMMEMCTL0_EL1_FUNC(void)
{
    return 0x3000b000400ll;
}

#define typedef_BDK_AP_CVMMEMCTL0_EL1 bdk_ap_cvmmemctl0_el1_t
#define bustype_BDK_AP_CVMMEMCTL0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVMMEMCTL0_EL1 "AP_CVMMEMCTL0_EL1"
#define busnum_BDK_AP_CVMMEMCTL0_EL1 0
#define arguments_BDK_AP_CVMMEMCTL0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvmmemctl1_el1
 *
 * AP Cavium Memory Control 1 Register
 * This register controls additional memory-unit features.
 * Internal:
 * Back-end, non-debug.
 */
union bdk_ap_cvmmemctl1_el1
{
    uint64_t u;
    struct bdk_ap_cvmmemctl1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t rsvd_57_63            : 7;  /**< [ 63: 57](R/W) Reserved. */
        uint64_t ldictxchkena          : 1;  /**< [ 56: 56](R/W) LDI context consistency check enable. For diagnostic use only. */
        uint64_t rbfevictbyp3dis       : 1;  /**< [ 55: 55](R/W) MAF RBUF evict datapath 3-cycle bypass disable. For diagnostic use only. */
        uint64_t rbfevictbyp2dis       : 1;  /**< [ 54: 54](R/W) MAF RBUF evict datapath 2-cycle bypass disable. For diagnostic use only. */
        uint64_t xmcpriwbfdis          : 1;  /**< [ 53: 53](R/W) XMC priority disable for predicted unlock WBF eviction. For diagnostic use only. */
        uint64_t xmcpristdis           : 1;  /**< [ 52: 52](R/W) XMC priority disable for predicted unlock ST. For diagnostic use only. */
        uint64_t xmcpriswpdis          : 1;  /**< [ 51: 51](R/W) XMC priority disable for predicted unlock SWP. For diagnostic use only. */
        uint64_t xmcpricasdis          : 1;  /**< [ 50: 50](R/W) XMC priority disable for predicted unlock CAS. For diagnostic use only. */
        uint64_t iostmergedis          : 1;  /**< [ 49: 49](R/W) IO ST merging disable. */
        uint64_t ioldmergedis          : 1;  /**< [ 48: 48](R/W) IO LD merging disable. */
        uint64_t gclkforce             : 1;  /**< [ 47: 47](R/W) Force gated clocks to be on. For diagnostic use only. */
        uint64_t ldil3prefdis          : 1;  /**< [ 46: 46](R/W) LDIL3 PREF instructions disable. */
        uint64_t ldil2prefdis          : 1;  /**< [ 45: 45](R/W) LDIL2 PREF instructions disable. */
        uint64_t spare44               : 1;  /**< [ 44: 44](R/W) Reserved; spare. */
        uint64_t evatt_limited_size    : 1;  /**< [ 43: 43](R/W) 0 = do not limit ASIDMAP/VMIDMAP size
                                                                 1 = ASIDMAP has 7 entries, VMIDMAP has 7 entries */
        uint64_t evatt_periodic_flush  : 1;  /**< [ 42: 42](R/W) 0 = EVATT is not periodically flushed
                                                                 1 = EVATT is flushed every 2^14 cycles */
        uint64_t cvap_dis              : 1;  /**< [ 41: 41](R/W) If set, convert DC_CVAP into DC_CVAC.  For diagnostic use only. */
        uint64_t tlbinoadr             : 1;  /**< [ 40: 40](R/W) If set, convert broadcast TLBI address-based opcodes to context-based opcode. For
                                                                 diagnostic use only. */
        uint64_t utlbentriesm1_5       : 1;  /**< [ 39: 39](R/W) Bit\<5\> of [UTLBENTRIESM1], the number of uTLB entries minus one. The uTLB is flushed when this
                                                                 value is changed. */
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable SSO switch-tag. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Trap any access to nonzero node id. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Reserved.
                                                                 Internal:
                                                                 Enable I/O SSO and PKO address region. */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable/disable LMTST(a). */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
#else /* Word 0 - Little Endian */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable/disable LMTST(a). */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Reserved.
                                                                 Internal:
                                                                 Enable I/O SSO and PKO address region. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Trap any access to nonzero node id. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable SSO switch-tag. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t utlbentriesm1_5       : 1;  /**< [ 39: 39](R/W) Bit\<5\> of [UTLBENTRIESM1], the number of uTLB entries minus one. The uTLB is flushed when this
                                                                 value is changed. */
        uint64_t tlbinoadr             : 1;  /**< [ 40: 40](R/W) If set, convert broadcast TLBI address-based opcodes to context-based opcode. For
                                                                 diagnostic use only. */
        uint64_t cvap_dis              : 1;  /**< [ 41: 41](R/W) If set, convert DC_CVAP into DC_CVAC.  For diagnostic use only. */
        uint64_t evatt_periodic_flush  : 1;  /**< [ 42: 42](R/W) 0 = EVATT is not periodically flushed
                                                                 1 = EVATT is flushed every 2^14 cycles */
        uint64_t evatt_limited_size    : 1;  /**< [ 43: 43](R/W) 0 = do not limit ASIDMAP/VMIDMAP size
                                                                 1 = ASIDMAP has 7 entries, VMIDMAP has 7 entries */
        uint64_t spare44               : 1;  /**< [ 44: 44](R/W) Reserved; spare. */
        uint64_t ldil2prefdis          : 1;  /**< [ 45: 45](R/W) LDIL2 PREF instructions disable. */
        uint64_t ldil3prefdis          : 1;  /**< [ 46: 46](R/W) LDIL3 PREF instructions disable. */
        uint64_t gclkforce             : 1;  /**< [ 47: 47](R/W) Force gated clocks to be on. For diagnostic use only. */
        uint64_t ioldmergedis          : 1;  /**< [ 48: 48](R/W) IO LD merging disable. */
        uint64_t iostmergedis          : 1;  /**< [ 49: 49](R/W) IO ST merging disable. */
        uint64_t xmcpricasdis          : 1;  /**< [ 50: 50](R/W) XMC priority disable for predicted unlock CAS. For diagnostic use only. */
        uint64_t xmcpriswpdis          : 1;  /**< [ 51: 51](R/W) XMC priority disable for predicted unlock SWP. For diagnostic use only. */
        uint64_t xmcpristdis           : 1;  /**< [ 52: 52](R/W) XMC priority disable for predicted unlock ST. For diagnostic use only. */
        uint64_t xmcpriwbfdis          : 1;  /**< [ 53: 53](R/W) XMC priority disable for predicted unlock WBF eviction. For diagnostic use only. */
        uint64_t rbfevictbyp2dis       : 1;  /**< [ 54: 54](R/W) MAF RBUF evict datapath 2-cycle bypass disable. For diagnostic use only. */
        uint64_t rbfevictbyp3dis       : 1;  /**< [ 55: 55](R/W) MAF RBUF evict datapath 3-cycle bypass disable. For diagnostic use only. */
        uint64_t ldictxchkena          : 1;  /**< [ 56: 56](R/W) LDI context consistency check enable. For diagnostic use only. */
        uint64_t rsvd_57_63            : 7;  /**< [ 63: 57](R/W) Reserved. */
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_cvmmemctl1_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t rsvd_57_63            : 7;  /**< [ 63: 57](R/W) Reserved. */
        uint64_t ldictxchkena          : 1;  /**< [ 56: 56](R/W) LDI context consistency check enable. For diagnostic use only. */
        uint64_t rbfevictbyp3dis       : 1;  /**< [ 55: 55](R/W) MAF RBUF evict datapath 3-cycle bypass disable. For diagnostic use only. */
        uint64_t rbfevictbyp2dis       : 1;  /**< [ 54: 54](R/W) MAF RBUF evict datapath 2-cycle bypass disable. For diagnostic use only. */
        uint64_t xmcpriwbfdis          : 1;  /**< [ 53: 53](R/W) XMC priority disable for predicted unlock WBF eviction. For diagnostic use only. */
        uint64_t xmcpristdis           : 1;  /**< [ 52: 52](R/W) XMC priority disable for predicted unlock ST. For diagnostic use only. */
        uint64_t xmcpriswpdis          : 1;  /**< [ 51: 51](R/W) XMC priority disable for predicted unlock SWP. For diagnostic use only. */
        uint64_t xmcpricasdis          : 1;  /**< [ 50: 50](R/W) XMC priority disable for predicted unlock CAS. For diagnostic use only. */
        uint64_t iostmergedis          : 1;  /**< [ 49: 49](R/W) IO ST merging disable. */
        uint64_t ioldmergedis          : 1;  /**< [ 48: 48](R/W) IO LD merging disable. */
        uint64_t gclkforce             : 1;  /**< [ 47: 47](R/W) Force gated clocks to be on. For diagnostic use only. */
        uint64_t ldil3prefdis          : 1;  /**< [ 46: 46](R/W) LDIL3 PREF instructions disable. */
        uint64_t ldil2prefdis          : 1;  /**< [ 45: 45](R/W) LDIL2 PREF instructions disable. */
        uint64_t spare44               : 1;  /**< [ 44: 44](R/W) Reserved; spare. */
        uint64_t evatt_limited_size    : 1;  /**< [ 43: 43](R/W) 0 = do not limit ASIDMAP/VMIDMAP size
                                                                 1 = ASIDMAP has 7 entries, VMIDMAP has 7 entries */
        uint64_t evatt_periodic_flush  : 1;  /**< [ 42: 42](R/W) 0 = EVATT is not periodically flushed
                                                                 1 = EVATT is flushed every 2^14 cycles */
        uint64_t cvap_dis              : 1;  /**< [ 41: 41](R/W) If set, convert DC_CVAP into DC_CVAC.  For diagnostic use only. */
        uint64_t tlbinoadr             : 1;  /**< [ 40: 40](R/W) If set, convert broadcast TLBI address-based opcodes to context-based opcode. For
                                                                 diagnostic use only. */
        uint64_t utlbentriesm1_5       : 1;  /**< [ 39: 39](R/W) Bit\<5\> of [UTLBENTRIESM1], the number of uTLB entries minus one. The uTLB is flushed when this
                                                                 value is changed. */
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 Enable SSO switch-tag. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Trap any access to nonzero node id. This should be clear on multi-socket
                                                                 systems, and set on single-socket systems. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Enable SSO and PKO address region.
                                                                 0 = Accesses described below will trap.
                                                                 1 = Allow \> 64-bit memory instructions, multi-register memory instructions, and
                                                                 atomic instructions to SSO and PKO I/O address regions. This must be set if SSO
                                                                 or PKO are to be used.

                                                                 Other address regions (e.g. SLI) are not affected by this setting. */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Enable LMTST. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
#else /* Word 0 - Little Endian */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Enable LMTST. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Enable SSO and PKO address region.
                                                                 0 = Accesses described below will trap.
                                                                 1 = Allow \> 64-bit memory instructions, multi-register memory instructions, and
                                                                 atomic instructions to SSO and PKO I/O address regions. This must be set if SSO
                                                                 or PKO are to be used.

                                                                 Other address regions (e.g. SLI) are not affected by this setting. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Trap any access to nonzero node id. This should be clear on multi-socket
                                                                 systems, and set on single-socket systems. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 Enable SSO switch-tag. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t utlbentriesm1_5       : 1;  /**< [ 39: 39](R/W) Bit\<5\> of [UTLBENTRIESM1], the number of uTLB entries minus one. The uTLB is flushed when this
                                                                 value is changed. */
        uint64_t tlbinoadr             : 1;  /**< [ 40: 40](R/W) If set, convert broadcast TLBI address-based opcodes to context-based opcode. For
                                                                 diagnostic use only. */
        uint64_t cvap_dis              : 1;  /**< [ 41: 41](R/W) If set, convert DC_CVAP into DC_CVAC.  For diagnostic use only. */
        uint64_t evatt_periodic_flush  : 1;  /**< [ 42: 42](R/W) 0 = EVATT is not periodically flushed
                                                                 1 = EVATT is flushed every 2^14 cycles */
        uint64_t evatt_limited_size    : 1;  /**< [ 43: 43](R/W) 0 = do not limit ASIDMAP/VMIDMAP size
                                                                 1 = ASIDMAP has 7 entries, VMIDMAP has 7 entries */
        uint64_t spare44               : 1;  /**< [ 44: 44](R/W) Reserved; spare. */
        uint64_t ldil2prefdis          : 1;  /**< [ 45: 45](R/W) LDIL2 PREF instructions disable. */
        uint64_t ldil3prefdis          : 1;  /**< [ 46: 46](R/W) LDIL3 PREF instructions disable. */
        uint64_t gclkforce             : 1;  /**< [ 47: 47](R/W) Force gated clocks to be on. For diagnostic use only. */
        uint64_t ioldmergedis          : 1;  /**< [ 48: 48](R/W) IO LD merging disable. */
        uint64_t iostmergedis          : 1;  /**< [ 49: 49](R/W) IO ST merging disable. */
        uint64_t xmcpricasdis          : 1;  /**< [ 50: 50](R/W) XMC priority disable for predicted unlock CAS. For diagnostic use only. */
        uint64_t xmcpriswpdis          : 1;  /**< [ 51: 51](R/W) XMC priority disable for predicted unlock SWP. For diagnostic use only. */
        uint64_t xmcpristdis           : 1;  /**< [ 52: 52](R/W) XMC priority disable for predicted unlock ST. For diagnostic use only. */
        uint64_t xmcpriwbfdis          : 1;  /**< [ 53: 53](R/W) XMC priority disable for predicted unlock WBF eviction. For diagnostic use only. */
        uint64_t rbfevictbyp2dis       : 1;  /**< [ 54: 54](R/W) MAF RBUF evict datapath 2-cycle bypass disable. For diagnostic use only. */
        uint64_t rbfevictbyp3dis       : 1;  /**< [ 55: 55](R/W) MAF RBUF evict datapath 3-cycle bypass disable. For diagnostic use only. */
        uint64_t ldictxchkena          : 1;  /**< [ 56: 56](R/W) LDI context consistency check enable. For diagnostic use only. */
        uint64_t rsvd_57_63            : 7;  /**< [ 63: 57](R/W) Reserved. */
#endif /* Word 0 - End */
    } cn9;
    struct bdk_ap_cvmmemctl1_el1_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_39_63        : 25;
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable SSO switch-tag. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Trap any access to nonzero node id. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Reserved.
                                                                 Internal:
                                                                 Enable I/O SSO and PKO address region. */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable/disable LMTST(a). */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
#else /* Word 0 - Little Endian */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable/disable LMTST(a). */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Reserved.
                                                                 Internal:
                                                                 Enable I/O SSO and PKO address region. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Trap any access to nonzero node id. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable SSO switch-tag. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t reserved_39_63        : 25;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_ap_cvmmemctl1_el1_cn88xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_37_63        : 27;
        uint64_t reserved_8_36         : 29;
        uint64_t reserved_7            : 1;
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable SSO switch-tag. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Trap any access to nonzero node id. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Reserved.
                                                                 Internal:
                                                                 Enable I/O SSO and PKO address region. */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable/disable LMTST(a). */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
#else /* Word 0 - Little Endian */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable/disable LMTST(a). */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Reserved.
                                                                 Internal:
                                                                 Enable I/O SSO and PKO address region. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Trap any access to nonzero node id. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Reserved.
                                                                 Internal:
                                                                 83xx: Enable SSO switch-tag. */
        uint64_t reserved_7            : 1;
        uint64_t reserved_8_36         : 29;
        uint64_t reserved_37_63        : 27;
#endif /* Word 0 - End */
    } cn88xx;
    struct bdk_ap_cvmmemctl1_el1_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_39_63        : 25;
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Enable SSO switch-tag caching. The cache must be invalidated through e.g. use of
                                                                 SSO_WS_CFG[SSO_SAI_FLUSH] before clearing this bit. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Trap any access to nonzero node id. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Enable SSO and PKO address region.
                                                                 0 = Accesses described below will trap.
                                                                 1 = Allow \> 64-bit memory instructions, multi-register memory instructions, and
                                                                 atomic instructions to SSO and PKO I/O address regions. This must be set if SSO
                                                                 or PKO are to be used.

                                                                 Other address regions (e.g. SLI) are not affected by this setting. */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Enable LMTST. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
#else /* Word 0 - Little Endian */
        uint64_t lodnshena             : 1;  /**< [  0:  0](R/W) LocalOrderDomain DMB/DSB_NSH{ST} enable. */
        uint64_t lodishena             : 1;  /**< [  1:  1](R/W) LocalOrderDomain DMB/DSB_ISH{ST} enable. */
        uint64_t lodignoresh           : 1;  /**< [  2:  2](R/W) LocalOrderDomain DMB/DSB_NSH{ST} ignores shareability (applies to both nsh and ish pages). */
        uint64_t lmtstena              : 1;  /**< [  3:  3](R/W) Enable LMTST. */
        uint64_t ioatomicena           : 1;  /**< [  4:  4](R/W) Enable SSO and PKO address region.
                                                                 0 = Accesses described below will trap.
                                                                 1 = Allow \> 64-bit memory instructions, multi-register memory instructions, and
                                                                 atomic instructions to SSO and PKO I/O address regions. This must be set if SSO
                                                                 or PKO are to be used.

                                                                 Other address regions (e.g. SLI) are not affected by this setting. */
        uint64_t node1trapena          : 1;  /**< [  5:  5](R/W) Trap any access to nonzero node id. */
        uint64_t switchtagena          : 1;  /**< [  6:  6](R/W) Enable SSO switch-tag caching. The cache must be invalidated through e.g. use of
                                                                 SSO_WS_CFG[SSO_SAI_FLUSH] before clearing this bit. */
        uint64_t spare                 : 1;  /**< [  7:  7](R/W) Reserved; spare. */
        uint64_t dprefbpmissthresh     : 12; /**< [ 19:  8](R/W) Data-stream hardware prefetcher backpressure threshold for L2C miss latency. */
        uint64_t dprefbphitthresh      : 12; /**< [ 31: 20](R/W) Data-stream hardware prefetcher backpressure threshold for L2C hit latency. */
        uint64_t dprefbpctl            : 4;  /**< [ 35: 32](R/W) Data-stream hardware prefetcher backpressure control mask for dual counter mode.
                                                                 Internal:
                                                                 Backpressure is applied if:
                                                                 \<pre\>
                                                                   (   ([DPREFBPCTL]\<0\> && !hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<1\> && !hit_ctr_bp &&  miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<2\> &&  hit_ctr_bp && !miss_ctr_bp)
                                                                    || ([DPREFBPCTL]\<3\> &&  hit_ctr_bp &&  miss_ctr_bp))
                                                                 \</pre\>

                                                                 Where hit_ctr_bp is the MSB of the 4-bit hit counter being set, and miss_ctr_bp
                                                                 is the MSB of the 4-bit miss counter being set. */
        uint64_t dprefbpmode           : 1;  /**< [ 36: 36](R/W) Data-stream hardware prefetcher backpressure mode select.
                                                                 0 = Single counter mode (combined hit and miss latency counter).
                                                                 1 = Dual counter mode (separate hit and miss latency counters). */
        uint64_t tlbilocalicflush      : 1;  /**< [ 37: 37](R/W) Force ICache flush when any local TLBI is issued.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t tlbiremoteicflush     : 1;  /**< [ 38: 38](R/W) Force ICache flush when any remote TLBI is received.
                                                                 0 = Do nothing.
                                                                 1 = Flush the ICache. */
        uint64_t reserved_39_63        : 25;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_ap_cvmmemctl1_el1 bdk_ap_cvmmemctl1_el1_t;

#define BDK_AP_CVMMEMCTL1_EL1 BDK_AP_CVMMEMCTL1_EL1_FUNC()
static inline uint64_t BDK_AP_CVMMEMCTL1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVMMEMCTL1_EL1_FUNC(void)
{
    return 0x3000b000500ll;
}

#define typedef_BDK_AP_CVMMEMCTL1_EL1 bdk_ap_cvmmemctl1_el1_t
#define bustype_BDK_AP_CVMMEMCTL1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVMMEMCTL1_EL1 "AP_CVMMEMCTL1_EL1"
#define busnum_BDK_AP_CVMMEMCTL1_EL1 0
#define arguments_BDK_AP_CVMMEMCTL1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvmmemctl2_el1
 *
 * AP Cavium Memory Control 2 Register
 * This register controls additional memory-unit features.
 * Internal:
 * Back-end, non-debug.
 */
union bdk_ap_cvmmemctl2_el1
{
    uint64_t u;
    struct bdk_ap_cvmmemctl2_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t rsvd_63_60            : 4;  /**< [ 63: 60](R/W) Reserved. */
        uint64_t tlbiremotegsyncall    : 1;  /**< [ 59: 59](R/W) Remote TLBI apply GSYNC semantics.  For diagnostic use only. */
        uint64_t tlbiremotemultidis    : 1;  /**< [ 58: 58](R/W) Remote TLBI multiple processing disable.  For diagnostic use only. */
        uint64_t tlbiremotebatchdis    : 1;  /**< [ 57: 57](R/W) Remote TLBI batch processing disable.  For diagnostic use only. */
        uint64_t l1dwaysm1             : 6;  /**< [ 56: 51](R/W) Number of L1D WAYS minus one. */
        uint64_t wbfentriesm1          : 5;  /**< [ 50: 46](R/W) Number of MAF WBUF entries minus one. */
        uint64_t rbfentriesm1          : 4;  /**< [ 45: 42](R/W) Number of MAF RBUF entries minus one. */
        uint64_t ptwspecdis            : 1;  /**< [ 41: 41](R/W) Disable page table walker access on speculative instructions. */
        uint64_t ptwprefudis           : 1;  /**< [ 40: 40](R/W) Disable page table walker access on PREFU instructions. */
        uint64_t ptwdhwprefdis         : 1;  /**< [ 39: 39](R/W) Disable page table walker access on dstream hardware prefetches. */
        uint64_t ptwdswprefdis         : 1;  /**< [ 38: 38](R/W) Disable page table walker access on dstream software prefetches. */
        uint64_t ptwihwprefdis         : 1;  /**< [ 37: 37](R/W) Disable page table walker access on istream hardware prefetches. */
        uint64_t ptwiswprefdis         : 1;  /**< [ 36: 36](R/W) Disable page table walker access on istream software prefetches. */
        uint64_t mtlbdhwprefdis        : 1;  /**< [ 35: 35](R/W) Disable MTLB access on dstream hardware prefetches. */
        uint64_t mtlbdswprefdis        : 1;  /**< [ 34: 34](R/W) Disable MTLB access on dstream software prefetches. */
        uint64_t mtlbihwprefdis        : 1;  /**< [ 33: 33](R/W) Disable MTLB access on istream hardware prefetches. */
        uint64_t mtlbiswprefdis        : 1;  /**< [ 32: 32](R/W) Disable MTLB access on istream software prefetches. */
        uint64_t rsvd_25_31            : 7;  /**< [ 31: 25](R/W) Reserved. */
        uint64_t tlbi_block_msk        : 9;  /**< [ 24: 16](R/W) Mask of block sizes that are precisely invalidated by TLBI instructions.
                                                                 For each bit {a} in this field:
                                                                 _ Mask\<{a}\>=0 = blocksize {a} is not precisely invalidated.
                                                                 _ Mask\<{a}\>=1 = blocksize {a} is     precisely invalidated.

                                                                 _ Mask\<0\> represents block size 2^12.
                                                                 _ Mask\<1\> represents block size 2^14.
                                                                 _ Mask\<2\> represents block size 2^16.
                                                                 _ Mask\<3\> represents block size 2^21.
                                                                 _ Mask\<4\> represents block size 2^25.
                                                                 _ Mask\<5\> represents block size 2^29.
                                                                 _ Mask\<6\> represents block size 2^30.
                                                                 _ Mask\<7\> represents block size 2^34.
                                                                 _ Mask\<8\> represents block size 2^42. */
        uint64_t rsvd_9_15             : 7;  /**< [ 15:  9](R/W) Reserved. */
        uint64_t mtlb0_block_msk       : 9;  /**< [  8:  0](R/W) Mask of block sizes that are allocated in MTLB0.
                                                                 For each bit {a} in this field:
                                                                 _ Mask\<{a}\>=0 = blocksize {a} allocated in MTLB1.
                                                                 _ Mask\<{a}\>=1 = blocksize {a} allocated in MTLB0.

                                                                 _ Mask\<0\> represents block size 2^12.
                                                                 _ Mask\<1\> represents block size 2^14.
                                                                 _ Mask\<2\> represents block size 2^16.
                                                                 _ Mask\<3\> represents block size 2^21.
                                                                 _ Mask\<4\> represents block size 2^25.
                                                                 _ Mask\<5\> represents block size 2^29.
                                                                 _ Mask\<6\> represents block size 2^30.
                                                                 _ Mask\<7\> represents block size 2^34.
                                                                 _ Mask\<8\> represents block size 2^42. */
#else /* Word 0 - Little Endian */
        uint64_t mtlb0_block_msk       : 9;  /**< [  8:  0](R/W) Mask of block sizes that are allocated in MTLB0.
                                                                 For each bit {a} in this field:
                                                                 _ Mask\<{a}\>=0 = blocksize {a} allocated in MTLB1.
                                                                 _ Mask\<{a}\>=1 = blocksize {a} allocated in MTLB0.

                                                                 _ Mask\<0\> represents block size 2^12.
                                                                 _ Mask\<1\> represents block size 2^14.
                                                                 _ Mask\<2\> represents block size 2^16.
                                                                 _ Mask\<3\> represents block size 2^21.
                                                                 _ Mask\<4\> represents block size 2^25.
                                                                 _ Mask\<5\> represents block size 2^29.
                                                                 _ Mask\<6\> represents block size 2^30.
                                                                 _ Mask\<7\> represents block size 2^34.
                                                                 _ Mask\<8\> represents block size 2^42. */
        uint64_t rsvd_9_15             : 7;  /**< [ 15:  9](R/W) Reserved. */
        uint64_t tlbi_block_msk        : 9;  /**< [ 24: 16](R/W) Mask of block sizes that are precisely invalidated by TLBI instructions.
                                                                 For each bit {a} in this field:
                                                                 _ Mask\<{a}\>=0 = blocksize {a} is not precisely invalidated.
                                                                 _ Mask\<{a}\>=1 = blocksize {a} is     precisely invalidated.

                                                                 _ Mask\<0\> represents block size 2^12.
                                                                 _ Mask\<1\> represents block size 2^14.
                                                                 _ Mask\<2\> represents block size 2^16.
                                                                 _ Mask\<3\> represents block size 2^21.
                                                                 _ Mask\<4\> represents block size 2^25.
                                                                 _ Mask\<5\> represents block size 2^29.
                                                                 _ Mask\<6\> represents block size 2^30.
                                                                 _ Mask\<7\> represents block size 2^34.
                                                                 _ Mask\<8\> represents block size 2^42. */
        uint64_t rsvd_25_31            : 7;  /**< [ 31: 25](R/W) Reserved. */
        uint64_t mtlbiswprefdis        : 1;  /**< [ 32: 32](R/W) Disable MTLB access on istream software prefetches. */
        uint64_t mtlbihwprefdis        : 1;  /**< [ 33: 33](R/W) Disable MTLB access on istream hardware prefetches. */
        uint64_t mtlbdswprefdis        : 1;  /**< [ 34: 34](R/W) Disable MTLB access on dstream software prefetches. */
        uint64_t mtlbdhwprefdis        : 1;  /**< [ 35: 35](R/W) Disable MTLB access on dstream hardware prefetches. */
        uint64_t ptwiswprefdis         : 1;  /**< [ 36: 36](R/W) Disable page table walker access on istream software prefetches. */
        uint64_t ptwihwprefdis         : 1;  /**< [ 37: 37](R/W) Disable page table walker access on istream hardware prefetches. */
        uint64_t ptwdswprefdis         : 1;  /**< [ 38: 38](R/W) Disable page table walker access on dstream software prefetches. */
        uint64_t ptwdhwprefdis         : 1;  /**< [ 39: 39](R/W) Disable page table walker access on dstream hardware prefetches. */
        uint64_t ptwprefudis           : 1;  /**< [ 40: 40](R/W) Disable page table walker access on PREFU instructions. */
        uint64_t ptwspecdis            : 1;  /**< [ 41: 41](R/W) Disable page table walker access on speculative instructions. */
        uint64_t rbfentriesm1          : 4;  /**< [ 45: 42](R/W) Number of MAF RBUF entries minus one. */
        uint64_t wbfentriesm1          : 5;  /**< [ 50: 46](R/W) Number of MAF WBUF entries minus one. */
        uint64_t l1dwaysm1             : 6;  /**< [ 56: 51](R/W) Number of L1D WAYS minus one. */
        uint64_t tlbiremotebatchdis    : 1;  /**< [ 57: 57](R/W) Remote TLBI batch processing disable.  For diagnostic use only. */
        uint64_t tlbiremotemultidis    : 1;  /**< [ 58: 58](R/W) Remote TLBI multiple processing disable.  For diagnostic use only. */
        uint64_t tlbiremotegsyncall    : 1;  /**< [ 59: 59](R/W) Remote TLBI apply GSYNC semantics.  For diagnostic use only. */
        uint64_t rsvd_63_60            : 4;  /**< [ 63: 60](R/W) Reserved. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvmmemctl2_el1_s cn; */
};
typedef union bdk_ap_cvmmemctl2_el1 bdk_ap_cvmmemctl2_el1_t;

#define BDK_AP_CVMMEMCTL2_EL1 BDK_AP_CVMMEMCTL2_EL1_FUNC()
static inline uint64_t BDK_AP_CVMMEMCTL2_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVMMEMCTL2_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000b000600ll;
    __bdk_csr_fatal("AP_CVMMEMCTL2_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVMMEMCTL2_EL1 bdk_ap_cvmmemctl2_el1_t
#define bustype_BDK_AP_CVMMEMCTL2_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVMMEMCTL2_EL1 "AP_CVMMEMCTL2_EL1"
#define busnum_BDK_AP_CVMMEMCTL2_EL1 0
#define arguments_BDK_AP_CVMMEMCTL2_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_cvmmemctl3_el1
 *
 * AP Cavium Memory Control 3 Register
 * This register controls additional memory-unit features.
 * Internal:
 * Back-end, non-debug.
 */
union bdk_ap_cvmmemctl3_el1
{
    uint64_t u;
    struct bdk_ap_cvmmemctl3_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t rsvd_63_12            : 52; /**< [ 63: 12](RAZ) Reserved. */
        uint64_t iopredclrfreq         : 4;  /**< [ 11:  8](R/W) IO predictor clear frequency. For diagnostic use only. */
        uint64_t unalignpredclrfreq    : 4;  /**< [  7:  4](R/W) Unaligned predictor clear frequency. For diagnostic use only. */
        uint64_t ldstpredclrfreq       : 4;  /**< [  3:  0](R/W) Load-store predictor clear frequency. For diagnostic use only. */
#else /* Word 0 - Little Endian */
        uint64_t ldstpredclrfreq       : 4;  /**< [  3:  0](R/W) Load-store predictor clear frequency. For diagnostic use only. */
        uint64_t unalignpredclrfreq    : 4;  /**< [  7:  4](R/W) Unaligned predictor clear frequency. For diagnostic use only. */
        uint64_t iopredclrfreq         : 4;  /**< [ 11:  8](R/W) IO predictor clear frequency. For diagnostic use only. */
        uint64_t rsvd_63_12            : 52; /**< [ 63: 12](RAZ) Reserved. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_cvmmemctl3_el1_s cn; */
};
typedef union bdk_ap_cvmmemctl3_el1 bdk_ap_cvmmemctl3_el1_t;

#define BDK_AP_CVMMEMCTL3_EL1 BDK_AP_CVMMEMCTL3_EL1_FUNC()
static inline uint64_t BDK_AP_CVMMEMCTL3_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_CVMMEMCTL3_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000b000700ll;
    __bdk_csr_fatal("AP_CVMMEMCTL3_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_CVMMEMCTL3_EL1 bdk_ap_cvmmemctl3_el1_t
#define bustype_BDK_AP_CVMMEMCTL3_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_CVMMEMCTL3_EL1 "AP_CVMMEMCTL3_EL1"
#define busnum_BDK_AP_CVMMEMCTL3_EL1 0
#define arguments_BDK_AP_CVMMEMCTL3_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dacr32_el2
 *
 * AP Domain Access Control Register
 * Allows access to the AArch32 DACR register from AArch64 state
 *     only. Its value has no effect on execution in AArch64 state.
 */
union bdk_ap_dacr32_el2
{
    uint32_t u;
    struct bdk_ap_dacr32_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dacr32_el2_s cn; */
};
typedef union bdk_ap_dacr32_el2 bdk_ap_dacr32_el2_t;

#define BDK_AP_DACR32_EL2 BDK_AP_DACR32_EL2_FUNC()
static inline uint64_t BDK_AP_DACR32_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DACR32_EL2_FUNC(void)
{
    return 0x30403000000ll;
}

#define typedef_BDK_AP_DACR32_EL2 bdk_ap_dacr32_el2_t
#define bustype_BDK_AP_DACR32_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DACR32_EL2 "AP_DACR32_EL2"
#define busnum_BDK_AP_DACR32_EL2 0
#define arguments_BDK_AP_DACR32_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_daif
 *
 * AP Interrupt Mask Bits Register
 * Allows access to the interrupt mask bits.
 */
union bdk_ap_daif
{
    uint32_t u;
    struct bdk_ap_daif_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_10_31        : 22;
        uint32_t dd                    : 1;  /**< [  9:  9](R/W) Process state D mask.
                                                                 When the target Exception level of the debug exception is not
                                                                     than the current Exception level, the exception is not masked
                                                                     by this bit.
                                                                 0 = Debug exceptions from Watchpoint, Breakpoint, and Software
                                                                     step debug events targeted at the current Exception level are
                                                                     not masked.
                                                                 1 = Debug exceptions from Watchpoint, Breakpoint, and Software
                                                                     step debug events targeted at the current Exception level are
                                                                     masked. */
        uint32_t aa                    : 1;  /**< [  8:  8](R/W) SError (System Error) mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t i                     : 1;  /**< [  7:  7](R/W) IRQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t f                     : 1;  /**< [  6:  6](R/W) FIQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t reserved_0_5          : 6;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_5          : 6;
        uint32_t f                     : 1;  /**< [  6:  6](R/W) FIQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t i                     : 1;  /**< [  7:  7](R/W) IRQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t aa                    : 1;  /**< [  8:  8](R/W) SError (System Error) mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t dd                    : 1;  /**< [  9:  9](R/W) Process state D mask.
                                                                 When the target Exception level of the debug exception is not
                                                                     than the current Exception level, the exception is not masked
                                                                     by this bit.
                                                                 0 = Debug exceptions from Watchpoint, Breakpoint, and Software
                                                                     step debug events targeted at the current Exception level are
                                                                     not masked.
                                                                 1 = Debug exceptions from Watchpoint, Breakpoint, and Software
                                                                     step debug events targeted at the current Exception level are
                                                                     masked. */
        uint32_t reserved_10_31        : 22;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_daif_s cn; */
};
typedef union bdk_ap_daif bdk_ap_daif_t;

#define BDK_AP_DAIF BDK_AP_DAIF_FUNC()
static inline uint64_t BDK_AP_DAIF_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DAIF_FUNC(void)
{
    return 0x30304020100ll;
}

#define typedef_BDK_AP_DAIF bdk_ap_daif_t
#define bustype_BDK_AP_DAIF BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DAIF "AP_DAIF"
#define busnum_BDK_AP_DAIF 0
#define arguments_BDK_AP_DAIF -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgauthstatus_el1
 *
 * AP Debug Authentication Status Register
 * Provides information about the state of the implementation
 *     defined authentication interface for debug.
 */
union bdk_ap_dbgauthstatus_el1
{
    uint32_t u;
    struct bdk_ap_dbgauthstatus_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_8_31         : 24;
        uint32_t snid                  : 2;  /**< [  7:  6](RO) Secure non-invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                     nonsecure.
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t sid                   : 2;  /**< [  5:  4](RO) Secure invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                     nonsecure.
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t nsnid                 : 2;  /**< [  3:  2](RO) Nonsecure non-invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                     Secure.
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t nsid                  : 2;  /**< [  1:  0](RO) Nonsecure invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
#else /* Word 0 - Little Endian */
        uint32_t nsid                  : 2;  /**< [  1:  0](RO) Nonsecure invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t nsnid                 : 2;  /**< [  3:  2](RO) Nonsecure non-invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                     Secure.
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t sid                   : 2;  /**< [  5:  4](RO) Secure invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                     nonsecure.
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t snid                  : 2;  /**< [  7:  6](RO) Secure non-invasive debug.
                                                                 0x0 = Not implemented. EL3 is not implemented and the processor is
                                                                     nonsecure.
                                                                 0x2 = Implemented and disabled.
                                                                 0x3 = Implemented and enabled. */
        uint32_t reserved_8_31         : 24;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgauthstatus_el1_s cn; */
};
typedef union bdk_ap_dbgauthstatus_el1 bdk_ap_dbgauthstatus_el1_t;

#define BDK_AP_DBGAUTHSTATUS_EL1 BDK_AP_DBGAUTHSTATUS_EL1_FUNC()
static inline uint64_t BDK_AP_DBGAUTHSTATUS_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGAUTHSTATUS_EL1_FUNC(void)
{
    return 0x200070e0600ll;
}

#define typedef_BDK_AP_DBGAUTHSTATUS_EL1 bdk_ap_dbgauthstatus_el1_t
#define bustype_BDK_AP_DBGAUTHSTATUS_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGAUTHSTATUS_EL1 "AP_DBGAUTHSTATUS_EL1"
#define busnum_BDK_AP_DBGAUTHSTATUS_EL1 0
#define arguments_BDK_AP_DBGAUTHSTATUS_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgbcr#_el1
 *
 * AP Debug Breakpoint Control Registers
 * Holds control information for a breakpoint. Forms breakpoint n
 *     together with value register DBGBVR\<n\>_EL1, where n is 0 to
 *     15.
 */
union bdk_ap_dbgbcrx_el1
{
    uint32_t u;
    struct bdk_ap_dbgbcrx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_24_31        : 8;
        uint32_t bt                    : 4;  /**< [ 23: 20](R/W) Breakpoint Type.
                                                                 The field breaks down as follows:
                                                                  BT[3:1]: Base type.- 0b000: Match address. DBGBVR\<n\>_EL1 is
                                                                     the address of an     instruction. - 0b010: Mismatch address.
                                                                     Behaves as type0b000 DBGBVR\<n\>_EL1     is the address of an
                                                                     instruction to be stepped. - 0b001: Match context ID.
                                                                     DBGBVR\<n\>_EL1[31:0] is a context     ID. - 0b100: Match VMID.
                                                                     DBGBVR\<n\>_EL1[39:32] is a VMID. - 0b101: Match VMID and
                                                                     context ID. DBGBVR\<n\>_EL1[31:0] is a     context ID, and
                                                                     DBGBVR\<n\>_EL1[39:32] is a VMID.
                                                                  BT[0]: Enable linking.

                                                                 If the breakpoint is not context-aware, BT[3] and BT[1] are
                                                                     RES0. If EL2 is not implemented, BT[3] is RES0. If EL1 using
                                                                     AArch32 is not implemented, BT[2] is RES0.

                                                                 0x0 = Unlinked address match.
                                                                 0x1 = Linked address match.
                                                                 0x2 = Unlinked context ID match.
                                                                 0x3 = Linked context ID match
                                                                 0x4 = Unlinked address mismatch.
                                                                 0x5 = Linked address mismatch.
                                                                 0x8 = Unlinked VMID match.
                                                                 0x9 = Linked VMID match.
                                                                 0xA = Unlinked VMID and context ID match.
                                                                 0xB = Linked VMID and context ID match. */
        uint32_t lbn                   : 4;  /**< [ 19: 16](R/W) Linked breakpoint number. For Linked address matching
                                                                     breakpoints, this specifies the index of the Context-matching
                                                                     breakpoint linked to. */
        uint32_t ssc                   : 2;  /**< [ 15: 14](R/W) Security state control. Determines the Security states under
                                                                     which a breakpoint debug event for breakpoint n is generated.
                                                                     This field must be interpreted along with the HMC and PMC
                                                                     fields. */
        uint32_t hmc                   : 1;  /**< [ 13: 13](R/W) Higher mode control. Determines the debug perspective for
                                                                     deciding when a breakpoint debug event for breakpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and PMC fields. */
        uint32_t reserved_9_12         : 4;
        uint32_t rsvd_5_8              : 4;  /**< [  8:  5](RO) Byte address select. Defines which half-words an address-
                                                                     matching breakpoint matches, regardless of the instruction set
                                                                     and Execution state. In an AArch64-only implementation, this
                                                                     field is reserved, RES1. Otherwise:

                                                                  BAS[2] and BAS[0] are read/write.

                                                                  BAS[3] and BAS[1] are read-only copies of BAS[2] and BAS[0]
                                                                     respectively.

                                                                 The permitted values depend on the breakpoint type.

                                                                 For Address match breakpoints in either AArch32 or AArch64
                                                                     state:
                                                                 BAS Match instruction at    Constraint for debuggers
                                                                 0b0011       DBGBVR\<n\>_EL1  Use for T32 instructions.
                                                                 0b1100       DBGBVR\<n\>_EL1+2        Use for T32 instructions.
                                                                 0b1111       DBGBVR\<n\>_EL1  Use for A64 and A32 instructions.
                                                                 0b0000

                                                                 For Address mismatch breakpoints in an AArch32 stage 1
                                                                     translation regime:
                                                                 BAS Step instruction at     Constraint for debuggers
                                                                 0b0000      -       Use for a match anywhere breakpoint.
                                                                 0b0011       DBGBVR\<n\>_EL1  Use for stepping T32 instructions.
                                                                 0b1100       DBGBVR\<n\>_EL1+2        Use for stepping T32 instructions.
                                                                 0b1111       DBGBVR\<n\>_EL1  Use for stepping A32 instructions.

                                                                 For Context matching breakpoints, this field is RES1 and
                                                                     ignored. */
        uint32_t reserved_3_4          : 2;
        uint32_t pmc                   : 2;  /**< [  2:  1](R/W) Privilege mode control. Determines the Exception level or
                                                                     levels at which a breakpoint debug event for breakpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and HMC fields. */
        uint32_t ee                    : 1;  /**< [  0:  0](R/W) Enable breakpoint DBGBVR\<n\>_EL1.
                                                                 0 = Breakpoint disabled.
                                                                 1 = Breakpoint enabled. */
#else /* Word 0 - Little Endian */
        uint32_t ee                    : 1;  /**< [  0:  0](R/W) Enable breakpoint DBGBVR\<n\>_EL1.
                                                                 0 = Breakpoint disabled.
                                                                 1 = Breakpoint enabled. */
        uint32_t pmc                   : 2;  /**< [  2:  1](R/W) Privilege mode control. Determines the Exception level or
                                                                     levels at which a breakpoint debug event for breakpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and HMC fields. */
        uint32_t reserved_3_4          : 2;
        uint32_t rsvd_5_8              : 4;  /**< [  8:  5](RO) Byte address select. Defines which half-words an address-
                                                                     matching breakpoint matches, regardless of the instruction set
                                                                     and Execution state. In an AArch64-only implementation, this
                                                                     field is reserved, RES1. Otherwise:

                                                                  BAS[2] and BAS[0] are read/write.

                                                                  BAS[3] and BAS[1] are read-only copies of BAS[2] and BAS[0]
                                                                     respectively.

                                                                 The permitted values depend on the breakpoint type.

                                                                 For Address match breakpoints in either AArch32 or AArch64
                                                                     state:
                                                                 BAS Match instruction at    Constraint for debuggers
                                                                 0b0011       DBGBVR\<n\>_EL1  Use for T32 instructions.
                                                                 0b1100       DBGBVR\<n\>_EL1+2        Use for T32 instructions.
                                                                 0b1111       DBGBVR\<n\>_EL1  Use for A64 and A32 instructions.
                                                                 0b0000

                                                                 For Address mismatch breakpoints in an AArch32 stage 1
                                                                     translation regime:
                                                                 BAS Step instruction at     Constraint for debuggers
                                                                 0b0000      -       Use for a match anywhere breakpoint.
                                                                 0b0011       DBGBVR\<n\>_EL1  Use for stepping T32 instructions.
                                                                 0b1100       DBGBVR\<n\>_EL1+2        Use for stepping T32 instructions.
                                                                 0b1111       DBGBVR\<n\>_EL1  Use for stepping A32 instructions.

                                                                 For Context matching breakpoints, this field is RES1 and
                                                                     ignored. */
        uint32_t reserved_9_12         : 4;
        uint32_t hmc                   : 1;  /**< [ 13: 13](R/W) Higher mode control. Determines the debug perspective for
                                                                     deciding when a breakpoint debug event for breakpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and PMC fields. */
        uint32_t ssc                   : 2;  /**< [ 15: 14](R/W) Security state control. Determines the Security states under
                                                                     which a breakpoint debug event for breakpoint n is generated.
                                                                     This field must be interpreted along with the HMC and PMC
                                                                     fields. */
        uint32_t lbn                   : 4;  /**< [ 19: 16](R/W) Linked breakpoint number. For Linked address matching
                                                                     breakpoints, this specifies the index of the Context-matching
                                                                     breakpoint linked to. */
        uint32_t bt                    : 4;  /**< [ 23: 20](R/W) Breakpoint Type.
                                                                 The field breaks down as follows:
                                                                  BT[3:1]: Base type.- 0b000: Match address. DBGBVR\<n\>_EL1 is
                                                                     the address of an     instruction. - 0b010: Mismatch address.
                                                                     Behaves as type0b000 DBGBVR\<n\>_EL1     is the address of an
                                                                     instruction to be stepped. - 0b001: Match context ID.
                                                                     DBGBVR\<n\>_EL1[31:0] is a context     ID. - 0b100: Match VMID.
                                                                     DBGBVR\<n\>_EL1[39:32] is a VMID. - 0b101: Match VMID and
                                                                     context ID. DBGBVR\<n\>_EL1[31:0] is a     context ID, and
                                                                     DBGBVR\<n\>_EL1[39:32] is a VMID.
                                                                  BT[0]: Enable linking.

                                                                 If the breakpoint is not context-aware, BT[3] and BT[1] are
                                                                     RES0. If EL2 is not implemented, BT[3] is RES0. If EL1 using
                                                                     AArch32 is not implemented, BT[2] is RES0.

                                                                 0x0 = Unlinked address match.
                                                                 0x1 = Linked address match.
                                                                 0x2 = Unlinked context ID match.
                                                                 0x3 = Linked context ID match
                                                                 0x4 = Unlinked address mismatch.
                                                                 0x5 = Linked address mismatch.
                                                                 0x8 = Unlinked VMID match.
                                                                 0x9 = Linked VMID match.
                                                                 0xA = Unlinked VMID and context ID match.
                                                                 0xB = Linked VMID and context ID match. */
        uint32_t reserved_24_31        : 8;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgbcrx_el1_s cn; */
};
typedef union bdk_ap_dbgbcrx_el1 bdk_ap_dbgbcrx_el1_t;

static inline uint64_t BDK_AP_DBGBCRX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGBCRX_EL1(unsigned long a)
{
    if (a<=15)
        return 0x20000000500ll + 0x10000ll * ((a) & 0xf);
    __bdk_csr_fatal("AP_DBGBCRX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_DBGBCRX_EL1(a) bdk_ap_dbgbcrx_el1_t
#define bustype_BDK_AP_DBGBCRX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGBCRX_EL1(a) "AP_DBGBCRX_EL1"
#define busnum_BDK_AP_DBGBCRX_EL1(a) (a)
#define arguments_BDK_AP_DBGBCRX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_dbgbvr#_el1
 *
 * AP Debug Breakpoint Value Registers
 * Holds a virtual address, or a VMID and/or a context ID, for
 *     use in breakpoint matching. Forms breakpoint n together with
 *     control register DBGBCR\<n\>_EL1, where n is 0 to 15.
 */
union bdk_ap_dbgbvrx_el1
{
    uint64_t u;
    struct bdk_ap_dbgbvrx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data for breakpoint value. This doesn't match ARM docs as
                                                                 they have many encoding of the same register.
                                                                 Reserved, Sign extended. Hardwired to the value of the sign
                                                                     bit, bit [48]. Hardware and software must treat this field as
                                                                     RES0 if bit[48] is 0, and as RES1 if bit[48] is 1. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data for breakpoint value. This doesn't match ARM docs as
                                                                 they have many encoding of the same register.
                                                                 Reserved, Sign extended. Hardwired to the value of the sign
                                                                     bit, bit [48]. Hardware and software must treat this field as
                                                                     RES0 if bit[48] is 0, and as RES1 if bit[48] is 1. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgbvrx_el1_s cn; */
};
typedef union bdk_ap_dbgbvrx_el1 bdk_ap_dbgbvrx_el1_t;

static inline uint64_t BDK_AP_DBGBVRX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGBVRX_EL1(unsigned long a)
{
    if (a<=15)
        return 0x20000000400ll + 0x10000ll * ((a) & 0xf);
    __bdk_csr_fatal("AP_DBGBVRX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_DBGBVRX_EL1(a) bdk_ap_dbgbvrx_el1_t
#define bustype_BDK_AP_DBGBVRX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGBVRX_EL1(a) "AP_DBGBVRX_EL1"
#define busnum_BDK_AP_DBGBVRX_EL1(a) (a)
#define arguments_BDK_AP_DBGBVRX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_dbgclaimclr_el1
 *
 * AP Debug Claim Tag Clear Register
 * Used by software to read the values of the CLAIM bits, and to
 *     clear these bits to 0.
 */
union bdk_ap_dbgclaimclr_el1
{
    uint32_t u;
    struct bdk_ap_dbgclaimclr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_8_31         : 24;
        uint32_t claim                 : 8;  /**< [  7:  0](R/W) Claim clear bits. Reading this field returns the current value
                                                                     of the CLAIM bits.
                                                                 Writing a 1 to one of these bits clears the corresponding
                                                                     CLAIM bit to 0. This is an indirect write to the CLAIM bits.
                                                                 A single write operation can clear multiple bits to 0. Writing
                                                                     0 to one of these bits has no effect. */
#else /* Word 0 - Little Endian */
        uint32_t claim                 : 8;  /**< [  7:  0](R/W) Claim clear bits. Reading this field returns the current value
                                                                     of the CLAIM bits.
                                                                 Writing a 1 to one of these bits clears the corresponding
                                                                     CLAIM bit to 0. This is an indirect write to the CLAIM bits.
                                                                 A single write operation can clear multiple bits to 0. Writing
                                                                     0 to one of these bits has no effect. */
        uint32_t reserved_8_31         : 24;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgclaimclr_el1_s cn; */
};
typedef union bdk_ap_dbgclaimclr_el1 bdk_ap_dbgclaimclr_el1_t;

#define BDK_AP_DBGCLAIMCLR_EL1 BDK_AP_DBGCLAIMCLR_EL1_FUNC()
static inline uint64_t BDK_AP_DBGCLAIMCLR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGCLAIMCLR_EL1_FUNC(void)
{
    return 0x20007090600ll;
}

#define typedef_BDK_AP_DBGCLAIMCLR_EL1 bdk_ap_dbgclaimclr_el1_t
#define bustype_BDK_AP_DBGCLAIMCLR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGCLAIMCLR_EL1 "AP_DBGCLAIMCLR_EL1"
#define busnum_BDK_AP_DBGCLAIMCLR_EL1 0
#define arguments_BDK_AP_DBGCLAIMCLR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgclaimset_el1
 *
 * AP Debug Claim Tag Set Register
 * Used by software to set CLAIM bits to 1.
 */
union bdk_ap_dbgclaimset_el1
{
    uint32_t u;
    struct bdk_ap_dbgclaimset_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_8_31         : 24;
        uint32_t claim                 : 8;  /**< [  7:  0](R/W) Claim set bits. RAO.
                                                                 Writing a 1 to one of these bits sets the corresponding CLAIM
                                                                     bit to 1. This is an indirect write to the CLAIM bits.
                                                                 A single write operation can set multiple bits to 1. Writing 0
                                                                     to one of these bits has no effect. */
#else /* Word 0 - Little Endian */
        uint32_t claim                 : 8;  /**< [  7:  0](R/W) Claim set bits. RAO.
                                                                 Writing a 1 to one of these bits sets the corresponding CLAIM
                                                                     bit to 1. This is an indirect write to the CLAIM bits.
                                                                 A single write operation can set multiple bits to 1. Writing 0
                                                                     to one of these bits has no effect. */
        uint32_t reserved_8_31         : 24;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgclaimset_el1_s cn; */
};
typedef union bdk_ap_dbgclaimset_el1 bdk_ap_dbgclaimset_el1_t;

#define BDK_AP_DBGCLAIMSET_EL1 BDK_AP_DBGCLAIMSET_EL1_FUNC()
static inline uint64_t BDK_AP_DBGCLAIMSET_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGCLAIMSET_EL1_FUNC(void)
{
    return 0x20007080600ll;
}

#define typedef_BDK_AP_DBGCLAIMSET_EL1 bdk_ap_dbgclaimset_el1_t
#define bustype_BDK_AP_DBGCLAIMSET_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGCLAIMSET_EL1 "AP_DBGCLAIMSET_EL1"
#define busnum_BDK_AP_DBGCLAIMSET_EL1 0
#define arguments_BDK_AP_DBGCLAIMSET_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgdtr_el0
 *
 * AP Debug Data Transfer Half-Duplex Register
 * Transfers 64 bits of data between the processor and an
 *     external host. Can transfer both ways using only a single
 *     register.
 */
union bdk_ap_dbgdtr_el0
{
    uint64_t u;
    struct bdk_ap_dbgdtr_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t highword              : 32; /**< [ 63: 32](R/W) Writes to this register set DTRRX to the value in this field.
                                                                     Reads from this register return the value of DTRTX. */
        uint64_t lowword               : 32; /**< [ 31:  0](R/W) Writes to this register set DTRTX to the value in this field.
                                                                     Reads from this register return the value of DTRRX. */
#else /* Word 0 - Little Endian */
        uint64_t lowword               : 32; /**< [ 31:  0](R/W) Writes to this register set DTRTX to the value in this field.
                                                                     Reads from this register return the value of DTRRX. */
        uint64_t highword              : 32; /**< [ 63: 32](R/W) Writes to this register set DTRRX to the value in this field.
                                                                     Reads from this register return the value of DTRTX. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgdtr_el0_s cn; */
};
typedef union bdk_ap_dbgdtr_el0 bdk_ap_dbgdtr_el0_t;

#define BDK_AP_DBGDTR_EL0 BDK_AP_DBGDTR_EL0_FUNC()
static inline uint64_t BDK_AP_DBGDTR_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGDTR_EL0_FUNC(void)
{
    return 0x20300040000ll;
}

#define typedef_BDK_AP_DBGDTR_EL0 bdk_ap_dbgdtr_el0_t
#define bustype_BDK_AP_DBGDTR_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGDTR_EL0 "AP_DBGDTR_EL0"
#define busnum_BDK_AP_DBGDTR_EL0 0
#define arguments_BDK_AP_DBGDTR_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgdtrrx_el0
 *
 * AP Debug Data Transfer Receive Register
 * Transfers 32 bits of data from an external host to the
 *     processor.
 *
 * This register is at the same select as AP_DBGDTRTX_EL0.
 */
union bdk_ap_dbgdtrrx_el0
{
    uint32_t u;
    struct bdk_ap_dbgdtrrx_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](RO) Host to target data
                                                                 Host to target data. One word of data for transfer from the
                                                                     debug host to the debug target.
                                                                 For the full behavior of the Debug Communications Channel, see
                                                                     section 9 (The Debug Communications Channel and Instruction
                                                                     Transfer Register) in document PRD03-PRDC-010486. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](RO) Host to target data
                                                                 Host to target data. One word of data for transfer from the
                                                                     debug host to the debug target.
                                                                 For the full behavior of the Debug Communications Channel, see
                                                                     section 9 (The Debug Communications Channel and Instruction
                                                                     Transfer Register) in document PRD03-PRDC-010486. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgdtrrx_el0_s cn; */
};
typedef union bdk_ap_dbgdtrrx_el0 bdk_ap_dbgdtrrx_el0_t;

#define BDK_AP_DBGDTRRX_EL0 BDK_AP_DBGDTRRX_EL0_FUNC()
static inline uint64_t BDK_AP_DBGDTRRX_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGDTRRX_EL0_FUNC(void)
{
    return 0x20300050000ll;
}

#define typedef_BDK_AP_DBGDTRRX_EL0 bdk_ap_dbgdtrrx_el0_t
#define bustype_BDK_AP_DBGDTRRX_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGDTRRX_EL0 "AP_DBGDTRRX_EL0"
#define busnum_BDK_AP_DBGDTRRX_EL0 0
#define arguments_BDK_AP_DBGDTRRX_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgdtrtx_el0
 *
 * AP Debug Data Transfer Transmit Register
 * Transfers 32 bits of data from the processor to an external
 *     host.
 *
 * This register is at the same select as AP_DBGDTRRX_EL0.
 */
union bdk_ap_dbgdtrtx_el0
{
    uint32_t u;
    struct bdk_ap_dbgdtrtx_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](RO) Target to host data. One word of data for transfer from the
                                                                     debug target to the debug host.
                                                                 For the full behavior of the Debug Communications Channel, see
                                                                     section 9 (The Debug Communications Channel and Instruction
                                                                     Transfer Register) in document PRD03-PRDC-010486. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](RO) Target to host data. One word of data for transfer from the
                                                                     debug target to the debug host.
                                                                 For the full behavior of the Debug Communications Channel, see
                                                                     section 9 (The Debug Communications Channel and Instruction
                                                                     Transfer Register) in document PRD03-PRDC-010486. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgdtrtx_el0_s cn8; */
    struct bdk_ap_dbgdtrtx_el0_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t data                  : 32; /**< [ 31:  0](WO) Target to host data. One word of data for transfer from the
                                                                     debug target to the debug host.
                                                                 For the full behavior of the Debug Communications Channel, see
                                                                     section 9 (The Debug Communications Channel and Instruction
                                                                     Transfer Register) in document PRD03-PRDC-010486. */
#else /* Word 0 - Little Endian */
        uint32_t data                  : 32; /**< [ 31:  0](WO) Target to host data. One word of data for transfer from the
                                                                     debug target to the debug host.
                                                                 For the full behavior of the Debug Communications Channel, see
                                                                     section 9 (The Debug Communications Channel and Instruction
                                                                     Transfer Register) in document PRD03-PRDC-010486. */
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_dbgdtrtx_el0 bdk_ap_dbgdtrtx_el0_t;

#define BDK_AP_DBGDTRTX_EL0 BDK_AP_DBGDTRTX_EL0_FUNC()
static inline uint64_t BDK_AP_DBGDTRTX_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGDTRTX_EL0_FUNC(void)
{
    return 0x20300050010ll;
}

#define typedef_BDK_AP_DBGDTRTX_EL0 bdk_ap_dbgdtrtx_el0_t
#define bustype_BDK_AP_DBGDTRTX_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGDTRTX_EL0 "AP_DBGDTRTX_EL0"
#define busnum_BDK_AP_DBGDTRTX_EL0 0
#define arguments_BDK_AP_DBGDTRTX_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgprcr_el1
 *
 * AP Debug Power Control Register
 * Controls behavior of processor on power-down request.
 */
union bdk_ap_dbgprcr_el1
{
    uint32_t u;
    struct bdk_ap_dbgprcr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_1_31         : 31;
        uint32_t corenpdrq             : 1;  /**< [  0:  0](R/W) Core no powerdown request. Requests emulation of powerdown.

                                                                 0 = On a powerdown request, the system powers down the Core power
                                                                     domain.
                                                                 1 = On a powerdown request, the system emulates powerdown of the
                                                                     Core power domain. In this emulation mode the Core power
                                                                     domain is not actually powered down. */
#else /* Word 0 - Little Endian */
        uint32_t corenpdrq             : 1;  /**< [  0:  0](R/W) Core no powerdown request. Requests emulation of powerdown.

                                                                 0 = On a powerdown request, the system powers down the Core power
                                                                     domain.
                                                                 1 = On a powerdown request, the system emulates powerdown of the
                                                                     Core power domain. In this emulation mode the Core power
                                                                     domain is not actually powered down. */
        uint32_t reserved_1_31         : 31;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgprcr_el1_s cn; */
};
typedef union bdk_ap_dbgprcr_el1 bdk_ap_dbgprcr_el1_t;

#define BDK_AP_DBGPRCR_EL1 BDK_AP_DBGPRCR_EL1_FUNC()
static inline uint64_t BDK_AP_DBGPRCR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGPRCR_EL1_FUNC(void)
{
    return 0x20001040400ll;
}

#define typedef_BDK_AP_DBGPRCR_EL1 bdk_ap_dbgprcr_el1_t
#define bustype_BDK_AP_DBGPRCR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGPRCR_EL1 "AP_DBGPRCR_EL1"
#define busnum_BDK_AP_DBGPRCR_EL1 0
#define arguments_BDK_AP_DBGPRCR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgvcr32_el2
 *
 * AP Debug Vector Catch Register
 * Allows access to the AArch32 register DBGVCR from AArch64
 *     state only. Its value has no effect on execution in AArch64
 *     state.
 */
union bdk_ap_dbgvcr32_el2
{
    uint32_t u;
    struct bdk_ap_dbgvcr32_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t nsf                   : 1;  /**< [ 31: 31](R/W) FIQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x1C. */
        uint32_t nsi                   : 1;  /**< [ 30: 30](R/W) IRQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t reserved_29           : 1;
        uint32_t nsd                   : 1;  /**< [ 28: 28](R/W) Data Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t nsp                   : 1;  /**< [ 27: 27](R/W) Prefetch Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t nss                   : 1;  /**< [ 26: 26](R/W) Supervisor Call (SVC) vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t nsu                   : 1;  /**< [ 25: 25](R/W) Undefined Instruction vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t reserved_8_24         : 17;
        uint32_t sf                    : 1;  /**< [  7:  7](R/W) FIQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x1C. */
        uint32_t si                    : 1;  /**< [  6:  6](R/W) IRQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t reserved_5            : 1;
        uint32_t sd                    : 1;  /**< [  4:  4](R/W) Data Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t sp                    : 1;  /**< [  3:  3](R/W) Prefetch Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t ss                    : 1;  /**< [  2:  2](R/W) Supervisor Call (SVC) vector catch enable in Secure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t su                    : 1;  /**< [  1:  1](R/W) Undefined Instruction vector catch enable in Secure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0            : 1;
        uint32_t su                    : 1;  /**< [  1:  1](R/W) Undefined Instruction vector catch enable in Secure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t ss                    : 1;  /**< [  2:  2](R/W) Supervisor Call (SVC) vector catch enable in Secure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t sp                    : 1;  /**< [  3:  3](R/W) Prefetch Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t sd                    : 1;  /**< [  4:  4](R/W) Data Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t reserved_5            : 1;
        uint32_t si                    : 1;  /**< [  6:  6](R/W) IRQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t sf                    : 1;  /**< [  7:  7](R/W) FIQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x1C. */
        uint32_t reserved_8_24         : 17;
        uint32_t nsu                   : 1;  /**< [ 25: 25](R/W) Undefined Instruction vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t nss                   : 1;  /**< [ 26: 26](R/W) Supervisor Call (SVC) vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t nsp                   : 1;  /**< [ 27: 27](R/W) Prefetch Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t nsd                   : 1;  /**< [ 28: 28](R/W) Data Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t reserved_29           : 1;
        uint32_t nsi                   : 1;  /**< [ 30: 30](R/W) IRQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t nsf                   : 1;  /**< [ 31: 31](R/W) FIQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x1C. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgvcr32_el2_s cn8; */
    struct bdk_ap_dbgvcr32_el2_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t nsf                   : 1;  /**< [ 31: 31](RAZ) FIQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x1C. */
        uint32_t nsi                   : 1;  /**< [ 30: 30](RAZ) IRQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t reserved_29           : 1;
        uint32_t nsd                   : 1;  /**< [ 28: 28](RAZ) Data Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t nsp                   : 1;  /**< [ 27: 27](RAZ) Prefetch Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t nss                   : 1;  /**< [ 26: 26](RAZ) Supervisor Call (SVC) vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t nsu                   : 1;  /**< [ 25: 25](RAZ) Undefined Instruction vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t reserved_8_24         : 17;
        uint32_t sf                    : 1;  /**< [  7:  7](RAZ) FIQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x1C. */
        uint32_t si                    : 1;  /**< [  6:  6](RAZ) IRQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t reserved_5            : 1;
        uint32_t sd                    : 1;  /**< [  4:  4](RAZ) Data Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t sp                    : 1;  /**< [  3:  3](RAZ) Prefetch Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t ss                    : 1;  /**< [  2:  2](RAZ) Supervisor Call (SVC) vector catch enable in Secure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t su                    : 1;  /**< [  1:  1](RAZ) Undefined Instruction vector catch enable in Secure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0            : 1;
        uint32_t su                    : 1;  /**< [  1:  1](RAZ) Undefined Instruction vector catch enable in Secure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t ss                    : 1;  /**< [  2:  2](RAZ) Supervisor Call (SVC) vector catch enable in Secure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t sp                    : 1;  /**< [  3:  3](RAZ) Prefetch Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t sd                    : 1;  /**< [  4:  4](RAZ) Data Abort vector catch enable in Secure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t reserved_5            : 1;
        uint32_t si                    : 1;  /**< [  6:  6](RAZ) IRQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t sf                    : 1;  /**< [  7:  7](RAZ) FIQ vector catch enable in Secure state.
                                                                 The exception vector offset is 0x1C. */
        uint32_t reserved_8_24         : 17;
        uint32_t nsu                   : 1;  /**< [ 25: 25](RAZ) Undefined Instruction vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x04. */
        uint32_t nss                   : 1;  /**< [ 26: 26](RAZ) Supervisor Call (SVC) vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x08. */
        uint32_t nsp                   : 1;  /**< [ 27: 27](RAZ) Prefetch Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x0C. */
        uint32_t nsd                   : 1;  /**< [ 28: 28](RAZ) Data Abort vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x10. */
        uint32_t reserved_29           : 1;
        uint32_t nsi                   : 1;  /**< [ 30: 30](RAZ) IRQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x18. */
        uint32_t nsf                   : 1;  /**< [ 31: 31](RAZ) FIQ vector catch enable in nonsecure state.
                                                                 The exception vector offset is 0x1C. */
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_dbgvcr32_el2 bdk_ap_dbgvcr32_el2_t;

#define BDK_AP_DBGVCR32_EL2 BDK_AP_DBGVCR32_EL2_FUNC()
static inline uint64_t BDK_AP_DBGVCR32_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGVCR32_EL2_FUNC(void)
{
    return 0x20400070000ll;
}

#define typedef_BDK_AP_DBGVCR32_EL2 bdk_ap_dbgvcr32_el2_t
#define bustype_BDK_AP_DBGVCR32_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGVCR32_EL2 "AP_DBGVCR32_EL2"
#define busnum_BDK_AP_DBGVCR32_EL2 0
#define arguments_BDK_AP_DBGVCR32_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dbgwcr#_el1
 *
 * AP Debug Watchpoint Control Registers
 * Holds control information for a watchpoint. Forms watchpoint n
 *     together with value register DBGWVR\<n\>_EL1, where n is 0 to
 *     15.
 */
union bdk_ap_dbgwcrx_el1
{
    uint32_t u;
    struct bdk_ap_dbgwcrx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_29_31        : 3;
        uint32_t mask                  : 5;  /**< [ 28: 24](R/W) Address mask. Only objects up to 2GB can be watched using a
                                                                     single mask.
                                                                 Other values mask the corresponding number of address bits.

                                                                 0x0 = No mask.
                                                                 0x1 = Reserved.
                                                                 0x2 = Reserved. */
        uint32_t reserved_21_23        : 3;
        uint32_t wt                    : 1;  /**< [ 20: 20](R/W) Watchpoint type.
                                                                 0 = Unlinked data address match.
                                                                 1 = Linked data address match. */
        uint32_t lbn                   : 4;  /**< [ 19: 16](R/W) Linked breakpoint number. For Linked data address watchpoints,
                                                                     this specifies the index of the Context-matching breakpoint
                                                                     linked to. */
        uint32_t ssc                   : 2;  /**< [ 15: 14](R/W) Security state control. Determines the Security states under
                                                                     which a watchpoint debug event for watchpoint n is generated.
                                                                     This field must be interpreted along with the HMC and PAC
                                                                     fields. */
        uint32_t hmc                   : 1;  /**< [ 13: 13](R/W) Higher mode control. Determines the debug perspective for
                                                                     deciding when a watchpoint debug event for watchpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and PAC fields. */
        uint32_t bas                   : 8;  /**< [ 12:  5](R/W) Byte address select. Each bit of this field selects whether a
                                                                     byte from within the word or double-word addressed by
                                                                     DBGWVR\<n\>_EL1 is being watched.

                                                                 xxxxxxx1    Match byte at DBGWVR\<n\>_EL1
                                                                 xxxxxx1x    Match byte at DBGWVR\<n\>_EL1+1
                                                                 xxxxx1xx    Match byte at DBGWVR\<n\>_EL1+2
                                                                 xxxx1xxx    Match byte at DBGWVR\<n\>_EL1+3

                                                                 In cases where DBGWVR\<n\>_EL1 addresses a double-word:
                                                                 BAS Description, if DBGWVR\<n\>_EL1[2] == 0

                                                                 xxx1xxxx    Match byte at DBGWVR\<n\>_EL1+4
                                                                 xx1xxxxx    Match byte at DBGWVR\<n\>_EL1+5
                                                                 x1xxxxxx    Match byte at DBGWVR\<n\>_EL1+6
                                                                 1xxxxxxx    Match byte at DBGWVR\<n\>_EL1+7

                                                                 If DBGWVR\<n\>_EL1[2] == 1, only BAS[3:0] is used. ARM
                                                                     deprecates setting DBGWVR\<n\>_EL1 == 1.
                                                                 If BAS is zero, no bytes are watched by this watchpoint.
                                                                 Ignored if E is 0. */
        uint32_t lsc                   : 2;  /**< [  4:  3](R/W) Load/store control. This field enables watchpoint matching on
                                                                     the type of access being made.
                                                                 All other values are reserved, but must behave as if the
                                                                     watchpoint is disabled. Software must not rely on this
                                                                     property as the behavior of reserved values might change in a
                                                                     future revision of the architecture.
                                                                 Ignored if E is 0.
                                                                 0x1 = Match instructions that load from a watchpointed address.
                                                                 0x2 = Match instructions that store to a watchpointed address.
                                                                 0x3 = Match instructions that load from or store to a watchpointed
                                                                     address. */
        uint32_t pac                   : 2;  /**< [  2:  1](R/W) Privilege of access control. Determines the Exception level or
                                                                     levels at which a watchpoint debug event for watchpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and HMC fields. */
        uint32_t ee                    : 1;  /**< [  0:  0](R/W) Enable watchpoint n.
                                                                 0 = Watchpoint disabled.
                                                                 1 = Watchpoint enabled. */
#else /* Word 0 - Little Endian */
        uint32_t ee                    : 1;  /**< [  0:  0](R/W) Enable watchpoint n.
                                                                 0 = Watchpoint disabled.
                                                                 1 = Watchpoint enabled. */
        uint32_t pac                   : 2;  /**< [  2:  1](R/W) Privilege of access control. Determines the Exception level or
                                                                     levels at which a watchpoint debug event for watchpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and HMC fields. */
        uint32_t lsc                   : 2;  /**< [  4:  3](R/W) Load/store control. This field enables watchpoint matching on
                                                                     the type of access being made.
                                                                 All other values are reserved, but must behave as if the
                                                                     watchpoint is disabled. Software must not rely on this
                                                                     property as the behavior of reserved values might change in a
                                                                     future revision of the architecture.
                                                                 Ignored if E is 0.
                                                                 0x1 = Match instructions that load from a watchpointed address.
                                                                 0x2 = Match instructions that store to a watchpointed address.
                                                                 0x3 = Match instructions that load from or store to a watchpointed
                                                                     address. */
        uint32_t bas                   : 8;  /**< [ 12:  5](R/W) Byte address select. Each bit of this field selects whether a
                                                                     byte from within the word or double-word addressed by
                                                                     DBGWVR\<n\>_EL1 is being watched.

                                                                 xxxxxxx1    Match byte at DBGWVR\<n\>_EL1
                                                                 xxxxxx1x    Match byte at DBGWVR\<n\>_EL1+1
                                                                 xxxxx1xx    Match byte at DBGWVR\<n\>_EL1+2
                                                                 xxxx1xxx    Match byte at DBGWVR\<n\>_EL1+3

                                                                 In cases where DBGWVR\<n\>_EL1 addresses a double-word:
                                                                 BAS Description, if DBGWVR\<n\>_EL1[2] == 0

                                                                 xxx1xxxx    Match byte at DBGWVR\<n\>_EL1+4
                                                                 xx1xxxxx    Match byte at DBGWVR\<n\>_EL1+5
                                                                 x1xxxxxx    Match byte at DBGWVR\<n\>_EL1+6
                                                                 1xxxxxxx    Match byte at DBGWVR\<n\>_EL1+7

                                                                 If DBGWVR\<n\>_EL1[2] == 1, only BAS[3:0] is used. ARM
                                                                     deprecates setting DBGWVR\<n\>_EL1 == 1.
                                                                 If BAS is zero, no bytes are watched by this watchpoint.
                                                                 Ignored if E is 0. */
        uint32_t hmc                   : 1;  /**< [ 13: 13](R/W) Higher mode control. Determines the debug perspective for
                                                                     deciding when a watchpoint debug event for watchpoint n is
                                                                     generated. This field must be interpreted along with the SSC
                                                                     and PAC fields. */
        uint32_t ssc                   : 2;  /**< [ 15: 14](R/W) Security state control. Determines the Security states under
                                                                     which a watchpoint debug event for watchpoint n is generated.
                                                                     This field must be interpreted along with the HMC and PAC
                                                                     fields. */
        uint32_t lbn                   : 4;  /**< [ 19: 16](R/W) Linked breakpoint number. For Linked data address watchpoints,
                                                                     this specifies the index of the Context-matching breakpoint
                                                                     linked to. */
        uint32_t wt                    : 1;  /**< [ 20: 20](R/W) Watchpoint type.
                                                                 0 = Unlinked data address match.
                                                                 1 = Linked data address match. */
        uint32_t reserved_21_23        : 3;
        uint32_t mask                  : 5;  /**< [ 28: 24](R/W) Address mask. Only objects up to 2GB can be watched using a
                                                                     single mask.
                                                                 Other values mask the corresponding number of address bits.

                                                                 0x0 = No mask.
                                                                 0x1 = Reserved.
                                                                 0x2 = Reserved. */
        uint32_t reserved_29_31        : 3;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dbgwcrx_el1_s cn; */
};
typedef union bdk_ap_dbgwcrx_el1 bdk_ap_dbgwcrx_el1_t;

static inline uint64_t BDK_AP_DBGWCRX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGWCRX_EL1(unsigned long a)
{
    if (a<=15)
        return 0x20000000700ll + 0x10000ll * ((a) & 0xf);
    __bdk_csr_fatal("AP_DBGWCRX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_DBGWCRX_EL1(a) bdk_ap_dbgwcrx_el1_t
#define bustype_BDK_AP_DBGWCRX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGWCRX_EL1(a) "AP_DBGWCRX_EL1"
#define busnum_BDK_AP_DBGWCRX_EL1(a) (a)
#define arguments_BDK_AP_DBGWCRX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_dbgwvr#_el1
 *
 * AP Debug Watchpoint Value Registers
 * Holds a data address value for use in watchpoint matching.
 *     Forms watchpoint n together with control register
 *     DBGWCR\<n\>_EL1, where n is 0 to 15.
 */
union bdk_ap_dbgwvrx_el1
{
    uint64_t u;
    struct bdk_ap_dbgwvrx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_dbgwvrx_el1_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t ress                  : 15; /**< [ 63: 49](R/W) Reserved, Sign extended. Hardwired to the value of the sign
                                                                     bit, bit [48]. Hardware and software must treat this field as
                                                                     RES0 if bit[48] is 0, and as RES1 if bit[48] is 1. */
        uint64_t va                    : 47; /**< [ 48:  2](R/W) Bits[48:2] of the address value for comparison.
                                                                 ARM deprecates setting DBGWVR\<n\>_EL1[2] == 1. */
        uint64_t reserved_0_1          : 2;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_1          : 2;
        uint64_t va                    : 47; /**< [ 48:  2](R/W) Bits[48:2] of the address value for comparison.
                                                                 ARM deprecates setting DBGWVR\<n\>_EL1[2] == 1. */
        uint64_t ress                  : 15; /**< [ 63: 49](R/W) Reserved, Sign extended. Hardwired to the value of the sign
                                                                     bit, bit [48]. Hardware and software must treat this field as
                                                                     RES0 if bit[48] is 0, and as RES1 if bit[48] is 1. */
#endif /* Word 0 - End */
    } cn8;
    struct bdk_ap_dbgwvrx_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t ress                  : 11; /**< [ 63: 53](R/W) Reserved, Sign extended. Hardwired to the value of the sign
                                                                     bit, bit [52]. Hardware and software must treat this field as
                                                                     RES0 if bit[52] is 0, and as RES1 if bit[52] is 1. */
        uint64_t va                    : 51; /**< [ 52:  2](R/W) Bits[52:2] of the address value for comparison.
                                                                 ARM deprecates setting DBGWVR\<n\>_EL1[2] == 1. */
        uint64_t reserved_0_1          : 2;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_1          : 2;
        uint64_t va                    : 51; /**< [ 52:  2](R/W) Bits[52:2] of the address value for comparison.
                                                                 ARM deprecates setting DBGWVR\<n\>_EL1[2] == 1. */
        uint64_t ress                  : 11; /**< [ 63: 53](R/W) Reserved, Sign extended. Hardwired to the value of the sign
                                                                     bit, bit [52]. Hardware and software must treat this field as
                                                                     RES0 if bit[52] is 0, and as RES1 if bit[52] is 1. */
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_dbgwvrx_el1 bdk_ap_dbgwvrx_el1_t;

static inline uint64_t BDK_AP_DBGWVRX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DBGWVRX_EL1(unsigned long a)
{
    if (a<=15)
        return 0x20000000600ll + 0x10000ll * ((a) & 0xf);
    __bdk_csr_fatal("AP_DBGWVRX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_DBGWVRX_EL1(a) bdk_ap_dbgwvrx_el1_t
#define bustype_BDK_AP_DBGWVRX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DBGWVRX_EL1(a) "AP_DBGWVRX_EL1"
#define busnum_BDK_AP_DBGWVRX_EL1(a) (a)
#define arguments_BDK_AP_DBGWVRX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_dczid_el0
 *
 * AP Data Cache Zero ID Register
 * This register indicates the block size that is written with byte values of 0 by the
 * DC ZVA (Data Cache Zero by Address) system instruction.
 */
union bdk_ap_dczid_el0
{
    uint32_t u;
    struct bdk_ap_dczid_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_5_31         : 27;
        uint32_t dzp                   : 1;  /**< [  4:  4](RO) Data Zero prohibited.
                                                                 The value read from this field is governed by the access state
                                                                     and the values of the AP_HCR_EL2[TDZ] and AP_SCTLR_EL1[DZE] bits.
                                                                 0 =  DC ZVA instruction is permitted.
                                                                 1 =  DC ZVA instruction is prohibited. */
        uint32_t bs                    : 4;  /**< [  3:  0](RO) Log2 of the block size in words. The maximum size supported is 2KB (value == 9).

                                                                 In CNXXXX, 128 bytes. */
#else /* Word 0 - Little Endian */
        uint32_t bs                    : 4;  /**< [  3:  0](RO) Log2 of the block size in words. The maximum size supported is 2KB (value == 9).

                                                                 In CNXXXX, 128 bytes. */
        uint32_t dzp                   : 1;  /**< [  4:  4](RO) Data Zero prohibited.
                                                                 The value read from this field is governed by the access state
                                                                     and the values of the AP_HCR_EL2[TDZ] and AP_SCTLR_EL1[DZE] bits.
                                                                 0 =  DC ZVA instruction is permitted.
                                                                 1 =  DC ZVA instruction is prohibited. */
        uint32_t reserved_5_31         : 27;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dczid_el0_s cn; */
};
typedef union bdk_ap_dczid_el0 bdk_ap_dczid_el0_t;

#define BDK_AP_DCZID_EL0 BDK_AP_DCZID_EL0_FUNC()
static inline uint64_t BDK_AP_DCZID_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DCZID_EL0_FUNC(void)
{
    return 0x30300000700ll;
}

#define typedef_BDK_AP_DCZID_EL0 bdk_ap_dczid_el0_t
#define bustype_BDK_AP_DCZID_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DCZID_EL0 "AP_DCZID_EL0"
#define busnum_BDK_AP_DCZID_EL0 0
#define arguments_BDK_AP_DCZID_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_disr_el1
 *
 * AP Deferred Interrupt Status Register
 * Records that an SError interrupt has been consumed by an ESB instruction.
 *
 * Usage constraints:
 *   DISR_EL1 is UNDEFINED at EL0.
 *   Direct reads and writes of DISR_EL1:
 *     - If EL2 is implemented and HCR_EL2.AMO is set to 1 access VDISR_EL2 at Non-secure EL1.
 *     - If EL3 is implemented and SCR_EL3.EA == 1, are RAZ/WI at EL2, Secure EL1, and, if they
 * do not access VDISR_EL2, Non-secure EL1.
 *   An indirect write to DISR_EL1 made by an ESB instruction does not require an explicit
 * synchronization operation for the value written to be observed by a direct read of DISR_EL1
 * occurring in program order after the ESB.
 */
union bdk_ap_disr_el1
{
    uint64_t u;
    struct bdk_ap_disr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_32_63        : 32;
        uint64_t aa                    : 1;  /**< [ 31: 31](R/W) Set to 1 when ESB defers an asynchronous SError interrupt. If the implementation does not
                                                                 include any synchronizable sources of SError interrupt, this bit is RES0. */
        uint64_t reserved_25_30        : 6;
        uint64_t ids                   : 1;  /**< [ 24: 24](R/W) Indicates whether the deferred SError interrupt was of an implementation defined type.
                                                                   0 = Deferred error uses architecturally-defined format.
                                                                   1 = Deferred error uses implementation defined format.  ISS, bits [23:0], when
                                                                   IDS = 1 contain an implementation defined SError interrupt syndrome. See the
                                                                   description of ESR_ELx[23:0] for an SError interrupt. */
        uint64_t reserved_13_23        : 11;
        uint64_t aet                   : 3;  /**< [ 12: 10](R/W) Asynchronous error type. See the description of ESR_ELx.AET for an SError interrupt. */
        uint64_t ea                    : 1;  /**< [  9:  9](R/W) External abort type. See the description of ESR_ELx.EA for an SError interrupt. */
        uint64_t reserved_6_8          : 3;
        uint64_t dfsc                  : 6;  /**< [  5:  0](R/W) Fault status code. See the description of ESR_ELx.DFSC for an SError interrupt. */
#else /* Word 0 - Little Endian */
        uint64_t dfsc                  : 6;  /**< [  5:  0](R/W) Fault status code. See the description of ESR_ELx.DFSC for an SError interrupt. */
        uint64_t reserved_6_8          : 3;
        uint64_t ea                    : 1;  /**< [  9:  9](R/W) External abort type. See the description of ESR_ELx.EA for an SError interrupt. */
        uint64_t aet                   : 3;  /**< [ 12: 10](R/W) Asynchronous error type. See the description of ESR_ELx.AET for an SError interrupt. */
        uint64_t reserved_13_23        : 11;
        uint64_t ids                   : 1;  /**< [ 24: 24](R/W) Indicates whether the deferred SError interrupt was of an implementation defined type.
                                                                   0 = Deferred error uses architecturally-defined format.
                                                                   1 = Deferred error uses implementation defined format.  ISS, bits [23:0], when
                                                                   IDS = 1 contain an implementation defined SError interrupt syndrome. See the
                                                                   description of ESR_ELx[23:0] for an SError interrupt. */
        uint64_t reserved_25_30        : 6;
        uint64_t aa                    : 1;  /**< [ 31: 31](R/W) Set to 1 when ESB defers an asynchronous SError interrupt. If the implementation does not
                                                                 include any synchronizable sources of SError interrupt, this bit is RES0. */
        uint64_t reserved_32_63        : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_disr_el1_s cn; */
};
typedef union bdk_ap_disr_el1 bdk_ap_disr_el1_t;

#define BDK_AP_DISR_EL1 BDK_AP_DISR_EL1_FUNC()
static inline uint64_t BDK_AP_DISR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DISR_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000c010100ll;
    __bdk_csr_fatal("AP_DISR_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_DISR_EL1 bdk_ap_disr_el1_t
#define bustype_BDK_AP_DISR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DISR_EL1 "AP_DISR_EL1"
#define busnum_BDK_AP_DISR_EL1 0
#define arguments_BDK_AP_DISR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dlr_el0
 *
 * AP Debug Link Register
 * In Debug state, holds the address to restart from.
 */
union bdk_ap_dlr_el0
{
    uint64_t u;
    struct bdk_ap_dlr_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Restart address. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Restart address. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_dlr_el0_s cn; */
};
typedef union bdk_ap_dlr_el0 bdk_ap_dlr_el0_t;

#define BDK_AP_DLR_EL0 BDK_AP_DLR_EL0_FUNC()
static inline uint64_t BDK_AP_DLR_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DLR_EL0_FUNC(void)
{
    return 0x30304050100ll;
}

#define typedef_BDK_AP_DLR_EL0 bdk_ap_dlr_el0_t
#define bustype_BDK_AP_DLR_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DLR_EL0 "AP_DLR_EL0"
#define busnum_BDK_AP_DLR_EL0 0
#define arguments_BDK_AP_DLR_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_dspsr_el0
 *
 * AP Debug Saved Program Status Register
 * Holds the saved processor state on entry to debug state.
 */
union bdk_ap_dspsr_el0
{
    uint32_t u;
    struct bdk_ap_dspsr_el0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t n                     : 1;  /**< [ 31: 31](R/W) Set to the value of CPSR[N] on entering Debug state, and copied
                                                                     to CPSR[N] on exiting Debug state. */
        uint32_t z                     : 1;  /**< [ 30: 30](R/W) Set to the value of CPSR[Z] on entering Debug state, and copied
                                                                     to CPSR[Z] on exiting Debug state. */
        uint32_t cc                    : 1;  /**< [ 29: 29](R/W) Set to the value of CPSR[C] on entering Debug state, and copied
                                                                     to CPSR[C] on exiting Debug state. */
        uint32_t v                     : 1;  /**< [ 28: 28](R/W) Set to the value of CPSR[V] on entering Debug state, and copied
                                                                     to CPSR[V] on exiting Debug state. */
        uint32_t reserved_24_27        : 4;
        uint32_t uao                   : 1;  /**< [ 23: 23](R/W) User access override. */
        uint32_t reserved_22           : 1;
        uint32_t ss                    : 1;  /**< [ 21: 21](R/W) Software step. Indicates whether software step was enabled when
                                                                 Debug state was entered. */
        uint32_t il                    : 1;  /**< [ 20: 20](R/W) Illegal Execution State bit. Shows the value of PSTATE[IL]
                                                                     immediately before Debug state was entered. */
        uint32_t reserved_10_19        : 10;
        uint32_t dd                    : 1;  /**< [  9:  9](R/W) Interrupt masks - can also be accessed as PSTATE.[D,A,I,F] */
        uint32_t aa                    : 1;  /**< [  8:  8](R/W) Asynchronous data abort mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t i                     : 1;  /**< [  7:  7](R/W) IRQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t f                     : 1;  /**< [  6:  6](R/W) FIQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t reserved_5            : 1;
        uint32_t nrw                   : 1;  /**< [  4:  4](R/W) Current register width:  0 = AArch64, 1 = AArch32. */
        uint32_t el                    : 2;  /**< [  3:  2](R/W) Current exception level: 0x0 = EL0, 0x1 = EL1, 0x2 = EL2, 0x3 = EL3. */
        uint32_t reserved_1            : 1;
        uint32_t sp                    : 1;  /**< [  0:  0](R/W) AArch64 only - Stack Pointer selection - 0 - SP0, 1 - SPx. */
#else /* Word 0 - Little Endian */
        uint32_t sp                    : 1;  /**< [  0:  0](R/W) AArch64 only - Stack Pointer selection - 0 - SP0, 1 - SPx. */
        uint32_t reserved_1            : 1;
        uint32_t el                    : 2;  /**< [  3:  2](R/W) Current exception level: 0x0 = EL0, 0x1 = EL1, 0x2 = EL2, 0x3 = EL3. */
        uint32_t nrw                   : 1;  /**< [  4:  4](R/W) Current register width:  0 = AArch64, 1 = AArch32. */
        uint32_t reserved_5            : 1;
        uint32_t f                     : 1;  /**< [  6:  6](R/W) FIQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t i                     : 1;  /**< [  7:  7](R/W) IRQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t aa                    : 1;  /**< [  8:  8](R/W) Asynchronous data abort mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t dd                    : 1;  /**< [  9:  9](R/W) Interrupt masks - can also be accessed as PSTATE.[D,A,I,F] */
        uint32_t reserved_10_19        : 10;
        uint32_t il                    : 1;  /**< [ 20: 20](R/W) Illegal Execution State bit. Shows the value of PSTATE[IL]
                                                                     immediately before Debug state was entered. */
        uint32_t ss                    : 1;  /**< [ 21: 21](R/W) Software step. Indicates whether software step was enabled when
                                                                 Debug state was entered. */
        uint32_t reserved_22           : 1;
        uint32_t uao                   : 1;  /**< [ 23: 23](R/W) User access override. */
        uint32_t reserved_24_27        : 4;
        uint32_t v                     : 1;  /**< [ 28: 28](R/W) Set to the value of CPSR[V] on entering Debug state, and copied
                                                                     to CPSR[V] on exiting Debug state. */
        uint32_t cc                    : 1;  /**< [ 29: 29](R/W) Set to the value of CPSR[C] on entering Debug state, and copied
                                                                     to CPSR[C] on exiting Debug state. */
        uint32_t z                     : 1;  /**< [ 30: 30](R/W) Set to the value of CPSR[Z] on entering Debug state, and copied
                                                                     to CPSR[Z] on exiting Debug state. */
        uint32_t n                     : 1;  /**< [ 31: 31](R/W) Set to the value of CPSR[N] on entering Debug state, and copied
                                                                     to CPSR[N] on exiting Debug state. */
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_dspsr_el0_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t n                     : 1;  /**< [ 31: 31](R/W) Set to the value of CPSR[N] on entering Debug state, and copied
                                                                     to CPSR[N] on exiting Debug state. */
        uint32_t z                     : 1;  /**< [ 30: 30](R/W) Set to the value of CPSR[Z] on entering Debug state, and copied
                                                                     to CPSR[Z] on exiting Debug state. */
        uint32_t cc                    : 1;  /**< [ 29: 29](R/W) Set to the value of CPSR[C] on entering Debug state, and copied
                                                                     to CPSR[C] on exiting Debug state. */
        uint32_t v                     : 1;  /**< [ 28: 28](R/W) Set to the value of CPSR[V] on entering Debug state, and copied
                                                                     to CPSR[V] on exiting Debug state. */
        uint32_t reserved_22_27        : 6;
        uint32_t ss                    : 1;  /**< [ 21: 21](R/W) Software step. Indicates whether software step was enabled when
                                                                 Debug state was entered. */
        uint32_t il                    : 1;  /**< [ 20: 20](R/W) Illegal Execution State bit. Shows the value of PSTATE[IL]
                                                                     immediately before Debug state was entered. */
        uint32_t reserved_10_19        : 10;
        uint32_t dd                    : 1;  /**< [  9:  9](R/W) Interrupt masks - can also be accessed as PSTATE.[D,A,I,F] */
        uint32_t aa                    : 1;  /**< [  8:  8](R/W) Asynchronous data abort mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t i                     : 1;  /**< [  7:  7](R/W) IRQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t f                     : 1;  /**< [  6:  6](R/W) FIQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t reserved_5            : 1;
        uint32_t nrw                   : 1;  /**< [  4:  4](R/W) Current register width:  0 = AArch64, 1 = AArch32. */
        uint32_t el                    : 2;  /**< [  3:  2](R/W) Current exception level: 0x0 = EL0, 0x1 = EL1, 0x2 = EL2, 0x3 = EL3. */
        uint32_t reserved_1            : 1;
        uint32_t sp                    : 1;  /**< [  0:  0](R/W) AArch64 only - Stack Pointer selection - 0 - SP0, 1 - SPx. */
#else /* Word 0 - Little Endian */
        uint32_t sp                    : 1;  /**< [  0:  0](R/W) AArch64 only - Stack Pointer selection - 0 - SP0, 1 - SPx. */
        uint32_t reserved_1            : 1;
        uint32_t el                    : 2;  /**< [  3:  2](R/W) Current exception level: 0x0 = EL0, 0x1 = EL1, 0x2 = EL2, 0x3 = EL3. */
        uint32_t nrw                   : 1;  /**< [  4:  4](R/W) Current register width:  0 = AArch64, 1 = AArch32. */
        uint32_t reserved_5            : 1;
        uint32_t f                     : 1;  /**< [  6:  6](R/W) FIQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t i                     : 1;  /**< [  7:  7](R/W) IRQ mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t aa                    : 1;  /**< [  8:  8](R/W) Asynchronous data abort mask bit.
                                                                 0 = Exception not masked.
                                                                 1 = Exception masked. */
        uint32_t dd                    : 1;  /**< [  9:  9](R/W) Interrupt masks - can also be accessed as PSTATE.[D,A,I,F] */
        uint32_t reserved_10_19        : 10;
        uint32_t il                    : 1;  /**< [ 20: 20](R/W) Illegal Execution State bit. Shows the value of PSTATE[IL]
                                                                     immediately before Debug state was entered. */
        uint32_t ss                    : 1;  /**< [ 21: 21](R/W) Software step. Indicates whether software step was enabled when
                                                                 Debug state was entered. */
        uint32_t reserved_22_27        : 6;
        uint32_t v                     : 1;  /**< [ 28: 28](R/W) Set to the value of CPSR[V] on entering Debug state, and copied
                                                                     to CPSR[V] on exiting Debug state. */
        uint32_t cc                    : 1;  /**< [ 29: 29](R/W) Set to the value of CPSR[C] on entering Debug state, and copied
                                                                     to CPSR[C] on exiting Debug state. */
        uint32_t z                     : 1;  /**< [ 30: 30](R/W) Set to the value of CPSR[Z] on entering Debug state, and copied
                                                                     to CPSR[Z] on exiting Debug state. */
        uint32_t n                     : 1;  /**< [ 31: 31](R/W) Set to the value of CPSR[N] on entering Debug state, and copied
                                                                     to CPSR[N] on exiting Debug state. */
#endif /* Word 0 - End */
    } cn8;
    /* struct bdk_ap_dspsr_el0_s cn9; */
};
typedef union bdk_ap_dspsr_el0 bdk_ap_dspsr_el0_t;

#define BDK_AP_DSPSR_EL0 BDK_AP_DSPSR_EL0_FUNC()
static inline uint64_t BDK_AP_DSPSR_EL0_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_DSPSR_EL0_FUNC(void)
{
    return 0x30304050000ll;
}

#define typedef_BDK_AP_DSPSR_EL0 bdk_ap_dspsr_el0_t
#define bustype_BDK_AP_DSPSR_EL0 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_DSPSR_EL0 "AP_DSPSR_EL0"
#define busnum_BDK_AP_DSPSR_EL0 0
#define arguments_BDK_AP_DSPSR_EL0 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_elr_el#
 *
 * AP Exception Link Register
 * Return address for exception
 */
union bdk_ap_elr_elx
{
    uint64_t u;
    struct bdk_ap_elr_elx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t address               : 64; /**< [ 63:  0](R/W) Return address for exception. */
#else /* Word 0 - Little Endian */
        uint64_t address               : 64; /**< [ 63:  0](R/W) Return address for exception. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_elr_elx_s cn; */
};
typedef union bdk_ap_elr_elx bdk_ap_elr_elx_t;

static inline uint64_t BDK_AP_ELR_ELX(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ELR_ELX(unsigned long a)
{
    if ((a>=1)&&(a<=3))
        return 0x30004000100ll + 0ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_ELR_ELX", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_ELR_ELX(a) bdk_ap_elr_elx_t
#define bustype_BDK_AP_ELR_ELX(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ELR_ELX(a) "AP_ELR_ELX"
#define busnum_BDK_AP_ELR_ELX(a) (a)
#define arguments_BDK_AP_ELR_ELX(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_elr_el12
 *
 * AP Exception Link EL2/3 Alias Register
 * Alias to allow EL2/3 access to ELR_EL1 when AP_HCR_EL2[E2H]==1.
 */
union bdk_ap_elr_el12
{
    uint64_t u;
    struct bdk_ap_elr_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t address               : 64; /**< [ 63:  0](R/W) Return address for exception. */
#else /* Word 0 - Little Endian */
        uint64_t address               : 64; /**< [ 63:  0](R/W) Return address for exception. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_elr_el12_s cn; */
};
typedef union bdk_ap_elr_el12 bdk_ap_elr_el12_t;

#define BDK_AP_ELR_EL12 BDK_AP_ELR_EL12_FUNC()
static inline uint64_t BDK_AP_ELR_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ELR_EL12_FUNC(void)
{
    return 0x30504000100ll;
}

#define typedef_BDK_AP_ELR_EL12 bdk_ap_elr_el12_t
#define bustype_BDK_AP_ELR_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ELR_EL12 "AP_ELR_EL12"
#define busnum_BDK_AP_ELR_EL12 0
#define arguments_BDK_AP_ELR_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erridr_el1
 *
 * AP Error Record ID Register
 * Defines the number of error records that can be accessed through the Error Record system
 * registers.
 *
 * Usage constraints:
 *   AP_ERRIDR_EL1 is UNDEFINED at EL0.
 *   If EL2 is implemented and AP_HCR_EL2[TERR] == 1, then direct reads of AP_ERRIDR_EL1 at
 * nonsecure
 * EL1 generate a Trap exception to EL2.
 *   If EL3 is implemented and AP_SCR_EL3[TERR] == 1, then direct reads of AP_ERRIDR_EL1 at EL1
 * and EL2
 * generate a Trap exception to EL3.
 */
union bdk_ap_erridr_el1
{
    uint64_t u;
    struct bdk_ap_erridr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t num                   : 16; /**< [ 15:  0](RO) Number of records that can be accessed through the error record system registers. Each
                                                                 record is notionally owned by a node. A node might own multiple records. */
#else /* Word 0 - Little Endian */
        uint64_t num                   : 16; /**< [ 15:  0](RO) Number of records that can be accessed through the error record system registers. Each
                                                                 record is notionally owned by a node. A node might own multiple records. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erridr_el1_s cn; */
};
typedef union bdk_ap_erridr_el1 bdk_ap_erridr_el1_t;

#define BDK_AP_ERRIDR_EL1 BDK_AP_ERRIDR_EL1_FUNC()
static inline uint64_t BDK_AP_ERRIDR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERRIDR_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005030000ll;
    __bdk_csr_fatal("AP_ERRIDR_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERRIDR_EL1 bdk_ap_erridr_el1_t
#define bustype_BDK_AP_ERRIDR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERRIDR_EL1 "AP_ERRIDR_EL1"
#define busnum_BDK_AP_ERRIDR_EL1 0
#define arguments_BDK_AP_ERRIDR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_errselr_el1
 *
 * AP Error Record Select Register
 * ERRSELR_EL1 is UNDEFINED at EL0.
 * If EL2 is implemented and HCR_EL2.TERR == 1, then direct reads and writes of ERRSELR_EL1 at
 * Non-secure EL1 generate a Trap exception to EL2.
 * If EL3 is implemented and SCR_EL3.TERR == 1, then direct reads and writes of ERRSELR_EL1 at
 * EL1 and EL2 generate a Trap exception to EL3.
 * If ERRIDR_EL1 indicates that zero records are implemented, ERRSELR_EL1 might be UNDEFINED or
 * RES0.
 */
union bdk_ap_errselr_el1
{
    uint64_t u;
    struct bdk_ap_errselr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t sel                   : 16; /**< [ 15:  0](R/W) Selects the record accessed through the ERX registers.
                                                                 For example, if AP_ERRSELR_EL1[SEL] is set to 4, then reads and writes of AP_ERXSTATUS_EL1
                                                                 access
                                                                 ERR4STATUS.
                                                                 If AP_ERRSELR_EL1[SEL] is set to a value greater than or equal to AP_ERRIDR_EL1[NUM] then:
                                                                   - The value read back from AP_ERRSELR_EL1[SEL] is UNKNOWN.
                                                                   - One of:
                                                                       - An UNKNOWN record is selected.
                                                                       - The ERX* registers are RAZ/WI.
                                                                       - ERX* register reads and writes are NOPs.
                                                                       - ERX* register reads and writes are UNDEFINED.
                                                                     Note: The ARM preferred behavior if one or more records are implemented is:
                                                                       - SEL is implemented as an N-bit field, where N is the smallest value such that
                                                                 ERRIDR_EL1.NUM . 2N.
                                                                       - If the value written to SEL modulo 2N is greater than or equal to ERRIDR_EL1.NUM,
                                                                 a dummy RAZ/WI record is selected.
                                                                     If zero records are implemented, the ARM preferred behavior is for ERRSELR_EL1 and
                                                                 ERX* to be undefined. */
#else /* Word 0 - Little Endian */
        uint64_t sel                   : 16; /**< [ 15:  0](R/W) Selects the record accessed through the ERX registers.
                                                                 For example, if AP_ERRSELR_EL1[SEL] is set to 4, then reads and writes of AP_ERXSTATUS_EL1
                                                                 access
                                                                 ERR4STATUS.
                                                                 If AP_ERRSELR_EL1[SEL] is set to a value greater than or equal to AP_ERRIDR_EL1[NUM] then:
                                                                   - The value read back from AP_ERRSELR_EL1[SEL] is UNKNOWN.
                                                                   - One of:
                                                                       - An UNKNOWN record is selected.
                                                                       - The ERX* registers are RAZ/WI.
                                                                       - ERX* register reads and writes are NOPs.
                                                                       - ERX* register reads and writes are UNDEFINED.
                                                                     Note: The ARM preferred behavior if one or more records are implemented is:
                                                                       - SEL is implemented as an N-bit field, where N is the smallest value such that
                                                                 ERRIDR_EL1.NUM . 2N.
                                                                       - If the value written to SEL modulo 2N is greater than or equal to ERRIDR_EL1.NUM,
                                                                 a dummy RAZ/WI record is selected.
                                                                     If zero records are implemented, the ARM preferred behavior is for ERRSELR_EL1 and
                                                                 ERX* to be undefined. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_errselr_el1_s cn; */
};
typedef union bdk_ap_errselr_el1 bdk_ap_errselr_el1_t;

#define BDK_AP_ERRSELR_EL1 BDK_AP_ERRSELR_EL1_FUNC()
static inline uint64_t BDK_AP_ERRSELR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERRSELR_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005030100ll;
    __bdk_csr_fatal("AP_ERRSELR_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERRSELR_EL1 bdk_ap_errselr_el1_t
#define bustype_BDK_AP_ERRSELR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERRSELR_EL1 "AP_ERRSELR_EL1"
#define busnum_BDK_AP_ERRSELR_EL1 0
#define arguments_BDK_AP_ERRSELR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erxaddr_el1
 *
 * AP Selected Error Record Address Register
 * Accesses the ERR\<n\>ADDR address register for the error record selected by ERRSELR_EL1.SEL.
 *
 * Usage constraints as described in AP_ERXFR_EL1.
 */
union bdk_ap_erxaddr_el1
{
    uint64_t u;
    struct bdk_ap_erxaddr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erxaddr_el1_s cn; */
};
typedef union bdk_ap_erxaddr_el1 bdk_ap_erxaddr_el1_t;

#define BDK_AP_ERXADDR_EL1 BDK_AP_ERXADDR_EL1_FUNC()
static inline uint64_t BDK_AP_ERXADDR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERXADDR_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005040300ll;
    __bdk_csr_fatal("AP_ERXADDR_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERXADDR_EL1 bdk_ap_erxaddr_el1_t
#define bustype_BDK_AP_ERXADDR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERXADDR_EL1 "AP_ERXADDR_EL1"
#define busnum_BDK_AP_ERXADDR_EL1 0
#define arguments_BDK_AP_ERXADDR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erxctlr_el1
 *
 * AP Selected Error Record Control Register
 * Accesses the ERR\<n\>CTLR control register for the error record selected by AP_ERRSELR_EL1[SEL].
 *
 * Usage constraints as described in AP_ERXFR_EL1.
 */
union bdk_ap_erxctlr_el1
{
    uint64_t u;
    struct bdk_ap_erxctlr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erxctlr_el1_s cn; */
};
typedef union bdk_ap_erxctlr_el1 bdk_ap_erxctlr_el1_t;

#define BDK_AP_ERXCTLR_EL1 BDK_AP_ERXCTLR_EL1_FUNC()
static inline uint64_t BDK_AP_ERXCTLR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERXCTLR_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005040100ll;
    __bdk_csr_fatal("AP_ERXCTLR_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERXCTLR_EL1 bdk_ap_erxctlr_el1_t
#define bustype_BDK_AP_ERXCTLR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERXCTLR_EL1 "AP_ERXCTLR_EL1"
#define busnum_BDK_AP_ERXCTLR_EL1 0
#define arguments_BDK_AP_ERXCTLR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erxfr_el1
 *
 * AP Selected Error Record Feature Register
 * Accesses the ERR\<n\>FR feature register for the error record selected by AP_ERRSELR_EL1[SEL].
 *
 * Usage constraints:
 *   AP_ERXFR_EL1 is UNDEFINED at EL0.
 *   If EL2 is implemented and AP_HCR_EL2[TERR] == 1, then direct reads of AP_ERXFR_EL1 at Non-
 * secure
 * EL1 generate a Trap exception to EL2.
 *   If EL3 is implemented and AP_SCR_EL3[TERR] == 1, then direct reads of AP_ERXFR_EL1 at EL1
 * and EL2
 * generate a Trap exception to EL3.
 *   If AP_ERRIDR_EL1[NUM] == 0 or AP_ERRSELR_EL1[SEL] is set to a value greater than or equal to
 *   AP_ERRIDR_EL1[NUM] then one of:
 *     - An UNKNOWN record is selected.
 *     - AP_ERXFR_EL1 is RAZ/WI.
 *     - Direct reads of AP_ERXFR_EL1 are NOPs.
 *     - Direct reads of AP_ERXFR_EL1 are undefined.
 */
union bdk_ap_erxfr_el1
{
    uint64_t u;
    struct bdk_ap_erxfr_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erxfr_el1_s cn; */
};
typedef union bdk_ap_erxfr_el1 bdk_ap_erxfr_el1_t;

#define BDK_AP_ERXFR_EL1 BDK_AP_ERXFR_EL1_FUNC()
static inline uint64_t BDK_AP_ERXFR_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERXFR_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005040000ll;
    __bdk_csr_fatal("AP_ERXFR_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERXFR_EL1 bdk_ap_erxfr_el1_t
#define bustype_BDK_AP_ERXFR_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERXFR_EL1 "AP_ERXFR_EL1"
#define busnum_BDK_AP_ERXFR_EL1 0
#define arguments_BDK_AP_ERXFR_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erxmisc0_el1
 *
 * AP Selected Error Record Miscellaneous Register 0
 * Accesses the ERR\<n\>MISC0 miscellaneous register 0 for the error record selected by
 * ERRSELR_EL1.SEL.
 *
 * Usage constraints as described in AP_ERXFR_EL1.
 */
union bdk_ap_erxmisc0_el1
{
    uint64_t u;
    struct bdk_ap_erxmisc0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erxmisc0_el1_s cn; */
};
typedef union bdk_ap_erxmisc0_el1 bdk_ap_erxmisc0_el1_t;

#define BDK_AP_ERXMISC0_EL1 BDK_AP_ERXMISC0_EL1_FUNC()
static inline uint64_t BDK_AP_ERXMISC0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERXMISC0_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005050000ll;
    __bdk_csr_fatal("AP_ERXMISC0_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERXMISC0_EL1 bdk_ap_erxmisc0_el1_t
#define bustype_BDK_AP_ERXMISC0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERXMISC0_EL1 "AP_ERXMISC0_EL1"
#define busnum_BDK_AP_ERXMISC0_EL1 0
#define arguments_BDK_AP_ERXMISC0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erxmisc1_el1
 *
 * AP Selected Error Record Miscellaneous Register 1
 * Accesses the ERR\<n\>MISC1 miscellaneous register 1 for the error record selected by
 * ERRSELR_EL1.SEL.
 *
 * Usage constraints as described in AP_ERXFR_EL1.
 */
union bdk_ap_erxmisc1_el1
{
    uint64_t u;
    struct bdk_ap_erxmisc1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erxmisc1_el1_s cn; */
};
typedef union bdk_ap_erxmisc1_el1 bdk_ap_erxmisc1_el1_t;

#define BDK_AP_ERXMISC1_EL1 BDK_AP_ERXMISC1_EL1_FUNC()
static inline uint64_t BDK_AP_ERXMISC1_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERXMISC1_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005050100ll;
    __bdk_csr_fatal("AP_ERXMISC1_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERXMISC1_EL1 bdk_ap_erxmisc1_el1_t
#define bustype_BDK_AP_ERXMISC1_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERXMISC1_EL1 "AP_ERXMISC1_EL1"
#define busnum_BDK_AP_ERXMISC1_EL1 0
#define arguments_BDK_AP_ERXMISC1_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_erxstatus_el1
 *
 * AP Selected Error Record Primary Status Register
 * Accesses the ERR\<n\>STATUS primary status register for the error record selected by
 * ERRSELR_EL1.SEL.
 *
 * Usage constraints as described in AP_ERXFR_EL1.
 */
union bdk_ap_erxstatus_el1
{
    uint64_t u;
    struct bdk_ap_erxstatus_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Data. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_erxstatus_el1_s cn; */
};
typedef union bdk_ap_erxstatus_el1 bdk_ap_erxstatus_el1_t;

#define BDK_AP_ERXSTATUS_EL1 BDK_AP_ERXSTATUS_EL1_FUNC()
static inline uint64_t BDK_AP_ERXSTATUS_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ERXSTATUS_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x30005040200ll;
    __bdk_csr_fatal("AP_ERXSTATUS_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ERXSTATUS_EL1 bdk_ap_erxstatus_el1_t
#define bustype_BDK_AP_ERXSTATUS_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ERXSTATUS_EL1 "AP_ERXSTATUS_EL1"
#define busnum_BDK_AP_ERXSTATUS_EL1 0
#define arguments_BDK_AP_ERXSTATUS_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_esr_el#
 *
 * AP Exception Syndrome Register
 * Holds syndrome information for an exception taken to EL*.
 */
union bdk_ap_esr_elx
{
    uint32_t u;
    struct bdk_ap_esr_elx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t ec                    : 6;  /**< [ 31: 26](R/W) Exception Class. Indicates the reason for the exception that
                                                                     this register holds information about.

                                                                 0x0 = Unknown or Uncategorized Reason - generally used for
                                                                     exceptions as a result of erroneous execution.
                                                                 0x1 = Exceptions from WFE/WFI from either AArch32 or AArch64 as a
                                                                     result of configurable traps, enables, or disables.

                                                                 Conditional WFE and WFI instructions that fail their condition
                                                                     code check do not cause an exception.

                                                                 0x3 = Exceptions from MCR/MRC to CP15 from AArch32 as a result of
                                                                     configurable traps, enables, or disables that do not use
                                                                     code 0x0.
                                                                 0x4 = Exceptions from MCRR/MRRC to CP15 from AArch32 as a result of
                                                                     configurable traps, enables, or disables that do not use
                                                                     code 0x0.
                                                                 0x5 = Exceptions from MCR/MRC to CP14 from AArch32 as a result of
                                                                     configurable traps, enables, or disables that do not use
                                                                     code 0x0.
                                                                 0x6 = Exceptions from LDC/STC to CP14 from AArch32 as a result of
                                                                     configurable traps, enables, or disables. The only architected
                                                                     uses of these instructions to access CP14 are:
                                                                  An STC to write to AP_DBGDTRRX_EL0 or DBGDTRRXint.
                                                                  An LDC to read from AP_DBGDTRTX_EL0 or DBGDTRTXint.

                                                                 0x7 = Exceptions from access to Advanced SIMD or Floating Point as a
                                                                     result of configurable traps, enables, or disables.
                                                                 0xC = Exceptions from MCRR/MRRC to CP14 from AArch32 as a result of
                                                                     configurable traps, enables, or disables.
                                                                 0xE = Exceptions that occur because the value of PSTATE[IL] is 1.
                                                                 0x13 =SMC that is not disabled executed in AArch32.
                                                                 0x15 = SVC executed in AArch64.
                                                                 0x16 = HVC that is not disabled executed in AArch64.
                                                                 0x17 = SMC that is not disabled executed in AArch64.
                                                                 0x18 = Exceptions as a result of MSR, MRS, or System AArch64
                                                                     instructions as a result of configurable traps, enables, or
                                                                     disables, except those using codes0b0000000b0000010b000111
                                                                 0x20 = Instruction Abort that caused entry from a lower Exception
                                                                     level (AArch32 or AArch64). Used for instruction access
                                                                     generated MMU faults and synchronous external aborts,
                                                                     including synchronous parity errors. Not used for debug
                                                                     related exceptions.
                                                                 0x21 = Instruction Abort that caused entry from a current Exception
                                                                     level (AArch64). Used for instruction access generated MMU
                                                                     faults and synchronous external aborts, including synchronous
                                                                     parity errors. Not used for debug related exceptions.
                                                                 0x22 = PC Alignment Exception.
                                                                 0x24 = Data Abort that caused entry from a lower Exception level
                                                                     (AArch32 or AArch64). Used for data access generated MMU
                                                                     faults, alignment faults other than those caused by the Stack
                                                                     Pointer misalignment, and synchronous external aborts,
                                                                     including synchronous parity errors. Not used for debug
                                                                     related exceptions.
                                                                 0x25 = Data Abort that caused entry from a current Exception level
                                                                     (AArch64). Used for data access generated MMU faults,
                                                                     alignment faults other than those caused by the Stack Pointer
                                                                     misalignment, and synchronous external aborts, including
                                                                     synchronous parity errors. Not used for debug related
                                                                     exceptions.
                                                                 0x26 = Stack Pointer Alignment Exception.
                                                                 0x2C = Exceptions as a result of Floating-point exception (optional
                                                                     feature) from AArch64.
                                                                 0x2F = SError Interrupt.
                                                                 0x3C = BRK instruction executed in AArch64 state. */
        uint32_t il                    : 1;  /**< [ 25: 25](R/W) Instruction Length for synchronous exceptions.
                                                                 0 = 16-bit instruction trapped.
                                                                 1 = 32-bit instruction trapped. This value is also used when the
                                                                     exception is one of the following:
                                                                  * An SError interrupt.
                                                                  * An Instruction Abort exception.
                                                                  * A Misaligned PC exception.
                                                                  * A Misaligned Stack Pointer exception.
                                                                  * A Data Abort exception for which the value of the ISV bit is 0.
                                                                  * An Illegal Execution State exception.
                                                                  * Any debug exception except for Software Breakpoint
                                                                     Instruction exceptions. For Software Breakpoint Instruction
                                                                     exceptions, this bit has its standard meaning:- 0: 16-bit T32
                                                                     BKPT instruction. - 1: 32-bit A32 BKPT instruction or A64 BRK
                                                                     instruction.
                                                                  * An exception reported using EC value 0b000000. */
        uint32_t iss                   : 25; /**< [ 24:  0](R/W) Instruction Specific Syndrome. Architecturally, this field can
                                                                     be defined independently for each defined Exception class.
                                                                     However, in practice, some ISS encodings are used for more
                                                                     than one Exception class.

                                                                 Typically, an ISS encoding has a number of subfields. When an
                                                                     ISS subfield holds a register number, the value returned in
                                                                     that field is the AArch64 view of the register number, even if
                                                                     the reported exception was taken from AArch32 state. If the
                                                                     register number is AArch32 register R15, then:

                                                                  If the instruction that generated the exception was not
                                                                     UNPREDICTABLE, the field takes the value 0b11111.

                                                                  If the instruction that generated the exception was
                                                                     UNPREDICTABLE, the field takes an UNKNOWN value that must be
                                                                     either: The AArch64 view of the register number of a register
                                                                     that     might have been used at the Exception level from
                                                                     which the     exception was taken.  The value 0b11111.

                                                                 When the EC field is0b000000 RES0. */
#else /* Word 0 - Little Endian */
        uint32_t iss                   : 25; /**< [ 24:  0](R/W) Instruction Specific Syndrome. Architecturally, this field can
                                                                     be defined independently for each defined Exception class.
                                                                     However, in practice, some ISS encodings are used for more
                                                                     than one Exception class.

                                                                 Typically, an ISS encoding has a number of subfields. When an
                                                                     ISS subfield holds a register number, the value returned in
                                                                     that field is the AArch64 view of the register number, even if
                                                                     the reported exception was taken from AArch32 state. If the
                                                                     register number is AArch32 register R15, then:

                                                                  If the instruction that generated the exception was not
                                                                     UNPREDICTABLE, the field takes the value 0b11111.

                                                                  If the instruction that generated the exception was
                                                                     UNPREDICTABLE, the field takes an UNKNOWN value that must be
                                                                     either: The AArch64 view of the register number of a register
                                                                     that     might have been used at the Exception level from
                                                                     which the     exception was taken.  The value 0b11111.

                                                                 When the EC field is0b000000 RES0. */
        uint32_t il                    : 1;  /**< [ 25: 25](R/W) Instruction Length for synchronous exceptions.
                                                                 0 = 16-bit instruction trapped.
                                                                 1 = 32-bit instruction trapped. This value is also used when the
                                                                     exception is one of the following:
                                                                  * An SError interrupt.
                                                                  * An Instruction Abort exception.
                                                                  * A Misaligned PC exception.
                                                                  * A Misaligned Stack Pointer exception.
                                                                  * A Data Abort exception for which the value of the ISV bit is 0.
                                                                  * An Illegal Execution State exception.
                                                                  * Any debug exception except for Software Breakpoint
                                                                     Instruction exceptions. For Software Breakpoint Instruction
                                                                     exceptions, this bit has its standard meaning:- 0: 16-bit T32
                                                                     BKPT instruction. - 1: 32-bit A32 BKPT instruction or A64 BRK
                                                                     instruction.
                                                                  * An exception reported using EC value 0b000000. */
        uint32_t ec                    : 6;  /**< [ 31: 26](R/W) Exception Class. Indicates the reason for the exception that
                                                                     this register holds information about.

                                                                 0x0 = Unknown or Uncategorized Reason - generally used for
                                                                     exceptions as a result of erroneous execution.
                                                                 0x1 = Exceptions from WFE/WFI from either AArch32 or AArch64 as a
                                                                     result of configurable traps, enables, or disables.

                                                                 Conditional WFE and WFI instructions that fail their condition
                                                                     code check do not cause an exception.

                                                                 0x3 = Exceptions from MCR/MRC to CP15 from AArch32 as a result of
                                                                     configurable traps, enables, or disables that do not use
                                                                     code 0x0.
                                                                 0x4 = Exceptions from MCRR/MRRC to CP15 from AArch32 as a result of
                                                                     configurable traps, enables, or disables that do not use
                                                                     code 0x0.
                                                                 0x5 = Exceptions from MCR/MRC to CP14 from AArch32 as a result of
                                                                     configurable traps, enables, or disables that do not use
                                                                     code 0x0.
                                                                 0x6 = Exceptions from LDC/STC to CP14 from AArch32 as a result of
                                                                     configurable traps, enables, or disables. The only architected
                                                                     uses of these instructions to access CP14 are:
                                                                  An STC to write to AP_DBGDTRRX_EL0 or DBGDTRRXint.
                                                                  An LDC to read from AP_DBGDTRTX_EL0 or DBGDTRTXint.

                                                                 0x7 = Exceptions from access to Advanced SIMD or Floating Point as a
                                                                     result of configurable traps, enables, or disables.
                                                                 0xC = Exceptions from MCRR/MRRC to CP14 from AArch32 as a result of
                                                                     configurable traps, enables, or disables.
                                                                 0xE = Exceptions that occur because the value of PSTATE[IL] is 1.
                                                                 0x13 =SMC that is not disabled executed in AArch32.
                                                                 0x15 = SVC executed in AArch64.
                                                                 0x16 = HVC that is not disabled executed in AArch64.
                                                                 0x17 = SMC that is not disabled executed in AArch64.
                                                                 0x18 = Exceptions as a result of MSR, MRS, or System AArch64
                                                                     instructions as a result of configurable traps, enables, or
                                                                     disables, except those using codes0b0000000b0000010b000111
                                                                 0x20 = Instruction Abort that caused entry from a lower Exception
                                                                     level (AArch32 or AArch64). Used for instruction access
                                                                     generated MMU faults and synchronous external aborts,
                                                                     including synchronous parity errors. Not used for debug
                                                                     related exceptions.
                                                                 0x21 = Instruction Abort that caused entry from a current Exception
                                                                     level (AArch64). Used for instruction access generated MMU
                                                                     faults and synchronous external aborts, including synchronous
                                                                     parity errors. Not used for debug related exceptions.
                                                                 0x22 = PC Alignment Exception.
                                                                 0x24 = Data Abort that caused entry from a lower Exception level
                                                                     (AArch32 or AArch64). Used for data access generated MMU
                                                                     faults, alignment faults other than those caused by the Stack
                                                                     Pointer misalignment, and synchronous external aborts,
                                                                     including synchronous parity errors. Not used for debug
                                                                     related exceptions.
                                                                 0x25 = Data Abort that caused entry from a current Exception level
                                                                     (AArch64). Used for data access generated MMU faults,
                                                                     alignment faults other than those caused by the Stack Pointer
                                                                     misalignment, and synchronous external aborts, including
                                                                     synchronous parity errors. Not used for debug related
                                                                     exceptions.
                                                                 0x26 = Stack Pointer Alignment Exception.
                                                                 0x2C = Exceptions as a result of Floating-point exception (optional
                                                                     feature) from AArch64.
                                                                 0x2F = SError Interrupt.
                                                                 0x3C = BRK instruction executed in AArch64 state. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_esr_elx_s cn; */
};
typedef union bdk_ap_esr_elx bdk_ap_esr_elx_t;

static inline uint64_t BDK_AP_ESR_ELX(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ESR_ELX(unsigned long a)
{
    if ((a>=1)&&(a<=3))
        return 0x30005020000ll + 0ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_ESR_ELX", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_ESR_ELX(a) bdk_ap_esr_elx_t
#define bustype_BDK_AP_ESR_ELX(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ESR_ELX(a) "AP_ESR_ELX"
#define busnum_BDK_AP_ESR_ELX(a) (a)
#define arguments_BDK_AP_ESR_ELX(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_esr_el12
 *
 * AP Exception Syndrome Register
 * Alias of ESR_EL1 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_esr_el12
{
    uint32_t u;
    struct bdk_ap_esr_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_esr_el12_s cn; */
};
typedef union bdk_ap_esr_el12 bdk_ap_esr_el12_t;

#define BDK_AP_ESR_EL12 BDK_AP_ESR_EL12_FUNC()
static inline uint64_t BDK_AP_ESR_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ESR_EL12_FUNC(void)
{
    return 0x30505020000ll;
}

#define typedef_BDK_AP_ESR_EL12 bdk_ap_esr_el12_t
#define bustype_BDK_AP_ESR_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ESR_EL12 "AP_ESR_EL12"
#define busnum_BDK_AP_ESR_EL12 0
#define arguments_BDK_AP_ESR_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_far_el#
 *
 * AP Fault Address Register
 * Holds the faulting Virtual Address for all synchronous
 *     instruction or data aborts, or exceptions from a misaligned
 *     PC, taken to EL*.
 */
union bdk_ap_far_elx
{
    uint64_t u;
    struct bdk_ap_far_elx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Faulting Virtual Address for exceptions taken to EL*.
                                                                     Exceptions that set the FAR_EL* are all synchronous
                                                                     instruction aborts or data aborts, or an exception from a
                                                                     misaligned PC.
                                                                 If a memory fault that sets FAR_EL* is generated from one of
                                                                     the data cache instructions, this field holds the address
                                                                     specified in the register argument of the instruction. */
#else /* Word 0 - Little Endian */
        uint64_t data                  : 64; /**< [ 63:  0](R/W) Faulting Virtual Address for exceptions taken to EL*.
                                                                     Exceptions that set the FAR_EL* are all synchronous
                                                                     instruction aborts or data aborts, or an exception from a
                                                                     misaligned PC.
                                                                 If a memory fault that sets FAR_EL* is generated from one of
                                                                     the data cache instructions, this field holds the address
                                                                     specified in the register argument of the instruction. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_far_elx_s cn; */
};
typedef union bdk_ap_far_elx bdk_ap_far_elx_t;

static inline uint64_t BDK_AP_FAR_ELX(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_FAR_ELX(unsigned long a)
{
    if ((a>=1)&&(a<=3))
        return 0x30006000000ll + 0ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_FAR_ELX", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_FAR_ELX(a) bdk_ap_far_elx_t
#define bustype_BDK_AP_FAR_ELX(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_FAR_ELX(a) "AP_FAR_ELX"
#define busnum_BDK_AP_FAR_ELX(a) (a)
#define arguments_BDK_AP_FAR_ELX(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_far_el12
 *
 * AP Fault Address Register
 * Alias of ESR_EL1 when accessed at EL2/3 and AP_HCR_EL2[E2H] is set.
 */
union bdk_ap_far_el12
{
    uint64_t u;
    struct bdk_ap_far_el12_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_far_el12_s cn; */
};
typedef union bdk_ap_far_el12 bdk_ap_far_el12_t;

#define BDK_AP_FAR_EL12 BDK_AP_FAR_EL12_FUNC()
static inline uint64_t BDK_AP_FAR_EL12_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_FAR_EL12_FUNC(void)
{
    return 0x30506000000ll;
}

#define typedef_BDK_AP_FAR_EL12 bdk_ap_far_el12_t
#define bustype_BDK_AP_FAR_EL12 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_FAR_EL12 "AP_FAR_EL12"
#define busnum_BDK_AP_FAR_EL12 0
#define arguments_BDK_AP_FAR_EL12 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_fpcr
 *
 * AP Floating-point Control Register
 * Controls floating-point extension behavior.
 */
union bdk_ap_fpcr
{
    uint32_t u;
    struct bdk_ap_fpcr_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_27_31        : 5;
        uint32_t ahp                   : 1;  /**< [ 26: 26](R/W) Alternative half-precision control bit:
                                                                 0 = IEEE half-precision format selected.
                                                                 1 = Alternative half-precision format selected. */
        uint32_t dn                    : 1;  /**< [ 25: 25](R/W) Default NaN mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = NaN operands propagate through to the output of a floating-
                                                                     point operation.
                                                                 1 = Any operation involving one or more NaNs returns the Default
                                                                     NaN. */
        uint32_t fz                    : 1;  /**< [ 24: 24](R/W) Flush-to-zero mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = Flush-to-zero mode disabled. Behavior of the floating-point
                                                                     system is fully compliant with the IEEE 754 standard.
                                                                 1 = Flush-to-zero mode enabled. */
        uint32_t rmode                 : 2;  /**< [ 23: 22](R/W) Rounding Mode control field. The encoding of this field is:
                                                                 The specified rounding mode is used by both scalar and
                                                                     Advanced SIMD floating-point instructions.
                                                                 0x0 = Round to Nearest (RN) mode.
                                                                 0x1 = Round towards Plus Infinity (RP) mode.
                                                                 0x2 = Round towards Minus Infinity (RM) mode.
                                                                 0x3 = Round towards Zero (RZ) mode. */
        uint32_t reserved_0_21         : 22;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_21         : 22;
        uint32_t rmode                 : 2;  /**< [ 23: 22](R/W) Rounding Mode control field. The encoding of this field is:
                                                                 The specified rounding mode is used by both scalar and
                                                                     Advanced SIMD floating-point instructions.
                                                                 0x0 = Round to Nearest (RN) mode.
                                                                 0x1 = Round towards Plus Infinity (RP) mode.
                                                                 0x2 = Round towards Minus Infinity (RM) mode.
                                                                 0x3 = Round towards Zero (RZ) mode. */
        uint32_t fz                    : 1;  /**< [ 24: 24](R/W) Flush-to-zero mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = Flush-to-zero mode disabled. Behavior of the floating-point
                                                                     system is fully compliant with the IEEE 754 standard.
                                                                 1 = Flush-to-zero mode enabled. */
        uint32_t dn                    : 1;  /**< [ 25: 25](R/W) Default NaN mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = NaN operands propagate through to the output of a floating-
                                                                     point operation.
                                                                 1 = Any operation involving one or more NaNs returns the Default
                                                                     NaN. */
        uint32_t ahp                   : 1;  /**< [ 26: 26](R/W) Alternative half-precision control bit:
                                                                 0 = IEEE half-precision format selected.
                                                                 1 = Alternative half-precision format selected. */
        uint32_t reserved_27_31        : 5;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_fpcr_cn
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_27_31        : 5;
        uint32_t ahp                   : 1;  /**< [ 26: 26](R/W) Alternative half-precision control bit:
                                                                 0 = IEEE half-precision format selected.
                                                                 1 = Alternative half-precision format selected. */
        uint32_t dn                    : 1;  /**< [ 25: 25](R/W) Default NaN mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = NaN operands propagate through to the output of a floating-
                                                                     point operation.
                                                                 1 = Any operation involving one or more NaNs returns the Default
                                                                     NaN. */
        uint32_t fz                    : 1;  /**< [ 24: 24](R/W) Flush-to-zero mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = Flush-to-zero mode disabled. Behavior of the floating-point
                                                                     system is fully compliant with the IEEE 754 standard.
                                                                 1 = Flush-to-zero mode enabled. */
        uint32_t rmode                 : 2;  /**< [ 23: 22](R/W) Rounding Mode control field. The encoding of this field is:
                                                                 The specified rounding mode is used by both scalar and
                                                                     Advanced SIMD floating-point instructions.
                                                                 0x0 = Round to Nearest (RN) mode.
                                                                 0x1 = Round towards Plus Infinity (RP) mode.
                                                                 0x2 = Round towards Minus Infinity (RM) mode.
                                                                 0x3 = Round towards Zero (RZ) mode. */
        uint32_t reserved_20_21        : 2;
        uint32_t reserved_19           : 1;
        uint32_t reserved_16_18        : 3;
        uint32_t reserved_15           : 1;
        uint32_t reserved_13_14        : 2;
        uint32_t reserved_12           : 1;
        uint32_t reserved_11           : 1;
        uint32_t reserved_10           : 1;
        uint32_t reserved_9            : 1;
        uint32_t reserved_8            : 1;
        uint32_t reserved_0_7          : 8;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_7          : 8;
        uint32_t reserved_8            : 1;
        uint32_t reserved_9            : 1;
        uint32_t reserved_10           : 1;
        uint32_t reserved_11           : 1;
        uint32_t reserved_12           : 1;
        uint32_t reserved_13_14        : 2;
        uint32_t reserved_15           : 1;
        uint32_t reserved_16_18        : 3;
        uint32_t reserved_19           : 1;
        uint32_t reserved_20_21        : 2;
        uint32_t rmode                 : 2;  /**< [ 23: 22](R/W) Rounding Mode control field. The encoding of this field is:
                                                                 The specified rounding mode is used by both scalar and
                                                                     Advanced SIMD floating-point instructions.
                                                                 0x0 = Round to Nearest (RN) mode.
                                                                 0x1 = Round towards Plus Infinity (RP) mode.
                                                                 0x2 = Round towards Minus Infinity (RM) mode.
                                                                 0x3 = Round towards Zero (RZ) mode. */
        uint32_t fz                    : 1;  /**< [ 24: 24](R/W) Flush-to-zero mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = Flush-to-zero mode disabled. Behavior of the floating-point
                                                                     system is fully compliant with the IEEE 754 standard.
                                                                 1 = Flush-to-zero mode enabled. */
        uint32_t dn                    : 1;  /**< [ 25: 25](R/W) Default NaN mode control bit:
                                                                 The value of this bit controls both scalar and Advanced SIMD
                                                                     floating-point arithmetic.
                                                                 0 = NaN operands propagate through to the output of a floating-
                                                                     point operation.
                                                                 1 = Any operation involving one or more NaNs returns the Default
                                                                     NaN. */
        uint32_t ahp                   : 1;  /**< [ 26: 26](R/W) Alternative half-precision control bit:
                                                                 0 = IEEE half-precision format selected.
                                                                 1 = Alternative half-precision format selected. */
        uint32_t reserved_27_31        : 5;
#endif /* Word 0 - End */
    } cn;
};
typedef union bdk_ap_fpcr bdk_ap_fpcr_t;

#define BDK_AP_FPCR BDK_AP_FPCR_FUNC()
static inline uint64_t BDK_AP_FPCR_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_FPCR_FUNC(void)
{
    return 0x30304040000ll;
}

#define typedef_BDK_AP_FPCR bdk_ap_fpcr_t
#define bustype_BDK_AP_FPCR BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_FPCR "AP_FPCR"
#define busnum_BDK_AP_FPCR 0
#define arguments_BDK_AP_FPCR -1,-1,-1,-1

/**
 * Register (SYSREG) ap_fpexc32_el2
 *
 * AP Floating-point Exception Control Register
 * Allows access to the AArch32 register FPEXC from AArch64 state
 *     only. Its value has no effect on execution in AArch64 state.
 */
union bdk_ap_fpexc32_el2
{
    uint32_t u;
    struct bdk_ap_fpexc32_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_fpexc32_el2_s cn; */
};
typedef union bdk_ap_fpexc32_el2 bdk_ap_fpexc32_el2_t;

#define BDK_AP_FPEXC32_EL2 BDK_AP_FPEXC32_EL2_FUNC()
static inline uint64_t BDK_AP_FPEXC32_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_FPEXC32_EL2_FUNC(void)
{
    return 0x30405030000ll;
}

#define typedef_BDK_AP_FPEXC32_EL2 bdk_ap_fpexc32_el2_t
#define bustype_BDK_AP_FPEXC32_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_FPEXC32_EL2 "AP_FPEXC32_EL2"
#define busnum_BDK_AP_FPEXC32_EL2 0
#define arguments_BDK_AP_FPEXC32_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_fpsr
 *
 * AP Floating-point Status Register
 * Provides floating-point system status information.
 */
union bdk_ap_fpsr
{
    uint32_t u;
    struct bdk_ap_fpsr_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_28_31        : 4;
        uint32_t qc                    : 1;  /**< [ 27: 27](R/W) Cumulative saturation bit, Advanced SIMD only. This bit is set
                                                                     to 1 to indicate that an Advanced SIMD integer operation has
                                                                     saturated since 0 was last written to this bit. */
        uint32_t reserved_8_26         : 19;
        uint32_t idc                   : 1;  /**< [  7:  7](R/W) Input Denormal cumulative exception bit. This bit is set to 1
                                                                     to indicate that the Input Denormal exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IDE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IDE] is
                                                                     0, or if trapping software sets it. */
        uint32_t reserved_5_6          : 2;
        uint32_t ixc                   : 1;  /**< [  4:  4](R/W) Inexact cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Inexact exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IXE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IXE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ufc                   : 1;  /**< [  3:  3](R/W) Underflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Underflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[UFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[UFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ofc                   : 1;  /**< [  2:  2](R/W) Overflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Overflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[OFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[OFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t dzc                   : 1;  /**< [  1:  1](R/W) Division by Zero cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Division by Zero exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[DZE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[DZE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ioc                   : 1;  /**< [  0:  0](R/W) Invalid Operation cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Invalid Operation exception has
                                                                     occurred since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IOE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IOE] is
                                                                     0, or if trapping software sets it. */
#else /* Word 0 - Little Endian */
        uint32_t ioc                   : 1;  /**< [  0:  0](R/W) Invalid Operation cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Invalid Operation exception has
                                                                     occurred since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IOE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IOE] is
                                                                     0, or if trapping software sets it. */
        uint32_t dzc                   : 1;  /**< [  1:  1](R/W) Division by Zero cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Division by Zero exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[DZE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[DZE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ofc                   : 1;  /**< [  2:  2](R/W) Overflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Overflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[OFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[OFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ufc                   : 1;  /**< [  3:  3](R/W) Underflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Underflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[UFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[UFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ixc                   : 1;  /**< [  4:  4](R/W) Inexact cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Inexact exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IXE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IXE] is
                                                                     0, or if trapping software sets it. */
        uint32_t reserved_5_6          : 2;
        uint32_t idc                   : 1;  /**< [  7:  7](R/W) Input Denormal cumulative exception bit. This bit is set to 1
                                                                     to indicate that the Input Denormal exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IDE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IDE] is
                                                                     0, or if trapping software sets it. */
        uint32_t reserved_8_26         : 19;
        uint32_t qc                    : 1;  /**< [ 27: 27](R/W) Cumulative saturation bit, Advanced SIMD only. This bit is set
                                                                     to 1 to indicate that an Advanced SIMD integer operation has
                                                                     saturated since 0 was last written to this bit. */
        uint32_t reserved_28_31        : 4;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_fpsr_cn
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_31           : 1;
        uint32_t reserved_30           : 1;
        uint32_t reserved_29           : 1;
        uint32_t reserved_28           : 1;
        uint32_t qc                    : 1;  /**< [ 27: 27](R/W) Cumulative saturation bit, Advanced SIMD only. This bit is set
                                                                     to 1 to indicate that an Advanced SIMD integer operation has
                                                                     saturated since 0 was last written to this bit. */
        uint32_t reserved_8_26         : 19;
        uint32_t idc                   : 1;  /**< [  7:  7](R/W) Input Denormal cumulative exception bit. This bit is set to 1
                                                                     to indicate that the Input Denormal exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IDE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IDE] is
                                                                     0, or if trapping software sets it. */
        uint32_t reserved_5_6          : 2;
        uint32_t ixc                   : 1;  /**< [  4:  4](R/W) Inexact cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Inexact exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IXE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IXE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ufc                   : 1;  /**< [  3:  3](R/W) Underflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Underflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[UFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[UFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ofc                   : 1;  /**< [  2:  2](R/W) Overflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Overflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[OFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[OFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t dzc                   : 1;  /**< [  1:  1](R/W) Division by Zero cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Division by Zero exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[DZE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[DZE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ioc                   : 1;  /**< [  0:  0](R/W) Invalid Operation cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Invalid Operation exception has
                                                                     occurred since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IOE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IOE] is
                                                                     0, or if trapping software sets it. */
#else /* Word 0 - Little Endian */
        uint32_t ioc                   : 1;  /**< [  0:  0](R/W) Invalid Operation cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Invalid Operation exception has
                                                                     occurred since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IOE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IOE] is
                                                                     0, or if trapping software sets it. */
        uint32_t dzc                   : 1;  /**< [  1:  1](R/W) Division by Zero cumulative exception bit. This bit is set to
                                                                     1 to indicate that the Division by Zero exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[DZE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[DZE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ofc                   : 1;  /**< [  2:  2](R/W) Overflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Overflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[OFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[OFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ufc                   : 1;  /**< [  3:  3](R/W) Underflow cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Underflow exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[UFE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[UFE] is
                                                                     0, or if trapping software sets it. */
        uint32_t ixc                   : 1;  /**< [  4:  4](R/W) Inexact cumulative exception bit. This bit is set to 1 to
                                                                     indicate that the Inexact exception has occurred since 0 was
                                                                     last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IXE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IXE] is
                                                                     0, or if trapping software sets it. */
        uint32_t reserved_5_6          : 2;
        uint32_t idc                   : 1;  /**< [  7:  7](R/W) Input Denormal cumulative exception bit. This bit is set to 1
                                                                     to indicate that the Input Denormal exception has occurred
                                                                     since 0 was last written to this bit.

                                                                 How scalar and Advanced SIMD floating-point instructions
                                                                     update this bit depends on the value of the AP_FPCR[IDE] bit. This
                                                                     bit is only set to 1 to indicate an exception if AP_FPCR[IDE] is
                                                                     0, or if trapping software sets it. */
        uint32_t reserved_8_26         : 19;
        uint32_t qc                    : 1;  /**< [ 27: 27](R/W) Cumulative saturation bit, Advanced SIMD only. This bit is set
                                                                     to 1 to indicate that an Advanced SIMD integer operation has
                                                                     saturated since 0 was last written to this bit. */
        uint32_t reserved_28           : 1;
        uint32_t reserved_29           : 1;
        uint32_t reserved_30           : 1;
        uint32_t reserved_31           : 1;
#endif /* Word 0 - End */
    } cn;
};
typedef union bdk_ap_fpsr bdk_ap_fpsr_t;

#define BDK_AP_FPSR BDK_AP_FPSR_FUNC()
static inline uint64_t BDK_AP_FPSR_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_FPSR_FUNC(void)
{
    return 0x30304040100ll;
}

#define typedef_BDK_AP_FPSR bdk_ap_fpsr_t
#define bustype_BDK_AP_FPSR BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_FPSR "AP_FPSR"
#define busnum_BDK_AP_FPSR 0
#define arguments_BDK_AP_FPSR -1,-1,-1,-1

/**
 * Register (SYSREG) ap_hacr_el2
 *
 * AP Hypervisor Auxiliary Control Register
 * Controls trapping to EL2 of implementation defined aspects of
 *     nonsecure EL1 or EL0 operation.
 */
union bdk_ap_hacr_el2
{
    uint32_t u;
    struct bdk_ap_hacr_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_hacr_el2_s cn; */
};
typedef union bdk_ap_hacr_el2 bdk_ap_hacr_el2_t;

#define BDK_AP_HACR_EL2 BDK_AP_HACR_EL2_FUNC()
static inline uint64_t BDK_AP_HACR_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_HACR_EL2_FUNC(void)
{
    return 0x30401010700ll;
}

#define typedef_BDK_AP_HACR_EL2 bdk_ap_hacr_el2_t
#define bustype_BDK_AP_HACR_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_HACR_EL2 "AP_HACR_EL2"
#define busnum_BDK_AP_HACR_EL2 0
#define arguments_BDK_AP_HACR_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_hcr_el2
 *
 * AP Hypervisor Configuration Register
 * Provides configuration controls for virtualization, including
 *     defining whether various nonsecure operations are trapped to
 *     EL2.
 */
union bdk_ap_hcr_el2
{
    uint64_t u;
    struct bdk_ap_hcr_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_38_63        : 26;
        uint64_t tea                   : 1;  /**< [ 37: 37](R/W) RAS: Route synchronous external aborts to EL2.
                                                                   0 = Do not route synchronous external aborts from Non-secure EL0 and EL1 to EL2.
                                                                   1 = Route synchronous external aborts from Non-secure EL0 and EL1 to EL2, if not routed
                                                                 to EL3. */
        uint64_t terr                  : 1;  /**< [ 36: 36](R/W) RAS: Trap Error record accesses.
                                                                   0 = Do not trap accesses to error record registers from Non-secure EL1 to EL2.
                                                                   1 = Accesses to the ER* registers from Non-secure EL1 generate a Trap exception to EL2. */
        uint64_t tlor                  : 1;  /**< [ 35: 35](R/W) v8.1: Trap access to the LOR Registers from nonsecure EL1 to EL2.
                                                                 0 = Nonsecure EL1 accesses to the LOR Registers are not trapped to EL2.
                                                                 1 = Nonsecure EL1 accesses to the LOR Registers are trapped to EL2. */
        uint64_t e2h                   : 1;  /**< [ 34: 34](R/W) V8.1: Enable EL2 host. */
        uint64_t id                    : 1;  /**< [ 33: 33](R/W) Stage 2 Instruction cache disable. When AP_HCR_EL2[VM]==1, this
                                                                     forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     instruction accesses.
                                                                 1 = Forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime. */
        uint64_t cd                    : 1;  /**< [ 32: 32](R/W) Stage 2 Data cache disable. When AP_HCR_EL2[VM]==1, this forces
                                                                     all stage 2 translations for data accesses and translation
                                                                     table walks to Normal memory to be Non-cacheable for the EL1&0
                                                                     translation regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     data accesses and translation table walks.
                                                                 1 = Forces all stage 2 translations for data accesses and
                                                                     translation table walks to Normal memory to be Non-cacheable
                                                                     for the EL1&0 translation regime. */
        uint64_t rsvd_31               : 1;  /**< [ 31: 31](RO) rw - Register Width control for lower exception levels:
                                                                 When AP_SCR_EL3[NS]==0, this bit behaves as if it has the same
                                                                     value as the AP_SCR_EL3[RW] bit except for the value read back.
                                                                 The RW bit is permitted to be cached in a TLB.
                                                                 0 = Lower levels are all AArch32.
                                                                 1 = EL1 is AArch64. EL0 is determined by the Execution state
                                                                     described in the current process state when executing at EL0. */
        uint64_t trvm                  : 1;  /**< [ 30: 30](R/W) Trap Read of Virtual Memory controls. When this bit is set to
                                                                     1, this causes Reads to the EL1 virtual memory control
                                                                     registers from EL1 to be trapped to EL2. This covers the
                                                                     following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1. */
        uint64_t reserved_29           : 1;
        uint64_t tdz                   : 1;  /**< [ 28: 28](R/W) Trap DC ZVA instruction:
                                                                 This bit also has an effect on the value read from the
                                                                     AP_DCZID_EL0 register. If this bit is 1, then reading
                                                                     AP_DCZID_EL0[DZP] from nonsecure EL1 or EL0 will return 1 to
                                                                     indicate that DC ZVA is prohibited.
                                                                 0 = The instruction is not trapped.
                                                                 1 = The instruction is trapped to EL2 when executed in nonsecure
                                                                     EL1 or EL0. */
        uint64_t tge                   : 1;  /**< [ 27: 27](R/W) Trap General Exceptions. If this bit is set to 1, and
                                                                     AP_SCR_EL3[NS] is set to 1, then:

                                                                  All exceptions that would be routed to EL1 are routed to EL2.

                                                                  The AP_SCTLR_EL1[M] bit is treated as being 0 regardless of its
                                                                     actual state (for EL1 using AArch32 or AArch64) other than for
                                                                     the purpose of reading the bit.

                                                                  The AP_HCR_EL2[FMO], IMO and AMO bits are treated as being 1
                                                                     regardless of their actual state other than for the purpose of
                                                                     reading the bits.

                                                                  All virtual interrupts are disabled.

                                                                  Any implementation defined mechanisms for signalling virtual
                                                                     interrupts are disabled.

                                                                  An exception return to EL1 is treated as an illegal exception
                                                                     return.

                                                                 Additionally, if AP_HCR_EL2[TGE] == 1, the
                                                                     AP_MDCR_EL2.{TDRA,TDOSA,TDA} bits are ignored and the processor
                                                                     behaves as if they are set to 1, other than for the value read
                                                                     back from AP_MDCR_EL2. */
        uint64_t tvm                   : 1;  /**< [ 26: 26](R/W) Trap Virtual Memory controls. When this bit is set to 1, this
                                                                     causes Writes to the EL1 virtual memory control registers from
                                                                     EL1 to be trapped to EL2. This covers the following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1 */
        uint64_t ttlb                  : 1;  /**< [ 25: 25](R/W) Trap TLB maintenance instructions. When this bit is set to 1,
                                                                     this causes TLB maintenance instructions executed from EL1
                                                                     which are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: TLBIALLIS, TLBIMVAIS, TLBIASIDIS, TLBIMVAAIS,
                                                                     TLBIALL, TLBIMVA, TLBIASID, DTLBIALL, DTLBIMVA, DTLBIASID,
                                                                     ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA, TLBIMVALIS,
                                                                     TLBIMVAALIS, TLBIMVAL, TLBIMVAAL

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, TLBI VMALLE1IS, TLBI VAE1IS, TLBI
                                                                     ASIDE1IS, TLBI VAAE1IS, TLBI VALE1IS, TLBI VAALE1IS */
        uint64_t tpu                   : 1;  /**< [ 24: 24](R/W) Trap Cache maintenance instructions to Point of Unification.
                                                                     When this bit is set to 1, this causes Cache maintenance
                                                                     instructions to the point of unification executed from EL1 or
                                                                     EL0 which are not UNdefined to be trapped to EL2. This covers
                                                                     the following instructions:

                                                                 AArch32: ICIMVAU, ICIALLU, ICIALLUIS, DCCMVAU.

                                                                 AArch64: IC IVAU, IC IALLU, IC IALLUIS, DC CVAU. */
        uint64_t tpc                   : 1;  /**< [ 23: 23](R/W) Trap Data/Unified Cache maintenance operations to Point of
                                                                     Coherency. When this bit is set to 1, this causes Data or
                                                                     Unified Cache maintenance instructions by address to the point
                                                                     of coherency executed from EL1 or EL0 which are not UNdefined
                                                                     to be trapped to EL2. This covers the following instructions:

                                                                 AArch32: DCIMVAC, DCCIMVAC, DCCMVAC.

                                                                 AArch64: DC IVAC, DC CIVAC, DC CVAC. */
        uint64_t tsw                   : 1;  /**< [ 22: 22](R/W) Trap Data/Unified Cache maintenance operations by Set/Way.
                                                                     When this bit is set to 1, this causes Data or Unified Cache
                                                                     maintenance instructions by set/way executed from EL1 which
                                                                     are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: DCISW, DCCSW, DCCISW.

                                                                 AArch64: DC ISW, DC CSW, DC CISW. */
        uint64_t tacr                  : 1;  /**< [ 21: 21](R/W) Trap Auxiliary Control Register. When this bit is set to 1,
                                                                     this causes accesses to the following registers executed from
                                                                     EL1 to be trapped to EL2:

                                                                 AArch32: ACTLR.

                                                                 AArch64: ACTLR_EL1. */
        uint64_t tidcp                 : 1;  /**< [ 20: 20](R/W) Trap Implementation Dependent functionality. When this bit is
                                                                     set to 1, this causes accesses to the following instruction
                                                                     set space executed from EL1 to be trapped to EL2.

                                                                 AArch32: MCR and MRC instructions as follows:

                                                                  All CP15, CRn==9,  Opcode1 = {0-7}, CRm == {c0-c2, c5-c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==10, Opcode1 =={0-7}, CRm == {c0, c1, c4, c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==11, Opcode1=={0-7}, CRm == {c0-c8, c15},
                                                                     opcode2 == {0-7}.

                                                                 AArch64: All encoding space reserved for implementation
                                                                     defined system operations ( S1_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>) and
                                                                     system registers ( S3_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>).

                                                                 It is implementation defined whether any of this functionality
                                                                     accessed from EL0 is trapped to EL2 when the AP_HCR_EL2[TIDCP] bit
                                                                     is set. If it is not trapped to EL2, it results in an
                                                                     Undefined exception taken to EL1. */
        uint64_t tsc                   : 1;  /**< [ 19: 19](R/W) Trap SMC. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 to be trapped to EL2:

                                                                 AArch32: SMC.

                                                                 AArch64: SMC.

                                                                 If EL3 is not implemented, this bit is RES0. */
        uint64_t tid3                  : 1;  /**< [ 18: 18](R/W) Trap ID Group 3. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: ID_PFR0, ID_PFR1, ID_DFR0, ID_AFR0, ID_MMFR0,
                                                                     ID_MMFR1, ID_MMFR2, ID_MMFR3, ID_ISAR0, ID_ISAR1, ID_ISAR2,
                                                                     ID_ISAR3, ID_ISAR4, ID_ISAR5, MVFR0, MVFR1, MVFR2. Also MRC to
                                                                     any of the following encodings:

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == {3-7}, Opc2 == {0,1}.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 3, Opc2 == 2.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 5, Opc2 == {4,5}.

                                                                 AArch64: AP_ID_PFR0_EL1, AP_ID_PFR1_EL1, AP_ID_DFR0_EL1, AP_ID_AFR0_EL1,
                                                                     ID_MMFR0_EL1, ID_MMFR1_EL1, ID_MMFR2_EL1, ID_MMFR3_EL1,
                                                                     ID_ISAR0_EL1, ID_ISAR1_EL1, ID_ISAR2_EL1, ID_ISAR3_EL1,
                                                                     ID_ISAR4_EL1, ID_ISAR5_EL1, MVFR0_EL1, MVFR1_EL1, MVFR2_EL1,
                                                                     AP_ID_AA64PFR0_EL1, AP_ID_AA64PFR1_EL1, AP_ID_AA64DFR0_EL1,
                                                                     AP_ID_AA64DFR1_EL1, AP_ID_AA64ISAR0_EL1, AP_ID_AA64ISAR1_EL1,
                                                                     AP_ID_AA64MMFR0_EL1, AP_ID_AA64MMFR1_EL1, AP_ID_AA64AFR0_EL1,
                                                                     AP_ID_AA64AFR1_EL1. */
        uint64_t tid2                  : 1;  /**< [ 17: 17](R/W) Trap ID Group 2. When this bit is set to 1, this causes reads
                                                                     (or writes to CSSELR/ AP_CSSELR_EL1) to the following registers
                                                                     executed from EL1 or EL0 if not UNdefined to be trapped to
                                                                     EL2:

                                                                 AArch32: CTR, CCSIDR, CLIDR, CSSELR.

                                                                 AArch64: AP_CTR_EL0, AP_CCSIDR_EL1, AP_CLIDR_EL1, AP_CSSELR_EL1. */
        uint64_t tid1                  : 1;  /**< [ 16: 16](R/W) Trap ID Group 1. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: TCMTR, TLBTR, AIDR, REVIDR.

                                                                 AArch64: AP_AIDR_EL1, AP_REVIDR_EL1. */
        uint64_t tid0                  : 1;  /**< [ 15: 15](R/W) Trap ID Group 0. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 or EL0 if not
                                                                     UNdefined to be trapped to EL2:

                                                                 AArch32: FPSID, JIDR.

                                                                 AArch64: None. */
        uint64_t twe                   : 1;  /**< [ 14: 14](R/W) Trap WFE. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if the event register is not set):

                                                                 AArch32: WFE.

                                                                 AArch64: WFE.

                                                                 Conditional WFE instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t twi                   : 1;  /**< [ 13: 13](R/W) Trap WFI. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if there is not a pending WFI wakeup event):

                                                                 AArch32: WFI.

                                                                 AArch64: WFI.

                                                                 Conditional WFI instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t dc                    : 1;  /**< [ 12: 12](R/W) Default Cacheable. When this bit is set to 1, this causes:

                                                                 * The AP_SCTLR_EL1[M] bit to behave as 0 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 * The AP_HCR_EL2[VM] bit to behave as 1 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 The memory type produced by the first stage of translation
                                                                     used by EL1 and EL0 is Normal Non-Shareable, Inner WriteBack
                                                                     Read-WriteAllocate, Outer WriteBack Read-WriteAllocate.

                                                                 When this bit is 0 and the stage 1 MMU is disabled, the
                                                                     default memory attribute for Data accesses is Device-nGnRnE.

                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t bsu                   : 2;  /**< [ 11: 10](R/W) Barrier Shareability upgrade. The value in this field
                                                                     determines the minimum shareability domain that is applied to
                                                                     any barrier executed from EL1 or EL0.

                                                                 This value is combined with the specified level of the barrier
                                                                     held in its instruction, using the same principles as
                                                                     combining the shareability attributes from two stages of
                                                                     address translation.

                                                                 0x0 = No effect.
                                                                 0x1 = Inner Shareable.
                                                                 0x2 = Outer Shareable.
                                                                 0x3 = Full system. */
        uint64_t fb                    : 1;  /**< [  9:  9](R/W) Force broadcast. When this bit is set to 1, this causes the
                                                                     following instructions to be broadcast within the Inner
                                                                     Shareable domain when executed from nonsecure EL1:

                                                                 AArch32: BPIALL, TLBIALL, TLBIMVA, TLBIASID, DTLBIALL,
                                                                     DTLBIMVA, DTLBIASID, ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA,
                                                                     ICIALLU, TLBIMVAL, TLBIMVAAL.

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, IC IALLU. */
        uint64_t vse                   : 1;  /**< [  8:  8](R/W) Virtual System Error/Asynchronous Abort.
                                                                 The virtual System Error/Asynchronous Abort is only enabled
                                                                     when the AP_HCR_EL2[AMO] bit is set.
                                                                 0 = Virtual System Error/Asynchronous Abort is not pending by this
                                                                     mechanism.
                                                                 1 = Virtual System Error/Asynchronous Abort is pending by this
                                                                     mechanism. */
        uint64_t vi                    : 1;  /**< [  7:  7](R/W) Virtual IRQ Interrupt.
                                                                 The virtual IRQ is only enabled when the AP_HCR_EL2[IMO] bit is
                                                                     set.
                                                                 0 = Virtual IRQ is not pending by this mechanism.
                                                                 1 = Virtual IRQ is pending by this mechanism. */
        uint64_t vf                    : 1;  /**< [  6:  6](R/W) Virtual FIQ Interrupt.
                                                                 The virtual FIQ is only enabled when the AP_HCR_EL2[FMO] bit is
                                                                     set.
                                                                 0 = Virtual FIQ is not pending by this mechanism.
                                                                 1 = Virtual FIQ is pending by this mechanism. */
        uint64_t amo                   : 1;  /**< [  5:  5](R/W) Asynchronous abort and error interrupt routing.
                                                                 0 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at exception levels lower than EL2 are not taken in
                                                                     EL2. Virtual System Error/Asynchronous Abort is disabled.
                                                                 1 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at EL2 or lower are taken in EL2 unless routed by
                                                                     the AP_SCR_EL3[EA] bit to EL3. Virtual System Error/Asynchronous
                                                                     Abort is enabled. */
        uint64_t imo                   : 1;  /**< [  4:  4](R/W) Physical IRQ Routing.
                                                                 0 = Physical IRQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual IRQ Interrupt is disabled.
                                                                 1 = Physical IRQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[IRQ] bit to EL3. Virtual IRQ
                                                                     Interrupt is enabled. */
        uint64_t fmo                   : 1;  /**< [  3:  3](R/W) Physical FIQ Routing.
                                                                 0 = Physical FIQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual FIQ Interrupt is disabled.
                                                                 1 = Physical FIQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[FIQ] bit to EL3. Virtual FIQ
                                                                     Interrupt is enabled. */
        uint64_t ptw                   : 1;  /**< [  2:  2](R/W) Protected Table Walk. When this bit is set to 1, if the stage
                                                                     2 translation of a translation table access made as part of a
                                                                     stage 1 translation table walk at EL0 or EL1 maps that
                                                                     translation table access to Strongly-ordered or Device memory,
                                                                     the access is faulted as a stage 2 Permission fault.
                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t swio                  : 1;  /**< [  1:  1](R/W) Set/Way Invalidation Override. When this bit is set to 1, this
                                                                     causes EL1 execution of the data cache invalidate by set/way
                                                                     instruction to be treated as data cache clean and invalidate
                                                                     by set/way. That is:

                                                                 AArch32: DCISW is executed as DCCISW.

                                                                 AArch64: DC ISW is executed as DC CISW.

                                                                 As a result of changes to the behavior of DCISW, this bit is
                                                                     redundant in ARMv8. It is permissible that an implementation
                                                                     makes this bit RES1. */
        uint64_t vm                    : 1;  /**< [  0:  0](R/W) Virtualization MMU enable for EL1 and EL0 stage 2 address
                                                                     translation.
                                                                 This bit is permitted to be cached in a TLB.
                                                                 0 = EL1 and EL0 stage 2 address translation disabled.
                                                                 1 = EL1 and EL0 stage 2 address translation enabled. */
#else /* Word 0 - Little Endian */
        uint64_t vm                    : 1;  /**< [  0:  0](R/W) Virtualization MMU enable for EL1 and EL0 stage 2 address
                                                                     translation.
                                                                 This bit is permitted to be cached in a TLB.
                                                                 0 = EL1 and EL0 stage 2 address translation disabled.
                                                                 1 = EL1 and EL0 stage 2 address translation enabled. */
        uint64_t swio                  : 1;  /**< [  1:  1](R/W) Set/Way Invalidation Override. When this bit is set to 1, this
                                                                     causes EL1 execution of the data cache invalidate by set/way
                                                                     instruction to be treated as data cache clean and invalidate
                                                                     by set/way. That is:

                                                                 AArch32: DCISW is executed as DCCISW.

                                                                 AArch64: DC ISW is executed as DC CISW.

                                                                 As a result of changes to the behavior of DCISW, this bit is
                                                                     redundant in ARMv8. It is permissible that an implementation
                                                                     makes this bit RES1. */
        uint64_t ptw                   : 1;  /**< [  2:  2](R/W) Protected Table Walk. When this bit is set to 1, if the stage
                                                                     2 translation of a translation table access made as part of a
                                                                     stage 1 translation table walk at EL0 or EL1 maps that
                                                                     translation table access to Strongly-ordered or Device memory,
                                                                     the access is faulted as a stage 2 Permission fault.
                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t fmo                   : 1;  /**< [  3:  3](R/W) Physical FIQ Routing.
                                                                 0 = Physical FIQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual FIQ Interrupt is disabled.
                                                                 1 = Physical FIQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[FIQ] bit to EL3. Virtual FIQ
                                                                     Interrupt is enabled. */
        uint64_t imo                   : 1;  /**< [  4:  4](R/W) Physical IRQ Routing.
                                                                 0 = Physical IRQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual IRQ Interrupt is disabled.
                                                                 1 = Physical IRQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[IRQ] bit to EL3. Virtual IRQ
                                                                     Interrupt is enabled. */
        uint64_t amo                   : 1;  /**< [  5:  5](R/W) Asynchronous abort and error interrupt routing.
                                                                 0 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at exception levels lower than EL2 are not taken in
                                                                     EL2. Virtual System Error/Asynchronous Abort is disabled.
                                                                 1 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at EL2 or lower are taken in EL2 unless routed by
                                                                     the AP_SCR_EL3[EA] bit to EL3. Virtual System Error/Asynchronous
                                                                     Abort is enabled. */
        uint64_t vf                    : 1;  /**< [  6:  6](R/W) Virtual FIQ Interrupt.
                                                                 The virtual FIQ is only enabled when the AP_HCR_EL2[FMO] bit is
                                                                     set.
                                                                 0 = Virtual FIQ is not pending by this mechanism.
                                                                 1 = Virtual FIQ is pending by this mechanism. */
        uint64_t vi                    : 1;  /**< [  7:  7](R/W) Virtual IRQ Interrupt.
                                                                 The virtual IRQ is only enabled when the AP_HCR_EL2[IMO] bit is
                                                                     set.
                                                                 0 = Virtual IRQ is not pending by this mechanism.
                                                                 1 = Virtual IRQ is pending by this mechanism. */
        uint64_t vse                   : 1;  /**< [  8:  8](R/W) Virtual System Error/Asynchronous Abort.
                                                                 The virtual System Error/Asynchronous Abort is only enabled
                                                                     when the AP_HCR_EL2[AMO] bit is set.
                                                                 0 = Virtual System Error/Asynchronous Abort is not pending by this
                                                                     mechanism.
                                                                 1 = Virtual System Error/Asynchronous Abort is pending by this
                                                                     mechanism. */
        uint64_t fb                    : 1;  /**< [  9:  9](R/W) Force broadcast. When this bit is set to 1, this causes the
                                                                     following instructions to be broadcast within the Inner
                                                                     Shareable domain when executed from nonsecure EL1:

                                                                 AArch32: BPIALL, TLBIALL, TLBIMVA, TLBIASID, DTLBIALL,
                                                                     DTLBIMVA, DTLBIASID, ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA,
                                                                     ICIALLU, TLBIMVAL, TLBIMVAAL.

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, IC IALLU. */
        uint64_t bsu                   : 2;  /**< [ 11: 10](R/W) Barrier Shareability upgrade. The value in this field
                                                                     determines the minimum shareability domain that is applied to
                                                                     any barrier executed from EL1 or EL0.

                                                                 This value is combined with the specified level of the barrier
                                                                     held in its instruction, using the same principles as
                                                                     combining the shareability attributes from two stages of
                                                                     address translation.

                                                                 0x0 = No effect.
                                                                 0x1 = Inner Shareable.
                                                                 0x2 = Outer Shareable.
                                                                 0x3 = Full system. */
        uint64_t dc                    : 1;  /**< [ 12: 12](R/W) Default Cacheable. When this bit is set to 1, this causes:

                                                                 * The AP_SCTLR_EL1[M] bit to behave as 0 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 * The AP_HCR_EL2[VM] bit to behave as 1 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 The memory type produced by the first stage of translation
                                                                     used by EL1 and EL0 is Normal Non-Shareable, Inner WriteBack
                                                                     Read-WriteAllocate, Outer WriteBack Read-WriteAllocate.

                                                                 When this bit is 0 and the stage 1 MMU is disabled, the
                                                                     default memory attribute for Data accesses is Device-nGnRnE.

                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t twi                   : 1;  /**< [ 13: 13](R/W) Trap WFI. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if there is not a pending WFI wakeup event):

                                                                 AArch32: WFI.

                                                                 AArch64: WFI.

                                                                 Conditional WFI instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t twe                   : 1;  /**< [ 14: 14](R/W) Trap WFE. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if the event register is not set):

                                                                 AArch32: WFE.

                                                                 AArch64: WFE.

                                                                 Conditional WFE instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t tid0                  : 1;  /**< [ 15: 15](R/W) Trap ID Group 0. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 or EL0 if not
                                                                     UNdefined to be trapped to EL2:

                                                                 AArch32: FPSID, JIDR.

                                                                 AArch64: None. */
        uint64_t tid1                  : 1;  /**< [ 16: 16](R/W) Trap ID Group 1. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: TCMTR, TLBTR, AIDR, REVIDR.

                                                                 AArch64: AP_AIDR_EL1, AP_REVIDR_EL1. */
        uint64_t tid2                  : 1;  /**< [ 17: 17](R/W) Trap ID Group 2. When this bit is set to 1, this causes reads
                                                                     (or writes to CSSELR/ AP_CSSELR_EL1) to the following registers
                                                                     executed from EL1 or EL0 if not UNdefined to be trapped to
                                                                     EL2:

                                                                 AArch32: CTR, CCSIDR, CLIDR, CSSELR.

                                                                 AArch64: AP_CTR_EL0, AP_CCSIDR_EL1, AP_CLIDR_EL1, AP_CSSELR_EL1. */
        uint64_t tid3                  : 1;  /**< [ 18: 18](R/W) Trap ID Group 3. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: ID_PFR0, ID_PFR1, ID_DFR0, ID_AFR0, ID_MMFR0,
                                                                     ID_MMFR1, ID_MMFR2, ID_MMFR3, ID_ISAR0, ID_ISAR1, ID_ISAR2,
                                                                     ID_ISAR3, ID_ISAR4, ID_ISAR5, MVFR0, MVFR1, MVFR2. Also MRC to
                                                                     any of the following encodings:

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == {3-7}, Opc2 == {0,1}.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 3, Opc2 == 2.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 5, Opc2 == {4,5}.

                                                                 AArch64: AP_ID_PFR0_EL1, AP_ID_PFR1_EL1, AP_ID_DFR0_EL1, AP_ID_AFR0_EL1,
                                                                     ID_MMFR0_EL1, ID_MMFR1_EL1, ID_MMFR2_EL1, ID_MMFR3_EL1,
                                                                     ID_ISAR0_EL1, ID_ISAR1_EL1, ID_ISAR2_EL1, ID_ISAR3_EL1,
                                                                     ID_ISAR4_EL1, ID_ISAR5_EL1, MVFR0_EL1, MVFR1_EL1, MVFR2_EL1,
                                                                     AP_ID_AA64PFR0_EL1, AP_ID_AA64PFR1_EL1, AP_ID_AA64DFR0_EL1,
                                                                     AP_ID_AA64DFR1_EL1, AP_ID_AA64ISAR0_EL1, AP_ID_AA64ISAR1_EL1,
                                                                     AP_ID_AA64MMFR0_EL1, AP_ID_AA64MMFR1_EL1, AP_ID_AA64AFR0_EL1,
                                                                     AP_ID_AA64AFR1_EL1. */
        uint64_t tsc                   : 1;  /**< [ 19: 19](R/W) Trap SMC. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 to be trapped to EL2:

                                                                 AArch32: SMC.

                                                                 AArch64: SMC.

                                                                 If EL3 is not implemented, this bit is RES0. */
        uint64_t tidcp                 : 1;  /**< [ 20: 20](R/W) Trap Implementation Dependent functionality. When this bit is
                                                                     set to 1, this causes accesses to the following instruction
                                                                     set space executed from EL1 to be trapped to EL2.

                                                                 AArch32: MCR and MRC instructions as follows:

                                                                  All CP15, CRn==9,  Opcode1 = {0-7}, CRm == {c0-c2, c5-c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==10, Opcode1 =={0-7}, CRm == {c0, c1, c4, c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==11, Opcode1=={0-7}, CRm == {c0-c8, c15},
                                                                     opcode2 == {0-7}.

                                                                 AArch64: All encoding space reserved for implementation
                                                                     defined system operations ( S1_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>) and
                                                                     system registers ( S3_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>).

                                                                 It is implementation defined whether any of this functionality
                                                                     accessed from EL0 is trapped to EL2 when the AP_HCR_EL2[TIDCP] bit
                                                                     is set. If it is not trapped to EL2, it results in an
                                                                     Undefined exception taken to EL1. */
        uint64_t tacr                  : 1;  /**< [ 21: 21](R/W) Trap Auxiliary Control Register. When this bit is set to 1,
                                                                     this causes accesses to the following registers executed from
                                                                     EL1 to be trapped to EL2:

                                                                 AArch32: ACTLR.

                                                                 AArch64: ACTLR_EL1. */
        uint64_t tsw                   : 1;  /**< [ 22: 22](R/W) Trap Data/Unified Cache maintenance operations by Set/Way.
                                                                     When this bit is set to 1, this causes Data or Unified Cache
                                                                     maintenance instructions by set/way executed from EL1 which
                                                                     are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: DCISW, DCCSW, DCCISW.

                                                                 AArch64: DC ISW, DC CSW, DC CISW. */
        uint64_t tpc                   : 1;  /**< [ 23: 23](R/W) Trap Data/Unified Cache maintenance operations to Point of
                                                                     Coherency. When this bit is set to 1, this causes Data or
                                                                     Unified Cache maintenance instructions by address to the point
                                                                     of coherency executed from EL1 or EL0 which are not UNdefined
                                                                     to be trapped to EL2. This covers the following instructions:

                                                                 AArch32: DCIMVAC, DCCIMVAC, DCCMVAC.

                                                                 AArch64: DC IVAC, DC CIVAC, DC CVAC. */
        uint64_t tpu                   : 1;  /**< [ 24: 24](R/W) Trap Cache maintenance instructions to Point of Unification.
                                                                     When this bit is set to 1, this causes Cache maintenance
                                                                     instructions to the point of unification executed from EL1 or
                                                                     EL0 which are not UNdefined to be trapped to EL2. This covers
                                                                     the following instructions:

                                                                 AArch32: ICIMVAU, ICIALLU, ICIALLUIS, DCCMVAU.

                                                                 AArch64: IC IVAU, IC IALLU, IC IALLUIS, DC CVAU. */
        uint64_t ttlb                  : 1;  /**< [ 25: 25](R/W) Trap TLB maintenance instructions. When this bit is set to 1,
                                                                     this causes TLB maintenance instructions executed from EL1
                                                                     which are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: TLBIALLIS, TLBIMVAIS, TLBIASIDIS, TLBIMVAAIS,
                                                                     TLBIALL, TLBIMVA, TLBIASID, DTLBIALL, DTLBIMVA, DTLBIASID,
                                                                     ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA, TLBIMVALIS,
                                                                     TLBIMVAALIS, TLBIMVAL, TLBIMVAAL

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, TLBI VMALLE1IS, TLBI VAE1IS, TLBI
                                                                     ASIDE1IS, TLBI VAAE1IS, TLBI VALE1IS, TLBI VAALE1IS */
        uint64_t tvm                   : 1;  /**< [ 26: 26](R/W) Trap Virtual Memory controls. When this bit is set to 1, this
                                                                     causes Writes to the EL1 virtual memory control registers from
                                                                     EL1 to be trapped to EL2. This covers the following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1 */
        uint64_t tge                   : 1;  /**< [ 27: 27](R/W) Trap General Exceptions. If this bit is set to 1, and
                                                                     AP_SCR_EL3[NS] is set to 1, then:

                                                                  All exceptions that would be routed to EL1 are routed to EL2.

                                                                  The AP_SCTLR_EL1[M] bit is treated as being 0 regardless of its
                                                                     actual state (for EL1 using AArch32 or AArch64) other than for
                                                                     the purpose of reading the bit.

                                                                  The AP_HCR_EL2[FMO], IMO and AMO bits are treated as being 1
                                                                     regardless of their actual state other than for the purpose of
                                                                     reading the bits.

                                                                  All virtual interrupts are disabled.

                                                                  Any implementation defined mechanisms for signalling virtual
                                                                     interrupts are disabled.

                                                                  An exception return to EL1 is treated as an illegal exception
                                                                     return.

                                                                 Additionally, if AP_HCR_EL2[TGE] == 1, the
                                                                     AP_MDCR_EL2.{TDRA,TDOSA,TDA} bits are ignored and the processor
                                                                     behaves as if they are set to 1, other than for the value read
                                                                     back from AP_MDCR_EL2. */
        uint64_t tdz                   : 1;  /**< [ 28: 28](R/W) Trap DC ZVA instruction:
                                                                 This bit also has an effect on the value read from the
                                                                     AP_DCZID_EL0 register. If this bit is 1, then reading
                                                                     AP_DCZID_EL0[DZP] from nonsecure EL1 or EL0 will return 1 to
                                                                     indicate that DC ZVA is prohibited.
                                                                 0 = The instruction is not trapped.
                                                                 1 = The instruction is trapped to EL2 when executed in nonsecure
                                                                     EL1 or EL0. */
        uint64_t reserved_29           : 1;
        uint64_t trvm                  : 1;  /**< [ 30: 30](R/W) Trap Read of Virtual Memory controls. When this bit is set to
                                                                     1, this causes Reads to the EL1 virtual memory control
                                                                     registers from EL1 to be trapped to EL2. This covers the
                                                                     following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1. */
        uint64_t rsvd_31               : 1;  /**< [ 31: 31](RO) rw - Register Width control for lower exception levels:
                                                                 When AP_SCR_EL3[NS]==0, this bit behaves as if it has the same
                                                                     value as the AP_SCR_EL3[RW] bit except for the value read back.
                                                                 The RW bit is permitted to be cached in a TLB.
                                                                 0 = Lower levels are all AArch32.
                                                                 1 = EL1 is AArch64. EL0 is determined by the Execution state
                                                                     described in the current process state when executing at EL0. */
        uint64_t cd                    : 1;  /**< [ 32: 32](R/W) Stage 2 Data cache disable. When AP_HCR_EL2[VM]==1, this forces
                                                                     all stage 2 translations for data accesses and translation
                                                                     table walks to Normal memory to be Non-cacheable for the EL1&0
                                                                     translation regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     data accesses and translation table walks.
                                                                 1 = Forces all stage 2 translations for data accesses and
                                                                     translation table walks to Normal memory to be Non-cacheable
                                                                     for the EL1&0 translation regime. */
        uint64_t id                    : 1;  /**< [ 33: 33](R/W) Stage 2 Instruction cache disable. When AP_HCR_EL2[VM]==1, this
                                                                     forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     instruction accesses.
                                                                 1 = Forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime. */
        uint64_t e2h                   : 1;  /**< [ 34: 34](R/W) V8.1: Enable EL2 host. */
        uint64_t tlor                  : 1;  /**< [ 35: 35](R/W) v8.1: Trap access to the LOR Registers from nonsecure EL1 to EL2.
                                                                 0 = Nonsecure EL1 accesses to the LOR Registers are not trapped to EL2.
                                                                 1 = Nonsecure EL1 accesses to the LOR Registers are trapped to EL2. */
        uint64_t terr                  : 1;  /**< [ 36: 36](R/W) RAS: Trap Error record accesses.
                                                                   0 = Do not trap accesses to error record registers from Non-secure EL1 to EL2.
                                                                   1 = Accesses to the ER* registers from Non-secure EL1 generate a Trap exception to EL2. */
        uint64_t tea                   : 1;  /**< [ 37: 37](R/W) RAS: Route synchronous external aborts to EL2.
                                                                   0 = Do not route synchronous external aborts from Non-secure EL0 and EL1 to EL2.
                                                                   1 = Route synchronous external aborts from Non-secure EL0 and EL1 to EL2, if not routed
                                                                 to EL3. */
        uint64_t reserved_38_63        : 26;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_hcr_el2_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_36_63        : 28;
        uint64_t tlor                  : 1;  /**< [ 35: 35](R/W) v8.1: Trap access to the LOR Registers from nonsecure EL1 to EL2.
                                                                 0 = Nonsecure EL1 accesses to the LOR Registers are not trapped to EL2.
                                                                 1 = Nonsecure EL1 accesses to the LOR Registers are trapped to EL2. */
        uint64_t e2h                   : 1;  /**< [ 34: 34](R/W) V8.1: Enable EL2 host. */
        uint64_t id                    : 1;  /**< [ 33: 33](R/W) Stage 2 Instruction cache disable. When AP_HCR_EL2[VM]==1, this
                                                                     forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     instruction accesses.
                                                                 1 = Forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime. */
        uint64_t cd                    : 1;  /**< [ 32: 32](R/W) Stage 2 Data cache disable. When AP_HCR_EL2[VM]==1, this forces
                                                                     all stage 2 translations for data accesses and translation
                                                                     table walks to Normal memory to be Non-cacheable for the EL1&0
                                                                     translation regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     data accesses and translation table walks.
                                                                 1 = Forces all stage 2 translations for data accesses and
                                                                     translation table walks to Normal memory to be Non-cacheable
                                                                     for the EL1&0 translation regime. */
        uint64_t rsvd_31               : 1;  /**< [ 31: 31](RO) rw - Register Width control for lower exception levels:
                                                                 When AP_SCR_EL3[NS]==0, this bit behaves as if it has the same
                                                                     value as the AP_SCR_EL3[RW] bit except for the value read back.
                                                                 The RW bit is permitted to be cached in a TLB.
                                                                 0 = Lower levels are all AArch32.
                                                                 1 = EL1 is AArch64. EL0 is determined by the Execution state
                                                                     described in the current process state when executing at EL0. */
        uint64_t trvm                  : 1;  /**< [ 30: 30](R/W) Trap Read of Virtual Memory controls. When this bit is set to
                                                                     1, this causes Reads to the EL1 virtual memory control
                                                                     registers from EL1 to be trapped to EL2. This covers the
                                                                     following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1. */
        uint64_t reserved_29           : 1;
        uint64_t tdz                   : 1;  /**< [ 28: 28](R/W) Trap DC ZVA instruction:
                                                                 This bit also has an effect on the value read from the
                                                                     AP_DCZID_EL0 register. If this bit is 1, then reading
                                                                     AP_DCZID_EL0[DZP] from nonsecure EL1 or EL0 will return 1 to
                                                                     indicate that DC ZVA is prohibited.
                                                                 0 = The instruction is not trapped.
                                                                 1 = The instruction is trapped to EL2 when executed in nonsecure
                                                                     EL1 or EL0. */
        uint64_t tge                   : 1;  /**< [ 27: 27](R/W) Trap General Exceptions. If this bit is set to 1, and
                                                                     AP_SCR_EL3[NS] is set to 1, then:

                                                                  All exceptions that would be routed to EL1 are routed to EL2.

                                                                  The AP_SCTLR_EL1[M] bit is treated as being 0 regardless of its
                                                                     actual state (for EL1 using AArch32 or AArch64) other than for
                                                                     the purpose of reading the bit.

                                                                  The AP_HCR_EL2[FMO], IMO and AMO bits are treated as being 1
                                                                     regardless of their actual state other than for the purpose of
                                                                     reading the bits.

                                                                  All virtual interrupts are disabled.

                                                                  Any implementation defined mechanisms for signalling virtual
                                                                     interrupts are disabled.

                                                                  An exception return to EL1 is treated as an illegal exception
                                                                     return.

                                                                 Additionally, if AP_HCR_EL2[TGE] == 1, the
                                                                     AP_MDCR_EL2.{TDRA,TDOSA,TDA} bits are ignored and the processor
                                                                     behaves as if they are set to 1, other than for the value read
                                                                     back from AP_MDCR_EL2. */
        uint64_t tvm                   : 1;  /**< [ 26: 26](R/W) Trap Virtual Memory controls. When this bit is set to 1, this
                                                                     causes Writes to the EL1 virtual memory control registers from
                                                                     EL1 to be trapped to EL2. This covers the following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1 */
        uint64_t ttlb                  : 1;  /**< [ 25: 25](R/W) Trap TLB maintenance instructions. When this bit is set to 1,
                                                                     this causes TLB maintenance instructions executed from EL1
                                                                     which are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: TLBIALLIS, TLBIMVAIS, TLBIASIDIS, TLBIMVAAIS,
                                                                     TLBIALL, TLBIMVA, TLBIASID, DTLBIALL, DTLBIMVA, DTLBIASID,
                                                                     ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA, TLBIMVALIS,
                                                                     TLBIMVAALIS, TLBIMVAL, TLBIMVAAL

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, TLBI VMALLE1IS, TLBI VAE1IS, TLBI
                                                                     ASIDE1IS, TLBI VAAE1IS, TLBI VALE1IS, TLBI VAALE1IS */
        uint64_t tpu                   : 1;  /**< [ 24: 24](R/W) Trap Cache maintenance instructions to Point of Unification.
                                                                     When this bit is set to 1, this causes Cache maintenance
                                                                     instructions to the point of unification executed from EL1 or
                                                                     EL0 which are not UNdefined to be trapped to EL2. This covers
                                                                     the following instructions:

                                                                 AArch32: ICIMVAU, ICIALLU, ICIALLUIS, DCCMVAU.

                                                                 AArch64: IC IVAU, IC IALLU, IC IALLUIS, DC CVAU. */
        uint64_t tpc                   : 1;  /**< [ 23: 23](R/W) Trap Data/Unified Cache maintenance operations to Point of
                                                                     Coherency. When this bit is set to 1, this causes Data or
                                                                     Unified Cache maintenance instructions by address to the point
                                                                     of coherency executed from EL1 or EL0 which are not UNdefined
                                                                     to be trapped to EL2. This covers the following instructions:

                                                                 AArch32: DCIMVAC, DCCIMVAC, DCCMVAC.

                                                                 AArch64: DC IVAC, DC CIVAC, DC CVAC. */
        uint64_t tsw                   : 1;  /**< [ 22: 22](R/W) Trap Data/Unified Cache maintenance operations by Set/Way.
                                                                     When this bit is set to 1, this causes Data or Unified Cache
                                                                     maintenance instructions by set/way executed from EL1 which
                                                                     are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: DCISW, DCCSW, DCCISW.

                                                                 AArch64: DC ISW, DC CSW, DC CISW. */
        uint64_t tacr                  : 1;  /**< [ 21: 21](R/W) Trap Auxiliary Control Register. When this bit is set to 1,
                                                                     this causes accesses to the following registers executed from
                                                                     EL1 to be trapped to EL2:

                                                                 AArch32: ACTLR.

                                                                 AArch64: ACTLR_EL1. */
        uint64_t tidcp                 : 1;  /**< [ 20: 20](R/W) Trap Implementation Dependent functionality. When this bit is
                                                                     set to 1, this causes accesses to the following instruction
                                                                     set space executed from EL1 to be trapped to EL2.

                                                                 AArch32: MCR and MRC instructions as follows:

                                                                  All CP15, CRn==9,  Opcode1 = {0-7}, CRm == {c0-c2, c5-c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==10, Opcode1 =={0-7}, CRm == {c0, c1, c4, c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==11, Opcode1=={0-7}, CRm == {c0-c8, c15},
                                                                     opcode2 == {0-7}.

                                                                 AArch64: All encoding space reserved for implementation
                                                                     defined system operations ( S1_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>) and
                                                                     system registers ( S3_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>).

                                                                 It is implementation defined whether any of this functionality
                                                                     accessed from EL0 is trapped to EL2 when the AP_HCR_EL2[TIDCP] bit
                                                                     is set. If it is not trapped to EL2, it results in an
                                                                     Undefined exception taken to EL1. */
        uint64_t tsc                   : 1;  /**< [ 19: 19](R/W) Trap SMC. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 to be trapped to EL2:

                                                                 AArch32: SMC.

                                                                 AArch64: SMC.

                                                                 If EL3 is not implemented, this bit is RES0. */
        uint64_t tid3                  : 1;  /**< [ 18: 18](R/W) Trap ID Group 3. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: ID_PFR0, ID_PFR1, ID_DFR0, ID_AFR0, ID_MMFR0,
                                                                     ID_MMFR1, ID_MMFR2, ID_MMFR3, ID_ISAR0, ID_ISAR1, ID_ISAR2,
                                                                     ID_ISAR3, ID_ISAR4, ID_ISAR5, MVFR0, MVFR1, MVFR2. Also MRC to
                                                                     any of the following encodings:

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == {3-7}, Opc2 == {0,1}.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 3, Opc2 == 2.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 5, Opc2 == {4,5}.

                                                                 AArch64: AP_ID_PFR0_EL1, AP_ID_PFR1_EL1, AP_ID_DFR0_EL1, AP_ID_AFR0_EL1,
                                                                     ID_MMFR0_EL1, ID_MMFR1_EL1, ID_MMFR2_EL1, ID_MMFR3_EL1,
                                                                     ID_ISAR0_EL1, ID_ISAR1_EL1, ID_ISAR2_EL1, ID_ISAR3_EL1,
                                                                     ID_ISAR4_EL1, ID_ISAR5_EL1, MVFR0_EL1, MVFR1_EL1, MVFR2_EL1,
                                                                     AP_ID_AA64PFR0_EL1, AP_ID_AA64PFR1_EL1, AP_ID_AA64DFR0_EL1,
                                                                     AP_ID_AA64DFR1_EL1, AP_ID_AA64ISAR0_EL1, AP_ID_AA64ISAR1_EL1,
                                                                     AP_ID_AA64MMFR0_EL1, AP_ID_AA64MMFR1_EL1, AP_ID_AA64AFR0_EL1,
                                                                     AP_ID_AA64AFR1_EL1. */
        uint64_t tid2                  : 1;  /**< [ 17: 17](R/W) Trap ID Group 2. When this bit is set to 1, this causes reads
                                                                     (or writes to CSSELR/ AP_CSSELR_EL1) to the following registers
                                                                     executed from EL1 or EL0 if not UNdefined to be trapped to
                                                                     EL2:

                                                                 AArch32: CTR, CCSIDR, CLIDR, CSSELR.

                                                                 AArch64: AP_CTR_EL0, AP_CCSIDR_EL1, AP_CLIDR_EL1, AP_CSSELR_EL1. */
        uint64_t tid1                  : 1;  /**< [ 16: 16](R/W) Trap ID Group 1. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: TCMTR, TLBTR, AIDR, REVIDR.

                                                                 AArch64: AP_AIDR_EL1, AP_REVIDR_EL1. */
        uint64_t tid0                  : 1;  /**< [ 15: 15](R/W) Trap ID Group 0. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 or EL0 if not
                                                                     UNdefined to be trapped to EL2:

                                                                 AArch32: FPSID, JIDR.

                                                                 AArch64: None. */
        uint64_t twe                   : 1;  /**< [ 14: 14](R/W) Trap WFE. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if the event register is not set):

                                                                 AArch32: WFE.

                                                                 AArch64: WFE.

                                                                 Conditional WFE instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t twi                   : 1;  /**< [ 13: 13](R/W) Trap WFI. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if there is not a pending WFI wakeup event):

                                                                 AArch32: WFI.

                                                                 AArch64: WFI.

                                                                 Conditional WFI instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t dc                    : 1;  /**< [ 12: 12](R/W) Default Cacheable. When this bit is set to 1, this causes:

                                                                 * The AP_SCTLR_EL1[M] bit to behave as 0 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 * The AP_HCR_EL2[VM] bit to behave as 1 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 The memory type produced by the first stage of translation
                                                                     used by EL1 and EL0 is Normal Non-Shareable, Inner WriteBack
                                                                     Read-WriteAllocate, Outer WriteBack Read-WriteAllocate.

                                                                 When this bit is 0 and the stage 1 MMU is disabled, the
                                                                     default memory attribute for Data accesses is Device-nGnRnE.

                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t bsu                   : 2;  /**< [ 11: 10](R/W) Barrier Shareability upgrade. The value in this field
                                                                     determines the minimum shareability domain that is applied to
                                                                     any barrier executed from EL1 or EL0.

                                                                 This value is combined with the specified level of the barrier
                                                                     held in its instruction, using the same principles as
                                                                     combining the shareability attributes from two stages of
                                                                     address translation.

                                                                 0x0 = No effect.
                                                                 0x1 = Inner Shareable.
                                                                 0x2 = Outer Shareable.
                                                                 0x3 = Full system. */
        uint64_t fb                    : 1;  /**< [  9:  9](R/W) Force broadcast. When this bit is set to 1, this causes the
                                                                     following instructions to be broadcast within the Inner
                                                                     Shareable domain when executed from nonsecure EL1:

                                                                 AArch32: BPIALL, TLBIALL, TLBIMVA, TLBIASID, DTLBIALL,
                                                                     DTLBIMVA, DTLBIASID, ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA,
                                                                     ICIALLU, TLBIMVAL, TLBIMVAAL.

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, IC IALLU. */
        uint64_t vse                   : 1;  /**< [  8:  8](R/W) Virtual System Error/Asynchronous Abort.
                                                                 The virtual System Error/Asynchronous Abort is only enabled
                                                                     when the AP_HCR_EL2[AMO] bit is set.
                                                                 0 = Virtual System Error/Asynchronous Abort is not pending by this
                                                                     mechanism.
                                                                 1 = Virtual System Error/Asynchronous Abort is pending by this
                                                                     mechanism. */
        uint64_t vi                    : 1;  /**< [  7:  7](R/W) Virtual IRQ Interrupt.
                                                                 The virtual IRQ is only enabled when the AP_HCR_EL2[IMO] bit is
                                                                     set.
                                                                 0 = Virtual IRQ is not pending by this mechanism.
                                                                 1 = Virtual IRQ is pending by this mechanism. */
        uint64_t vf                    : 1;  /**< [  6:  6](R/W) Virtual FIQ Interrupt.
                                                                 The virtual FIQ is only enabled when the AP_HCR_EL2[FMO] bit is
                                                                     set.
                                                                 0 = Virtual FIQ is not pending by this mechanism.
                                                                 1 = Virtual FIQ is pending by this mechanism. */
        uint64_t amo                   : 1;  /**< [  5:  5](R/W) Asynchronous abort and error interrupt routing.
                                                                 0 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at exception levels lower than EL2 are not taken in
                                                                     EL2. Virtual System Error/Asynchronous Abort is disabled.
                                                                 1 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at EL2 or lower are taken in EL2 unless routed by
                                                                     the AP_SCR_EL3[EA] bit to EL3. Virtual System Error/Asynchronous
                                                                     Abort is enabled. */
        uint64_t imo                   : 1;  /**< [  4:  4](R/W) Physical IRQ Routing.
                                                                 0 = Physical IRQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual IRQ Interrupt is disabled.
                                                                 1 = Physical IRQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[IRQ] bit to EL3. Virtual IRQ
                                                                     Interrupt is enabled. */
        uint64_t fmo                   : 1;  /**< [  3:  3](R/W) Physical FIQ Routing.
                                                                 0 = Physical FIQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual FIQ Interrupt is disabled.
                                                                 1 = Physical FIQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[FIQ] bit to EL3. Virtual FIQ
                                                                     Interrupt is enabled. */
        uint64_t ptw                   : 1;  /**< [  2:  2](R/W) Protected Table Walk. When this bit is set to 1, if the stage
                                                                     2 translation of a translation table access made as part of a
                                                                     stage 1 translation table walk at EL0 or EL1 maps that
                                                                     translation table access to Strongly-ordered or Device memory,
                                                                     the access is faulted as a stage 2 Permission fault.
                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t swio                  : 1;  /**< [  1:  1](R/W) Set/Way Invalidation Override. When this bit is set to 1, this
                                                                     causes EL1 execution of the data cache invalidate by set/way
                                                                     instruction to be treated as data cache clean and invalidate
                                                                     by set/way. That is:

                                                                 AArch32: DCISW is executed as DCCISW.

                                                                 AArch64: DC ISW is executed as DC CISW.

                                                                 As a result of changes to the behavior of DCISW, this bit is
                                                                     redundant in ARMv8. It is permissible that an implementation
                                                                     makes this bit RES1. */
        uint64_t vm                    : 1;  /**< [  0:  0](R/W) Virtualization MMU enable for EL1 and EL0 stage 2 address
                                                                     translation.
                                                                 This bit is permitted to be cached in a TLB.
                                                                 0 = EL1 and EL0 stage 2 address translation disabled.
                                                                 1 = EL1 and EL0 stage 2 address translation enabled. */
#else /* Word 0 - Little Endian */
        uint64_t vm                    : 1;  /**< [  0:  0](R/W) Virtualization MMU enable for EL1 and EL0 stage 2 address
                                                                     translation.
                                                                 This bit is permitted to be cached in a TLB.
                                                                 0 = EL1 and EL0 stage 2 address translation disabled.
                                                                 1 = EL1 and EL0 stage 2 address translation enabled. */
        uint64_t swio                  : 1;  /**< [  1:  1](R/W) Set/Way Invalidation Override. When this bit is set to 1, this
                                                                     causes EL1 execution of the data cache invalidate by set/way
                                                                     instruction to be treated as data cache clean and invalidate
                                                                     by set/way. That is:

                                                                 AArch32: DCISW is executed as DCCISW.

                                                                 AArch64: DC ISW is executed as DC CISW.

                                                                 As a result of changes to the behavior of DCISW, this bit is
                                                                     redundant in ARMv8. It is permissible that an implementation
                                                                     makes this bit RES1. */
        uint64_t ptw                   : 1;  /**< [  2:  2](R/W) Protected Table Walk. When this bit is set to 1, if the stage
                                                                     2 translation of a translation table access made as part of a
                                                                     stage 1 translation table walk at EL0 or EL1 maps that
                                                                     translation table access to Strongly-ordered or Device memory,
                                                                     the access is faulted as a stage 2 Permission fault.
                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t fmo                   : 1;  /**< [  3:  3](R/W) Physical FIQ Routing.
                                                                 0 = Physical FIQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual FIQ Interrupt is disabled.
                                                                 1 = Physical FIQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[FIQ] bit to EL3. Virtual FIQ
                                                                     Interrupt is enabled. */
        uint64_t imo                   : 1;  /**< [  4:  4](R/W) Physical IRQ Routing.
                                                                 0 = Physical IRQ while executing at exception levels lower than
                                                                     EL2 are not taken in EL2. Virtual IRQ Interrupt is disabled.
                                                                 1 = Physical IRQ while executing at EL2 or lower are taken in EL2
                                                                     unless routed by the AP_SCR_EL3[IRQ] bit to EL3. Virtual IRQ
                                                                     Interrupt is enabled. */
        uint64_t amo                   : 1;  /**< [  5:  5](R/W) Asynchronous abort and error interrupt routing.
                                                                 0 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at exception levels lower than EL2 are not taken in
                                                                     EL2. Virtual System Error/Asynchronous Abort is disabled.
                                                                 1 = Asynchronous External Aborts and SError Interrupts while
                                                                     executing at EL2 or lower are taken in EL2 unless routed by
                                                                     the AP_SCR_EL3[EA] bit to EL3. Virtual System Error/Asynchronous
                                                                     Abort is enabled. */
        uint64_t vf                    : 1;  /**< [  6:  6](R/W) Virtual FIQ Interrupt.
                                                                 The virtual FIQ is only enabled when the AP_HCR_EL2[FMO] bit is
                                                                     set.
                                                                 0 = Virtual FIQ is not pending by this mechanism.
                                                                 1 = Virtual FIQ is pending by this mechanism. */
        uint64_t vi                    : 1;  /**< [  7:  7](R/W) Virtual IRQ Interrupt.
                                                                 The virtual IRQ is only enabled when the AP_HCR_EL2[IMO] bit is
                                                                     set.
                                                                 0 = Virtual IRQ is not pending by this mechanism.
                                                                 1 = Virtual IRQ is pending by this mechanism. */
        uint64_t vse                   : 1;  /**< [  8:  8](R/W) Virtual System Error/Asynchronous Abort.
                                                                 The virtual System Error/Asynchronous Abort is only enabled
                                                                     when the AP_HCR_EL2[AMO] bit is set.
                                                                 0 = Virtual System Error/Asynchronous Abort is not pending by this
                                                                     mechanism.
                                                                 1 = Virtual System Error/Asynchronous Abort is pending by this
                                                                     mechanism. */
        uint64_t fb                    : 1;  /**< [  9:  9](R/W) Force broadcast. When this bit is set to 1, this causes the
                                                                     following instructions to be broadcast within the Inner
                                                                     Shareable domain when executed from nonsecure EL1:

                                                                 AArch32: BPIALL, TLBIALL, TLBIMVA, TLBIASID, DTLBIALL,
                                                                     DTLBIMVA, DTLBIASID, ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA,
                                                                     ICIALLU, TLBIMVAL, TLBIMVAAL.

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, IC IALLU. */
        uint64_t bsu                   : 2;  /**< [ 11: 10](R/W) Barrier Shareability upgrade. The value in this field
                                                                     determines the minimum shareability domain that is applied to
                                                                     any barrier executed from EL1 or EL0.

                                                                 This value is combined with the specified level of the barrier
                                                                     held in its instruction, using the same principles as
                                                                     combining the shareability attributes from two stages of
                                                                     address translation.

                                                                 0x0 = No effect.
                                                                 0x1 = Inner Shareable.
                                                                 0x2 = Outer Shareable.
                                                                 0x3 = Full system. */
        uint64_t dc                    : 1;  /**< [ 12: 12](R/W) Default Cacheable. When this bit is set to 1, this causes:

                                                                 * The AP_SCTLR_EL1[M] bit to behave as 0 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 * The AP_HCR_EL2[VM] bit to behave as 1 when in the nonsecure
                                                                     state for all purposes other than reading the value of the
                                                                     bit.

                                                                 The memory type produced by the first stage of translation
                                                                     used by EL1 and EL0 is Normal Non-Shareable, Inner WriteBack
                                                                     Read-WriteAllocate, Outer WriteBack Read-WriteAllocate.

                                                                 When this bit is 0 and the stage 1 MMU is disabled, the
                                                                     default memory attribute for Data accesses is Device-nGnRnE.

                                                                 This bit is permitted to be cached in a TLB. */
        uint64_t twi                   : 1;  /**< [ 13: 13](R/W) Trap WFI. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if there is not a pending WFI wakeup event):

                                                                 AArch32: WFI.

                                                                 AArch64: WFI.

                                                                 Conditional WFI instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t twe                   : 1;  /**< [ 14: 14](R/W) Trap WFE. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 or EL0 to be trapped to EL2 if
                                                                     the instruction would otherwise cause suspension of execution
                                                                     (i.e. if the event register is not set):

                                                                 AArch32: WFE.

                                                                 AArch64: WFE.

                                                                 Conditional WFE instructions that fail their condition are not
                                                                     trapped if this bit is set to 1. */
        uint64_t tid0                  : 1;  /**< [ 15: 15](R/W) Trap ID Group 0. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 or EL0 if not
                                                                     UNdefined to be trapped to EL2:

                                                                 AArch32: FPSID, JIDR.

                                                                 AArch64: None. */
        uint64_t tid1                  : 1;  /**< [ 16: 16](R/W) Trap ID Group 1. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: TCMTR, TLBTR, AIDR, REVIDR.

                                                                 AArch64: AP_AIDR_EL1, AP_REVIDR_EL1. */
        uint64_t tid2                  : 1;  /**< [ 17: 17](R/W) Trap ID Group 2. When this bit is set to 1, this causes reads
                                                                     (or writes to CSSELR/ AP_CSSELR_EL1) to the following registers
                                                                     executed from EL1 or EL0 if not UNdefined to be trapped to
                                                                     EL2:

                                                                 AArch32: CTR, CCSIDR, CLIDR, CSSELR.

                                                                 AArch64: AP_CTR_EL0, AP_CCSIDR_EL1, AP_CLIDR_EL1, AP_CSSELR_EL1. */
        uint64_t tid3                  : 1;  /**< [ 18: 18](R/W) Trap ID Group 3. When this bit is set to 1, this causes reads
                                                                     to the following registers executed from EL1 to be trapped to
                                                                     EL2:

                                                                 AArch32: ID_PFR0, ID_PFR1, ID_DFR0, ID_AFR0, ID_MMFR0,
                                                                     ID_MMFR1, ID_MMFR2, ID_MMFR3, ID_ISAR0, ID_ISAR1, ID_ISAR2,
                                                                     ID_ISAR3, ID_ISAR4, ID_ISAR5, MVFR0, MVFR1, MVFR2. Also MRC to
                                                                     any of the following encodings:

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == {3-7}, Opc2 == {0,1}.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 3, Opc2 == 2.

                                                                  CP15, CRn == 0, Opc1 == 0, CRm == 5, Opc2 == {4,5}.

                                                                 AArch64: AP_ID_PFR0_EL1, AP_ID_PFR1_EL1, AP_ID_DFR0_EL1, AP_ID_AFR0_EL1,
                                                                     ID_MMFR0_EL1, ID_MMFR1_EL1, ID_MMFR2_EL1, ID_MMFR3_EL1,
                                                                     ID_ISAR0_EL1, ID_ISAR1_EL1, ID_ISAR2_EL1, ID_ISAR3_EL1,
                                                                     ID_ISAR4_EL1, ID_ISAR5_EL1, MVFR0_EL1, MVFR1_EL1, MVFR2_EL1,
                                                                     AP_ID_AA64PFR0_EL1, AP_ID_AA64PFR1_EL1, AP_ID_AA64DFR0_EL1,
                                                                     AP_ID_AA64DFR1_EL1, AP_ID_AA64ISAR0_EL1, AP_ID_AA64ISAR1_EL1,
                                                                     AP_ID_AA64MMFR0_EL1, AP_ID_AA64MMFR1_EL1, AP_ID_AA64AFR0_EL1,
                                                                     AP_ID_AA64AFR1_EL1. */
        uint64_t tsc                   : 1;  /**< [ 19: 19](R/W) Trap SMC. When this bit is set to 1, this causes the following
                                                                     instructions executed from EL1 to be trapped to EL2:

                                                                 AArch32: SMC.

                                                                 AArch64: SMC.

                                                                 If EL3 is not implemented, this bit is RES0. */
        uint64_t tidcp                 : 1;  /**< [ 20: 20](R/W) Trap Implementation Dependent functionality. When this bit is
                                                                     set to 1, this causes accesses to the following instruction
                                                                     set space executed from EL1 to be trapped to EL2.

                                                                 AArch32: MCR and MRC instructions as follows:

                                                                  All CP15, CRn==9,  Opcode1 = {0-7}, CRm == {c0-c2, c5-c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==10, Opcode1 =={0-7}, CRm == {c0, c1, c4, c8},
                                                                     opcode2 == {0-7}.

                                                                  All CP15, CRn==11, Opcode1=={0-7}, CRm == {c0-c8, c15},
                                                                     opcode2 == {0-7}.

                                                                 AArch64: All encoding space reserved for implementation
                                                                     defined system operations ( S1_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>) and
                                                                     system registers ( S3_\<op1\>_\<Cn\>_\<Cm\>_\<op2\>).

                                                                 It is implementation defined whether any of this functionality
                                                                     accessed from EL0 is trapped to EL2 when the AP_HCR_EL2[TIDCP] bit
                                                                     is set. If it is not trapped to EL2, it results in an
                                                                     Undefined exception taken to EL1. */
        uint64_t tacr                  : 1;  /**< [ 21: 21](R/W) Trap Auxiliary Control Register. When this bit is set to 1,
                                                                     this causes accesses to the following registers executed from
                                                                     EL1 to be trapped to EL2:

                                                                 AArch32: ACTLR.

                                                                 AArch64: ACTLR_EL1. */
        uint64_t tsw                   : 1;  /**< [ 22: 22](R/W) Trap Data/Unified Cache maintenance operations by Set/Way.
                                                                     When this bit is set to 1, this causes Data or Unified Cache
                                                                     maintenance instructions by set/way executed from EL1 which
                                                                     are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: DCISW, DCCSW, DCCISW.

                                                                 AArch64: DC ISW, DC CSW, DC CISW. */
        uint64_t tpc                   : 1;  /**< [ 23: 23](R/W) Trap Data/Unified Cache maintenance operations to Point of
                                                                     Coherency. When this bit is set to 1, this causes Data or
                                                                     Unified Cache maintenance instructions by address to the point
                                                                     of coherency executed from EL1 or EL0 which are not UNdefined
                                                                     to be trapped to EL2. This covers the following instructions:

                                                                 AArch32: DCIMVAC, DCCIMVAC, DCCMVAC.

                                                                 AArch64: DC IVAC, DC CIVAC, DC CVAC. */
        uint64_t tpu                   : 1;  /**< [ 24: 24](R/W) Trap Cache maintenance instructions to Point of Unification.
                                                                     When this bit is set to 1, this causes Cache maintenance
                                                                     instructions to the point of unification executed from EL1 or
                                                                     EL0 which are not UNdefined to be trapped to EL2. This covers
                                                                     the following instructions:

                                                                 AArch32: ICIMVAU, ICIALLU, ICIALLUIS, DCCMVAU.

                                                                 AArch64: IC IVAU, IC IALLU, IC IALLUIS, DC CVAU. */
        uint64_t ttlb                  : 1;  /**< [ 25: 25](R/W) Trap TLB maintenance instructions. When this bit is set to 1,
                                                                     this causes TLB maintenance instructions executed from EL1
                                                                     which are not UNdefined to be trapped to EL2. This covers the
                                                                     following instructions:

                                                                 AArch32: TLBIALLIS, TLBIMVAIS, TLBIASIDIS, TLBIMVAAIS,
                                                                     TLBIALL, TLBIMVA, TLBIASID, DTLBIALL, DTLBIMVA, DTLBIASID,
                                                                     ITLBIALL, ITLBIMVA, ITLBIASID, TLBIMVAA, TLBIMVALIS,
                                                                     TLBIMVAALIS, TLBIMVAL, TLBIMVAAL

                                                                 AArch64: TLBI VMALLE1, TLBI VAE1, TLBI ASIDE1, TLBI VAAE1,
                                                                     TLBI VALE1, TLBI VAALE1, TLBI VMALLE1IS, TLBI VAE1IS, TLBI
                                                                     ASIDE1IS, TLBI VAAE1IS, TLBI VALE1IS, TLBI VAALE1IS */
        uint64_t tvm                   : 1;  /**< [ 26: 26](R/W) Trap Virtual Memory controls. When this bit is set to 1, this
                                                                     causes Writes to the EL1 virtual memory control registers from
                                                                     EL1 to be trapped to EL2. This covers the following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1 */
        uint64_t tge                   : 1;  /**< [ 27: 27](R/W) Trap General Exceptions. If this bit is set to 1, and
                                                                     AP_SCR_EL3[NS] is set to 1, then:

                                                                  All exceptions that would be routed to EL1 are routed to EL2.

                                                                  The AP_SCTLR_EL1[M] bit is treated as being 0 regardless of its
                                                                     actual state (for EL1 using AArch32 or AArch64) other than for
                                                                     the purpose of reading the bit.

                                                                  The AP_HCR_EL2[FMO], IMO and AMO bits are treated as being 1
                                                                     regardless of their actual state other than for the purpose of
                                                                     reading the bits.

                                                                  All virtual interrupts are disabled.

                                                                  Any implementation defined mechanisms for signalling virtual
                                                                     interrupts are disabled.

                                                                  An exception return to EL1 is treated as an illegal exception
                                                                     return.

                                                                 Additionally, if AP_HCR_EL2[TGE] == 1, the
                                                                     AP_MDCR_EL2.{TDRA,TDOSA,TDA} bits are ignored and the processor
                                                                     behaves as if they are set to 1, other than for the value read
                                                                     back from AP_MDCR_EL2. */
        uint64_t tdz                   : 1;  /**< [ 28: 28](R/W) Trap DC ZVA instruction:
                                                                 This bit also has an effect on the value read from the
                                                                     AP_DCZID_EL0 register. If this bit is 1, then reading
                                                                     AP_DCZID_EL0[DZP] from nonsecure EL1 or EL0 will return 1 to
                                                                     indicate that DC ZVA is prohibited.
                                                                 0 = The instruction is not trapped.
                                                                 1 = The instruction is trapped to EL2 when executed in nonsecure
                                                                     EL1 or EL0. */
        uint64_t reserved_29           : 1;
        uint64_t trvm                  : 1;  /**< [ 30: 30](R/W) Trap Read of Virtual Memory controls. When this bit is set to
                                                                     1, this causes Reads to the EL1 virtual memory control
                                                                     registers from EL1 to be trapped to EL2. This covers the
                                                                     following registers:

                                                                 AArch32: SCTLR, TTBR0, TTBR1, TTBCR, DACR, DFSR, IFSR, DFAR,
                                                                     IFAR, ADFSR, AIFSR, PRRR/ MAIR0, NMRR/ MAIR1, AMAIR0, AMAIR1,
                                                                     CONTEXTIDR.

                                                                 AArch64: AP_SCTLR_EL1, AP_TTBR0_EL1, AP_TTBR1_EL1, AP_TCR_EL1, ESR_EL1,
                                                                     FAR_EL1, AFSR0_EL1, AFSR1_EL1, MAIR_EL1, AMAIR_EL1,
                                                                     AP_CONTEXTIDR_EL1. */
        uint64_t rsvd_31               : 1;  /**< [ 31: 31](RO) rw - Register Width control for lower exception levels:
                                                                 When AP_SCR_EL3[NS]==0, this bit behaves as if it has the same
                                                                     value as the AP_SCR_EL3[RW] bit except for the value read back.
                                                                 The RW bit is permitted to be cached in a TLB.
                                                                 0 = Lower levels are all AArch32.
                                                                 1 = EL1 is AArch64. EL0 is determined by the Execution state
                                                                     described in the current process state when executing at EL0. */
        uint64_t cd                    : 1;  /**< [ 32: 32](R/W) Stage 2 Data cache disable. When AP_HCR_EL2[VM]==1, this forces
                                                                     all stage 2 translations for data accesses and translation
                                                                     table walks to Normal memory to be Non-cacheable for the EL1&0
                                                                     translation regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     data accesses and translation table walks.
                                                                 1 = Forces all stage 2 translations for data accesses and
                                                                     translation table walks to Normal memory to be Non-cacheable
                                                                     for the EL1&0 translation regime. */
        uint64_t id                    : 1;  /**< [ 33: 33](R/W) Stage 2 Instruction cache disable. When AP_HCR_EL2[VM]==1, this
                                                                     forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime.
                                                                 This bit has no effect on the EL2 or EL3 translation regimes.
                                                                 0 = No effect on the stage 2 of the EL1&0 translation regime for
                                                                     instruction accesses.
                                                                 1 = Forces all stage 2 translations for instruction accesses to
                                                                     Normal memory to be Non-cacheable for the EL1&0 translation
                                                                     regime. */
        uint64_t e2h                   : 1;  /**< [ 34: 34](R/W) V8.1: Enable EL2 host. */
        uint64_t tlor                  : 1;  /**< [ 35: 35](R/W) v8.1: Trap access to the LOR Registers from nonsecure EL1 to EL2.
                                                                 0 = Nonsecure EL1 accesses to the LOR Registers are not trapped to EL2.
                                                                 1 = Nonsecure EL1 accesses to the LOR Registers are trapped to EL2. */
        uint64_t reserved_36_63        : 28;
#endif /* Word 0 - End */
    } cn8;
    /* struct bdk_ap_hcr_el2_s cn9; */
};
typedef union bdk_ap_hcr_el2 bdk_ap_hcr_el2_t;

#define BDK_AP_HCR_EL2 BDK_AP_HCR_EL2_FUNC()
static inline uint64_t BDK_AP_HCR_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_HCR_EL2_FUNC(void)
{
    return 0x30401010000ll;
}

#define typedef_BDK_AP_HCR_EL2 bdk_ap_hcr_el2_t
#define bustype_BDK_AP_HCR_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_HCR_EL2 "AP_HCR_EL2"
#define busnum_BDK_AP_HCR_EL2 0
#define arguments_BDK_AP_HCR_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_hpfar_el2
 *
 * AP Hypervisor IPA Fault Address Register
 * Holds the faulting IPA for some aborts on a stage 2
 *     translation taken to EL2.
 */
union bdk_ap_hpfar_el2
{
    uint64_t u;
    struct bdk_ap_hpfar_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_45_63        : 19;
        uint64_t fipa                  : 41; /**< [ 44:  4](R/W) Bits \<47:12\> of the faulting intermediate physical address.
                                                                     For implementations with fewer than 48 physical address bits,
                                                                     the equivalent upper bits in this field are RES0. */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t fipa                  : 41; /**< [ 44:  4](R/W) Bits \<47:12\> of the faulting intermediate physical address.
                                                                     For implementations with fewer than 48 physical address bits,
                                                                     the equivalent upper bits in this field are RES0. */
        uint64_t reserved_45_63        : 19;
#endif /* Word 0 - End */
    } s;
    struct bdk_ap_hpfar_el2_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_40_63        : 24;
        uint64_t fipa                  : 36; /**< [ 39:  4](R/W) Bits \<47:12\> of the faulting intermediate physical address.
                                                                     For implementations with fewer than 48 physical address bits,
                                                                     the equivalent upper bits in this field are RES0. */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t fipa                  : 36; /**< [ 39:  4](R/W) Bits \<47:12\> of the faulting intermediate physical address.
                                                                     For implementations with fewer than 48 physical address bits,
                                                                     the equivalent upper bits in this field are RES0. */
        uint64_t reserved_40_63        : 24;
#endif /* Word 0 - End */
    } cn8;
    struct bdk_ap_hpfar_el2_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_45_63        : 19;
        uint64_t fipa                  : 41; /**< [ 44:  4](R/W) Bits \<51:12\> of the faulting intermediate physical address.
                                                                 For implementations that don't support as large an IPA, or when
                                                                 using a translation granule, the upper in this field are RES0. */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t fipa                  : 41; /**< [ 44:  4](R/W) Bits \<51:12\> of the faulting intermediate physical address.
                                                                 For implementations that don't support as large an IPA, or when
                                                                 using a translation granule, the upper in this field are RES0. */
        uint64_t reserved_45_63        : 19;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_hpfar_el2 bdk_ap_hpfar_el2_t;

#define BDK_AP_HPFAR_EL2 BDK_AP_HPFAR_EL2_FUNC()
static inline uint64_t BDK_AP_HPFAR_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_HPFAR_EL2_FUNC(void)
{
    return 0x30406000400ll;
}

#define typedef_BDK_AP_HPFAR_EL2 bdk_ap_hpfar_el2_t
#define bustype_BDK_AP_HPFAR_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_HPFAR_EL2 "AP_HPFAR_EL2"
#define busnum_BDK_AP_HPFAR_EL2 0
#define arguments_BDK_AP_HPFAR_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_hstr_el2
 *
 * AP Hypervisor System Trap Register
 * Controls access to coprocessor registers at lower Exception
 *     levels in AArch32.
 */
union bdk_ap_hstr_el2
{
    uint32_t u;
    struct bdk_ap_hstr_el2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_0_31         : 32;
#else /* Word 0 - Little Endian */
        uint32_t reserved_0_31         : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_hstr_el2_s cn; */
};
typedef union bdk_ap_hstr_el2 bdk_ap_hstr_el2_t;

#define BDK_AP_HSTR_EL2 BDK_AP_HSTR_EL2_FUNC()
static inline uint64_t BDK_AP_HSTR_EL2_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_HSTR_EL2_FUNC(void)
{
    return 0x30401010300ll;
}

#define typedef_BDK_AP_HSTR_EL2 bdk_ap_hstr_el2_t
#define bustype_BDK_AP_HSTR_EL2 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_HSTR_EL2 "AP_HSTR_EL2"
#define busnum_BDK_AP_HSTR_EL2 0
#define arguments_BDK_AP_HSTR_EL2 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_icc_ap0r#_el1
 *
 * AP Interrupt Controller Active Priorities Group 0 (1,3) Register
 * Provides information about the active priorities for the
 *     current interrupt regime.
 */
union bdk_ap_icc_ap0rx_el1
{
    uint32_t u;
    struct bdk_ap_icc_ap0rx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:
                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).
                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits == 0b100:

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Exception level     AP0Rn access

                                                                 (Secure) EL3        Permitted. Accesses Group 0 Secure active priorities.

                                                                 Secure EL1  Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP0Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 0 active priorities.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#else /* Word 0 - Little Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:
                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).
                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits == 0b100:

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Exception level     AP0Rn access

                                                                 (Secure) EL3        Permitted. Accesses Group 0 Secure active priorities.

                                                                 Secure EL1  Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP0Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 0 active priorities.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_icc_ap0rx_el1_s cn; */
};
typedef union bdk_ap_icc_ap0rx_el1 bdk_ap_icc_ap0rx_el1_t;

static inline uint64_t BDK_AP_ICC_AP0RX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ICC_AP0RX_EL1(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN8XXX) && (a<=3))
        return 0x3000c080400ll + 0x100ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a>=1)&&(a<=3)))
        return 0x3000c080400ll + 0x100ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_ICC_AP0RX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_ICC_AP0RX_EL1(a) bdk_ap_icc_ap0rx_el1_t
#define bustype_BDK_AP_ICC_AP0RX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ICC_AP0RX_EL1(a) "AP_ICC_AP0RX_EL1"
#define busnum_BDK_AP_ICC_AP0RX_EL1(a) (a)
#define arguments_BDK_AP_ICC_AP0RX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_icc_ap0r0_el1
 *
 * AP Interrupt Controller Active Priorities Group 0 (0,0) Register
 * Provides information about the active priorities for the
 *     current interrupt regime.
 */
union bdk_ap_icc_ap0r0_el1
{
    uint32_t u;
    struct bdk_ap_icc_ap0r0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:
                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).
                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits == 0b100:

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Exception level     AP0Rn access

                                                                 (Secure) EL3        Permitted. Accesses Group 0 Secure active priorities.

                                                                 Secure EL1  Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP0Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 0 active priorities.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#else /* Word 0 - Little Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:
                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).
                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits == 0b100:

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Exception level     AP0Rn access

                                                                 (Secure) EL3        Permitted. Accesses Group 0 Secure active priorities.

                                                                 Secure EL1  Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP0Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 0 Secure active priorities.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 0 active priorities.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_icc_ap0r0_el1_s cn; */
};
typedef union bdk_ap_icc_ap0r0_el1 bdk_ap_icc_ap0r0_el1_t;

#define BDK_AP_ICC_AP0R0_EL1 BDK_AP_ICC_AP0R0_EL1_FUNC()
static inline uint64_t BDK_AP_ICC_AP0R0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ICC_AP0R0_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000c080400ll;
    __bdk_csr_fatal("AP_ICC_AP0R0_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ICC_AP0R0_EL1 bdk_ap_icc_ap0r0_el1_t
#define bustype_BDK_AP_ICC_AP0R0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ICC_AP0R0_EL1 "AP_ICC_AP0R0_EL1"
#define busnum_BDK_AP_ICC_AP0R0_EL1 0
#define arguments_BDK_AP_ICC_AP0R0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_icc_ap1r#_el1
 *
 * AP Interrupt Controller Active Priorities Group 1(1,3) Register
 * Provides information about the active priorities for the
 *     current interrupt regime.
 */
union bdk_ap_icc_ap1rx_el1
{
    uint32_t u;
    struct bdk_ap_icc_ap1rx_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:

                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).

                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits ==0b100

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Current Exception level and Security state  AP1Rn access

                                                                 (Secure) EL3        Permitted. When AP_SCR_EL3[NS] is 0, accesses Group 1 Secure active
                                                                 priorities. When AP_SCR_EL3[NS] is 1, accesses Group 1 nonsecure active priorities
                                                                 (unshifted). When a bit is written, the bit is only updated if the corresponding Group 0
                                                                 and Group 1 Secure active priority is zero.

                                                                 Secure EL1  Permitted. Accesses Group 1 Secure active priorities (unshifted). When a bit
                                                                 is written, the bit is only updated if the corresponding Group 0 Secure active priority is
                                                                 zero.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP1Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 1 Nonsecure active priorities (shifted). When a bit is
                                                                 written, the bit is only updated if the corresponding Group 0 and Group 1 Secure active
                                                                 priority is zero.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 1 Nonsecure active priorities (unshifted). When a bit is
                                                                 written, the bit is only updated if the Group 0 active priority is zero.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#else /* Word 0 - Little Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:

                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).

                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits ==0b100

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Current Exception level and Security state  AP1Rn access

                                                                 (Secure) EL3        Permitted. When AP_SCR_EL3[NS] is 0, accesses Group 1 Secure active
                                                                 priorities. When AP_SCR_EL3[NS] is 1, accesses Group 1 nonsecure active priorities
                                                                 (unshifted). When a bit is written, the bit is only updated if the corresponding Group 0
                                                                 and Group 1 Secure active priority is zero.

                                                                 Secure EL1  Permitted. Accesses Group 1 Secure active priorities (unshifted). When a bit
                                                                 is written, the bit is only updated if the corresponding Group 0 Secure active priority is
                                                                 zero.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP1Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 1 Nonsecure active priorities (shifted). When a bit is
                                                                 written, the bit is only updated if the corresponding Group 0 and Group 1 Secure active
                                                                 priority is zero.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 1 Nonsecure active priorities (unshifted). When a bit is
                                                                 written, the bit is only updated if the Group 0 active priority is zero.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_icc_ap1rx_el1_s cn; */
};
typedef union bdk_ap_icc_ap1rx_el1 bdk_ap_icc_ap1rx_el1_t;

static inline uint64_t BDK_AP_ICC_AP1RX_EL1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ICC_AP1RX_EL1(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN8XXX) && (a<=3))
        return 0x3000c090000ll + 0x100ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a>=1)&&(a<=3)))
        return 0x3000c090000ll + 0x100ll * ((a) & 0x3);
    __bdk_csr_fatal("AP_ICC_AP1RX_EL1", 1, a, 0, 0, 0);
}

#define typedef_BDK_AP_ICC_AP1RX_EL1(a) bdk_ap_icc_ap1rx_el1_t
#define bustype_BDK_AP_ICC_AP1RX_EL1(a) BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ICC_AP1RX_EL1(a) "AP_ICC_AP1RX_EL1"
#define busnum_BDK_AP_ICC_AP1RX_EL1(a) (a)
#define arguments_BDK_AP_ICC_AP1RX_EL1(a) (a),-1,-1,-1

/**
 * Register (SYSREG) ap_icc_ap1r0_el1
 *
 * AP Interrupt Controller Active Priorities Group 1 (0,0) Register
 * Provides information about the active priorities for the
 *     current interrupt regime.
 */
union bdk_ap_icc_ap1r0_el1
{
    uint32_t u;
    struct bdk_ap_icc_ap1r0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:

                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).

                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits ==0b100

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Current Exception level and Security state  AP1Rn access

                                                                 (Secure) EL3        Permitted. When AP_SCR_EL3[NS] is 0, accesses Group 1 Secure active
                                                                 priorities. When AP_SCR_EL3[NS] is 1, accesses Group 1 nonsecure active priorities
                                                                 (unshifted). When a bit is written, the bit is only updated if the corresponding Group 0
                                                                 and Group 1 Secure active priority is zero.

                                                                 Secure EL1  Permitted. Accesses Group 1 Secure active priorities (unshifted). When a bit
                                                                 is written, the bit is only updated if the corresponding Group 0 Secure active priority is
                                                                 zero.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP1Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 1 Nonsecure active priorities (shifted). When a bit is
                                                                 written, the bit is only updated if the corresponding Group 0 and Group 1 Secure active
                                                                 priority is zero.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 1 Nonsecure active priorities (unshifted). When a bit is
                                                                 written, the bit is only updated if the Group 0 active priority is zero.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#else /* Word 0 - Little Endian */
        uint32_t prioritybits          : 32; /**< [ 31:  0](R/W) Provides information about priority M, according to the
                                                                     following relationship:

                                                                 Bit P\<n\> corresponds to priority (M divided by 22^(U))
                                                                     minus 1, where U is the number of unimplemented bits of
                                                                     priority and is equal to (7 -  AP_ICC_CTLR_EL1[PRI]bits).

                                                                 For example, in a system with AP_ICC_CTLR_EL1[PRI]bits ==0b100

                                                                  There are 5 bits of implemented priority.

                                                                  This means there are 3 bits of unimplemented priority, which
                                                                     are always at the least significant end (bits [2:0] are RES0).

                                                                  Valid priorities are 8, 16, 24, 32, and so on. Dividing these
                                                                     by 22^(3) gives 1, 2, 3, 4, and so on.

                                                                  Subtracting 1 from each gives bits 0, 1, 2, 3, and so on that
                                                                     provide information about those priorities.

                                                                 Accesses to these registers from an interrupt regime give a
                                                                     view of the active priorities that is appropriate for that
                                                                     interrupt regime, to allow save and restore of the appropriate
                                                                     state.

                                                                 Interrupt regime and the number of Security states supported
                                                                     by the Distributor affect the view as follows. Unless
                                                                     otherwise stated, when a bit is successfully set to one, this
                                                                     clears any other active priorities corresponding to that bit.

                                                                 Current Exception level and Security state  AP1Rn access

                                                                 (Secure) EL3        Permitted. When AP_SCR_EL3[NS] is 0, accesses Group 1 Secure active
                                                                 priorities. When AP_SCR_EL3[NS] is 1, accesses Group 1 nonsecure active priorities
                                                                 (unshifted). When a bit is written, the bit is only updated if the corresponding Group 0
                                                                 and Group 1 Secure active priority is zero.

                                                                 Secure EL1  Permitted. Accesses Group 1 Secure active priorities (unshifted). When a bit
                                                                 is written, the bit is only updated if the corresponding Group 0 Secure active priority is
                                                                 zero.

                                                                 Nonsecure EL1 access for a Virtual interrupt       ICH_AP1Rn_EL2

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports two Security states (GICD_CTLR[DS] is
                                                                 0) Permitted. Accesses Group 1 Nonsecure active priorities (shifted). When a bit is
                                                                 written, the bit is only updated if the corresponding Group 0 and Group 1 Secure active
                                                                 priority is zero.

                                                                 Nonsecure EL1 or EL2 when GIC Distributor supports one Security state (GICD_CTLR[DS] is
                                                                 1)  Permitted. Accesses Group 1 Nonsecure active priorities (unshifted). When a bit is
                                                                 written, the bit is only updated if the Group 0 active priority is zero.

                                                                 A Virtual interrupt in this case means that the interrupt
                                                                     group associated with the register has been virtualized. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_icc_ap1r0_el1_s cn; */
};
typedef union bdk_ap_icc_ap1r0_el1 bdk_ap_icc_ap1r0_el1_t;

#define BDK_AP_ICC_AP1R0_EL1 BDK_AP_ICC_AP1R0_EL1_FUNC()
static inline uint64_t BDK_AP_ICC_AP1R0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ICC_AP1R0_EL1_FUNC(void)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX))
        return 0x3000c090000ll;
    __bdk_csr_fatal("AP_ICC_AP1R0_EL1", 0, 0, 0, 0, 0);
}

#define typedef_BDK_AP_ICC_AP1R0_EL1 bdk_ap_icc_ap1r0_el1_t
#define bustype_BDK_AP_ICC_AP1R0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ICC_AP1R0_EL1 "AP_ICC_AP1R0_EL1"
#define busnum_BDK_AP_ICC_AP1R0_EL1 0
#define arguments_BDK_AP_ICC_AP1R0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_icc_asgi1r_el1
 *
 * AP Interrupt Controller Alias Software Generated Interrupt Group 1 Register
 * Provides software the ability to generate group 1 SGIs for the
 *     other Security state.
 */
union bdk_ap_icc_asgi1r_el1
{
    uint64_t u;
    struct bdk_ap_icc_asgi1r_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_56_63        : 8;
        uint64_t aff3                  : 8;  /**< [ 55: 48](R/W) The affinity 3 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t reserved_41_47        : 7;
        uint64_t irm                   : 1;  /**< [ 40: 40](R/W) Interrupt Routing Mode. Determines how the generated
                                                                     interrupts should be distributed to processors. Possible
                                                                     values are:
                                                                 0 = Interrupts routed to the processors specified by a.b.c.{target
                                                                     list}. In this routing, a, b, and c are the values of fields
                                                                     Aff3, Aff2, and Aff1 respectively.
                                                                 1 = Interrupts routed to all processors in the system, excluding
                                                                     "self". */
        uint64_t aff2                  : 8;  /**< [ 39: 32](R/W) The affinity 2 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t reserved_28_31        : 4;
        uint64_t sgiid                 : 4;  /**< [ 27: 24](R/W) SGI Interrupt ID. */
        uint64_t aff1                  : 8;  /**< [ 23: 16](R/W) The affinity 1 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t targetlist            : 16; /**< [ 15:  0](R/W) Target List. The set of processors for which SGI interrupts
                                                                     will be generated. Each bit corresponds to the processor
                                                                     within a cluster with an Affinity 0 value equal to the bit
                                                                     number.

                                                                 If a bit is 1 and the bit does not correspond to a valid
                                                                     target processor, the bit must be ignored by the Distributor.
                                                                     In such cases, a Distributor may optionally generate an SError
                                                                     interrupt.

                                                                 This restricts distribution of SGIs to the first 16 processors
                                                                     of an affinity 1 cluster. */
#else /* Word 0 - Little Endian */
        uint64_t targetlist            : 16; /**< [ 15:  0](R/W) Target List. The set of processors for which SGI interrupts
                                                                     will be generated. Each bit corresponds to the processor
                                                                     within a cluster with an Affinity 0 value equal to the bit
                                                                     number.

                                                                 If a bit is 1 and the bit does not correspond to a valid
                                                                     target processor, the bit must be ignored by the Distributor.
                                                                     In such cases, a Distributor may optionally generate an SError
                                                                     interrupt.

                                                                 This restricts distribution of SGIs to the first 16 processors
                                                                     of an affinity 1 cluster. */
        uint64_t aff1                  : 8;  /**< [ 23: 16](R/W) The affinity 1 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t sgiid                 : 4;  /**< [ 27: 24](R/W) SGI Interrupt ID. */
        uint64_t reserved_28_31        : 4;
        uint64_t aff2                  : 8;  /**< [ 39: 32](R/W) The affinity 2 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t irm                   : 1;  /**< [ 40: 40](R/W) Interrupt Routing Mode. Determines how the generated
                                                                     interrupts should be distributed to processors. Possible
                                                                     values are:
                                                                 0 = Interrupts routed to the processors specified by a.b.c.{target
                                                                     list}. In this routing, a, b, and c are the values of fields
                                                                     Aff3, Aff2, and Aff1 respectively.
                                                                 1 = Interrupts routed to all processors in the system, excluding
                                                                     "self". */
        uint64_t reserved_41_47        : 7;
        uint64_t aff3                  : 8;  /**< [ 55: 48](R/W) The affinity 3 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t reserved_56_63        : 8;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_icc_asgi1r_el1_s cn8; */
    struct bdk_ap_icc_asgi1r_el1_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_56_63        : 8;
        uint64_t aff3                  : 8;  /**< [ 55: 48](WO) The affinity 3 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t reserved_41_47        : 7;
        uint64_t irm                   : 1;  /**< [ 40: 40](WO) Interrupt Routing Mode. Determines how the generated
                                                                     interrupts should be distributed to processors.
                                                                 0 = Interrupts routed to the processors specified by a.b.c.{target
                                                                     list}. In this routing, a, b, and c are the values of fields
                                                                     Aff3, Aff2, and Aff1 respectively.
                                                                 1 = Interrupts routed to all processors in the system, excluding
                                                                     self. */
        uint64_t aff2                  : 8;  /**< [ 39: 32](WO) The affinity 2 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t reserved_28_31        : 4;
        uint64_t sgiid                 : 4;  /**< [ 27: 24](WO) SGI Interrupt ID. */
        uint64_t aff1                  : 8;  /**< [ 23: 16](WO) The affinity 1 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t targetlist            : 16; /**< [ 15:  0](WO) Target List. The set of processors for which SGI interrupts
                                                                     will be generated. Each bit corresponds to the processor
                                                                     within a cluster with an Affinity 0 value equal to the bit
                                                                     number.

                                                                 If a bit is 1 and the bit does not correspond to a valid
                                                                     target processor, the bit must be ignored by the Distributor.
                                                                     In such cases, a Distributor may optionally generate an SError
                                                                     interrupt.

                                                                 This restricts distribution of SGIs to the first 16 processors
                                                                     of an affinity 1 cluster. */
#else /* Word 0 - Little Endian */
        uint64_t targetlist            : 16; /**< [ 15:  0](WO) Target List. The set of processors for which SGI interrupts
                                                                     will be generated. Each bit corresponds to the processor
                                                                     within a cluster with an Affinity 0 value equal to the bit
                                                                     number.

                                                                 If a bit is 1 and the bit does not correspond to a valid
                                                                     target processor, the bit must be ignored by the Distributor.
                                                                     In such cases, a Distributor may optionally generate an SError
                                                                     interrupt.

                                                                 This restricts distribution of SGIs to the first 16 processors
                                                                     of an affinity 1 cluster. */
        uint64_t aff1                  : 8;  /**< [ 23: 16](WO) The affinity 1 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t sgiid                 : 4;  /**< [ 27: 24](WO) SGI Interrupt ID. */
        uint64_t reserved_28_31        : 4;
        uint64_t aff2                  : 8;  /**< [ 39: 32](WO) The affinity 2 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t irm                   : 1;  /**< [ 40: 40](WO) Interrupt Routing Mode. Determines how the generated
                                                                     interrupts should be distributed to processors.
                                                                 0 = Interrupts routed to the processors specified by a.b.c.{target
                                                                     list}. In this routing, a, b, and c are the values of fields
                                                                     Aff3, Aff2, and Aff1 respectively.
                                                                 1 = Interrupts routed to all processors in the system, excluding
                                                                     self. */
        uint64_t reserved_41_47        : 7;
        uint64_t aff3                  : 8;  /**< [ 55: 48](WO) The affinity 3 value of the affinity path of the cluster for
                                                                     which SGI interrupts will be generated. */
        uint64_t reserved_56_63        : 8;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_ap_icc_asgi1r_el1 bdk_ap_icc_asgi1r_el1_t;

#define BDK_AP_ICC_ASGI1R_EL1 BDK_AP_ICC_ASGI1R_EL1_FUNC()
static inline uint64_t BDK_AP_ICC_ASGI1R_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ICC_ASGI1R_EL1_FUNC(void)
{
    return 0x3000c0b0600ll;
}

#define typedef_BDK_AP_ICC_ASGI1R_EL1 bdk_ap_icc_asgi1r_el1_t
#define bustype_BDK_AP_ICC_ASGI1R_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ICC_ASGI1R_EL1 "AP_ICC_ASGI1R_EL1"
#define busnum_BDK_AP_ICC_ASGI1R_EL1 0
#define arguments_BDK_AP_ICC_ASGI1R_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_icc_bpr0_el1
 *
 * AP Interrupt Controller Binary Point Register 0
 * Defines the point at which the priority value fields split
 *     into two parts, the group priority field and the subpriority
 *     field. The group priority field is used to determine interrupt
 *     preemption.
 */
union bdk_ap_icc_bpr0_el1
{
    uint32_t u;
    struct bdk_ap_icc_bpr0_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t binarypoint           : 3;  /**< [  2:  0](R/W) The value of this field controls how the 8-bit interrupt
                                                                     priority field is split into a group priority field, used to
                                                                     determine interrupt preemption, and a subpriority field. This
                                                                     is done as follows:

                                                                 \<pre\>
                                                                 Binary point value  Group priority field    Subpriority field       Field with binary
                                                                 point
                                                                 0   [7:1]   [0]     ggggggg.s
                                                                 1   [7:2]   [1:0]   gggggg.ss
                                                                 2   [7:3]   [2:0]   ggggg.sss
                                                                 3   [7:4]   [3:0]   gggg.ssss
                                                                 4   [7:5]   [4:0]   ggg.sssss
                                                                 5   [7:6]   [5:0]   gg.ssssss
                                                                 6   [7]     [6:0]   g.sssssss
                                                                 7   No preemption   [7:0]   .ssssssss
                                                                 \</pre\> */
#else /* Word 0 - Little Endian */
        uint32_t binarypoint           : 3;  /**< [  2:  0](R/W) The value of this field controls how the 8-bit interrupt
                                                                     priority field is split into a group priority field, used to
                                                                     determine interrupt preemption, and a subpriority field. This
                                                                     is done as follows:

                                                                 \<pre\>
                                                                 Binary point value  Group priority field    Subpriority field       Field with binary
                                                                 point
                                                                 0   [7:1]   [0]     ggggggg.s
                                                                 1   [7:2]   [1:0]   gggggg.ss
                                                                 2   [7:3]   [2:0]   ggggg.sss
                                                                 3   [7:4]   [3:0]   gggg.ssss
                                                                 4   [7:5]   [4:0]   ggg.sssss
                                                                 5   [7:6]   [5:0]   gg.ssssss
                                                                 6   [7]     [6:0]   g.sssssss
                                                                 7   No preemption   [7:0]   .ssssssss
                                                                 \</pre\> */
        uint32_t reserved_3_31         : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_ap_icc_bpr0_el1_s cn; */
};
typedef union bdk_ap_icc_bpr0_el1 bdk_ap_icc_bpr0_el1_t;

#define BDK_AP_ICC_BPR0_EL1 BDK_AP_ICC_BPR0_EL1_FUNC()
static inline uint64_t BDK_AP_ICC_BPR0_EL1_FUNC(void) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_AP_ICC_BPR0_EL1_FUNC(void)
{
    return 0x3000c080300ll;
}

#define typedef_BDK_AP_ICC_BPR0_EL1 bdk_ap_icc_bpr0_el1_t
#define bustype_BDK_AP_ICC_BPR0_EL1 BDK_CSR_TYPE_SYSREG
#define basename_BDK_AP_ICC_BPR0_EL1 "AP_ICC_BPR0_EL1"
#define busnum_BDK_AP_ICC_BPR0_EL1 0
#define arguments_BDK_AP_ICC_BPR0_EL1 -1,-1,-1,-1

/**
 * Register (SYSREG) ap_icc_bpr1_el1
 *
 * AP Interrupt Controller Binary Point Register 1
 * Defines the point at which the priority value fields split
 *     into two parts, the group priority field and the subpriority
 *     field. The group priority field is used to determine Group 1
 *     interrupt preemption.
 */
union bdk_ap_icc_bpr1_el1
{
    uint32_t u;
    struct bdk_ap_icc_bpr1_el1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint32_t reserved_3_31         : 29;
        uint32_t binarypoint           : 3;  /**< [  2:  0](R/W) The value of this field controls how the 8-bit interrupt
                                                                     priority field is split into a group priority field, used to
                                                                     determine interrupt preemption, and a subpriority field. This
                                                                     is done as follows:
                                                                 \<pre\>
                                                                 Binary point value  Group priority field    Subpriority field       Field with binary
                                                                 point
                                                                 0   [7:1]   [0]     ggggggg.s
                                                                 1   [7:2]   [1:0]   gggggg.ss
                                                                 2   [7:3]   [2:0]   ggggg.sss
                                                                 3   [7:4]   [3:0]   gggg.ssss
                                                     