/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.datetime;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class DateTimePrologCode
extends ExecuteOnlyCode {
    public static final AtomTerm dateAtom = AtomTerm.get("date");
    public static final AtomTerm timeAtom = AtomTerm.get("time");
    public static final CompoundTermTag date9Tag = CompoundTermTag.get(dateAtom, 9);
    public static final CompoundTermTag date3Tag = CompoundTermTag.get(dateAtom, 3);
    public static final CompoundTermTag timeTag = CompoundTermTag.get(timeAtom, 3);

    public static final Date getDate(Term term) throws PrologException {
        if (!(term instanceof CompoundTerm)) {
            PrologException.typeError(dateAtom, term);
        }
        CompoundTerm cterm = (CompoundTerm)term;
        if (cterm.tag != date9Tag) {
            PrologException.typeError(dateAtom, term);
        }
        if (cterm.args.length != 9) {
            PrologException.typeError(dateAtom, term);
        }
        if (!(cterm.args[0] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, cterm.args[0]);
        }
        if (!(cterm.args[1] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, cterm.args[1]);
        }
        if (!(cterm.args[2] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, cterm.args[2]);
        }
        if (!(cterm.args[3] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, cterm.args[3]);
        }
        if (!(cterm.args[4] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, cterm.args[4]);
        }
        if (!(cterm.args[5] instanceof FloatTerm) && !(cterm.args[5] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.floatAtom, cterm.args[5]);
        }
        if (!(cterm.args[6] instanceof IntegerTerm)) {
            PrologException.typeError(TermConstants.integerAtom, cterm.args[6]);
        }
        if (!(cterm.args[7] instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, cterm.args[7]);
        }
        if (!(cterm.args[8] instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, cterm.args[8]);
        }
        TimeZone zone = TimeZone.getDefault();
        if (cterm.args[7] != AtomTerm.get("-")) {
            zone = TimeZone.getTimeZone(((AtomTerm)cterm.args[7]).value);
        } else {
            String[] zones;
            String[] stringArray = zones = TimeZone.getAvailableIDs(((IntegerTerm)cterm.args[6]).value);
            int n = zones.length;
            int n2 = 0;
            while (n2 < n) {
                String zoneId = stringArray[n2];
                TimeZone z = TimeZone.getTimeZone(zoneId);
                if (cterm.args[8] == AtomTerm.get("-")) {
                    zone = z;
                    break;
                }
                if (cterm.args[8] == TermConstants.trueAtom) {
                    if (z.useDaylightTime()) {
                        zone = z;
                        break;
                    }
                } else if (cterm.args[8] == TermConstants.falseAtom && !z.useDaylightTime()) {
                    zone = z;
                    break;
                }
                ++n2;
            }
        }
        Calendar cal = Calendar.getInstance(zone);
        cal.clear();
        int sec = 0;
        int msec = 0;
        if (cterm.args[5] instanceof IntegerTerm) {
            sec = ((IntegerTerm)cterm.args[5]).value;
        } else {
            sec = (int)Math.floor(((FloatTerm)cterm.args[5]).value);
            msec = (int)Math.round(((FloatTerm)cterm.args[5]).value % 1.0 * 1000.0);
        }
        cal.set(((IntegerTerm)cterm.args[0]).value, ((IntegerTerm)cterm.args[1]).value - 1, ((IntegerTerm)cterm.args[2]).value, ((IntegerTerm)cterm.args[3]).value, ((IntegerTerm)cterm.args[4]).value, sec);
        cal.set(14, msec);
        return cal.getTime();
    }
}

