#! /bin/sh
# Copyright (C) 2011-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# "make uninstall" complains and errors out on failures.

# FIXME: this test only deal with DATA primary; maybe we need sister
# tests for other primaries too?  E.g., SCRIPTS, PROGRAMS, LISP, PYTHON,
# etc...

. ./defs || Exit 1

mkdir d
: > d/f
chmod a-w d || skip "cannot make directories unwritable"

# On Solaris 10, if '/bin/rm' is run with the '-f' option, it doesn't
# print any error message when failing to remove a file (due to e.g.,
# "Permission denied").  Yikes.  We'll cater to this incompatibility
# by relaxing a test below if a faulty 'rm' is detected.
st=0; rm -f d/f 2>stderr || st=$?
cat stderr >&2
test $st -gt 0 || skip_ "can delete files from unwritable directories"
if grep 'rm:' stderr; then
  rm_f_is_silent_on_error=no
else
  rm_f_is_silent_on_error=yes
fi

cat >> configure.ac << 'END'
AC_OUTPUT
END

cat > Makefile.am << 'END'
data_DATA = foobar.txt
END

: > foobar.txt

$ACLOCAL
$AUTOMAKE
$AUTOCONF

inst=__inst-dir__

./configure --prefix="`pwd`/$inst"

mkdir $inst $inst/share
: > $inst/share/foobar.txt

chmod a-w $inst/share
$MAKE uninstall >output 2>&1 && { cat output; Exit 1; }
cat output
if test $rm_f_is_silent_on_error = yes; then
  : "rm -f" is silent on errors, skip the grepping of make output
else
  grep "rm: .*foobar\.txt" output
fi

chmod a-rwx $inst/share
(cd $inst/share) && skip_ "cannot make directories fully unreadable"

$MAKE uninstall >output 2>&1 && { cat output; Exit 1; }
cat output
#
# Some shells, like Solaris 10 /bin/sh and /bin/ksh, do not report
# the name of the 'cd' builtin upon a chdir error:
#
#   $ /bin/sh -c 'cd /none'
#   /bin/sh: /none: does not exist
#
# In addition, some shells, like Solaris 10 /usr/xpg4/bin/sh, also print
# a line number in the error message *if the command contains newlines*:
#
#   $ /usr/xpg4/bin/sh -c 'cd unreadable'
#   /usr/xpg4/bin/sh: unreadable: permission denied
#   $ /usr/xpg4/bin/sh -c '\
#   > \
#   > cd unreadable'
#   /usr/xpg4/bin/sh[3]: unreadable: permission denied
#
$EGREP "(cd|sh)(\[[0-9]*[0-9]\])?: .*$inst/share" output

:
