/**
 * Main startup functions

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2003, 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/dink.c,v 1.4 2004/01/16 19:55:45 Beuc Exp $
 */

#include <getopt.h>
#include <string.h>
#include <time.h>
#include "dink.h"

/* Not in constants.h so it does not conflict with Dinkedit's */
#define NAME	"Dink Smallwood"
#define TITLE	"Dink Smallwood"

int fps_average;


void move (int u, int amount, char kind, char kindy);
void draw_box (struct rect box, int color);
void run_through_tag_list_push (int h);
void random_blood (int mx, int my, int h);
int check_if_move_is_legal (int u);
void change_dir_to_diag (int *dir);
int hurt_thing (int h, int damage, int special);

int but_timer = 0;
int water_timer = 0;
/*bool*/int fire_forward = 0;
int fire_flip = 0;

int fps_show = 0;
/* /\*BOOL*\/int InitSound (); */
/* /\*BOOL*\/int DestroySound (void); */
/* /\*BOOL*\/int DSDisable (void); */
/* /\*BOOL*\/int DSEnable (); */

int drawthistime = 1;
int x = 640;
int y = 480;
struct rect rc;
int winoffset = 25;
int winoffsetx = 5;
int cx = 0;
int cy = 0;
int speed = 0;

char *g_fontdir = NULL;
struct player_short_info short_play;

Mix_Music *music_data = NULL;
/*bool*/int g_b_no_write_ini = 0;
/*bool*/int no_cheat = 1;
int last_saved_game = 0;
/*bool*/int g_b_kill_app = 0; /* if true, will close app as soon as the message pump is */
int dinkspeed = 3;
int last_cd = 0;
char current_map[255] = "map.dat";
int regcode = 0, mycode = 0;
time_t time_start = 0;
/*bool*/int item_screen = 0;
/*bool*/int midi_active = 1;
char dversion_string[] = VERSION;
char dinkpath[200];
UINT CD_ID;
int map_vision = 0;
int flub_mode = -500;
unsigned short decipher_savegame = 0;
int draw_map_tiny = -1;

char last_debug[200];
int walk_off_screen = 0;

/*bool*/int cd_inserted = 0;
int burn_revision = 0;
/*bool*/int abort_this_flip = 0;
struct show_bmp_t showb;
int keep_mouse = 0;
int mcc = 0, sound_support = 0;
struct attackinfo_struct bow;
struct soundstruct soundinfo[NUM_SOUNDBANKS + 1];
int screenlock = 0;
struct talk_struct talk;
char last_midi[15];
char midi_cur[20];
char midi_last[20];

/* Initialisation des variables globales */
int *pvision = NULL,
  *plife = NULL,
  *presult =0,
  *pspeed = NULL,
  *ptiming = NULL,
  *plifemax = NULL,
  *pexper = NULL,
  *pmap = NULL,
  *pstrength = NULL,
  *pcur_weapon = NULL,
  *pcur_magic = NULL,
  *pdefense = NULL,
  *pgold = NULL,
  *pmagic = NULL,
  *plevel = NULL,
  *plast_text = NULL,
  *pmagic_level = NULL;
int *pupdate_status = NULL,
  *pmissile_target = NULL,
  *penemy_sprite = NULL,
  *pmagic_cost = NULL,
  *pmissle_source  = NULL;
int flife = 0,
  fexp = 0,
  fstrength = 0,
  fdefense = 0,
  fgold = 0,
  fmagic = 0,
  fmagic_level = 0,
  flifemax = 0,
  fraise = 0,
  last_magic_draw = 0;
int fcur_weapon = 0,
  fcur_magic = 0;
int mbase_timing = 0;
struct idata id[MAX_IDATA];

DWORD mold;

int item_timer;
int item_pic;

int mbase_count;
/*bool*/int no_transition = 0;
struct seth_sound ssound[MAX_SOUNDS];

int push_active = 1;

/*bool*/int turn_on_plane = 0;
TTF_Font *lf = NULL;
TTF_Font *hfont = NULL;
TTF_Font *hfont_small = NULL;
int stop_entire_game;
/*bool*/int in_enabled = 0;
char *in_string;
/*bool*/int first_frame = 0;
/*bool*/int no_running_main = 0;
struct call_back callback[MAX_CALLBACKS];
char *rbuf[MAX_SPRITES];	/* pointers to buffers we may need */
struct refinfo *rinfo[MAX_SPRITES];
int process_warp = 0;
/*bool*/int process_upcycle = 0;
/*bool*/int process_downcycle = 0;
DWORD cycle_clock = 0;
int cycle_script = 0;
int *in_int;
int in_x, in_y;
int sp_brain = 0;
int returnint = 0;
char returnstring[200];
int sp_speed = 0;
char slist[10][200];
long nlist[10];
int process_count = 0;
struct rect sp_alt;
int hard_tile = 0;
/*bool*/int sp_screenmatch = 0;
char in_temp[200];
int in_command;
int in_finish;
int in_onflag;
int in_max = 10;
int in_huh = 0;
char in_default[200];
int in_master = 0;
/*bool*/int sound_on = 1;
char dir[80];
/*bool*/int please_wait = 0;
int show_dot = 0;
int plane_process = 1;
struct hit_map hm;

struct sprite_index *sequence_index;
int last_sprite_added = 0;
DWORD timer = 0;
char *command_line;
/*bool*/int dinkedit = 0;
int base_timing;
int weapon_script = 0;
int magic_script = 0;

int sp_mode = 0;
int fps, fps_final = 0;
int last_sprite_created;
int move_screen = 0;
/*bool*/int move_gonna = 0;
int move_counter = 0;
int m1x, m1y;
int m2x, m2y;
int m3x, m3y;
int playx = 620;
/*bool*/int windowed = 0;
int playl = 20;

/*bool*/int mouse1 = 0;
int cur_sprite = 1;
int playy = 399;
int cur_map, cur_tile;
struct seth_joy sjoy;
DWORD thisTickCount, lastTickCount;
DWORD timecrap;
struct rect math, box_crap, box_real;

int sz, sy, x_offset, y_offset;

struct wait_for_button_t wait;

int mode;

struct sequence *seq;
struct map_info map;
struct small_map pam;

/* SDL_Surface *     lpDDSOne;       // Offscreen surface 1 */
SDL_Surface *lpDDSTwo = NULL;	/* Offscreen surface 2 */
SDL_Surface *lpDDSTrick = NULL;	/* Offscreen surface 2 */
SDL_Surface *lpDDSTrick2 = NULL;	/* Offscreen surface 2 */
/*bool*/int trig_man = 0;
/*bool*/int total_trigger = 0;
/*bool*/int debug_mode = 0;

struct pic_info *k;			/* Sprite data */
struct player_info play;


SDL_Surface *lpDDSPrimary = NULL;	/* DirectDraw primary surface */
SDL_Surface *lpDDSBack = NULL;	/* DirectDraw back surface */

SDL_Surface *tiles[TILE_SCREENS];	/* Game pieces */
SDL_Surface *game[MAX_GAME];	/* Game pieces */

struct sp *spr;			/* max sprite control systems at once */

SDL_Color pe[256];
SDL_Color real_pal[256];

/*bool*/int app_active = 0;		/* is application active? */

BYTE torusColors[256];		/* Marks the colors used in the torus */

SDL_Joystick *jinfo;
/*bool*/int joystick = 0;
struct hardness hmap;
struct rect tilerect[TILE_SCREENS];


/*bool*/int
initFail (char mess[200])
{
  fprintf (stderr, mess);
  finiObjects ();
  return 0;
}

/**
 * Prints the version on the standard ouput. Based on the homonymous
 * function from ratpoison
 */
void
print_version ()
{
  printf ("GNU %s %s\n", PACKAGE, VERSION);
  printf ("Copyright (C) 1997, 2003 by contributors\n");
  printf ("GNU %s comes with ABSOLUTELY NO WARRANTY.\n", PACKAGE);
  printf ("You may redistribute copies of FreeDink\n");
  printf ("under the terms of the GNU General Public License.\n");
  printf ("For more information about these matters, see the file named COPYING.\n");
  exit (EXIT_SUCCESS);
}

/**
 * Prints the version on the standard ouput. Based on the homonymous
 * function from ratpoison
 */
void
print_help ()
{
  printf ("Help for %s %s\n\n", PACKAGE, VERSION);
  printf ("TODO                  Display the default configuration here\n");
  printf ("-h, --help            Display this help screen\n");
  printf ("-v, --version         Display the version\n");
  printf ("\n");
  printf ("-g, --game <dir>      Specify a DMod directory\n");
  printf ("-f, --fontdir <dir>   Specify an alternative font directory\n");
  printf ("\n");
  printf ("-d, --debug           Explain what is being done\n");
  printf ("-i, --noini           Do not attempt to write dinksmallwood.ini\n");
  printf ("-j, --nojoy           Do not attempt to use joystick\n");
  printf ("-s, --nosound         Do not play sound\n");
  printf ("-w, --window          Use windowed mode instead of screen mode\n");
  printf ("\n");

  printf ("Report bugs to TODO %s\n", PACKAGE_BUGREPORT);
  printf ("Type 'info freedink' for more information\n");

  exit (EXIT_SUCCESS);
}

/**
 * Check the command line arguments and initialize the required global
 * variables
 */
/*bool*/int
check_args (int argc, char *argv[])
{
/*   int i; */
  int c;

  /** Options '-debug', '-game', '-noini', '-nojoy', '-nosound' and
      '-window' are required to maintain backward compatibility with
      the original non-free Dink */
  struct option long_options[] = 
    {
      {"debug",   no_argument,       NULL, 'd'},
      {"fontdir", required_argument, NULL, 'f'},
      {"game",    required_argument, NULL, 'g'},
      {"help",    no_argument,       NULL, 'h'},
      {"noini",   no_argument,       NULL, 'i'},
      {"nojoy",   no_argument,       NULL, 'j'},
      {"nosound", no_argument,       NULL, 's'},
      {"version", no_argument,       NULL, 'v'},
      {"window",  no_argument,       NULL, 'w'},
      {0, 0, 0, 0}
    };
  
  char short_options[] = "df:g:hijsvw";
  char *default_fontdir = "../fonts/";

  strcpy (dir, "dink");
  g_fontdir = malloc(strlen(default_fontdir) + 1);
  strcpy(g_fontdir, default_fontdir);

  /* Loop through each argument */
  while ((c = getopt_long_only (argc, argv, short_options, long_options, NULL)) != EOF)
    {
      switch (c) {
      case 'd':
	  debug_mode = 1;
	  unlink ("dink/debug.txt");
	  break;
      case 'f':
	{
	  char *tmp = malloc(256);
	  char *olddir = malloc(256);
	  free (g_fontdir);
	  
	  g_fontdir = optarg;
	  
	  /* Get the absolute path of the font directory. This */
	  /* must be done because dink changes the cwd to the game */
	  /* dir and a relative path the fonts may no longer work. */
	  dink_getcwd (olddir, 255);
	  if (dink_chdir (g_fontdir) == -1)
	    {
	      Msg (("Unable to find font dir, %s.", g_fontdir));
	      exit(EXIT_FAILURE);
	    }
	  dink_getcwd (tmp, 254);
	  /* Add a frontslash if there isn't one */
	  if (tmp[strlen (tmp) - 1] != '/')
	    {
	      int len = strlen (tmp);
	      
	      tmp[len] = '/';
	      tmp[len + 1] = '\0';
	    }
	  
	  /* free (g_fontdir); */
	  g_fontdir = tmp;
	  dink_chdir (olddir);
	  
	  Msg (("Fontdir is now %s.", g_fontdir));
	}
	break;
      case 'g':
	/* The next argument is the game directory, make sure this */
	/* isn't the last argument. */
	strcpy (dir, optarg);
	Msg (("Working directory %s requested.", dir));
	break;
      case 'h':
	print_help();
	break;
      case 'j':
	joystick = 0;
	break;
      case 'i':
	g_b_no_write_ini = 1;
	break;
      case 's':
	sound_on = 0;
	break;
      case 'v':
	print_version();
	break;
      case 'w':
	  windowed = 1;
	  no_transition = 1;
	  break;	
      default:
	exit (EXIT_FAILURE);
      }
    }

  if (dink_chdir (dir) == -1)
    {
      char shit[200];
      
#ifdef __ENGLISH
      sprintf (shit, "Game dir \"%s\" not found!\n", dir);
#endif
#ifdef __GERMAN

      sprintf (shit, "Spiele-direktory \"%s\" nicht gefunden!\n", dir);
#endif
      
      initFail (shit);
      return 0;
    }
  
  Msg (("Dir is now %s.", dir));
  return 1;
}

/*bool*/int
initfonts (char fontname[255])
{
  char *fullpath;

  fullpath =
    (char *) malloc ((strlen (fontname) + strlen (g_fontdir) + 1) *
		     sizeof (char *));

  strcpy (fullpath, g_fontdir);
  strcat (fullpath, fontname);

  lf = TTF_OpenFont (fullpath, 16);
  hfont = TTF_OpenFont (fullpath, 16);
  hfont_small = TTF_OpenFont (fullpath, 16);

  if (lf == NULL || hfont == NULL || hfont_small == NULL)
    {
      Msg (("TTF_OpenFont: %s", TTF_GetError ()));
      return 0;
    }

  free (fullpath);

  return 1;
}

void
kill_fonts ()
{
  TTF_CloseFont (lf);
  TTF_CloseFont (hfont);
  TTF_CloseFont (hfont_small);

}


/**
 * ? Clean-up
 */
void
finiObjects ()
{
  kill_all_scripts_for_real ();
  FastFileFini ();
  g_b_kill_app = 1;
}

void
load_batch (void)
{
  FILE *stream;
  char line[255];

  spr[1].x = 200;
  spr[1].y = 300;


  Msg (("Loading .ini"));
  if (!exist ("dink.ini"))
    {
      Msg (("File not found."));

      sprintf (line, "Error finding the dink.ini file in the %s dir.", dir);
      Msg ((line));
/* TRACE(line); */

    }


  if ((stream = fopen ("dink.ini", "r")) != NULL)
    {

      while (1)
	{
	  if (fgets (line, 255, stream) == NULL)
	    goto done;
	  else
	    {
	      pre_figure_out (line, 0);
	    }

	}

    done:
      fclose (stream);
    }
  else
    {
/* TRACE("Dink.ini missing."); */
      Msg (("Dink.ini missing."));
    }

  program_idata ();

}

/*
* finiObjects
*
* finished with all objects we use; release them
*/
/* long FAR PASCAL WindowProc( HWND hWnd, UINT message,  */
/* WPARAM wParam, LPARAM lParam ) */
/* { */
/* switch( message ) */
/* { */
/* case WM_ACTIVATEAPP: */
/* app_active = wParam; */
/* break; */

/* case WM_SETCURSOR: */
/* SetCursor(NULL); */
/* return TRUE; */

/* case WM_CREATE: */
/* break; */
/* case WM_IMDONE: */
/* Msg(("Sending quit message.")); */
/* PostQuitMessage(0); */
/* break; */

/* } */

/* program_idata(); */

/* } */
#include <sys/types.h>
#include <sys/stat.h>

/*bool*/int
random_date (char file[255])
{
/* MERLIN: I found this comment incredibly funny so I left it.   */
/* let's randomize the date on this file to trick Windows */
/* cacheing into doing it right! */
/* SABETTS: let's not. */
  return 1;
}

int
dir_num (char path[255])
{
  /* SABETTS: please the one caller */
  return 250 + 9;
}

void
load_tilescreens ()
{
  char crap[30];
  int h;

/* UNREFERENCED   char crap1[10]; */

  Msg (("loading tilescreens..."));

  for (h = 1; h < TILE_SCREENS; h++)
    {
      /* if (h < 10) strcpy(crap1,"0"); else strcpy(crap1, ""); */
      sprintf (crap, "tiles/ts%02d.bmp", h);

      if (!exist (crap))
	{
	  sprintf (crap, "../dink/tiles/ts%02d.bmp", h);
	}

      /* tiles[h] = DDTileLoad(lpDD, crap, 0, 0,h);  */
      tiles[h] = load_image (crap, 0, 0, 0, 0);

      if (tiles[h] == NULL)
	{
	  printf ("failed on %s\n", crap);
	  initFail ("Couldn't find one of the tilescreens!");
	}
      else
	{
	  tilerect[h].left = 0;
	  tilerect[h].top = 0;
	  tilerect[h].bottom = tiles[h]->h;
	  tilerect[h].right = tiles[h]->w;
/* SDL_SetColorKey (tiles[h], SDL_SRCCOLORKEY,  */
/* SDL_MapRGB (lpDDSBack->format, 0, 0, 0)); */
	}
    }
  Msg (("Done with tilescreens..."));
}

void
load_splash ()
{
  Msg (("Loading splash"));
  if (exist ("tiles/splash.bmp"))
    lpDDSTrick = load_image ("tiles/splash.bmp", 0, 0, 0, 0);
  else
    lpDDSTrick = load_image ("../dink/tiles/splash.bmp", 0, 0, 0, 0);

  if (exist ("tiles/splash.bmp"))
    lpDDSTrick2 = load_image ("tiles/splash.bmp", 0, 0, 0, 0);
  else
    lpDDSTrick2 = load_image ("../dink/tiles/splash.bmp", 0, 0, 0, 0);
}


void
display_loading_screen ()
{
  if (exist ("tiles/splash.bmp"))
    lpDDSTwo = load_image ("tiles/splash.bmp", 0, 0, 0, 0);
  else
    lpDDSTwo = load_image ("../dink/tiles/splash.bmp", 0, 0, 0, 0);

  SDL_BlitSurface (lpDDSTwo, NULL, lpDDSPrimary, NULL);

/* SDL_BlitSurface (lpDDSBack, NULL, lpDDSPrimary, NULL); */
/* SDL_UpdateRect (lpDDSPrimary, 0, 0, 0, 0); */
  flip_it ();
}

static int
doInit ()
{
  SDL_Rect rcRect;
/* UNREFERENCED   SDL_Rect rcRectSrc; */
/* UNREFERENCED   SDL_Rect rcRectDest; */

  init_sprites ();

  if (!init_video ()) return 0;
  /* init_audio(); */
  init_mouse_status (&mouse_status);
  memset (&hm, 0, sizeof (struct hit_map));
  load_tilescreens ();

  if (sound_on)
    {
      Msg (("Initting sound"));
      sound_on = InitSound ();
    }
  srand ((unsigned) time (NULL));

  getCDTrackStartTimes ();

  if (cd_inserted)
    PlayCD (7);


  joystick = CheckJoyStickPresent ();

  rcRect.x = 0;
  rcRect.y = 0;
  rcRect.w = x;
  rcRect.h = y;

  display_loading_screen ();
  Msg(("Finished loading screen"));

  /* dinks normal walk */

  Msg (("loading batch"));
  load_batch ();
  Msg (("done loading batch"));

  load_hard ();

  /* Activate dink, but don't really turn him on */
  /* spr[1].active = true; */
  spr[1].timer = 33;

  /* copy from player info */
  spr[1].x = play.x;
  spr[1].y = play.y;

  load_splash ();

  last_sprite_created = 1;
  mode = 0;
  load_info ();

  {
    int u;
    for (u = 1; u <= 10; u++)
      play.button[u] = u;
  }

  {
    int x1;
    for (x1 = 1; x1 <= 10; x1++)
      {
	sjoy.letgo[x1] = 1;
      }
  }

  /* lets run our init script */

  {
    int script = load_script ("main", 0, 1);
    
    locate (script, "main");
    run_script (script);
    /* lets attach our vars to the scripts */
    
    attach ();
  }

  /* init_mouse(hwnd); */

  if (!initfonts ("default.ttf"))
    {
      return 0;
    }
  /* g_pMouse->Acquire(); */

  return 1;
}


/**
 * Handle system events (mouse and signals and ). Seth's mouse part
 * was in called in updateFrame, and used system-specific events,
 * while this one is called in the main loop on the same level as
 * updateFrame, and uses SDL. TODO
 */
static void
gather_events ()
{
  SDL_Event event;

  while (SDL_PollEvent (&event))
    {
      switch (event.type)
	{
	case SDL_MOUSEBUTTONDOWN:
	  {
	    Msg (("mouse down"));
	    mouse_status.button = 1;
	  }
	  break;
	case SDL_MOUSEBUTTONUP:
	  {
	    Msg (("mouse up"));
	    mouse_status.button = 0;
	  }
	  break;
	case SDL_MOUSEMOTION:
	  {
	    mouse_status.x = event.motion.x;
	    mouse_status.y = event.motion.y;
	  }
	  break;
	case SDL_ACTIVEEVENT:
	  /* eg. window's focus or state (minimised/restored) */
	  {
/* Msg (("active event")); */
	    if (event.active.state & SDL_APPACTIVE)
	      {
		if (event.active.gain)
		  {
/* window restored */
/* app_active = true; */
		  }
		else
		  {
/* window iconified */
/* app_active = false; */
		  }
	      }
	  }
	  break;

	case SDL_QUIT: /* eg. window close or C-c */
	  {
	    printf ("freedink: Quit requested, quitting.\n");
	    exit (0);
	  }
	  break;
	}
    }
}

int
main (int argc, char *argv[])
{
  /* Read the command line arguments */
  if (!check_args (argc, argv)) return 1;

  if (!doInit ())
    {
      Msg (("Init failed\n"));
      return 1;
    }

/* log_path (1); */
  app_active = 1;

  while (g_b_kill_app == 0)
    {
      gather_events ();
      if (app_active)
	{
	  updateFrame ();
	}
    }

  return 0;
}

