/* -*- mode:c -*-
 *
 * Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifdef SECTION_IS_RO
GPIO_INT(USB_DET_PP_CHG,	PIN(C, 13), GPIO_INT_BOTH, vbus0_evt)
GPIO_INT(USB_DET_PP_DUT,	PIN(C, 12), GPIO_INT_BOTH, vbus1_evt)
GPIO_INT(STM_FAULT_IRQ_L,	PIN(A, 8),  GPIO_INT_FALLING, tca_evt)
GPIO_INT(DP_HPD,		PIN(A, 15), GPIO_INT_BOTH, dp_evt)
GPIO_INT(CHGSRV_TCPC_INT_ODL,	PIN(C, 0),  GPIO_INT_FALLING, tcpc_evt)
GPIO_INT(USBH_I2C_BUSY_INT,	PIN(C, 9),  GPIO_INT_FALLING, hub_evt)
GPIO_INT(DUT_PWR_IRQ_ODL,	PIN(F, 1),  GPIO_INT_FALLING, dut_pwr_evt)
#endif /* SECTION_IS_RO */

/* Outputs */
GPIO(HOST_USB_HUB_RESET_L,	PIN(D, 2),  GPIO_ODR_HIGH)
GPIO(FASTBOOT_DUTHUB_MUX_SEL,	PIN(B, 5),  GPIO_OUT_HIGH)
GPIO(SBU_MUX_EN,		PIN(B, 6),  GPIO_OUT_LOW)
GPIO(FASTBOOT_DUTHUB_MUX_EN_L,	PIN(B, 7),  GPIO_OUT_LOW)
/* Power on init has reset asserted, we will pull the hub out of reset
 * in the board init to help avoid brownout.
 */
GPIO(DUT_HUB_USB_RESET_L,	PIN(B, 9), GPIO_ODR_HIGH)
GPIO(ATMEL_HWB_L,		PIN(B, 12), GPIO_OUT_HIGH)
GPIO(USB3_A1_MUX_EN_L,		PIN(F, 0),  GPIO_OUT_HIGH)

/* Inputs */

/* Type-C */
/* PD RX/TX */
GPIO(USB_C_REF,			PIN(A, 1),  GPIO_ANALOG)
GPIO(USB_CHG_CC1_MCU,		PIN(A, 2),  GPIO_ANALOG)
GPIO(USB_CHG_CC2_MCU,		PIN(A, 4),  GPIO_ANALOG)
GPIO(USB_DUT_CC1_MCU,		PIN(A, 0),  GPIO_ANALOG)
GPIO(USB_DUT_CC2_MCU,		PIN(A, 5),  GPIO_ANALOG)

GPIO(USB_CHG_CC1_TX_DATA,	PIN(B, 4),  GPIO_INPUT)
GPIO(USB_CHG_CC2_TX_DATA,	PIN(A, 6),  GPIO_INPUT)
GPIO(USB_DUT_CC1_TX_DATA,	PIN(B, 14), GPIO_INPUT)
GPIO(USB_DUT_CC2_TX_DATA,	PIN(C, 2),  GPIO_INPUT)

GPIO(USB_DUT_CC1_RPUSB,		PIN(C, 3),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RD,		PIN(C, 6),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RA,		PIN(C, 7),  GPIO_INPUT)
GPIO(USB_DUT_CC1_RP3A0,		PIN(C, 14), GPIO_INPUT)
GPIO(USB_DUT_CC1_RP1A5,		PIN(C, 15), GPIO_INPUT)

GPIO(USB_DUT_CC2_RPUSB,		PIN(B, 0),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RD,		PIN(B, 1),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RA,		PIN(B, 2),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RP1A5,		PIN(C, 1),  GPIO_INPUT)
GPIO(USB_DUT_CC2_RP3A0,		PIN(C, 8),  GPIO_INPUT)

/* Alternate PD functions */
GPIO(USB_CHG_TX_CLKOUT,       PIN(B, 8),  GPIO_INPUT)
GPIO(USB_CHG_TX_CLKIN,        PIN(B, 3),  GPIO_INPUT)
GPIO(USB_DUT_TX_CLKOUT,       PIN(B, 15), GPIO_INPUT)
GPIO(USB_DUT_TX_CLKIN,        PIN(B, 13), GPIO_INPUT)

/* I2C pins should be configured as inputs until I2C module is    */
/* initialized. This will avoid driving the lines unintentionally.*/
GPIO(MASTER_I2C_SCL,		PIN(B, 10), GPIO_INPUT)
GPIO(MASTER_I2C_SDA,		PIN(B, 11), GPIO_INPUT)

/* IOEX */
#ifdef SECTION_IS_RO

IOEX(SBU_UART_SEL, 		EXPIN(0, 0, 0), GPIO_OUT_LOW)
IOEX(ATMEL_RESET_L, 		EXPIN(0, 0, 1), GPIO_OUT_LOW)
IOEX(SBU_FLIP_SEL, 		EXPIN(0, 0, 2), GPIO_OUT_HIGH)
IOEX(USB3_A0_MUX_SEL, 		EXPIN(0, 0, 3), GPIO_OUT_HIGH)
IOEX(USB3_A0_MUX_EN_L, 		EXPIN(0, 0, 4), GPIO_OUT_LOW)
IOEX(USB3_A0_PWR_EN, 		EXPIN(0, 0, 5), GPIO_OUT_LOW)
IOEX(UART_18_SEL, 		EXPIN(0, 0, 6), GPIO_OUT_LOW)
IOEX(USERVO_POWER_EN, 		EXPIN(0, 0, 7), GPIO_OUT_LOW)
IOEX(USERVO_FASTBOOT_MUX_SEL, 	EXPIN(0, 1, 0), GPIO_OUT_LOW)
IOEX(USB3_A1_PWR_EN, 		EXPIN(0, 1, 1), GPIO_OUT_LOW)
IOEX(USB3_A1_MUX_SEL, 		EXPIN(0, 1, 2), GPIO_OUT_HIGH)
IOEX(BOARD_ID_DET0, 		EXPIN(0, 1, 3), GPIO_INPUT)
IOEX(BOARD_ID_DET1, 		EXPIN(0, 1, 4), GPIO_INPUT)
IOEX(BOARD_ID_DET2, 		EXPIN(0, 1, 5), GPIO_INPUT)
IOEX(VBUS_DISCHRG_EN, 		EXPIN(0, 1, 6), GPIO_OUT_LOW)
IOEX(DONGLE_DET, 		EXPIN(0, 1, 7), GPIO_INPUT)

IOEX(EN_PP5000_ALT_3P3, 	EXPIN(1, 0, 0), GPIO_OUT_LOW)
IOEX(EN_PP3300_ETH, 		EXPIN(1, 0, 1), GPIO_OUT_HIGH)
IOEX(EN_PP3300_DP, 		EXPIN(1, 0, 2), GPIO_OUT_HIGH)
IOEX(FAULT_CLEAR_CC, 		EXPIN(1, 0, 3), GPIO_OUT_LOW)
IOEX(EN_VOUT_BUF_CC1, 		EXPIN(1, 0, 4), GPIO_OUT_LOW)
IOEX(EN_VOUT_BUF_CC2, 		EXPIN(1, 0, 5), GPIO_OUT_LOW)
IOEX(DUT_CHG_EN, 		EXPIN(1, 0, 6), GPIO_OUT_LOW)
IOEX(HOST_OR_CHG_CTL, 		EXPIN(1, 0, 7), GPIO_OUT_LOW)
IOEX(USERVO_FAULT_L, 		EXPIN(1, 1, 0), GPIO_INPUT)
IOEX(USB3_A0_FAULT_L, 		EXPIN(1, 1, 1), GPIO_INPUT)
IOEX(USB3_A1_FAULT_L, 		EXPIN(1, 1, 2), GPIO_INPUT)
IOEX(USB_DUTCHG_FLT_ODL, 	EXPIN(1, 1, 3), GPIO_INPUT)
IOEX(PP3300_DP_FAULT_L, 	EXPIN(1, 1, 4), GPIO_INPUT)
IOEX(DAC_BUF1_LATCH_FAULT_L, 	EXPIN(1, 1, 5), GPIO_INPUT)
IOEX(DAC_BUF2_LATCH_FAULT_L, 	EXPIN(1, 1, 6), GPIO_INPUT)
IOEX(PP5000_SRC_SEL, 		EXPIN(1, 1, 7), GPIO_INPUT)
IOEX(HOST_CHRG_DET, 		EXPIN(1, 2, 0), GPIO_INPUT)
IOEX(USBH_PWRDN_L, 		EXPIN(1, 2, 1), GPIO_OUT_HIGH)
IOEX(ATMEL_SS,			EXPIN(1, 2, 2), GPIO_INPUT)
IOEX(ATMEL_SCLK,		EXPIN(1, 2, 3), GPIO_INPUT)
IOEX(ATMEL_MOSI,		EXPIN(1, 2, 4), GPIO_INPUT)
IOEX(ATMEL_MISO,		EXPIN(1, 2, 5), GPIO_INPUT)
IOEX(SYS_PWR_IRQ_ODL, 		EXPIN(1, 2, 6), GPIO_INPUT)
IOEX(TCA_GPIO_DBG_LED_K_ODL, 	EXPIN(1, 2, 7), GPIO_OUT_LOW)

#endif

/* Unimplemented signals since we are not an EC */
UNIMPLEMENTED(ENTERING_RW)
UNIMPLEMENTED(WP_L)

ALTERNATE(PIN_MASK(A, 0x0600), 1, MODULE_USART, 0) /* USART1: PA9/PA10 - Servo DBG UART1 */
ALTERNATE(PIN_MASK(C, 0x0030), 1, MODULE_USART, 0) /* USART3: PC4/PC5 - Servo DUT UART3 */
ALTERNATE(PIN_MASK(C, 0x0C00), 0, MODULE_USART, 0) /* USART4: PC10/PC11 - Servo UART4 */
ALTERNATE(PIN_MASK(B, 0x0C00), 1, MODULE_I2C, GPIO_ODR_HIGH) /* I2C MASTER:PB10/11 */
ALTERNATE(PIN_MASK(B, 0x0008), 0, MODULE_USB_PD, 0) /* SPI1_SCK:  PB3   */
ALTERNATE(PIN_MASK(B, 0x2000), 0, MODULE_USB_PD, 0) /* SPI2_SCK:  PB13  */
ALTERNATE(PIN_MASK(B, 0x0100), 2, MODULE_USB_PD, 0) /* TIM16_CH1: PB8   */
ALTERNATE(PIN_MASK(B, 0x8000), 1, MODULE_USB_PD, 0) /* TIM15_CH2: PB15  */

