/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.datetime;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.buildins.datetime.DateTimePrologCode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Predicate_parse_time
extends DateTimePrologCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Date date;
        if (!(args[0] instanceof AtomTerm)) {
            PrologException.typeError(TermConstants.atomAtom, args[0]);
        }
        String text = ((AtomTerm)args[0]).value;
        String format = "EEE, dd MMM yyyy HH:mm:ss zzz";
        if (args.length == 3) {
            if (!(args[2] instanceof AtomTerm)) {
                PrologException.typeError(TermConstants.atomAtom, args[2]);
            }
            format = ((AtomTerm)args[2]).value;
        }
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        try {
            date = fmt.parse(text);
        }
        catch (ParseException e) {
            return -1;
        }
        return interpreter.unify(args[1], new FloatTerm((double)date.getTime() / 1000.0));
    }
}

