var browserTests = [
["foo[]bar",
    [["fontsize","4"]],
    "foo[]bar",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p><span style=\"font-size:large\">[foo</span></p> <p><span style=\"font-size:large\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p> <p>bar]</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p><font size=\"4\">[foo</font></p> <p><font size=\"4\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:large\"><span>[foo</span> <span>bar]</span></span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span>[foo</span> <span>bar]</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"4\"><span>[foo</span> <span>bar]</span></font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p><span style=\"font-size:large\">[foo</span></p><p> <span style=\"font-size:large\"><span>bar</span></span> </p><p><span style=\"font-size:large\">baz]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo</p><p> <span>bar</span> </p><p>baz]</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p><font size=\"4\">[foo</font></p><p> <font size=\"4\"><span>bar</span></font> </p><p><font size=\"4\">baz]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p><span style=\"font-size:large\">[foo</span></p><p><br></p><p><span style=\"font-size:large\">bar]</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",true,false,"4"]}],
["<p>[foo<p><br><p>bar]",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p><font size=\"4\">[foo</font></p><p><br></p><p><font size=\"4\">bar]</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",true,false,"4"]}],
["<b>foo[]bar</b>",
    [["fontsize","4"]],
    "<b>foo[]bar</b>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<i>foo[]bar</i>",
    [["fontsize","4"]],
    "<i>foo[]bar</i>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<span>foo</span>{}<span>bar</span>",
    [["fontsize","4"]],
    "<span>foo</span>{}<span>bar</span>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["<span>foo[</span><span>]bar</span>",
    [["fontsize","4"]],
    "<span>foo[</span><span>]bar</span>",
    [true],
    {"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar</span><b><span style=\"font-size:large\">baz]</span>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<b>baz]qoz</b>quz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar</font><b><font size=\"4\">baz]</font>qoz</b>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar</span><i><span style=\"font-size:large\">baz]</span>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar<i>baz]qoz</i>quz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar</font><i><font size=\"4\">baz]</font>qoz</i>quz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","true"],["fontsize","4"]],
    "{<p></p><p> </p><p><span style=\"font-size:large\">foo</span></p>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<p><p> <p>foo</p>}",
    [["stylewithcss","false"],["fontsize","4"]],
    "{<p></p><p> </p><p><font size=\"4\">foo</font></p>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","0"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","0"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","-5"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","-5"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","6"]],
    "foo<span style=\"font-size:xx-large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"6"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","6"]],
    "foo<font size=\"6\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"6"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","7"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","7"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","8"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","8"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","100"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","100"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["fontsize","2em"]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["fontsize","20pt"]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["fontsize","xx-large"]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize"," 1 "]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize"," 1 "]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["fontsize","1."]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.0"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.0"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.0e2"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.0e2"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.1"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.1"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","1.9"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","1.9"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["fontsize","+0"]],
    "foo[bar]baz",
    [true],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","+1"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","+1"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","+9"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","+9"]],
    "foo<font size=\"7\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"7"]}],
["foo[bar]baz",
    [["fontsize","-0"]],
    "foo[bar]baz",
    [true],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","-1"]],
    "foo<span style=\"font-size:small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"2"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","-1"]],
    "foo<font size=\"2\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"2"]}],
["foo[bar]baz",
    [["stylewithcss","true"],["fontsize","-9"]],
    "foo<span style=\"font-size:x-small\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["stylewithcss","false"],["fontsize","-9"]],
    "foo<font size=\"1\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"1"]}],
["foo[bar]baz",
    [["fontsize",""]],
    "foo[bar]baz",
    [false],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td><td>b<span style=\"font-size:large\">[a]</span>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td><td>b<font size=\"4\">[a]</font>r</td><td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td>{<td><span style=\"font-size:large\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=1 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody><tr><td>foo</td>{<td><font size=\"4\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody><tr>{<td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody><tr data-start=0 data-end=2><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody><tr>{<td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td>}<td>baz</td></tr></tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table><tbody>{<tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table><tbody data-start=0 data-end=1><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table><tbody>{<tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr>}</tbody></table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<table>{<tbody><tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<table data-start=0 data-end=1><tbody><tr><td>foo<td>bar<td>baz</table>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<table>{<tbody><tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr></tbody>}</table>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","true"],["fontsize","4"]],
    "{<table><tbody><tr><td><span style=\"font-size:large\">foo</span></td><td><span style=\"font-size:large\">bar</span></td><td><span style=\"font-size:large\">baz</span></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["stylewithcss","false"],["fontsize","4"]],
    "{<table><tbody><tr><td><font size=\"4\">foo</font></td><td><font size=\"4\">bar</font></td><td><font size=\"4\">baz</font></td></tr></tbody></table>}",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=1>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<font size=1>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=1>foo[bar]baz</font>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"1\">foo<span style=\"font-size:large\">[bar]</span>baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=1>foo[bar]baz</font>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"1\">foo<font size=\"4\">[bar]</font>baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<font size=3>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=3>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>foo[bar]baz</font>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"3\">foo<span style=\"font-size:large\">[bar]</span>baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>foo[bar]baz</font>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"3\">foo<font size=\"4\">[bar]</font>baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<font size=4>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=4>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=4>foo[bar]baz</font>",
    [["fontsize","4"]],
    "<font size=\"4\">foo[bar]baz</font>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=+1>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<font size=+1>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=+1>foo[bar]baz</font>",
    [["fontsize","4"]],
    "<font size=\"+1\">foo[bar]baz</font>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=4>foo<font size=1>b[a]r</font>baz</font>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"4\">foo<span style=\"font-size:x-small\">b</span>[a]<span style=\"font-size:x-small\">r</span>baz</font>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<font size=4>foo<font size=1>b[a]r</font>baz</font>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"4\">foo<font size=\"1\">b</font>[a]<font size=\"1\">r</font>baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: xx-small\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: xx-small\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: xx-small\">foo[bar]baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:xx-small\">foo<span style=\"font-size:large\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: xx-small\">foo[bar]baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:xx-small\">foo<font size=\"4\">[bar]</font>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: medium\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<span style=\"font-size: medium\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span style=\"font-size: medium\">foo[bar]baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:medium\">foo<span style=\"font-size:large\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<span style=\"font-size: medium\">foo[bar]baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:medium\">foo<font size=\"4\">[bar]</font>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["foo<span style=\"font-size: large\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"4"]}],
["foo<span style=\"font-size: large\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"4"]}],
["<span style=\"font-size: large\">foo[bar]baz</span>",
    [["fontsize","4"]],
    "<span style=\"font-size:large\">foo[bar]baz</span>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<span style=\"font-size: large\">foo<span style=\"font-size: xx-small\">b[a]r</span>baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:large\">foo<span style=\"font-size:xx-small\">b</span>[a]<span style=\"font-size:xx-small\">r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<span style=\"font-size: large\">foo<span style=\"font-size: xx-small\">b[a]r</span>baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:large\">foo<span style=\"font-size:xx-small\">b</span>[a]<span style=\"font-size:xx-small\">r</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["foo<span style=\"font-size: 2em\">[bar]</span>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["foo<span style=\"font-size: 2em\">[bar]</span>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<span style=\"font-size: 2em\">foo[bar]baz</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<span style=\"font-size:2em\">foo<span style=\"font-size:large\">[bar]</span>baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<span style=\"font-size: 2em\">foo[bar]baz</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<span style=\"font-size:2em\">foo<font size=\"4\">[bar]</font>baz</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p style=\"font-size:xx-small\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p style=\"font-size:xx-small\">foo<font size=\"4\">[bar]</font>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"4"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p style=\"font-size:medium\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p style=\"font-size:medium\">foo<font size=\"4\">[bar]</font>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
    [["fontsize","4"]],
    "<p style=\"font-size:large\">foo[bar]baz</p>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<p style=\"font-size:2em\">foo<span style=\"font-size:large\">[bar]</span>baz</p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<p style=\"font-size:2em\">foo<font size=\"4\">[bar]</font>baz</p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<p><span style=\"font-size:xx-small\">foo</span>[bar]<span style=\"font-size:xx-small\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"1",false,false,"3"]}],
["<p style=\"font-size: xx-small\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<p><span style=\"font-size:xx-small\">foo</span>[bar]<span style=\"font-size:xx-small\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"1",false,false,"3"]}],
["<p style=\"font-size: medium\">foo[bar]baz</p>",
    [["fontsize","3"]],
    "<p style=\"font-size:medium\">foo[bar]baz</p>",
    [true],
    {"fontsize":[false,false,"3",false,false,"3"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<p><span style=\"font-size:large\">foo</span>[bar]<span style=\"font-size:large\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["<p style=\"font-size: large\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<p><font size=\"4\">foo</font>[bar]<font size=\"4\">baz</font></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<p><span style=\"font-size:2em\">foo</span>[bar]<span style=\"font-size:2em\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"3"]}],
["<p style=\"font-size: 2em\">foo[bar]baz</p>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<p><span style=\"font-size:2em\">foo</span>[bar]<span style=\"font-size:2em\">baz</span></p>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"3"]}],
["<font size=6>foo <span style=\"font-size: 2em\">b[a]r</span> baz</font>",
    [["stylewithcss","true"],["fontsize","3"]],
    "<span style=\"font-size:xx-large\">foo </span><span style=\"font-size:2em\">b</span>[a]<span style=\"font-size:2em\">r</span><span style=\"font-size:xx-large\"> baz</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"7",false,false,"3"]}],
["<font size=6>foo <span style=\"font-size: 2em\">b[a]r</span> baz</font>",
    [["stylewithcss","false"],["fontsize","3"]],
    "<font size=\"6\">foo </font><span style=\"font-size:2em\">b</span>[a]<span style=\"font-size:2em\">r</span><font size=\"6\"> baz</font>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"7",false,false,"3"]}],
["foo<big>[bar]</big>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<big><span style=\"font-size:medium\">[bar]</span></big>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>[bar]</big>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<big><font size=\"3\">[bar]</font></big>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>b[a]r</big>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<big>b<span style=\"font-size:medium\">[a]</span>r</big>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<big>b[a]r</big>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<big>b<font size=\"3\">[a]</font>r</big>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"4",false,false,"3"]}],
["foo<small>[bar]</small>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<small><span style=\"font-size:medium\">[bar]</span></small>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>[bar]</small>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<small><font size=\"3\">[bar]</font></small>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>b[a]r</small>baz",
    [["stylewithcss","true"],["fontsize","3"]],
    "foo<small>b<span style=\"font-size:medium\">[a]</span>r</small>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"3"]}],
["foo<small>b[a]r</small>baz",
    [["stylewithcss","false"],["fontsize","3"]],
    "foo<small>b<font size=\"3\">[a]</font>r</small>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"3"]}],
["fo[o<font size=2>b]ar</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "fo<span style=\"font-size:large\">[o</span><font size=\"2\"><span style=\"font-size:large\">b]</span>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"3",false,false,"4"]}],
["fo[o<font size=2>b]ar</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "fo<font size=\"4\">[o</font><font size=\"2\"><font size=\"4\">b]</font>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"3",false,false,"4"]}],
["foo<font size=2>ba[r</font>b]az",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<font size=\"2\">ba<span style=\"font-size:large\">[r</span></font><span style=\"font-size:large\">b]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>b]az",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"2\">ba<font size=\"4\">[r</font></font><font size=\"4\">b]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"2",false,false,"4"]}],
["fo[o<font size=2>bar</font>b]az",
    [["stylewithcss","true"],["fontsize","4"]],
    "fo<span style=\"font-size:large\">[obarb]</span>az",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"3",false,false,"4"]}],
["fo[o<font size=2>bar</font>b]az",
    [["stylewithcss","false"],["fontsize","4"]],
    "fo<font size=\"4\">[obarb]</font>az",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"3",false,false,"4"]}],
["foo[<font size=2>b]ar</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo[<font size=\"2\"><span style=\"font-size:large\">b]</span>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>b]ar</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo[<font size=\"2\"><font size=\"4\">b]</font>ar</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>]baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<font size=\"2\">ba<span style=\"font-size:large\">[r</span></font>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>ba[r</font>]baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"2\">ba<font size=\"4\">[r</font></font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>bar</font>]baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo[<span style=\"font-size:large\">bar</span>]baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo[<font size=2>bar</font>]baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo[<font size=\"4\">bar</font>]baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>[bar]</font>baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo<span style=\"font-size:large\">[bar]</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo<font size=2>[bar]</font>baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo<font size=\"4\">[bar]</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo{<font size=2>bar</font>}baz",
    [["stylewithcss","true"],["fontsize","4"]],
    "foo{<span style=\"font-size:large\">bar}</span>baz",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["foo{<font size=2>bar</font>}baz",
    [["stylewithcss","false"],["fontsize","4"]],
    "foo{<font size=\"4\">bar}</font>baz",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=1>fo[o</font><span style=font-size:xx-small>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"1\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:xx-small\"><span style=\"font-size:large\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[true,false,"1",false,false,"4"]}],
["<font size=1>fo[o</font><span style=font-size:xx-small>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"1\">fo<font size=\"4\">[o</font></font><span style=\"font-size:xx-small\"><font size=\"4\">b]</font>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[true,false,"1",false,false,"4"]}],
["<font size=2>fo[o</font><span style=font-size:small>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"2\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:small\"><span style=\"font-size:large\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=2>fo[o</font><span style=font-size:small>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"2\">fo<font size=\"4\">[o</font></font><span style=\"font-size:small\"><font size=\"4\">b]</font>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"2",false,false,"4"]}],
["<font size=3>fo[o</font><span style=font-size:medium>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"3\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:medium\"><span style=\"font-size:large\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=3>fo[o</font><span style=font-size:medium>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"3\">fo<font size=\"4\">[o</font></font><span style=\"font-size:medium\"><font size=\"4\">b]</font>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"3",false,false,"4"]}],
["<font size=4>fo[o</font><span style=font-size:large>b]ar</span>",
    [["fontsize","4"]],
    "<font size=\"4\">fo[o</font><span style=\"font-size:large\">b]ar</span>",
    [true],
    {"fontsize":[false,false,"4",false,false,"4"]}],
["<font size=5>fo[o</font><span style=font-size:x-large>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"5\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:x-large\"><span style=\"font-size:large\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"5",false,false,"4"]}],
["<font size=5>fo[o</font><span style=font-size:x-large>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"5\">fo<font size=\"4\">[o</font></font><span style=\"font-size:x-large\"><font size=\"4\">b]</font>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"5",false,false,"4"]}],
["<font size=6>fo[o</font><span style=font-size:xx-large>b]ar</span>",
    [["stylewithcss","true"],["fontsize","4"]],
    "<font size=\"6\">fo<span style=\"font-size:large\">[o</span></font><span style=\"font-size:xx-large\"><span style=\"font-size:large\">b]</span>ar</span>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"fontsize":[false,false,"6",false,false,"4"]}],
["<font size=6>fo[o</font><span style=font-size:xx-large>b]ar</span>",
    [["stylewithcss","false"],["fontsize","4"]],
    "<font size=\"6\">fo<font size=\"4\">[o</font></font><span style=\"font-size:xx-large\"><font size=\"4\">b]</font>ar</span>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"fontsize":[false,false,"6",false,false,"4"]}]
]
