;;; Disarchive
;;; Copyright © 2020, 2021 Timothy Sample <samplet@ngyro.com>
;;;
;;; This file is part of Disarchive.
;;;
;;; Disarchive is free software: you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation, either version 3 of the License, or
;;; (at your option) any later version.
;;;
;;; Disarchive is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Disarchive.  If not, see <http://www.gnu.org/licenses/>.

(define-module (disarchive scripts disassemble)
  #:use-module (disarchive)
  #:use-module (ice-9 match)
  #:use-module (ice-9 pretty-print)
  #:export (disassemble-main))

(define (disassemble-main . args)
  (%disarchive-log-port (current-error-port))
  (match args
    (("-n" name filename)
     (pretty-print (disarchive-disassemble filename #:name name)))
    ((filename)
     (pretty-print (disarchive-disassemble filename)))
    (_ (display "Usage: disarchive save [-n NAME] FILENAME\n"))))
