/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;

public class Break
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        block6: {
            try {
                String type = this.args.remove(0).toString().toLowerCase();
                if (type.equals("in_method")) {
                    this.doBreakInMethod(this.args);
                    break block6;
                }
                if (type.equals("on_line")) {
                    this.doBreakOnLine(this.args);
                    break block6;
                }
                if (type.equals("absolute")) {
                    this.doBreakAbsolute(this.args);
                    break block6;
                }
                throw new JDEException("Syntax error: expecting one of 'in_method', 'on_line', or 'absolute'; '" + type + "' is not supported");
            }
            catch (UnsupportedOperationException ex) {
                throw new JDEException("Unspecified Error occured");
            }
            catch (IndexOutOfBoundsException ex) {
                throw new JDEException("Syntax error: argument missing");
            }
        }
    }

    public void doBreakInMethod(List args) throws JDEException {
        String arg;
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = args.remove(0).toString();
        String method = args.remove(0).toString();
        ArrayList<String> argumentList = null;
        if (args.size() > 0 && (arg = args.remove(0).toString()).startsWith("(")) {
            if (!arg.endsWith(")")) {
                throw new JDEException("The argument list seems to be corrupt");
            }
            arg = arg.substring(1, arg.length() - 1);
            argumentList = new ArrayList<String>();
            StringTokenizer t = new StringTokenizer(arg, ",");
            while (t.hasMoreTokens()) {
                argumentList.add(t.nextToken());
            }
        }
        EventRequestSpecList eventRequests = this.proc.getEventRequestSpecs();
        EventRequestSpec er = eventRequests.createMethodBreakpoint(classPattern, method, argumentList);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        eventRequests.install(er);
        this.jde.signalCommandResult(this.procID, this.cmdID, er.getID());
    }

    public void doBreakOnLine(List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = args.remove(0).toString();
        int line = Etc.safeGetint(args.remove(0), "line number");
        EventRequestSpecList eventRequests = this.proc.getEventRequestSpecs();
        EventRequestSpec er = eventRequests.createClassLineBreakpoint(classPattern, line);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        eventRequests.install(er);
        this.jde.signalCommandResult(this.procID, this.cmdID, er.getID());
    }

    public void doBreakAbsolute(List args) throws JDEException {
        if (args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String file = args.remove(0).toString();
        int line = Etc.safeGetint(args.remove(0), "line number");
        EventRequestSpecList eventRequests = this.proc.getEventRequestSpecs();
        EventRequestSpec er = eventRequests.createSourceLineBreakpoint(file, line);
        er.setThread(Etc.getThreadFromArgs(args));
        er.setExpression(Etc.getExprFromArgs(args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(args));
        eventRequests.install(er);
        this.jde.signalCommandResult(this.procID, this.cmdID, er.getID());
    }

    public Object clone() {
        return new Break();
    }
}

