/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.AuditListener;
import com.puppycrawl.tools.checkstyle.BlockOption;
import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.Configuration;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.LeftCurlyOption;
import com.puppycrawl.tools.checkstyle.PadOption;
import com.puppycrawl.tools.checkstyle.RightCurlyOption;
import com.puppycrawl.tools.checkstyle.Scope;
import com.puppycrawl.tools.checkstyle.WrapOpOption;
import com.puppycrawl.tools.checkstyle.XMLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.regexp.RESyntaxException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class CheckStyleTask
extends Task {
    private static final String E_XML = "xml";
    private static final String E_PLAIN = "plain";
    private Path mClasspath;
    private String mFileName;
    private boolean mFailOnViolation = true;
    private String mFailureProperty = null;
    private final List mFileSets = new ArrayList();
    private final List mFormatters = new ArrayList();
    private Configuration mConfig = new Configuration();
    private final ArrayList mOptionMemory = new ArrayList();

    public void setFailureProperty(String aPropertyName) {
        this.mFailureProperty = aPropertyName;
    }

    public void setFailOnViolation(boolean aFail) {
        this.mFailOnViolation = aFail;
    }

    public void addFileset(FileSet aFS) {
        this.mFileSets.add(aFS);
    }

    public void addFormatter(Formatter aFormatter) {
        this.mFormatters.add(aFormatter);
    }

    public void setClasspath(Path aClasspath) {
        this.mClasspath = aClasspath;
    }

    public Path createClasspath() {
        if (this.mClasspath == null) {
            this.mClasspath = new Path(((ProjectComponent)this).project);
        }
        return this.mClasspath.createPath();
    }

    public void setFile(File aFile) {
        this.mFileName = aFile.getAbsolutePath();
    }

    public void setProperties(File aProps) {
        Properties mProperties = new Properties();
        try {
            mProperties.load(new FileInputStream(aProps));
            this.mConfig = new Configuration(mProperties, System.out);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Could not find Properties file '" + aProps + "'", (Throwable)e, this.location);
        }
        catch (Exception e) {
            throw new BuildException("Error loading Properties file '" + aProps + "'", (Throwable)e, this.location);
        }
    }

    public void setAllowTabs(boolean aAllowed) {
        this.setBooleanProperty("checkstyle.allow.tabs", aAllowed);
    }

    public void setTabWidth(int aTabWidth) {
        this.setIntProperty("checkstyle.tab.width", aTabWidth);
    }

    public void setAllowProtected(boolean aAllowed) {
        this.setBooleanProperty("checkstyle.allow.protected", aAllowed);
    }

    public void setAllowPackage(boolean aAllowed) {
        this.setBooleanProperty("checkstyle.allow.package", aAllowed);
    }

    public void setAllowNoAuthor(boolean aAllowed) {
        this.setBooleanProperty("checkstyle.allow.noauthor", aAllowed);
    }

    public void setMaxLineLen(int aLen) {
        this.setIntProperty("checkstyle.maxlinelen", aLen);
    }

    public void setMaxMethodLen(int aLen) {
        this.setIntProperty("checkstyle.maxmethodlen", aLen);
    }

    public void setMaxConstructorLen(int aLen) {
        this.setIntProperty("checkstyle.maxconstructorlen", aLen);
    }

    public void setMaxFileLen(int aLen) {
        this.setIntProperty("checkstyle.maxfilelen", aLen);
    }

    public void setIgnoreLineLengthPattern(String aPat) {
        this.setPatternProperty("checkstyle.ignore.maxlinelen", aPat, "ignoreLineLengthPattern");
    }

    public void setIgnoreImportLen(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.importlength", aIgnore);
    }

    public void setMemberPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.member", aPat, "memberPattern");
    }

    public void setPublicMemberPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.publicmember", aPat, "publicMemberPattern");
    }

    public void setTodoPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.todo", aPat, "todoPattern");
    }

    public void setParamPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.parameter", aPat, "paramPattern");
    }

    public void setConstPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.const", aPat, "constPattern");
    }

    public void setStaticPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.static", aPat, "staticPattern");
    }

    public void setTypePattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.type", aPat, "typePattern");
    }

    public void setLocalVarPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.localvar", aPat, "localVarPattern");
    }

    public void setMethodPattern(String aPat) {
        this.setPatternProperty("checkstyle.pattern.method", aPat, "methodPattern");
    }

    public void setHeaderFile(final File aName) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                try {
                    CheckStyleTask.this.mConfig.setHeaderFile(aName.getAbsolutePath());
                }
                catch (IOException ex) {
                    throw new BuildException("Unable to read headerfile - ", (Throwable)ex);
                }
            }
        });
    }

    public void setHeaderLinesRegexp(boolean aIsRegexp) {
        this.setBooleanProperty("checkstyle.header.regexp", aIsRegexp);
    }

    public void setHeaderIgnoreLine(final String aList) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setHeaderIgnoreLines(aList);
            }
        });
    }

    public void setJavadocScope(final String aJavadocScope) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setJavadocScope(Scope.getInstance(aJavadocScope));
            }
        });
    }

    public void setRequirePackageHtml(boolean aRequirePackageHtml) {
        this.setBooleanProperty("checkstyle.require.packagehtml", aRequirePackageHtml);
    }

    public void setIgnoreImports(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.imports", aIgnore);
    }

    public void setIllegalImports(final String aPkgPrefixList) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setIllegalImports(aPkgPrefixList);
            }
        });
    }

    public void setIllegalInstantiations(final String aClassList) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setIllegalInstantiations(aClassList);
            }
        });
    }

    public void setIgnoreWhitespace(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.whitespace", aIgnore);
    }

    public void setIgnoreCastWhitespace(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.whitespace.cast", aIgnore);
    }

    public void setIgnoreBraces(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.braces", aIgnore);
    }

    public void setIgnoreLongEll(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.longell", aIgnore);
    }

    public void setIgnorePublicInInterface(boolean aIgnore) {
        this.setBooleanProperty("checkstyle.ignore.public.in.interface", aIgnore);
    }

    public void setCheckUnusedThrows(boolean aEnable) {
        this.setBooleanProperty("checkstyle.javadoc.checkUnusedThrows", aEnable);
    }

    public void setBasedir(File aBasedir) {
        if (!aBasedir.isDirectory()) {
            throw new BuildException("basedir must specify a directory.", this.location);
        }
        this.mConfig.setBasedir(aBasedir.getAbsolutePath());
    }

    public void setCacheFile(final File aCacheFile) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setCacheFile(aCacheFile.getAbsolutePath());
            }
        });
    }

    public void setLCurlyMethod(String aTo) {
        this.setLeftCurlyOptionProperty("checkstyle.lcurly.method", aTo);
    }

    public void setLCurlyType(String aTo) {
        this.setLeftCurlyOptionProperty("checkstyle.lcurly.type", aTo);
    }

    public void setLCurlyOther(String aTo) {
        this.setLeftCurlyOptionProperty("checkstyle.lcurly.other", aTo);
    }

    public void setRCurly(final String aTo) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setRCurly(CheckStyleTask.this.extractRightCurlyOption(aTo));
            }
        });
    }

    public void setTryBlock(String aTo) {
        this.setBlockOptionProperty("checkstyle.block.try", aTo);
    }

    public void setCatchBlock(String aTo) {
        this.setBlockOptionProperty("checkstyle.block.catch", aTo);
    }

    public void setFinallyBlock(String aTo) {
        this.setBlockOptionProperty("checkstyle.block.finally", aTo);
    }

    public void setParenPad(final String aTo) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setParenPadOption(CheckStyleTask.this.extractPadOption(aTo));
            }
        });
    }

    public void setWrapOp(final String aTo) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setWrapOpOption(CheckStyleTask.this.extractWrapOpOption(aTo));
            }
        });
    }

    public void execute() throws BuildException {
        if (this.mFileName == null && this.mFileSets.size() == 0) {
            throw new BuildException("Must specify atleast one of 'file' or nested 'fileset'.", this.location);
        }
        if (this.mClasspath != null) {
            this.mConfig.setClassLoader((ClassLoader)new AntClassLoader(((ProjectComponent)this).project, this.mClasspath));
        }
        Checker c = null;
        try {
            try {
                this.applyExplicitOptions();
                c = new Checker(this.mConfig);
                AuditListener[] listeners = this.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    c.addListener(listeners[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BuildException("Unable to create a Checker", (Throwable)e);
            }
            String[] files = this.scanFileSets();
            int numErrs = c.process(files);
            if (numErrs > 0 && this.mFailureProperty != null) {
                this.getProject().setProperty(this.mFailureProperty, "true");
            }
            if (numErrs > 0 && this.mFailOnViolation) {
                throw new BuildException("Got " + numErrs + " errors.", this.location);
            }
            Object var5_5 = null;
            if (c != null) {
                c.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (c != null) {
                c.destroy();
            }
            throw throwable;
        }
    }

    protected AuditListener[] getListeners() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        int listenerCount = Math.max(1, this.mFormatters.size());
        AuditListener[] listeners = new AuditListener[listenerCount];
        if (this.mFormatters.size() == 0) {
            LogOutputStream debug = new LogOutputStream((Task)this, 4);
            LogOutputStream err = new LogOutputStream((Task)this, 0);
            listeners[0] = new DefaultLogger((OutputStream)debug, true, (OutputStream)err, true);
            return listeners;
        }
        int i = 0;
        while (i < listeners.length) {
            Formatter f = (Formatter)this.mFormatters.get(i);
            listeners[i] = f.createListener(this);
            ++i;
        }
        return listeners;
    }

    protected String[] scanFileSets() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.mFileName != null) {
            this.log("Adding standalone file for audit", 3);
            list.add(this.mFileName);
        }
        int i = 0;
        while (i < this.mFileSets.size()) {
            FileSet fs = (FileSet)this.mFileSets.get(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] names = ds.getIncludedFiles();
            this.log(i + ") Adding " + names.length + " files from directory " + ds.getBasedir(), 3);
            int j = 0;
            while (j < names.length) {
                String pathname = ds.getBasedir() + File.separator + names[j];
                list.add(pathname);
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private RightCurlyOption extractRightCurlyOption(String aFrom) throws BuildException {
        RightCurlyOption opt = RightCurlyOption.decode(aFrom);
        if (opt == null) {
            throw new BuildException("Unable to parse '" + aFrom + "'.", this.location);
        }
        return opt;
    }

    private PadOption extractPadOption(String aFrom) throws BuildException {
        PadOption opt = PadOption.decode(aFrom);
        if (opt == null) {
            throw new BuildException("Unable to parse '" + aFrom + "'.", this.location);
        }
        return opt;
    }

    private WrapOpOption extractWrapOpOption(String aFrom) throws BuildException {
        WrapOpOption opt = WrapOpOption.decode(aFrom);
        if (opt == null) {
            throw new BuildException("Unable to parse '" + aFrom + "'.", this.location);
        }
        return opt;
    }

    private void applyExplicitOptions() {
        Iterator it = ((AbstractList)this.mOptionMemory).iterator();
        while (it.hasNext()) {
            Runnable runnable = (Runnable)it.next();
            runnable.run();
        }
        this.mOptionMemory.clear();
    }

    private void setBooleanProperty(final String aName, final boolean aTo) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setBooleanProperty(aName, aTo);
            }
        });
    }

    private void setIntProperty(final String aName, final int aTo) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setIntProperty(aName, aTo);
            }
        });
    }

    private void setPatternProperty(final String aName, final String aTo, final String aLabel) {
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                try {
                    CheckStyleTask.this.mConfig.setPatternProperty(aName, aTo);
                }
                catch (RESyntaxException ex) {
                    throw new BuildException("Unable to parse " + aLabel + " - ", (Throwable)ex);
                }
            }
        });
    }

    private void setBlockOptionProperty(final String aName, String aTo) throws BuildException {
        final BlockOption opt = BlockOption.decode(aTo);
        if (opt == null) {
            throw new BuildException("Unable to parse '" + aTo + "'.", this.location);
        }
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setBlockOptionProperty(aName, opt);
            }
        });
    }

    private void setLeftCurlyOptionProperty(final String aName, String aTo) throws BuildException {
        final LeftCurlyOption opt = LeftCurlyOption.decode(aTo);
        if (opt == null) {
            throw new BuildException("Unable to parse '" + aTo + "'.", this.location);
        }
        this.mOptionMemory.add(new Runnable(){

            public void run() {
                CheckStyleTask.this.mConfig.setLeftCurlyOptionProperty(aName, opt);
            }
        });
    }

    public static class Formatter {
        private FormatterType mFormatterType = null;
        private File mToFile = null;

        public void setType(FormatterType aType) {
            String val = aType.getValue();
            if (!CheckStyleTask.E_XML.equals(val) && !CheckStyleTask.E_PLAIN.equals(val)) {
                throw new BuildException("Invalid formatter type: " + val);
            }
            this.mFormatterType = aType;
        }

        public void setTofile(File aTo) {
            this.mToFile = aTo;
        }

        public AuditListener createListener(Task aTask) throws IOException {
            if (CheckStyleTask.E_XML.equals(this.mFormatterType.getValue())) {
                return this.createXMLLogger(aTask);
            }
            return this.createDefaultLogger(aTask);
        }

        private AuditListener createDefaultLogger(Task aTask) throws IOException {
            if (this.mToFile == null) {
                return new DefaultLogger((OutputStream)new LogOutputStream(aTask, 4), true, (OutputStream)new LogOutputStream(aTask, 0), true);
            }
            return new DefaultLogger(new FileOutputStream(this.mToFile), true);
        }

        private AuditListener createXMLLogger(Task aTask) throws IOException {
            if (this.mToFile == null) {
                return new XMLLogger((OutputStream)new LogOutputStream(aTask, 2), true);
            }
            return new XMLLogger(new FileOutputStream(this.mToFile), true);
        }
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"xml", "plain"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

