/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import jde.debugger.Protocol;

public class JDE
implements Protocol {
    private static JDE s_jde = new JDE(System.out);
    private PrintWriter m_out;
    private int m_debugFlags = 127;
    private StringBuffer msgbuf = new StringBuffer(256);

    private JDE(OutputStream out) {
        this.m_out = new PrintWriter(out, true);
    }

    private synchronized void p_transmit(String type, String message) {
        this.m_out.println("(jde-dbo-" + type + " " + message + ")");
    }

    private void p_setDebugFlags(int flags) {
        this.m_debugFlags = flags;
    }

    private void p_debug(int flag, String message) {
        if ((this.m_debugFlags & flag) != 0) {
            this.p_transmit("debug", " \"" + DateFormat.getTimeInstance(2).format(new Date()) + ": " + message + "\"");
        }
    }

    public static void setDebugFlags(int flags) {
        s_jde.p_setDebugFlags(flags);
    }

    public static void debug(int flag, String message) {
        s_jde.p_debug(flag, message);
    }

    public static void commandResult(Integer cmdID, String message, boolean success, boolean quote) {
        String type = success ? "command-result" : "command-error";
        StringBuffer messageBuffer = new StringBuffer(cmdID.toString());
        if (message != null && message.length() > 0) {
            messageBuffer.append(" ");
            if (quote) {
                messageBuffer.append("\"");
            }
            messageBuffer.append(message);
            if (quote) {
                messageBuffer.append("\"");
            }
        }
        s_jde.p_transmit(type, messageBuffer.toString());
    }

    public static void commandResult(Integer cmdID, String message, boolean success) {
        JDE.commandResult(cmdID, message, success, false);
    }

    public static void signal(Integer procID, String type, String message, boolean quote) {
        StringBuffer messageBuffer = new StringBuffer(procID.toString());
        if (message != null && message.length() > 0) {
            messageBuffer.append(" ");
            if (quote) {
                messageBuffer.append("\"");
            }
            messageBuffer.append(message);
            if (quote) {
                messageBuffer.append("\"");
            }
        }
        s_jde.p_transmit(type, messageBuffer.toString());
    }

    public static void signalException(Throwable exc) {
        s_jde.p_signalException(exc);
    }

    private void p_signalException(Throwable exc) {
        if ((this.m_debugFlags & 8) != 0) {
            StringWriter writer = new StringWriter();
            exc.printStackTrace(new PrintWriter(writer));
            JDE.signal(new Integer(-1), "error", "Exception during command execution: " + ((Object)writer).toString(), true);
        }
    }

    public static void signal(Integer procID, String type, String message) {
        JDE.signal(procID, type, message, false);
    }
}

