%******************************************************************************
%  FILE = spnr.red 				Wed Mar  2 15:07:22 EST 1988
% 
%  Procedures in this file:
%  
%  SPMETRIC* SPINMAT* SPCHRISTOFFEL*
% 
%  REDTEN source code
%  Copyright (c) 1986, 1987 University of Toronto.
%  All Rights Reserved.
%
%  Written by John Harper and Charles Dyer
%
%  Permission to use this software without fee is granted subject to 
%  the following restrictions:
% 
%  1. This software may not be used or distributed for direct commercial
%     gain.
% 
%  2. The author is not responsible for the consequences of use of this
%     software, no matter how awful, even if they arise from flaws in it.
% 
%  3. The origin of this software must not be misrepresented, either by
%     explicit claim or by omission.
% 
%  4. This code may be altered to suit your need, but such alterations
%     must be plainly marked and the code must not be misrepresented
%     as the original software.
% 
%  5. This notice may not be removed or altered.
% 
%**********************************************************************

REMPROP ('INDEX, 'STAT);
GLOBAL '(INDICESP CURRENTMETRIC CURRENTCONNECTION);
GLOBAL '(SPMETRIC SPINMAT SPCHRISTOFFEL);
SPMETRIC := '(E3 E4);		% default names for metrics
PUT ('SPMETRIC, 'SIMPFN, 'SPMETRIC!*);

% spmetric* generates a set of spinor metrics.

SYMBOLIC PROCEDURE SPMETRIC!* (U);
BEGIN SCALAR E3, E4, LE3, LE4;
  E3 := NEWNME (MYCAR (U), MYCAR (SPMETRIC)); 
  E4 := NEWNME (MYCADR (U), MYCADR (SPMETRIC));
  MKTNSR!* (E3, '(-3 -3), '(((-1) 1 2)), 1, 'METRIC);
  MKTNSR!* (E4, '(-4 -4), '(((-1) 1 2)), 1, 'METRIC);
  KILL (MYCAR (GET (E3, 'CONJUGATE))) ;% remove the automatically made conjugate
  KILL (MYCAR (GET (E4, 'CONJUGATE)));
  PUT (E3, 'CONJUGATE, LIST (E4));	% each is the others conjugate.
  PUT (E4, 'CONJUGATE, LIST (E3));
  PUT (E3, 'COORDS, 'NIL);
  PUT (E4, 'COORDS, 'NIL);
  LE3 := MAKENAME (APPEND (EXPLODE (E3), '(!# I N V)));  % make the inverses
  LE4 := MAKENAME (APPEND (EXPLODE (E4), '(!# I N V)));

  MKTNSR!* (LE3, '(3 3), '(((-1) 1 2)), 1, 'METRIC);
  MKTNSR!* (LE4, '(4 4), '(((-1) 1 2)), 1, 'METRIC);
  KILL (MYCAR (GET (LE3, 'CONJUGATE)));
  KILL (MYCAR (GET (LE4, 'CONJUGATE)));
  PUT (LE3, 'CONJUGATE, LIST (LE4));	% each is the others conjugate.
  PUT (LE4, 'CONJUGATE, LIST (LE3));
  PUT (LE3, 'COORDS, 'NIL);
  PUT (LE4, 'COORDS, 'NIL);
  PUT (E3, '!*AT!*, LIST ('T, E3, LE3, 'D3));
  PUT (E4, '!*AT!*, LIST ('T, E4, LE4, 'D4));
  PUT (LE3, 'PNAME, E3);
  PUT (LE4, 'PNAME, E4);
  PUT (E3, '!#DBR, 0);
  PUT (E4, '!#DBR, 0);
  FLAG (LIST (LE3, LE4), 'NODIR);
  PROTECT!* (E3, 'W);
  PROTECT!* (E4, 'W);
  PROTECT!* (LE3, 'W);
  PROTECT!* (LE4, 'W);
  IF NOT INDEXED (NTH (CURRENTMETRIC, 3)) THEN SETMET (E3);
  IF NOT INDEXED (NTH (CURRENTMETRIC, 4)) THEN SETMET (E4);
  TERPRI ();	% print the names by hand.
  WRITE (" ",E3,", ", E4);
  TERPRI ();
  RETURN ('T . 1);
END;

SPINMAT := 'SIG;	% default name for spin matrices.
PUT ('SPINMAT, 'SIMPFN, 'SPINMAT!*);

% spinmat* computes the spinmatrices associated with the defined tensor
% metric. currently it only can do this if the metric is diagonal,
% where it forms spin matrices that are closely related to the Pauli
% matrices of flat space.

SYMBOLIC PROCEDURE SPINMAT!* (U);
BEGIN SCALAR LEX, I1, I2, LEX1, MET, SPNR;
  SPNR := NEWNME (MYCAR (U), SPINMAT);
  MET := GETMET (1);		% tensor metric
  MKTNSR!* (SPNR, '(-1 3 4), '(((1 . T) 2 3)), 'NIL, 'CONNECTION);
  I1 := MYCAR (INDICESP);
  I2 := MYCADR (INDICESP);
  IF GET (MET, 'SYMMETRY) = '(((0) 1 2)) THEN << % done by hand essentially
    LEX1 := IGEN ('(a!# b!#), '(1 1), '(((0) 1 2)));

    LEX := SIMP (LIST ('CMOD, LIST ('SQRT, 
           MK!*SQ (QUOTSQ (READTNSR (MET, MYCAR (LEX1)), '(2 . 1))))));
    WRITETNSR (SPNR, LIST (MYCAAR (LEX1), I1, I1),
         LEX, 'T);
    WRITETNSR (SPNR, LIST (MYCAAR (LEX1), I2, I2),
         LEX, 'T);
    LEX1 := MYCDR (LEX1);
    LEX := SIMP (LIST ('CMOD, LIST ('SQRT, 
           MK!*SQ (QUOTSQ (READTNSR (MET, MYCAR (LEX1)), '(2 . 1))))));
    WRITETNSR (SPNR, LIST (MYCAAR (LEX1), I1, I2),
         LEX, 'T);
    LEX1 := MYCDR (LEX1);
    LEX := MULTSQ (SIMP (LIST ('CMOD, LIST ('SQRT, 
           MK!*SQ (QUOTSQ (READTNSR (MET, MYCAR (LEX1)), '(2 . 1)))))), 
          '((((I . 1) . -1)) . 1));
    WRITETNSR (SPNR, LIST (MYCAAR (LEX1), I1, I2),
         LEX, 'T);
    LEX1 := MYCDR (LEX1);
    LEX := SIMP (LIST ('CMOD, LIST ('SQRT, 
           MK!*SQ (QUOTSQ (READTNSR (MET, MYCAR (LEX1)), '(2 . 1))))));
    WRITETNSR (SPNR, LIST (MYCAAR (LEX1), I1, I1),
         LEX, 'T);
    WRITETNSR (SPNR, LIST (MYCAAR (LEX1), I2, I2),
         NEGSQ (LEX), 'T)
  >> ELSE <<
    MERROR (LIST ("can't make spin matrices -- sorry"), 'T, 'SPINMAT)
  >>;
  PUT (SPNR, 'TYPE, 'CONNECTION);
  PUT (SPNR, '!#DBR, 0);
  PROTECT!* (SPNR, 'W);
  IF NOT INDEXED (NTH (CURRENTCONNECTION, 2)) THEN SETCON (SPNR, 2);
  CLEANER ('SPINMAT);
  RETURN (SPNR . 1);
END;

SPCHRISTOFFEL := 'SPC;		% default name for christoffel symbols.
PUT ('SPCHRISTOFFEL, 'SIMPFN, 'SPCHRISTOFFEL!*);

% spchristoffel computes the spinor christoffel symbols from the spin
% matrices and the tensor christoffel symbols. 
% somewhere there's a factor of 4 hiding, the 8 below is a 2 in the formulae.

SYMBOLIC PROCEDURE SPCHRISTOFFEL!* (U);
BEGIN SCALAR SPNR, LEX;
  SPNR := MYCAR (U);
  LEX := GET (GETMET (1), 'SPCHRISTOFFEL);	% name stored on tensor metric.
  IF NOT SPNR AND INDEXED (LEX) THEN RETURN (LEX . 1);
  SPNR := NEWNME (SPNR, SPCHRISTOFFEL);
  MKTNSR!* (SPNR, '(3 -3 -1), '(), '(), 'SPCHRISTOFFEL);
  LEX := LIST ('TIMES,	% expression for symbol in terms of other things
         LIST ('RDR, GETCON (2), '(d!# c!# y!#)),
         LIST ('PLUS, LIST ('TIMES,
         LIST ('RDR, GETCON (2), '((!*AT!* e!#) (!*AT!* b!#) (!*AT!* y!#))),
         LIST ('RDR, MYCAR (CHRISTOFFEL2!* ('NIL)), '(d!# a!# e!#))),
         LIST ('RDR, GETCON (2), '((!*AT!* d!#) (!*AT!* b!#) (!*AT!* y!#)
                                     !#BR a!#))));

                     % this 8 is supposed to be a 2, but its right this way!
  EVALTNSR1 (SPNR, '(c!# b!# a!#), LIST ('QUOTIENT, LEX, 8), 'NIL);
  PROTECT!* (SPNR, 'W);
  PUT (SPNR, 'TYPE, 'SPCHRISTOFFEL);
  PUT (GETMET (1), 'SPCHRISTOFFEL, SPNR);	% store name on tensor metric.
  CLEANER ('SPCHRISTOFFEL);
  RETURN (SPNR . 1);
END;

;END;
