 /*
  * Khoros: $Id: xprism.h,v 1.2 1991/07/15 05:48:59 khoros Exp $
  */

 /*
  * $Log: xprism.h,v $
 * Revision 1.2  1991/07/15  05:48:59  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 *
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1990 by UNM */

#ifndef _xprism_h_
#define _xprism_h_

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: xprism.h					 <<<<
   >>>>                                                          <<<<
   >>>>      contains:  all #defines, structures, and global     <<<<
   >>>>                 definitions used by the xvplot library,  <<<<
   >>>>			xprism2 and xprism3			 <<<<
   >>>>                                                          <<<<
   >>>>      date: 5/25/88                                       <<<<
   >>>>                                                          <<<<
   >>>>      written by:  Danielle Argiro, Mark Young            <<<<
   >>>>                                                          <<<<
   >>>>      modifications:                                      <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "xvforms.h"
#include "xvutils.h"  
#include "xvgraphics.h"	
#include "xvoverlay.h"	
#include "machdefs.h"	

/*****************************************************************************
*
*              XPrism  Plot Structure
*
*****************************************************************************/

typedef struct  _XPlot
{
	int	id;	    /* each plot has its own id number */
	int	active;	    /* if this plot is active or not   */
	int	plot_type;  /* how is the plot currently displayed */

        long	data_type,  /* storage type of data points        */
		data_format, /* format of data, XY, Y, XYZ, Z */
		input_type, /* indicates origination of plot information  */
		size,       /* the number of individual points in a plot  */
		row_size;   /* in a 2-D plot: invalid		      	  */
			    /* in a 3-D plot: the number of points 	  */
			    /*		 in each line segment             */
	
	char	*filename;  /* if originated as a function, the file input    */
	char	*function;  /* if originated as a function, function string   */
	char	*xrange;    /* if originated as a function, X domain          */
	char	*yrange;    /* if originated as a function, Y range           */
	char	*color;	    /* color plot is currently displayed in	      */
	char    *legend_str;/* string for legend			      */

	int	marker;	     /* type of marker to be displayed                */
	int	line_type;   /* type of line to plot with                     */
	int 	colorindex;  /* the index into Colors array of the color for  */
			     /*	this plot                                     */
              /* only x and y will be used, eventhough z is not used it is
               * cleaner to do it this way
               */
        Coord   begin_point;	     /* subsample begin point */
        Coord   end_point;  	     /* subsample number of points */
	Coord   step_size;           /* subsample step size */ 

	int	machine_type_index;  /* if raw data contains the machine type,
				      * else set to -1 
				      */

	int	band;	     /* the band number of the viff file, or -1 if
			        not a VIFF file */

	int 	cmplx;	     /* the complex image type to plot, if the input
			        image is of type COMPLEX */

	int     contour_num; /* number of contours to be drawn for this plot  */
	Real    *levels;     /* contour levels to be drawn for this plot      */
	float   contour_offset;/* contour offset for this plot                */

        Coord	WCmax,       /* maximum and minimum world coordinate          */
		WCmin;       /* values for this plot                          */
			     /* in a 2D plot: zmin & zmax invalid             */
	Coord	*points;     /* (x,y,z) points describing plot                */

	struct _XPlot *next; /* and a pointer to the next plot in the window */

} XPlot;


/*****************************************************************************
*
*              XPrism  Graphics Window Structure
*
*****************************************************************************/

/*  A global XPGraphicsWindow structure allows us to create multiple plots 
    within a window. The XPGraphicsWindow structure contains all the 
    information about its graphics window, as well as a linked list of
    XPlot structures representing all the plots in the graphics window.
    It also provides other essential flags needed for the proper 
    maintenence of the window.
*/


/***  VPGraphicsWindow structure    ***/

struct  VPGraphicsWindow
{
     /* The main, opaque workspace window, for display of 
        plots, axes, and a buffer region (white space)  */

        int    id;		/* the identifier for this gwin */
	Widget xprism_widget;  /* the background widget for the workspace */
        Window workspace;       /* the workspace                */

        /* Various other pieces of necessary information */

        int    plot_type;  /* default plot_type for plots in the workspace */
        int    plotnum;    /* number of plots associated with workspace  */
        int    disp_plotnum; /* number of plots displayed in workspace  */

        XPlot  *plist;  /* header of list of plot structures         */

	Coord  WCmax, WCmin;
	Coord  major_intv; /* tic intv for x,y,z */
	Coord  num_tics; /* number of tics for each axis */

        Pixmap pixmap; /* used for saving window info to refresh      */
};


/*****************************************************************************
*
*              XPrism  Graphics Window Attributes Structure
*
*****************************************************************************/

/*
 *	The Graphics Window Attributes structure holds information that
 *	is relevant to the physical appearance of the gwin.  There is a
 *	single global gwin_attributes structure, just as there is a single
 *	global gwin.  However, while the global gwin structure may be set
 *	to NULL when the graphics workspace is deleted, and re-initialized
 *	when the next plot is input, the gwin_attributes structure remains
 *	the same.  Thus, we can display the old titles on the new plot, 
 *	retain the same fonts, colors, etc.  Also makes parameter passing
 *	neater to create_new_gwin & init_gwin.  Also makes the contrast
 *	between command-line startup and form startup more clean.
 */
#ifndef Coord_INT
typedef  struct
         {
                   int  x, y, z;
         }  Coord_INT;
#endif

#define MAX_COLORS 12

typedef struct _VPGraphicsWindowAttributes
{
	char   *title,          /* optional title of graph      */
               *xaxis,          /* optional titles of axes      */
               *yaxis,
               *zaxis;

        Coord  power_ten;       /* this is the times ten value the 
                                   labels on the axis have been 
                                   rescaled to */

        char   *font[6];        /* the current font for the title, xaxis,
                                                    yaxis, zaxis, numbers */
	int  current_colors[MAX_COLORS];  /* elements of current_colors 
				  	    will index into the global Colors 
					    array to give current colors of 
					    titles and axes */

	int    clear_labels;   /* true or false - should labels be shown? */
	int    draw_grid;   /* true or false - should a grid be displayed?   */
	int    draw_box; /* true or false - should box type axes be displayed?*/
	int    draw_legend; /* true or false - should a legend be displayed? */
        int    draw_axes;   /* true or false - should the axes be displayed? */
        int    draw_numlabels;   /* true or false - should the axes labels
                                  * be displayed? */
        int    auto_scale;   /* true or false - should we auto scale */

        int    rescale_relabel;   /* if = RESCALE, then rescale axes,
                                   * if = RELABEL, then just allow the
                                   * user to change the labels
                                   */

	int	machine_type_index;      /* the current machine type for
				          * reading raw data 
				          */

	Coord  scale;      /* type of scale for x, y, z */
	Coord  minor_tics; /* minor number of tics for x,y,z */

         /* The disp_label variables are used for labeling purposes
          * on the axes only. The disp_scale variables will contain
          * the actual window values for displaying the data.
          */

	Coord disp_label_min;
	Coord disp_label_max;
	Coord disp_label_major_intv; /* tic intv for x,y,z */
	Coord disp_label_num_tics; 

	Coord disp_scale_min;
	Coord disp_scale_max;
	Coord disp_scale_major_intv; /* tic intv for x,y,z */
	Coord disp_scale_num_tics; 

	Real alpha; 	/* the alpha view for the plot perspective in xprism3 */
	Real theta; 	/* the theta view for the plot perspective in xprism3 */
	Real eye_dist; 	/* the eye_dist for the plot perspective in xprism3 */
	Real view_dist;	/* the view_dist for the plot perspective in prism3 */

}VPGraphicsWindowAttributes;

/**************************************************************************
*
*	Global Variables for xprism
*
**************************************************************************/



/* 
 * allocation routines
 */
char *malloc();    
char *calloc();

/*
 *  a single global gwin
 */
struct VPGraphicsWindow *gwin, *create_new_gwin();

/*
 *  a single global gwin attributes structure
 */
VPGraphicsWindowAttributes *gwin_attr;


/*
 *  coordinate arrays defining the axes diagram used
 *  in changing the perspective
 */
Coord arrow_x[6], arrow_y[6], arrow_z[6];

/*
 *   global input & output directories 
 */
char *global_indir;
char *global_outdir;

/*
 *  variables particular to X11R3 version
 */
int	screen;
Window	rootwindow,
	window;
Display *display;
Screen  *def_scr;

/*
 *  global flag (true if on monochrome display)
 */
int  mono_display;

/*
 *  global flag (tells type of output display)
 */
#define xpX11        1
#define xpPostscript 2
#define xpHPGL       3
#define xpImpress    4
#define xpLN03       5
int xp_device;

/*
 *  widget for the change-perspective selection bar
 */
Widget *persp_toplevel;

/*
 *  graphics contexts and misc. color information.
 */
unsigned long sel_bar_colors[15]; /* colors for selection bar*/

XColor   fg, bg;		  /* general case foreground & background */
XColor   contour_colors[128],     /* colors for contour plots */
	      Colors[30];	  /* colors for plots, axes, text */

int	   color_num;		  /* number of colors successfully allocated */

typedef struct _xprism_rgb{
	unsigned short red;
	unsigned short green;
	unsigned short blue;
} xprism_rgb;

xprism_rgb rgb_values[30];

GC	   gc_draw,	/* graphics context structures used for plotting */
	   gc_fill;

/*
 *   Overlay display list
 */
XObject *obj_list;
Widget	canvas;

/***************************************************************************
 *
 * 		#Defines Used in Plot Structures    
 *
 ***************************************************************************/


/************************************
 *   General #Defines used in Xprism
 *************************************/

#undef true
#define	true	1

#undef false
#define	false	0


/*
 *	#Defines for types of files that can be used as input to Xprism
 *	plot->plot_type can be one of:
 */
#define ERROR     -1
#define UNKNOWN    0
#define XVIFF_IMPL 1
#define XVIFF_EXP  2
#define ASCII_FUN  3
#define ASCII_DATA 4
#define KEYB_FUN   5
#define RAW_DATA   6

#define ASCII_COMMENT    10

/*
 *	#Defines for Khoros Image files: either they are or they're not
 */
#define NOT_XVIFF  0
#define XVIFF      1

/*	
 *	#Defines for toggles on the Xprism Form  
 */
#define INPUT_FILE 1 
#define INPUT_FUNC 2 

/*
 *	#Defines for "Output Type" toggle on the Output Pane 
 */
#define EXPL_OUT   1
#define IMPL_OUT   2
#define FLOAT_OUT  3
#define ASCII_OUT  4
#define DUMP_OUT   5
#define PRINT_OUT  6


/*
 *	#Defines for types of transforms 
 */
#define ROTATE	   1
#define SCALE	   2
#define TRANSLATE  3


/*
 *  	#Defines for window_type and plot_type
 */
/*
 *  Plot type used by xprism3
 */
#define UNDEFINED	0
#define PLOT_3D		1
#define PLOT_MESH	2
#define PLOT_SCATTER	3
#define PLOT_CONTOUR_3D	4
#define PLOT_CONTOUR_2D	5
#define PLOT_IMPULSE	6
#define PLOT_SURFACE	7
#define PLOT_HORIZON	8
#define PLOT_COLORMESH  9
#define PLOT_3D_MESH    10
#define PLOT_3D_BEZIER  11
#define PLOT_SURFACE_BEZIER  12
#define PLOT_RENDERED_BEZIER 13


#define PLOT_TYPE_3D(plot)  (((plot) >= PLOT_3D) && ((plot) <= \
							PLOT_RENDERED_BEZIER))

/*
 *  Plot type used by xprism2
 */
#define PLOT_2D		20
#define PLOT_DISCRETE	21
#define PLOT_HISTOGRAM	22
#define PLOT_POLYMARKER	23
#define PLOT_LINEMARKER	24

#define PLOT_TYPE_2D(plot)  (((plot) >= PLOT_2D) && ((plot) <= PLOT_LINEMARKER))

/*
 *  Line Type used by xprism2 and xprism3
 */

#define SOLID 		1
#define DOTTED 		2
#define DOT_DASHED 	3
#define SHORT_DASHED 	4
#define LONG_DASHED 	5
#define ODD_DASHED 	6

/*
 *  Defines for appending proper strings onto display lists for list widgets
 */

#define APPEND_NONE  		1
#define APPEND_COLOR  		2
#define APPEND_PLOT_TYPE  	3
#define APPEND_MARKER_TYPE	4
#define APPEND_LINE_TYPE	5


/*
 *  #Defines for indices into gwin->current_colors array
 */
#define  TITLE_COLOR	0
#define XTITLE_COLOR	1
#define YTITLE_COLOR	2
#define ZTITLE_COLOR	3
#define XAXIS_COLOR	4
#define YAXIS_COLOR	5
#define ZAXIS_COLOR	6
#define XNUMS_COLOR	7
#define YNUMS_COLOR	8
#define ZNUMS_COLOR	9
#define GRID_COLOR	10
#define LEGEND_COLOR	11

/*
 *   #Defines for types of labels and axes
 */
#define TITLE	   0
#define XAXIS	   1
#define YAXIS	   2
#define ZAXIS	   3
#define NUMBERS	   4
#define LEGEND	   5

/*
 *   #Defines for calls to query forms, prompt forms
 */
#define MaxPrompt 25      /* max number of prompt & answer strings */
#define MaxRespLength 10  /* max size of the text widget & answer string */
#define MaxPromptLength 80  /* max size of the prompt string */

/*   defines for the data type is it XY pairs, XYZ triples, Y only, Z only */
#define	XY_PAIRS 1
#define	XYZ_TRIPLES 2
#define Y_ONLY 3
#define Z_ONLY 4
#define NO_FORMAT -1

/*   defines for whether we are rescaling the axes or relabeling the axes */
#define RESCALE 1
#define RELABEL 2

/* define the number of fonts */
#define NUMBER_FONTS 7

/* define the number of markers */
#define NUMBER_MARKERS 15

/* used by axes for the fonts */
#define         FONTNAME_R2     "fixed"
#define         FONTNAME_R3     "-adobe-times-bold-r-normal--14*"


/*
 *   General #defines for miscellaneous use 
 */

#define MAX_STRLEN 512

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define FLUSH()  \
           { \
              (void)fflush(stderr); \
              sleep((unsigned) 1); \
           }


/******************   function definitions *******************/


/*
 *	definitions of input functions
 */

XPlot	*getplot(), 		/* get a plot from Khoros File */
	*get_image(),		/* get image from Khoros File */
	*get_file_dps(),	/* get data points from a file */
	*get_a_plot();		/* allow user to select a plot */

char    *line_type_string(), 	/* returns line type in string form */
	*marker_type_string(), 	/* returns marker type in string form */
	*plot_type_string(); 	/* returns plot type in string form */
/*
 *	definitions of callbacks for widgets appearing  
 *	on the selection bar used for changing the perspective
 */

 void    camera_in_cb(), 	camera_out_cb(),
         zoom_in_cb(), 		zoom_out_cb(),
         rotate_x_cw_cb(), 	rotate_x_ccw_cb(),
         rotate_z_cw_cb(), 	rotate_z_ccw_cb(),
         reset_relative_cb(),   reset_absolute_cb(),
         use_cb(), 		exit_cb();


 /* definitions for colors for labels and contours */

#define PLOT_COLORNUM    24
#define CONTOUR_COLORNUM 64

static char *colornames[] =
{ 
          "White",	  "MediumSpringGreen",	"Yellow",  "Cyan",
          "MediumOrchid", "Magenta",		"Orange",  "Wheat",
          "LimeGreen",    "Turquoise",		"Pink",    "LightGrey",
          "Plum",	  "ForestGreen",	"Salmon",  "Thistle",
          "Violet",	  "OrangeRed",		"Red",     "SeaGreen",
          "Blue",	  "Goldenrod",		"Coral",   "Sienna"
};

static char *font_names[] =
{

"DoubleRoman", "SimplexRoman", "Symbols",
"TimesItalics", "ComplexItalics", "ComplexRoman", "TimesRoman"
};

#endif /* _xprism_h_ */
/* Don't add after this line */
