 /*
  * Khoros: $Id: cnd_info.c,v 1.2 1991/07/15 05:59:35 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cnd_info.c,v 1.2 1991/07/15 05:59:35 khoros Exp $";
#endif

 /*
  * $Log: cnd_info.c,v $
 * Revision 1.2  1991/07/15  05:59:35  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "conductor.h"  


/************************************************************
*
*  Routine Name: cnd_gen_get_forminfo
*
*      Purpose:  This routine creates a file called "form_info.c" 
*		 in the local directory, and automatically generates in
*		 this file the routine "_xvf_get_*",  to take the
*		 database and pull information out of it into the
*		 "forminfo" structure defined in "form_info.h"
*		 (automatically created by cnd_gen_form_struct).
*
*        Input:  database : internal database
*		 extract_flag: tells whether or not to call "xvf_get_XXX"
*			       routines, where XXX is the name of the 
*			       subform variables.
*
*	Output:  the "form_info.c" file to be used by the application program
*                returns TRUE if the structures were created successfully,
*                        FALSE otherwise
*
*       Called by: lconductor()
*
*       COMMENTS:  Note that this routine will *only* be called by lconductor
*                  if cnd_gen_form_struct (which creates the FormInfo struct)
*                  returns successfully.  This implies that all the detailed
*                  error checking of the database that is done in
*                  cnd_gen_form_struct is not necessary here, and need not be
*                  repeated.  Any errors in the database will be caught by
*                  cnd_gen_form_struct, and conductor will not get to this 
*		   routine.
*
*   Written By:  Danielle Argiro 
*
*************************************************************/


int cnd_gen_get_forminfo(database, extract_flag, line_num)

char **database;
int  extract_flag;
int  line_num;
{
	int  index, flag=0;
	Line_Info line_info;
	char *form_var, *subform_var, *buffer, *fullpath; 
	char temp[512], resp;
 	FILE *fid, *tmpfile;
	int  master_form;
	time_t clock;
	

        /*
	 *  first of all, if 'form_info.c' exists, see if they want to over-
	 *  write it.  If not, return immediately.
	 */
        fullpath = vfullpath("form_info.c", NULL, NULL);
        if (!conductor->f)
        {
           if (tmpfile = fopen(fullpath, "r"))
           {
              fprintf(stderr, "\nOverwrite file '%s'?  [y/n]: ", fullpath);
              fgets(temp, MaxLength, stdin);
              sscanf(temp, "%c", &resp);
              if ((resp != 'y') && (resp != 'Y')) 
	          return(true);
           }
	}

	/* 
	 * create & open the "form_info.c" file which will have the 
	 * "form_info" structure definition 
	 */
	if ((fid = fopen("form_info", "w"))== NULL)
	{
		fprintf(stderr, "\ncnd_gen_get_forminfo:\n");
		fprintf(stderr, "  Could not create tmp file 'form_info'\n");
		return(false);
	}

	/* begin file with RCS header */
	fprintf(fid, " /*\n  * Khoros: %cId%c\n  */\n\n", '$', '$');
        fprintf(fid, "#if !defined(lint) && !defined(SABER)\n");
        fprintf(fid, "static char rcsid[] = \"Khoros: %cId%c\";\n", '$','$');
        fprintf(fid, "#endif\n\n");
        fprintf(fid, " /*\n  * %cLog%c\n  */\n\n", '$','$');

	/* follow RCS header with UNM copyright */
        fprintf(fid, "%s", cp_top); 
        fprintf(fid, "%s", cp_line); 
        fprintf(fid, "%s", cp_right); 
        fprintf(fid, "%s", cp_line); 
        fprintf(fid, "%s", cp_bottom); 
		
	/* write to file the necessary #includes */
	fprintf(fid,"%s", include1);
	fprintf(fid,"%s", include2);
	fprintf(fid,"%s\n\n", include4);


	index = 0;
	master_form = false;

	/* read the StartForm definition & get FormInfo variable name */
	xvf_clear_line_info(&line_info);
       	xvf_parse_startform_line(database[index], &line_info);
        if (line_info.variable == NULL)
        {
	    fprintf(stderr, "\ncnd_gen_get_forminfo:\n");
	    fprintf(stderr, "Form does not have a variable name \n");
	    fprintf(stderr, "associated with it. Cannot generate \n");
	    fprintf(stderr, "correct code without this string.\n");
	    return(false);
        }
       	form_var = xvf_strcpy(line_info.variable);
	index++;
        
	/* write the header into the "form_info.h" file */
        fprintf(fid, "%s", filehdr_top);
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s form_info.c\n", filehdr_file);
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s code to extract values\n", filehdr_desc);
        fprintf(fid, " >>>>                     from the graphical user interface \n");
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s automatically generated by conductor\n", filehdr_auth);
        fprintf(fid, " >>>>\n");

        clock = (time_t) time(NULL);
        sprintf(temp, "%s %s\n", filehdr_date, ctime(&clock));
        temp[xvf_strlen(temp)-2] = '\0';
        fprintf(fid, "%s\n", temp);
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s\n\n\n", filehdr_bottom);

        
       	/* start out generated program with a header */
       	fprintf(fid, "%s%s", top_bdr, single_star); 
       	fprintf(fid, "%s%s\n", name, form_var); 
	fprintf(fid, "%s", single_star);
       	fprintf(fid, "%s", purpose1);
	fprintf(fid, "%s'%s'\n", purpose2, form_var); 
	fprintf(fid, "%s%s", purpose3, purpose4);
       	fprintf(fid, "%s", single_star); 
	fprintf(fid, "%s%s", input1, input2f); 
	fprintf(fid, "%s'%s'\n", purpose2, form_var); 
	fprintf(fid, "%s", single_star); 
       	fprintf(fid, "%s %s\n", output, form_var);
	fprintf(fid, "%s%s%s", single_star, called_by1, single_star);
       	fprintf(fid, "%s%s%s\n\n", author, single_star, bottom_bdr); 
       
       	/* write out program name & argument list */

       	fprintf(fid, "_xvf_get_%s(formptr, forminfo)\n\n", form_var);
       	fprintf(fid, "xvf_form *formptr;\n");
       	fprintf(fid, "%s *forminfo;", form_var); fprintf(fid, "\n");
       
       	/* write out beginning bracket & declarations */
       	fprintf(fid, "{\n"); 
       	fprintf(fid, "\t%s", declar1);
       	fprintf(fid, "\t%s", declar2);
       	fprintf(fid, "\t%s", declar3);
       
       	/* 
       	 * skip past definitions of guide pane & guide buttons;
       	 * the only thing we are interested in here is any subform
	 * action buttons that may have been selected, and terminated
	 * the run of xvforms.  look for this case.
       	 */

	fprintf(fid, "\n\txvf_clear_line_info(&line_info);\n");
	fprintf(fid, "\n\tdatabase = formptr->db;\n\n");

	fprintf(fid, "\t/***** getting '%s' Form ", form_var);
        fprintf(fid, "Information structure *****/\n\n");

	xvf_clear_line_info(&line_info);
	do
       	{

	    flag = xvf_get_line_type(database[index]);

	    
            switch(flag)
            {
		case StartMaster:
                     index++;
                     master_form = true;
                     break;
	
		case SubFormButton:
		case PsuedoSubForm:
		case StartSubMenu:
                case HelpSel:
                case Blank:
                     index++;
                     break;

	        case MasterAction:
		     xvf_parse_master_action_line(database[index], &line_info);
		     fprintf(fid, "\n\tindex = %d;\n\n", index);
                     fprintf(fid, "\t%s", parsen);
       		     fprintf(fid, "\t%s->%s = line_info.selected;\n", 
       			     forminfo, line_info.variable);
       		     index++;
		     break;
			
	        case WorkWidget:
		     xvf_parse_workspace_line(database[index], &line_info);
		     fprintf(fid, "\n\tindex = %d;\n\n", index);
                     fprintf(fid, "\t%s", parsew);
       		     fprintf(fid, "\t%s->%s = line_info.workspace;\n", 
       			     forminfo, line_info.variable);
       		     index++;
		     break;
			
		case QuitForm:
       		     fprintf(fid, "\n\tindex = %d;\n\n", index);
       		     fprintf(fid, "\t%s", parseQ);
		     xvf_parse_quit_line(database[index], &line_info);
       		     fprintf(fid, "\t%s->quit = line_info.selected;\n", 
       			     forminfo);
		     index++;
		     break;

		case End:
		     if (master_form == TRUE) /* skip over it */
                     {
                        index++;
                        flag = xvf_get_line_type(database[index]);
                     }
                     break;

		case StartSubForm:

		     xvf_parse_startsubform_line(database[index], &line_info);
                     subform_var = xvf_strcpy(line_info.variable);
		     fprintf(fid, "\n\tindex = %d;\n\n",index);
       		     fprintf(fid, "\t%s", parseM);
		     fprintf(fid, "\tforminfo->%s%s", subform_var, selected);
	
		     if (extract_flag == XVF_GET_ALL_LEVELS)
		     {
		        fprintf(fid, "\t_xvf_get_%s(formptr, forminfo->%s);\n",
				subform_var, subform_var);
		     }
                     index++;
                     if (!(cnd_gen_get_subforminfo(database,&index,
                	                            form_var, subform_var,
						    extract_flag)))
                          return(false);

                     flag = xvf_get_line_type(database[index]);
                     break;

	    } /* end switch */ 

	
	} while (flag != End);  /* end do-while */

       	fprintf(fid, "\n}\n\n");

       	fprintf(stderr, "\ncnd_gen_get_forminfo:\n");
        fprintf(stderr, "Done with generating extraction code:\n");
        fprintf(stderr, "routine '_xvf_get_%s' now in ", form_var);
	fprintf(stderr, "'form_info.c'\n");
       
        fclose(fid);

	buffer = xvf_strcpy("cat form_info subform_info pane_info>form_info.c");
	system(buffer);
	unlink("./form_info");
	unlink("./subform_info");
	unlink("./pane_info");
        return(true);

}  /* end  cnd_gen_get_forminfo */
        


/************************************************************
*
*  Routine Name: cnd_gen_get_subforminfo
*
*      Purpose:  generates the code to get the values from each pane 
*		 from the database & put them into the appropriate 
*		 Form Info structure
*
*        Input:  database    - the internal database struct
*                index       - current index into the database
*                form_var    - name of the form variable
*                subform_var - name of the subform variable
*		 extract_flag - tells whether or not to call "xvf_get_XXX"
*				routines, where XXX is the name of the 
*				pane variables.
*
*       Output:  appropriate subform initialization code
*                in the "form_init.c" file
*
*   Written By:  Danielle Argiro
*
*
*************************************************************/


int cnd_gen_get_subforminfo(database, index, form_var, 
			     subform_var, extract_flag)

char **database;
int  *index;
char *form_var;
char *subform_var;
int  extract_flag;
{
	FILE *fid;
        Line_Info line_info;
	int       flag;
        int  guide_pane = 0, panecount = 0;
        char *pane_var;

	/* 
	 * create & open the "subform_info" file which will have the 
	 * "form_info" structure definition 
	 */
	if ((fid = fopen("subform_info", "a"))== NULL)
	{
		fprintf(stderr, "\ncnd_gen_get_subforminfo:\n");
		fprintf(stderr, "  Could not create tmp file 'subform_info'\n");
		return(false);
	}

        /* start out generated program with a header */
        fprintf(fid, "%s%s", top_bdr, single_star); 
        fprintf(fid, "%s%s\n", name, subform_var); 
	fprintf(fid, "%s", single_star);
        fprintf(fid, "%s", purpose1);
	fprintf(fid, "%s'%s_%s'\n", purpose2, form_var, subform_var); 
	fprintf(fid, "%s%s", purpose3, purpose4);
        fprintf(fid, "%s", single_star); 
	fprintf(fid, "%s%s", input1, input2s); 
	fprintf(fid, "%s'%s_%s'\n", purpose2,form_var,subform_var); 
	fprintf(fid, "%s", single_star); 
        fprintf(fid, "%s '%s_%s'\n", output, form_var, subform_var);
     	if (extract_flag != XVF_GET_ALL_LEVELS)
	    fprintf(fid, "%s%s\n%s", single_star, called_by1, single_star);
	else 
	    fprintf(fid, "%s%s%s", single_star, called_by2, single_star);
        fprintf(fid, "%s%s%s\n\n", author, single_star, bottom_bdr); 
        
       	/* write out program name & argument list */

       	fprintf(fid, "_xvf_get_%s(formptr, subforminfo)\n\n", subform_var);
       	fprintf(fid, "xvf_form *formptr;\n");
       	fprintf(fid, "%s_%s *subforminfo;", form_var, subform_var); 
	fprintf(fid, "\n");
       
       	/* write out beginning bracket & declarations */
       	fprintf(fid, "{\n"); 
       	fprintf(fid, "\t%s", declar1);
       	fprintf(fid, "\t%s", declar2);
       	fprintf(fid, "\t%s", declar3);
        

	fprintf(fid, "\n\txvf_clear_line_info(&line_info);\n");
	fprintf(fid, "\n\tdatabase = formptr->db;\n");
	fprintf(fid, "\tindex = %d;\n\n", *index);

        xvf_clear_line_info(&line_info);

	fprintf(fid, "\n\t/*** extracting '%s->%s'\n", form_var, subform_var);
        fprintf(fid, " \t   Subform Information structure ***/\n\n");

        do
	{
	    flag = xvf_get_line_type(database[*index]);

            switch(flag)
            {
		case StartGuide:
                     (*index)++;
                     guide_pane = true;
                     break;

                case HelpSel:
                     (*index)++;
                     break;

		case GuideButton:
                     (*index)++;
                     break;

		case SubformAction:
        	     fprintf(fid, "\n\tindex = %d;\n\n", *index);
        	     fprintf(fid, "\t%s", parsem);
                     xvf_parse_subform_action_line(database[*index], &line_info);
                     fprintf(fid, "\tsubforminfo->%s = line_info.selected;\n",
                             line_info.variable);
        	     (*index)++;
		     break;

		case WorkWidget:
        	     fprintf(fid, "\n\tindex = %d;\n\n", *index);
        	     fprintf(fid, "\t%s", parsew);
                     xvf_parse_workspace_line(database[*index], &line_info);
                     fprintf(fid, "\tsubforminfo->%s = line_info.workspace;\n",
                             line_info.variable);
        	     (*index)++;
		     break;

		case QuitForm:
        	     fprintf(fid, "\n\tindex = %d;\n\n", *index);
		     fprintf(fid, "\t%s", parseQ);
		     xvf_parse_quit_line(database[*index], &line_info);
                     fprintf(fid, "\tsubforminfo->quit = line_info.selected;\n",
                             line_info.variable);
        	     (*index)++;
		     break;

		case End:
                     if (guide_pane == TRUE) /* skip over it */
                     {
                         (*index)++;
                         flag = xvf_get_line_type(database[*index]);
                     }
                     break;

		case StartPane:
        	     xvf_parse_startpane_line(database[*index], &line_info);
        	     pane_var = xvf_strcpy(line_info.variable);
        	     fprintf(fid, "\n\tindex = %d;\n", *index);
        	     fprintf(fid, "\t%s", parseP);
        	     fprintf(fid, "\tsubforminfo->%s%s", pane_var, selected);
		     panecount++;

		     if ((extract_flag == XVF_GET_ALL_LEVELS) ||
			 (extract_flag == XVF_GET_SUBFORMS))
		     {
		        fprintf(fid, "\t_xvf_get_%s(formptr, subforminfo->%s);\n",
				pane_var, pane_var);
		     }
         	     (*index)++;

		     if (!(cnd_gen_get_paneinfo(database, index,
                                                 form_var, subform_var,
                                                 pane_var, extract_flag)))
                          return(false);

        	     flag = xvf_get_line_type(database[*index]);

		} /* end switch */

	} while (flag != End);

	(*index)++;
        fprintf(fid, "\n}\n\n\n\n");
	fclose(fid);
	return(true);


} /* end cnd_gen_get_subforminfo */
        		
/************************************************************
*
*  Routine Name: cnd_gen_get_paneinfo
*
*      Purpose:  generates the code to get the values from each pane 
*		 from the database & put them into the appropriate 
*		 Form Info structure
*
*        Input:  database    - the internal database struct
*                index       - current index into the database
*                form_var    - name of the form variable
*                subform_var - name of the subform variable
*                pane_var    - name of the pane variable
*
*
*       Output:  appropriate code to get values of pane parameters
*                in the "form_info.c" file
*
*   Written By:  Danielle Argiro
*
*
*************************************************************/

int cnd_gen_get_paneinfo(database, index, form_var, 
			  subform_var, pane_var, extract_flag)
char **database;
int  *index;
char *form_var;
char *subform_var;
char *pane_var;
int  extract_flag;

{
	FILE	  *fid;
        Line_Info line_info;
	int       flag, mutual_exclusion = false;
	static char *end = "\t}\n";

	/* 
	 * create & open the "pane_info" file which will have the 
	 * routines which get "pane_info" information 
	 */
	if ((fid = fopen("pane_info", "a"))== NULL)
	{
		fprintf(stderr, "\ncnd_gen_get_paneinfo:\n");
		fprintf(stderr, "  Could not create tmp file 'pane_info'\n");
		return(false);
	}

        /* start out generated program with a header */
        fprintf(fid, "%s%s", top_bdr, single_star); 
        fprintf(fid, "%s%s\n", name, pane_var); 
	fprintf(fid, "%s", single_star);
        fprintf(fid, "%s", purpose1);
	fprintf(fid, "%s'%s_%s'\n", purpose2, subform_var, pane_var); 
	fprintf(fid, "%s%s", purpose3, purpose4);
        fprintf(fid, "%s", single_star); 
	fprintf(fid, "%s%s", input1, input2p); 
	fprintf(fid, "%s'%s_%s'\n", purpose2, subform_var, pane_var); 
	fprintf(fid, "%s", single_star); 
        fprintf(fid, "%s '%s_%s'\n", output, subform_var, pane_var);
     	if (extract_flag != XVF_GET_PANES)
	    fprintf(fid, "%s%s%s\n%s\n", single_star, called_by2, 
				       subform_var, single_star);
	else 
	    fprintf(fid, "%s%s%s", single_star, called_by1, single_star);
        fprintf(fid, "%s%s%s\n\n", author, single_star, bottom_bdr); 


       	/* write out program name & argument list */

       	fprintf(fid, "_xvf_get_%s(formptr, paneinfo)\n\n", pane_var);
       	fprintf(fid, "xvf_form *formptr;\n");
       	fprintf(fid, "%s_%s *paneinfo;", subform_var, pane_var); 
	fprintf(fid, "\n");
       
       	/* write out beginning bracket & declarations */
       	fprintf(fid, "{\n"); 
       	fprintf(fid, "\t%s", declar1);
       	fprintf(fid, "\t%s", declar2);
       	fprintf(fid, "\t%s", declar3);
        

	fprintf(fid, "\n\txvf_clear_line_info(&line_info);\n");
	fprintf(fid, "\n\tdatabase = formptr->db;\n");
	fprintf(fid, "\tindex = %d;\n\n", *index);

	fprintf(fid, "\n\t/* extracting '%s->%s->%s'\n",form_var, 
			subform_var, pane_var); 
	fprintf(fid, " \t   Pane Information structure */\n\n");

	xvf_clear_line_info(&line_info);
	do
       	{
	      flag = xvf_get_line_type(database[*index]);
       	      switch(flag) {
        
	      case InputFile:
        	   fprintf(fid, "\t%s", parseI);
        	   xvf_parse_input_line(database[*index], &line_info);
		   fprintf(fid, "\t%s", fil_neq_null);
        	   fprintf(fid, "\t   paneinfo->%s = \n", line_info.variable);
                   fprintf(fid, "\t\txvf_strcpy(line_info.filename);\n"); 
		   fprintf(fid,"%s", end);
		   fprintf(fid, "\telse  paneinfo->%s = NULL;\n\n",
			         line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
                   else if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
        	   fprintf(fid, "\t%s", incr_index);
                   (*index)++;
                   flag = xvf_get_line_type(database[*index]);
        	   break;
       
       	      case OutputFile:
       		   fprintf(fid, "\t%s", parseO);
       		   xvf_parse_output_line(database[*index], &line_info);
		   fprintf(fid, "\t%s\n", fil_neq_null);
       		   fprintf(fid, "\t   paneinfo->%s = \n", line_info.variable);
		   fprintf(fid, "\t\txvf_strcpy(line_info.filename);\n"); 
		   fprintf(fid,"%s", end);
		   fprintf(fid, "\telse  paneinfo->%s = NULL;\n\n",
			        line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       		   (*index)++;
       		   flag = xvf_get_line_type(database[*index]);
       		   break;
       
      	      case IntegerOpt:
       		   fprintf(fid, "\t%s", parsei);
       		   xvf_parse_int_line(database[*index], &line_info);
       		   fprintf(fid, "\tpaneinfo->%s = line_info.int_val;\n", 
       			        line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
       
       	      case FloatOpt:
       		   fprintf(fid, "\t%s", parsef);
       		   xvf_parse_float_line(database[*index], &line_info);
       		   fprintf(fid, "\tpaneinfo->%s = line_info.float_val;\n", 
				line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
      
      		
       	      case StringOpt:
       		   fprintf(fid, "\t%s", parses);
       		   xvf_parse_string_line(database[*index], &line_info);
		   fprintf(fid, "\t%s", str_neq_null);
       		   fprintf(fid, "\t   paneinfo->%s = \n",
				line_info.variable);
 		   fprintf(fid, "\t\txvf_strcpy(line_info.string_val);\n");
		   fprintf(fid,"%s", end);
		   fprintf(fid, "\telse  paneinfo->%s = NULL;\n\n",
				line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
       
       	      case LogicOpt:
       		   fprintf(fid, "\t%s", parsel);
       		   xvf_parse_logic_line(database[*index], &line_info);
       		   fprintf(fid, "\tpaneinfo->%s = line_info.logical_val;\n", 
				line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
       
       	      case Cycle:
       		   fprintf(fid, "\t%s", parsec);
       		   xvf_parse_cycle_line(database[*index], &line_info);
       		   fprintf(fid, "\tpaneinfo->%s = line_info.cycle_val;\n", 
				line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
       
       	      case List:
       		   fprintf(fid, "\t%s", parsex);
       		   xvf_parse_list_line(database[*index], &line_info);
       		   fprintf(fid, "\tpaneinfo->%s = xvf_strcpy(line_info.val_labels[line_info.list_val-1]);\n", 
				line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
       
	      case MutExcl:
		   mutual_exclusion = true;
		   fprintf(fid, "\tindex = %d;\n", *index+1);
		   (*index)++;
		   break;

	      case Toggle:
       		   fprintf(fid, "\t%s", parseT);
		   xvf_parse_toggle_line(database[*index], &line_info);
		   fprintf(fid,"\tpaneinfo->%s_val = line_info.toggle_val;\n",
				line_info.variable);
                   if (line_info.live == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.selected;\n",
			       line_info.variable);
                   if (line_info.optional == true)
                      fprintf(fid, 
			      "\tpaneinfo->%s_selected = line_info.opt_sel;\n",
			       line_info.variable);
		   fprintf(fid, "\t%s", incr_index);

		   while (flag != End) 
		   {
		      (*index)++;
		      flag = xvf_get_line_type(database[*index]);
		   }
		   (*index)++;
		   flag = xvf_get_line_type(database[*index]);
		   fprintf(fid, "\tindex = %d;\n", *index);
		   break;
			
			
       	      case Routine:
       	 	   fprintf(fid, "\t%s", parseR);
       		   xvf_parse_routine_line(database[*index], &line_info);
       		   fprintf(fid,"\tpaneinfo->%s = line_info.selected;\n",
				line_info.routine);
       		   fprintf(fid, "\t%s", incr_index);
       		   (*index)++;
       		   flag = xvf_get_line_type(database[*index]);
       		   break;
       
       	      case PaneAction:
       		   fprintf(fid, "\t%s", parseA);
       		   xvf_parse_pane_action_line(database[*index], &line_info);
       		   fprintf(fid,"\tpaneinfo->%s = line_info.selected;\n",
				line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
      
       	      case WorkWidget:
       		   fprintf(fid, "\t%s", parsew);
       		   xvf_parse_workspace_line(database[*index], &line_info);
       		   fprintf(fid,"\tpaneinfo->%s = line_info.workspace;\n",
				line_info.variable);
       		   fprintf(fid, "\t%s", incr_index);
       	           (*index)++;
       	           flag = xvf_get_line_type(database[*index]);
       		   break;
      
       	      case Blank:
       	      case LibCall:
	      case HelpSel:
       		   fprintf(fid, "\t%s", incr_index);
       		   (*index)++;
       		   flag = xvf_get_line_type(database[*index]);
       		   break;
       
	      case QuitForm:
	  	   fprintf(fid, "\t%s", parseQ);
		   xvf_parse_quit_line(database[*index],&line_info);
		   fprintf(fid, "\tpaneinfo->quit = line_info.selected;\n"); 
       		   fprintf(fid, "\t%s", incr_index);
		   (*index)++;
       		   flag = xvf_get_line_type(database[*index]);
       		   break;


       	      case End:
		   if (mutual_exclusion == true)
		   { 
		      mutual_exclusion = false;
		      (*index)++;
		      flag = xvf_get_line_type(database[*index]);
		   }
       	  	   fprintf(fid, "\t%s", incr_index);
       		   break;
       
      	      default:
       		   (*index)++;
       		   flag = xvf_get_line_type(database[*index]);
       		   break;
       
       		   }  /* end switch */
       
	      if ((flag == End) && (mutual_exclusion == true))
	      {
	          mutual_exclusion = false;
	         (*index)++;
                  fprintf(fid, "\t%s", incr_index);
	          flag = xvf_get_line_type(database[*index]);
	      }
       
       
       	      } while (flag != End);
       
       		(*index)++;
		fprintf(fid, "\n\n}\n\n\n");
		fclose(fid);
		return(true);
	
}  /* cnd_gen_get_paneinfo */
        
        	
        
        
        
