 /*
  * Khoros: $Id: cnd_init.c,v 1.2 1991/07/15 05:59:43 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: cnd_init.c,v 1.2 1991/07/15 05:59:43 khoros Exp $";
#endif

 /*
  * $Log: cnd_init.c,v $
 * Revision 1.2  1991/07/15  05:59:43  khoros
 * HellPatch1
 *
  */ 

 /*----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "conductor.h"  

/************************************************************
*
*  Routine Name: cnd_gen_init_forminfo
*
*      Purpose:  This routine creates a file called "form_init.c" 
*		 in the local directory, and automatically generates in
*		 this file the routine "xvf_init_form_var",  to take the
*		 database and pull the defaults out of it into the
*		 "form_var" structure defined in "form_info.h"
*		 (automatically created by cnd_gen_form_struct).
*		 It also updates the database so that the database will
*		 now have the default values as actual values for later
*		 calls to "_xvf_get_*".
*
*        Input:  database : internal database struct
*       Output:  "form_init.c" file to be used by the application program
*		returns TRUE if the structures were created successfully,
*                        FALSE otherwise
*
*	Called by: lconductor()
*
*	COMMENTS:  Note that this routine will *only* be called by lconductor
*		   if cnd_gen_form_struct(which creates the FormInfo structure)
*		   returns successfully.  This implies that all the detailed
*		   error checking of the database that is done in 
*		   cnd_gen_form_struct is not necessary here, and need not be
*		   repeated.  Any errors in the database will be caught by
*		   cnd_gen_form_struct, and conductor will not get to this 
*		   routine.
*
*   Written By:  Danielle Argiro
*
*************************************************************/


int cnd_gen_init_forminfo(database)

char **database;
{
	int  workspace = false, index, flag=0, master_form;
	Line_Info line_info;
	char *form_var, *subform_var, *fullpath; 
	char temp[512], resp;
 	FILE *fid, *tmpfile;
	int subformbutton_num, subform_count, subformbutton_indices[100];
	int total_subform_structs = 0;
	time_t clock;

	subformbutton_indices[0] = 0;

        /*
	 *  first of all, if 'form_init.c' exists, see if they want to over-
	 *  write it.  If not, return immediately.
	 */
        fullpath = vfullpath("form_init.c", NULL, NULL);
        if (!conductor->f)
        {
           if (tmpfile = fopen(fullpath, "r"))
           {
              fprintf(stderr, "\nOverwrite file '%s'?  [y/n]: ", fullpath);
              fgets(temp, MaxLength, stdin);
              sscanf(temp, "%c", &resp);
              if ((resp != 'y') && (resp != 'Y')) 
	          return(true);
           }
        }

	/* 
	 * create & open the "form_init.c" file which will have the 
         * code to initialize the generated form information structure
	 */
	if ((fid = fopen("form_init.c", "w"))== NULL)
	{
		fprintf(stderr, "\ncnd_gen_init_forminfo:\n");
		fprintf(stderr, "  Could not create file 'form_init.c'\n");
		return(false);
	}


	/* begin file with RCS header */
	fprintf(fid, " /*\n  * Khoros: %cId%c\n  */\n\n", '$', '$');
        fprintf(fid, "#if !defined(lint) && !defined(SABER)\n");
        fprintf(fid, "static char rcsid[] = \"Khoros: %cId%c\";\n", '$','$');
        fprintf(fid, "#endif\n\n");
        fprintf(fid, " /*\n  * %cLog%c\n  */\n\n", '$','$');

	/* follow RCS header with UNM copyright */
        fprintf(fid, "%s", cp_top); 
        fprintf(fid, "%s", cp_line); 
        fprintf(fid, "%s", cp_right); 
        fprintf(fid, "%s", cp_line); 
        fprintf(fid, "%s", cp_bottom); 
		
	/* write to file the necessary #includes */
	fprintf(fid,"%s", include1);
	fprintf(fid,"%s", include2);
	fprintf(fid,"%s\n\n", include4);


	 /* write the header into the "form_info.h" file */
        fprintf(fid, "%s", filehdr_top);
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s form_init.c\n", filehdr_file);
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s code to initialize fields\n", filehdr_desc);
        fprintf(fid, " >>>>                      in the structure found in form_info.h\n");
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s automatically generated by conductor\n", filehdr_auth);
        fprintf(fid, " >>>>\n");

        clock = (time_t) time(NULL);
        sprintf(temp, "%s %s\n", filehdr_date, ctime(&clock));
        temp[xvf_strlen(temp)-2] = '\0';
        fprintf(fid, "%s\n", temp);
        fprintf(fid, " >>>>\n");
        fprintf(fid, "%s\n\n\n", filehdr_bottom);

	index = 0;
	subformbutton_num = 0; /* number of subformbuttons (-d lines) */
	subform_count = 0;     /* number of subform descriptions (-M) */

	/* read the StartForm definition & get FormInfo variable name */
        xvf_clear_line_info(&line_info);
        flag = xvf_get_line_type(database[index]);
        xvf_parse_startform_line(database[index], &line_info);
	if (line_info.variable == NULL)
	{
	    fprintf(stderr, "\ncnd_gen_init_forminfo:\n");
	    fprintf(stderr, "Form does not have a variable name\n");
	    fprintf(stderr, "associated with it. Cannot generate \n");
	    fprintf(stderr, "correct code without this string.\n");
	    return(false);
	}
        form_var = xvf_strcpy(line_info.variable);
	index++;
        
        
        /* write out program name & argument list */

        fprintf(fid, "_xvf_init_%s(formptr,forminfo)\n\n",form_var); 
        fprintf(fid, "xvf_form *formptr; \n");
        fprintf(fid, "%s *forminfo;", form_var); fprintf(fid, "\n");
       
       	/* write out beginning bracket & declarations */
       	fprintf(fid, "{\n"); 
       	fprintf(fid, "\t%s", declar1);
       	fprintf(fid, "\t%s", declar2);
       	fprintf(fid, "\t%s", declar3);
       
	fprintf(fid, "\n\txvf_clear_line_info(&line_info);\n");
	fprintf(fid, "\tdatabase = formptr->db;\n\n");

	fprintf(fid, "\t/***** initializing '%s' Form ", form_var);
	fprintf(fid, "Information structure *****/\n\n");


	do 
	{
	    flag = xvf_get_line_type(database[index]);
	    
	    switch(flag)
	    {
		case StartMaster:
		     index++;
		     master_form = true;
		     break;

		case SubFormButton:
		case PsuedoSubForm:
		     total_subform_structs++;
		case StartSubMenu:
                     subformbutton_indices[subformbutton_num] = index;
               	     subformbutton_num++;
	             index++;
	             break;

		case HelpSel:
		     total_subform_structs++;
		case Blank:
		     index++;
		     break;

		case MasterAction:
		     xvf_parse_master_action_line(database[index], 
					      &line_info);
		     fprintf(fid,"\t%s->%s = false;\n", "forminfo", 
			     line_info.variable);
	             if (line_info.selected == true)
	             {
	    		fprintf(fid, "\t%s", parsen);
	    		fprintf(fid, "line_info.selected = false;\n");
	    		fprintf(fid, "\t%s", deparsen);
		     }
		     total_subform_structs++;
		     index++;
                     break;

		case WorkWidget:
		     workspace = true;
		     xvf_parse_workspace_line(database[index], 
					      &line_info);
		     total_subform_structs++;
       		     fprintf(fid, "\tforminfo->%s_index = %d;\n", 
				  line_info.variable, index); 
		     index++;
                     break;

		case QuitForm:
		     fprintf(fid,"\t%s->quit = false;\n", "forminfo");
		     index++;
		     total_subform_structs++;
		     break;

		case End:
		     if (master_form == TRUE) /* skip over it */
                     {
                        index++;
                        flag = xvf_get_line_type(database[index]);
                     }
                     break;

                   
		case StartSubForm:
		     xvf_parse_startsubform_line(database[index], 
						 &line_info);
		     subform_var = xvf_strcpy(line_info.variable);
	             fprintf(fid, "\tforminfo->%s = (%s_%s *) \n", 
				  subform_var, form_var,subform_var);
		     fprintf(fid, "\t\t\t  malloc(sizeof(%s_%s));\n\n",
				   form_var, subform_var);

       	     	     fprintf(fid, "\n\tindex = %d;\n\n", index);
       	     	     fprintf(fid, "\t%s", parseM);
       	             fprintf(fid, "\tforminfo->%s%s", subform_var, 
						      selected);
	             fprintf(fid, "\tforminfo->%s_index = %d;\n", 
                                            subform_var, index);
		     fprintf(fid, "\tforminfo->%s_sfb_index = %d;\n",
                       	     subform_var, subformbutton_indices[subform_count]);
		     index++;
		     subform_count++;
		     if (!(cnd_gen_init_subforminfo(fid, database, &index, 
			                  "forminfo", subform_var, 
					   subform_count)))
		          return(false);
		     flag = xvf_get_line_type(database[index]);
		     break;

	    }  /* end switch */

	} while (flag != End);  /* end do-while */

	if (workspace == true)
            fprintf(fid, "\t_xvf_get_%s(formptr, forminfo);\n", form_var);
       	fprintf(fid, "\n}\n\n");
       	fprintf(stderr, "\ncnd_gen_init_forminfo:\n");
        fprintf(stderr, "Done with generating initialization code:\n");
        fprintf(stderr, "routine '_xvf_init_%s' now in 'form_init.c'\n",
			 form_var);


        
       	fclose(fid);
       	return(true);
        
} /* end cnd_gen_init_forminfo */
        
        	
        
        
        
/************************************************************
*
*  Routine Name: cnd_gen_init_subforminfo
*
*      Purpose:  generates the initialization code for each subform
*
*	 Input:  fid         - open stream to "form_init.h" file
*		 database    - the internal database struct
*		 index       - current index into the database
*		 form_var    - name of the form variable
*		 subform_var - name of the subform variable
*
*       Output:  appropriate subform initialization code 
*		 in the "form_init.c" file 
*
*   Written By:  Danielle Argiro
*
*
*************************************************************/


int cnd_gen_init_subforminfo(fid, database, index, form_var, subform_var, subform_num)

FILE *fid;
char **database;
int  *index;
char *form_var;
char *subform_var;
int   subform_num;
{
	Line_Info line_info;
        int       tmp_index, actual_subforms, total_subform_structs;
        int       i, flag, workspace = false;
	int  guide_indices[100], guidecount = 0, guide_pane = 0, panecount = 0;
	char *pane_var, *variable;
	xvf_sub_form *tmp_subform;

	guide_indices[0] = 0;
	xvf_clear_line_info(&line_info);

	fprintf(fid, "\n\t/*** initializing '%s->%s'\n", form_var, subform_var);
	fprintf(fid, "\t      Subform Information structure ***/\n\n");

	do
       	{
	    
       	    flag = xvf_get_line_type(database[*index]);
	
	    switch(flag)
	    {
	
		case StartGuide:
		     (*index)++;
		     guide_pane = true;
		     break;

       	   	case Blank:
       	   	case LibCall:
                case HelpSel:
                     (*index)++;
                     break;

		case SubformAction:
	             xvf_parse_subform_action_line(database[*index], &line_info);
       	             fprintf(fid, "\t%s->%s->%s = false;\n", 
       		             form_var, subform_var, line_info.variable);
	             if (line_info.selected == true)
	             {
       	                  fprintf(fid, "\t%s", parsem);
		          fprintf(fid, "\tline_info.selected = false;\n");
		          fprintf(fid, "\t%s", deparsem);
	             }
		     (*index)++;
		     break;

		case WorkWidget:
		     workspace = true;
	             xvf_parse_workspace_line(database[*index], &line_info);
		     fprintf(fid, "\t%s->%s->%s_index = %d;\n", 
                                    form_var, subform_var, line_info.variable, 
				    *index);
		     (*index)++;
		     break;

		case GuideButton:
                     guide_indices[guidecount] = *index;
                     guidecount++;
		     (*index)++;
		     break;
	
		case QuitForm:
                     fprintf(fid, "\t%s->%s->quit = false;\n", 
				   form_var, subform_var);
	             xvf_parse_quit_line(database[*index], &line_info);
	             if (line_info.selected == true)
                     {
		         fprintf(fid, "\n\tindex = %d;\n\n", *index);
		         fprintf(fid, "\t%s", parseQ);
		         fprintf(fid, "\tline_info.selected = false;\n");
		         fprintf(fid, "\t%s", deparseQ);
	             }
		     (*index)++;
                     break;

		case End:
		     if (guide_pane == TRUE) /* skip over it */
                     {
                         (*index)++;
                         flag = xvf_get_line_type(database[*index]);
                     }
                     break;

		case StartPane:
		     xvf_parse_startpane_line(database[*index], &line_info);
		     pane_var = xvf_strcpy(line_info.variable);

		     fprintf(fid, "\tforminfo->%s->%s = (%s_%s *) \n", 
				  subform_var, pane_var, subform_var, pane_var);
		     fprintf(fid, "\t\t\t  malloc(sizeof(%s_%s));\n\n",
					   subform_var, pane_var);
       		     fprintf(fid, "\n\tindex = %d;\n\n", *index);
       		     fprintf(fid, "\t%s", parseP);
       		     fprintf(fid, "\t%s->%s->%s%s", form_var, subform_var,
				   pane_var, selected);
		     fprintf(fid, "\t%s->%s->%s_index = %d;\n", 
                                    form_var, subform_var, pane_var, *index);
		     fprintf(fid, "\t%s->%s->%s_gb_index = %d;\n",
                             form_var, subform_var, pane_var, 
			     guide_indices[panecount]);
		     panecount++;

       		     fprintf(fid, "\t%s", incr_index);
       		     (*index)++;
		
		     if (!(cnd_gen_init_paneinfo(fid, database, index, 
					form_var, subform_var, 
					pane_var, subform_num, panecount)))
		          return(false);

       		     flag = xvf_get_line_type(database[*index]);;
		     
	   	} /* end switch */

        }   while (flag != End); 

	if (workspace == true)
	{
	    print_create_subform_call(fid, database, subform_var, subform_num);
	    fprintf(fid, "\t_xvf_get_%s(formptr, forminfo->%s);\n",
			subform_var, subform_var);
	}

	(*index)++;

	return(true);
	

} /* end cnd_gen_init_subforminfo */


/************************************************************
*
*  Routine Name: cnd_gen_init_paneinfo
*
*      Purpose:  generates the initialization code for each pane
*
*	 Input:  fid         - open stream to "form_init.h" file
*		 database    - the internal database struct
*		 index       - current index into the database
*		 form_var    - name of the form variable
*		 subform_var - name of the subform variable
*		 pane_var    - name of the pane variable
*
*       Output:  appropriate pane initialization code 
*		 in the "form_init.c" file 
*
*   Written By:  Danielle Argiro
*
*
*************************************************************/

int cnd_gen_init_paneinfo(fid, database, index, form_var, subform_var, 
                          pane_var, subform_num, pane_num)
FILE *fid;
char **database;
int  *index;
char *form_var;
char *subform_var;
char *pane_var;
int   subform_num, pane_num;
{
	Line_Info line_info;
        int       i, flag, mutual_exclusion = false;
	static char *end = "\t}\n";

	fprintf(fid, "\n\t/* initializing '%s->%s->%s'\n",
			form_var, subform_var, pane_var);
	fprintf(fid, "\t       Pane Information structure */\n\n");

	xvf_clear_line_info(&line_info);
	do
       	{
       	   flag = xvf_get_line_type(database[*index]);

       	   switch(flag) {
      
     	   case InputFile:
       	        fprintf(fid, "\t%s", parseI);
       	        xvf_parse_input_line(database[*index], &line_info);
		fprintf(fid, "\t%s", fildef_neq_null);
        	fprintf(fid, "\t   %s->%s->%s->%s = \n", form_var, 
			     subform_var,pane_var, line_info.variable);
	        fprintf(fid, "\t\txvf_strcpy(line_info.file_def);\n");
		fprintf(fid,"%s", end);
		fprintf(fid, "\telse  %s->%s->%s->%s = NULL;\n\n",
			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\t%s", deparseI);
        	fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true) 
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == false))
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == true))
		    fprintf(fid, "%s->%s->%s->%s_selected = true;\n",
			form_var, subform_var,pane_var, line_info.variable);

        	fprintf(fid, "\t%s", incr_index);
                (*index)++;
                flag = xvf_get_line_type(database[*index]);
        	break;
        
           case OutputFile:
        	fprintf(fid, "\t%s", parseO);
        	xvf_parse_output_line(database[*index], &line_info);
		fprintf(fid, "\t%s", fildef_neq_null);
        	fprintf(fid, "\t   %s->%s->%s->%s = \n", form_var, 
			     subform_var,pane_var, line_info.variable);
	        fprintf(fid, "\t\txvf_strcpy(line_info.file_def);\n");
		fprintf(fid,"%s", end);
		fprintf(fid, "\telse  %s->%s->%s->%s = NULL;\n\n",
			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\t%s", deparseO);
        	fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)  
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == false))
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == true))
		    fprintf(fid, "%s->%s->%s->%s_selected = true;\n",
			form_var, subform_var,pane_var, line_info.variable);
        	fprintf(fid, "\t%s", incr_index);
                (*index)++;
                flag = xvf_get_line_type(database[*index]);
        	break;
        
           case IntegerOpt:
        	fprintf(fid, "\t%s", parsei);
        	xvf_parse_int_line(database[*index], &line_info);
        	fprintf(fid, "\t%s->%s->%s->%s = line_info.int_def;\n", 
        		form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\tline_info.int_val = line_info.int_def;\n");
		fprintf(fid, "\t%s", deparsei);
        	fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)  
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == false))
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == true))
		    fprintf(fid, "%s->%s->%s->%s_selected = true;\n",
			form_var, subform_var,pane_var, line_info.variable);
        	fprintf(fid, "\t%s", incr_index);

                (*index)++;
                flag = xvf_get_line_type(database[*index]);
        	break;
       
      	   case FloatOpt:
       		fprintf(fid, "\t%s", parsef);
       		xvf_parse_float_line(database[*index], &line_info);
       		fprintf(fid, "\t%s->%s->%s->%s = line_info.float_def;\n", 
       			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\tline_info.float_val = line_info.float_def;\n");
		fprintf(fid, "\t%s", deparsef);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)  
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
		            form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == false))
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == true))
		    fprintf(fid, "%s->%s->%s->%s_selected = true;\n",
			form_var, subform_var,pane_var, line_info.variable);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;
       
      		
       	   case StringOpt:
       		fprintf(fid, "\t%s", parses);
       		xvf_parse_string_line(database[*index], &line_info);
		fprintf(fid, "\t%s", strdef_neq_null);
        	fprintf(fid, "\t   %s->%s->%s->%s = \n", form_var, 
			     subform_var,pane_var, line_info.variable);
	        fprintf(fid, "\t\txvf_strcpy(line_info.string_def);\n");
		fprintf(fid,"%s", end);
		fprintf(fid, "\telse  %s->%s->%s->%s = NULL;\n\n",
			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\t%s", deparses);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true) 
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == false))
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == true))
		    fprintf(fid, "%s->%s->%s->%s_selected = true;\n",
			form_var, subform_var,pane_var, line_info.variable);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
		if ((flag == End) && (mutual_exclusion == true))
		{
		   mutual_exclusion = false;
		   (*index)++;
        	   fprintf(fid, "\t%s", incr_index);
		   flag = xvf_get_line_type(database[*index]);
		}
       		break;
       
      	  case LogicOpt:
       		fprintf(fid, "\t%s", parsel);
       		xvf_parse_logic_line(database[*index], &line_info);
       		fprintf(fid, "\t%s->%s->%s->%s = line_info.logical_def;\n", 
       			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\tline_info.logical_val = line_info.logical_def;\n");
		fprintf(fid, "\t%s", deparsel);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
		            form_var, subform_var,pane_var, line_info.variable);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;
       
      	  case Cycle:
       		fprintf(fid, "\t%s", parsec);
       		xvf_parse_cycle_line(database[*index], &line_info);
       		fprintf(fid, "\t%s->%s->%s->%s = line_info.cycle_val;\n",
       			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\t%s", deparsec);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)
		    fprintf(fid, "\t%s->%s->%s->%s_selected = false;\n",
		            form_var, subform_var,pane_var, line_info.variable);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;

      	  case List:
       		fprintf(fid, "\t%s", parsex);
       		xvf_parse_list_line(database[*index], &line_info);
       		fprintf(fid, "\t%s->%s->%s->%s = xvf_strcpy(line_info.val_labels[line_info.list_val-1]);\n", 
       			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\t%s", deparsex);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)
		    fprintf(fid, "\t%s->%s->%s->%s_selected = false;\n",
		            form_var, subform_var,pane_var, line_info.variable);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;

	   case MutExcl:
	        mutual_exclusion = true;
       		fprintf(fid, "\t%s", incr_index);
	        (*index)++;
	        break;

	   case Toggle:
       		fprintf(fid, "\t%s", parseT);
		xvf_parse_toggle_line(database[*index], &line_info);
		fprintf(fid,"\t%s->%s->%s->%s_val = line_info.toggle_def;\n",
		       form_var, subform_var,pane_var, line_info.variable);

		fprintf(fid, "\tline_info.toggle_val = line_info.toggle_def;\n");
		fprintf(fid, "\t%s", deparseT);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.live == true)
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
		            form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == false))
		    fprintf(fid, "%s->%s->%s->%s_selected = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if ((line_info.optional == true) && (line_info.opt_sel == true))
		    fprintf(fid, "%s->%s->%s->%s_selected = true;\n",
			form_var, subform_var,pane_var, line_info.variable);
		fprintf(fid, "\t%s", incr_index);

		while (flag != End) 
		{
		   (*index)++;
		   flag = xvf_get_line_type(database[*index]);
		}
		(*index)++;
		flag = xvf_get_line_type(database[*index]);
		fprintf(fid, "\tindex = %d;\n", *index);
		break;
		
		
       	   case Routine:
       		fprintf(fid, "\t%s", parseR);
       		xvf_parse_routine_line(database[*index], &line_info);
       		fprintf(fid,"\t%s->%s->%s->%s = line_info.selected;\n",
			form_var, subform_var,pane_var, line_info.routine);
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.routine);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;
       
      	   case PaneAction:
       		xvf_parse_pane_action_line(database[*index], &line_info);
       		fprintf(fid,"\t%s->%s->%s->%s = false;\n",
			form_var, subform_var,pane_var, line_info.variable);
		if (line_info.selected == true)
		{
		    fprintf(fid, "\t%s", parseA);
		    fprintf(fid, "line_info.selected = false;\n");
		    fprintf(fid, "\t%s", deparseA);
		}
       		fprintf(fid, "\t%s->%s->%s->%s_index = index;\n", 
			form_var, subform_var,pane_var, line_info.variable);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;
       
      	   case WorkWidget:

	        print_create_subform_call(fid, database, 
					   subform_var, subform_num);
		fprintf(fid, "\t_xvf_get_%s(formptr, forminfo->%s);\n", 
				subform_var, subform_var);
		fprintf(fid, "\t_xvf_get_%s(formptr, forminfo->%s->%s);\n", 
			pane_var, subform_var, pane_var);
		xvf_parse_workspace_line(database[*index], &line_info);
       		fprintf(fid, "\t%s->%s->%s->%s_index = %d;\n", 
			form_var, subform_var,pane_var, line_info.variable, *index);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;

	   case QuitForm:
		fprintf(fid, "\t%s->%s->%s->quit = false;\n",
			form_var, subform_var,pane_var);
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
		break;

       	   case Blank:
       	   case LibCall:
	   case HelpSel:
       		fprintf(fid, "\t%s", incr_index);
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;
       

   	   case End:
       		fprintf(fid, "\t%s", incr_index);
       		break;
       
      	   default:
       	        (*index)++;
       	        flag = xvf_get_line_type(database[*index]);
       		break;
       
      	   }  /* end switch */

	   if ((flag == End) && (mutual_exclusion == true))
	   {
	       mutual_exclusion = false;
	      (*index)++;
               fprintf(fid, "\t%s", incr_index);
	       flag = xvf_get_line_type(database[*index]);
	   }
       
      
      	} while (flag != End);  /* end do-while */
      
      	(*index)++;
	return(true);
      
} /* end cnd_gen_init_paneinfo */
        
        	
        
        
print_create_subform_call(fid, database, subform_var, subform_num)
FILE *fid;
char **database;
char *subform_var;
int   subform_num;
{
	char flag;
	int i, index, actual_subforms, total_subform_structs;

        fprintf(fid, "\tif (!(xvf_create_subform(formptr->db, formptr, formptr->subform");

	index = 0;
	actual_subforms = 0;
	total_subform_structs = 0;
	do
	{
	    flag =  xvf_get_line_type(database[index]);

	    switch(flag) {
		case SubFormButton:
                case PsuedoSubForm:
		     actual_subforms++;

		case HelpSel:
	        case MasterAction:
		case WorkWidget:
		case QuitForm:
		     total_subform_structs++;
		     break;
 	     }
	     index++;
         } while ((flag != StartSubForm) && (actual_subforms < subform_num));

	 for (i = 1; i < total_subform_structs; i++)
	        fprintf(fid, "->next_subform");
	  
 	 fprintf(fid, ", true)))\n");
	 fprintf(fid, "\t   return(false);\n");
	 fprintf(fid, "\t_xvf_get_%s(formptr, forminfo->%s);\n", 
	            subform_var, subform_var);
}
