 /*
  * Khoros: $Id: vgparms.c,v 1.1 1991/05/10 15:41:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgparms.c,v 1.1 1991/05/10 15:41:06 khoros Exp $";
#endif

 /*
  * $Log: vgparms.c,v $
 * Revision 1.1  1991/05/10  15:41:06  khoros
 * Initial revision
 *
  */ 

/******************************************************************

	Get String Parameter 

	source filename:			vgparms.c

	revision	  date			programmer
	--------	  ----			----------
	   0.0		May-1-85		don hush

******************************************************************

usage :
	vgparms(ifd,key,prompt,sarg,imax,imin,ierr)

	int ifd,imax,imin,*ierr ;
	character *sarg,*key,*prompt ;

description :
  This routine fetches a string parameter from either the
command line , an answer file , or the user (interactively).
The answer file must be opened prior to	calling this routine.
If no answer file is present then ifd should be passed as an
illegal (negative) file descriptor. The command line is searched
first, then the answer file (if one has been opened).
If a parameter is not found to	match the key on the command
line or in the answer file , the user is prompted interactively
for the parameter. If prompt = "noprompt" when no match 
is found then the query	to the user is suppressed and
a default parameter value is returned (currently 0 or NULL) with
an error flag of -1. 
The imax and imin arguments are not used in this routine and
are included only for consistancy with the other vgparm routines.

argument descriptions :

	ifd -	C file descriptor for the answer file ;
		If there is no answer file ifd should be
		passed as an invalid (negative) file descriptor

	key -	search key used to locate the parameter ;
		It must begin with a '-' and be the first thing
		to appear in the line in the answer file (no 
		leading spaces).
		A maximum of 1 character can follow the '-'
		to make up the key.  Case distinctions are made
		when parsing the key , so upper and lower case
		letters are not treated the same.

	prompt - prompt used to query the user if no match
		is found for the key. If prompt = "noprompt"
		then the query is suppressed and a default
		value for the parameter is returned with
		an error code of -1 .

	imax -	not used

	imin -	not used

	sarg - 	argument (parameter) value returned

	ierr -	error flag for this routine
		 0 means returned value is O.K.
		-1 means that this routine was unable to get a 
		   valid parameter
		Note: -1 can occur only when prompt = "noprompt" 
		      otherwise it has to return with a valid
		      parameter value

******************************************************************/

#include "vgparm.h"


extern int first_time,make;
extern char make_name[];

vgparms(ifd,key,prompt,sarg,imax,imin,ierr)

int ifd,imax,imin,*ierr;
char *key,*prompt,*sarg;

{
    char c_sarg[MAX_ARG_LEN+1];

    if (first_time) {
	first_time = FALSE;
	make = init_makec();
    }

    if ( strcmp(key,"nokey") == 0 )
	*ierr = get_arg_user(prompt,c_sarg,'s');
    else {
        if ( (*ierr=get_arg_clc(key,c_sarg,'s')) == -1 )
	    if ( (*ierr=get_arg_afile(ifd,key,c_sarg,'s')) == -1 )
	        *ierr=get_arg_user(prompt,c_sarg,'s');
    }

    strcpy(sarg,c_sarg);

    if ( strcmp(key,"nokey") != 0 )
        if ((*ierr==0)&&(make))
	    put_line(key,c_sarg,'s');

}
