#include <stdio.h>
#include <string.h>

/* Renamed soelim and .PS support added - Bill Stewart
	AT&T Bell Labs 2G-218, Holmdel NJ 1-201-949-0705 ihnp4!ho95c!wcs*/
/* Catso will cat the standard input to the standard output, inserting
 * all files referenced by the nroff commands '.so' or '.nx'.
 *  J. Leth, IH 55414 6B-326, x6133.
 *  (original program from: D. A. Spicer)
 */

#define SPACE " \t\n"
#define MAXLINE 511

char buff[MAXLINE];

char *MyName;
int verbose=0;

main(argc, argv)
    int argc;
    char *argv[];
{
    FILE *inp;
    int i;
    void exit();    /* Make lint quiet */

#ifdef CTRACE
ctroff();
#endif
    if (isatty(0)  &&  argc == 1) {
        /* If input is from the terminal, and there are no args,
         * print usage instructions and exit.
         */

        fprintf(stderr, "Usage:\t%s [ file or '-' ] ...\nX    Cats the files (standard input, default) together, inserting\nX    files referenced by the nroff commands '.so' and '.nx' in their\nX    proper positions.  File name '-' means standard input\n", *argv[0]);
        exit(1);
    };

    MyName = argv[0];
    if (strcmp(argv[1],"-v")==0) {verbose++; argc--; argv++; printf("Verbose!\n");}
    if (argc == 1) {
        fetch(stdin);
    } else {
        for (i=1; i < argc; ++i) {
            if (strcmp(argv[i], "-") == 0) {
                fetch(stdin);
            } else {
                inp = fopen(argv[i], "r");
                if (inp == NULL) {
                    fprintf(stderr,
                        "%s: can't open file '%s'.\n",
                        MyName,argv[i]);
                } else {
                    fetch(inp);
                }
            }
        }
    }
    return (0); /* If you get here, you're OK */
}

fetch(fdes)
    FILE *fdes;
{
    FILE *newdes;
    char *fname, *ptr;
    void exit();

    while(fgets(buff,sizeof(buff),fdes) != NULL ) {
        /* strncpy(line, buff, sizeof(line)); */
        if (buff[0]=='.' &&
                (buff[3]==' '||buff[3]=='\t' || buff[3]=='<')) {
            if (strncmp(buff, ".so", 3) == 0) {
                fname = strtok(buff+3, SPACE);
                if((newdes = fopen(fname,"r")) != NULL) {
                    fetch(newdes);
                    fclose(newdes);
                } else {
                    fprintf(stderr, "%s: can't open .so file '%s'.\n",
                        MyName, fname);
                    exit(1);
                }
            } else if (strncmp(buff, ".nx", 3) == 0) {
                fname = strtok(buff+3, SPACE);
                if((newdes = fopen(fname,"r")) != NULL) {
                    fclose(fdes);
                    fetch(newdes);
                    fclose(newdes);
                } else {
                    fprintf(stderr, "%s: can't open .nx file '%s'.\n",
                            MyName, fname);
                    exit(1);
                }
                exit(0);
            } else if (strncmp(buff, ".PS", 3) == 0) {
#ifdef CTRACE
ctron();
buff;
#endif
                fname=NULL;
                for (ptr=buff+3; *ptr; ptr++){
                    if (*ptr=='<') {
			for (ptr++; *ptr==' '||*ptr=='\t'; ptr++) ;
                        fname=ptr;
                        while (*ptr++) {
                            if (*ptr=='\n'||*ptr==' ')
                            	{*ptr='\0'; break;}
                        }
                        break;/*for loop*/
                    }
                }
                if (*fname) {
                    if((newdes = fopen(fname,"r")) != NULL) {
                        fetch(newdes);
                        fclose(newdes);
                    } else {
                        fprintf(stderr, "%s: can't open .PS file '%s'.\n",
                                MyName, fname);
                        exit(1);
#ifdef CTRACE
ctroff();
#endif
                    }
                } else fputs(buff,stdout); /* regular .PS */
            } else {
                fputs(buff, stdout); }  /* Starts with "." */
        } else fputs(buff, stdout); /* Doesn't start with "." */
    }
}
