
 /*
  * Khoros: $Id: kexec.c,v 1.3 1992/03/20 23:48:04 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: kexec.c,v 1.3 1992/03/20 23:48:04 dkhoros Exp $";
#endif

 /*
  * $Log: kexec.c,v $
 * Revision 1.3  1992/03/20  23:48:04  dkhoros
 * VirtualPatch5
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: kexec.c
 >>>>
 >>>>      Program Name: kexec
 >>>>
 >>>>      Program Desc: 
 >>>>

 >>>> 
 >>>> Date Last Updated: Mon Nov 18 00:21:33 1991
 >>>>
 >>>>          Routines: main- the main program for kexec
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "kexec.h"


/****************************************************************
 *
 * Routine Name:  main program for kexec
 *
 *       Input:  
 *       -c  command 
 *
 *
 *       [-m] machine
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
	char *command;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        if (check_args())
           exit(1);
/* -main_before_lib_call_end */

/* -main_library_call */

	if ((command = kmake_command(kexec->m_string, kexec->c_string)) == NULL)
	{
	   (void) fprintf(stderr,"kexec: unable to build command for \
exec'ing.\nThe command string is '%s'\nand the machine specified is '%s'\n",
			 kexec->c_string, kexec->m_string);
	   exit(1);
	}

        if (ksystem(command) != 0)
	   exit(1);

/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for kexec 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "kexec :\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-c  command  (string)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  machine (string) [null]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for kexec\n");
	fprintf(stderr, "\t[-U] Gives the usage for kexec\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called kexec.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses kexec.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for kexec
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*c_pstr = 
	"\nEnter: (c) command \n        {string}: "; 
char	*c_def = NULL;
char	*m_pstr = 
	"\nEnter: (m) machine \n        {string}: "; 
char	*m_def = NULL;
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "kexec", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "kexec.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "kexec: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "kexec.ans");
		}

	     }

	}

	/*
	 * allocate the kexec structure
	 */
	kexec = (kexec_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (kexec_struct));

	/*
	 * get required arguments for kexec
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(kexec->c_flag = vget_string(fid, prompt_flag,
			"-c", c_pstr, &(kexec->c_string),
			c_def)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(kexec->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    kexec->c_flag = vget_string(fid, prompt_flag,
		    "-c", c_pstr, &(kexec->c_string),
		    c_def);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for kexec
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	kexec->m_flag = vget_string(fid, prompt_flag,
	"-m", m_pstr, &(kexec->m_string),
	m_def);

	if (prompt_flag == FALSE)
	{
	    if ((kexec->m_flag == 1)&&(kexec->m_string == NULL))
    	{
		fprintf(stderr, "kexec:\n");
		fprintf(stderr, "you must specify a name following '-m'\n");
		gw_usage();
		exit(1);
		}
	}

}



